/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ultimate;

import com.intellij.execution.Platform;
import com.intellij.execution.process.ProcessInfo;
import com.intellij.execution.process.impl.ProcessListUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.profiler.api.Attached;
import com.intellij.profiler.ultimate.JavaProfilerProcess;
import com.intellij.profiler.ultimate.JavaTargetProcess;
import com.sun.tools.attach.VirtualMachine;
import com.sun.tools.attach.VirtualMachineDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sun.jvmstat.monitor.HostIdentifier;
import sun.jvmstat.monitor.MonitoredHost;
import sun.jvmstat.monitor.MonitoredVm;
import sun.jvmstat.monitor.MonitoredVmUtil;
import sun.jvmstat.monitor.VmIdentifier;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000<\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u001a.\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n2\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0002\u001a.\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n2\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0002\u001a\u0015\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\u0011\u001a\u0012\u0010\u0012\u001a\u00020\u000f2\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u0014\"\u0013\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getAllJavaProcesses", "", "Lcom/intellij/profiler/ultimate/JavaTargetProcess;", "progressIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "getAllJavaProcessesUsingJvmStat", "nativeProcesses", "", "", "Lcom/intellij/execution/process/ProcessInfo;", "getAllJavaProcessesUsingVM", "isProcessLikelyTerminatedByUser", "", "exitCode", "(Ljava/lang/Integer;)Z", "isProfilerDetached", "profilerProcess", "Lcom/intellij/profiler/ultimate/JavaProfilerProcess;", "intellij.profiler.ultimate"})
@SourceDebugExtension(value={"SMAP\nProcessUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProcessUtil.kt\ncom/intellij/profiler/ultimate/ProcessUtilKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,120:1\n1617#2,9:121\n1869#2:130\n1870#2:133\n1626#2:134\n1617#2,9:135\n1869#2:144\n1870#2:146\n1626#2:147\n1#3:131\n1#3:132\n1#3:145\n*S KotlinDebug\n*F\n+ 1 ProcessUtil.kt\ncom/intellij/profiler/ultimate/ProcessUtilKt\n*L\n62#1:121,9\n62#1:130\n62#1:133\n62#1:134\n86#1:135,9\n86#1:144\n86#1:146\n86#1:147\n62#1:132\n86#1:145\n*E\n"})
public final class ProcessUtilKt {
    @NotNull
    private static final Logger LOG;

    @NotNull
    public static final List<JavaTargetProcess> getAllJavaProcesses(@Nullable ProgressIndicator progressIndicator) {
        ProcessInfo[] processInfoArray = ProcessListUtil.getProcessList();
        Intrinsics.checkNotNullExpressionValue((Object)processInfoArray, (String)"getProcessList(...)");
        Map nativeProcesses = MapsKt.toMap((Sequence)SequencesKt.map((Sequence)ArraysKt.asSequence((Object[])processInfoArray), ProcessUtilKt::getAllJavaProcesses$lambda$0));
        return SystemInfo.isWindows ? ProcessUtilKt.getAllJavaProcessesUsingVM(nativeProcesses, progressIndicator) : ProcessUtilKt.getAllJavaProcessesUsingJvmStat(nativeProcesses, progressIndicator);
    }

    public static /* synthetic */ List getAllJavaProcesses$default(ProgressIndicator progressIndicator, int n, Object object) {
        if ((n & 1) != 0) {
            progressIndicator = null;
        }
        return ProcessUtilKt.getAllJavaProcesses(progressIndicator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static final List<JavaTargetProcess> getAllJavaProcessesUsingJvmStat(Map<Integer, ? extends ProcessInfo> nativeProcesses, ProgressIndicator progressIndicator) throws ProcessCanceledException {
        void $this$mapNotNullTo$iv$iv;
        MonitoredHost monitoredHost = MonitoredHost.getMonitoredHost(new HostIdentifier(null));
        Set<Integer> set = monitoredHost.activeVms();
        Intrinsics.checkNotNullExpressionValue(set, (String)"activeVms(...)");
        Iterable $this$mapNotNull$iv = set;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            JavaTargetProcess it$iv$iv;
            JavaTargetProcess javaTargetProcess;
            block8: {
                MonitoredVm it;
                boolean bl;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl2 = false;
                Integer pid = (Integer)element$iv$iv;
                boolean bl3 = false;
                MonitoredVm vm = null;
                ProgressIndicator progressIndicator2 = progressIndicator;
                if (progressIndicator2 != null) {
                    progressIndicator2.checkCanceled();
                }
                try {
                    JavaTargetProcess process;
                    vm = monitoredHost.getMonitoredVm(new VmIdentifier("//" + pid + "?mode=r"));
                    ProcessInfo processInfo = nativeProcesses.get(pid);
                    if (processInfo == null) {
                        throw new IllegalStateException(("cannot find process with id=" + pid).toString());
                    }
                    String string = MonitoredVmUtil.mainClass(vm, true);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"mainClass(...)");
                    String string2 = MonitoredVmUtil.jvmArgs(vm);
                    String string3 = MonitoredVmUtil.jvmFlags(vm);
                    String string4 = MonitoredVmUtil.commandLine(vm);
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"commandLine(...)");
                    javaTargetProcess = process = new JavaTargetProcess(processInfo, string, string2, string3, string4);
                    if (vm == null) break block8;
                    bl = false;
                }
                catch (Exception e) {
                    try {
                        LOG.debug((Throwable)e);
                        javaTargetProcess = null;
                        if (vm == null) break block8;
                        bl = false;
                    }
                    catch (Throwable throwable) {
                        MonitoredVm monitoredVm = vm;
                        if (monitoredVm != null) {
                            MonitoredVm it2 = monitoredVm;
                            boolean bl4 = false;
                            monitoredHost.detach(it2);
                        }
                        throw throwable;
                    }
                    monitoredHost.detach(it);
                }
                monitoredHost.detach(it);
            }
            if (javaTargetProcess == null) continue;
            boolean bl = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    static /* synthetic */ List getAllJavaProcessesUsingJvmStat$default(Map map, ProgressIndicator progressIndicator, int n, Object object) throws ProcessCanceledException {
        if ((n & 2) != 0) {
            progressIndicator = null;
        }
        return ProcessUtilKt.getAllJavaProcessesUsingJvmStat(map, progressIndicator);
    }

    /*
     * WARNING - void declaration
     */
    private static final List<JavaTargetProcess> getAllJavaProcessesUsingVM(Map<Integer, ? extends ProcessInfo> nativeProcesses, ProgressIndicator progressIndicator) throws ProcessCanceledException {
        void $this$mapNotNullTo$iv$iv;
        List<VirtualMachineDescriptor> list = VirtualMachine.list();
        Intrinsics.checkNotNullExpressionValue(list, (String)"list(...)");
        Iterable $this$mapNotNull$iv = list;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            JavaTargetProcess it$iv$iv;
            JavaTargetProcess javaTargetProcess;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            VirtualMachineDescriptor it = (VirtualMachineDescriptor)element$iv$iv;
            boolean bl2 = false;
            ProgressIndicator progressIndicator2 = progressIndicator;
            if (progressIndicator2 != null) {
                progressIndicator2.checkCanceled();
            }
            try {
                String string = it.id();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"id(...)");
                int pid = Integer.parseInt(string);
                String string2 = it.displayName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"displayName(...)");
                String mainClass = StringsKt.substringBefore$default((String)string2, (char)' ', null, (int)2, null);
                ProcessInfo processInfo = nativeProcesses.get(pid);
                if (processInfo == null) {
                    throw new IllegalStateException(("cannot find process with id=" + pid).toString());
                }
                String string3 = it.displayName();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"displayName(...)");
                javaTargetProcess = new JavaTargetProcess(processInfo, mainClass, null, null, string3, 12, null);
            }
            catch (Exception e) {
                LOG.debug((Throwable)e);
                javaTargetProcess = null;
            }
            if (javaTargetProcess == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    static /* synthetic */ List getAllJavaProcessesUsingVM$default(Map map, ProgressIndicator progressIndicator, int n, Object object) throws ProcessCanceledException {
        if ((n & 2) != 0) {
            progressIndicator = null;
        }
        return ProcessUtilKt.getAllJavaProcessesUsingVM(map, progressIndicator);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isProcessLikelyTerminatedByUser(@Nullable Integer exitCode) {
        switch (WhenMappings.$EnumSwitchMapping$0[Platform.current().ordinal()]) {
            case 1: {
                Integer n = exitCode;
                int n2 = -1073741510;
                if (n == null) return false;
                if (n != n2) return false;
                return true;
            }
            case 2: {
                Integer n = exitCode;
                int n3 = 130;
                if (n != null) {
                    if (n == n3) return true;
                }
                Integer n4 = exitCode;
                n3 = 137;
                if (n4 == null) return false;
                if (n4 != n3) return false;
                return true;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    public static final boolean isProfilerDetached(@NotNull JavaProfilerProcess<?> profilerProcess) {
        Intrinsics.checkNotNullParameter(profilerProcess, (String)"profilerProcess");
        return !Intrinsics.areEqual((Object)profilerProcess.getState(), (Object)Attached.INSTANCE) && !profilerProcess.getTargetProcessHandler().isProcessTerminating() && !profilerProcess.getTargetProcessHandler().isProcessTerminated();
    }

    private static final Pair getAllJavaProcesses$lambda$0(ProcessInfo it) {
        return TuplesKt.to((Object)it.getPid(), (Object)it);
    }

    static {
        Logger logger = Logger.getInstance((String)"#com.intellij.profiler.ultimate.ProcessUtil");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Platform.values().length];
            try {
                nArray[Platform.WINDOWS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Platform.UNIX.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

