/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.internal.parser.v0;

import org.openjdk.jmc.common.unit.ContentType;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.flightrecorder.internal.InvalidJfrFileException;
import org.openjdk.jmc.flightrecorder.internal.parser.v0.IValueReader;
import org.openjdk.jmc.flightrecorder.internal.parser.v0.Offset;
import org.openjdk.jmc.flightrecorder.parser.ByteBufferWrapper;

final class BooleanReader
implements IValueReader {
    public static final int SIZE = 1;
    public static final BooleanReader INSTANCE = new BooleanReader();

    BooleanReader() {
    }

    @Override
    public Object readValue(ByteBufferWrapper bytes, Offset offset, long timestamp) throws InvalidJfrFileException {
        return BooleanReader.readBoolean(bytes, offset);
    }

    public static boolean readBoolean(ByteBufferWrapper bytes, Offset offset) throws InvalidJfrFileException {
        int index = offset.get();
        offset.increase(1);
        return BooleanReader.readBoolean(bytes, index);
    }

    public static boolean readBoolean(ByteBufferWrapper bytes, int offset) {
        return bytes.get(offset) != 0;
    }

    @Override
    public ContentType<?> getValueType() {
        return UnitLookup.FLAG;
    }
}

