/*
 * Decompiled with CFR 0.152.
 */
package korlibs.crypto;

import korlibs.crypto.Hasher;
import korlibs.crypto.HasherFactory;
import korlibs.crypto.SHA;
import korlibs.crypto.internal.KryptoToolsKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0005\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0014J\b\u0010\n\u001a\u00020\u0007H\u0014J\u0010\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\tH\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lkorlibs/crypto/SHA1;", "Lkorlibs/crypto/SHA;", "()V", "h", "", "w", "coreDigest", "", "out", "", "coreReset", "coreUpdate", "chunk", "Companion", "krypto"})
public final class SHA1
extends SHA {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final int[] w = new int[80];
    @NotNull
    private final int[] h = new int[5];
    @NotNull
    private static final int[] H;
    private static final int K0020 = 1518500249;
    private static final int K2040 = 1859775393;
    private static final int K4060 = -1894007588;
    private static final int K6080 = -899497514;

    public SHA1() {
        super(64, 20, "SHA1");
        this.coreReset();
    }

    @Override
    protected void coreReset() {
        KryptoToolsKt.arraycopy(H, 0, this.h, 0, 5);
    }

    @Override
    protected void coreUpdate(@NotNull byte[] chunk) {
        int j;
        for (j = 0; j < 16; ++j) {
            this.w[j] = KryptoToolsKt.readS32_be(chunk, j * 4);
        }
        for (j = 16; j < 80; ++j) {
            this.w[j] = KryptoToolsKt.rotateLeft(this.w[j - 3] ^ this.w[j - 8] ^ this.w[j - 14] ^ this.w[j - 16], 1);
        }
        int a = this.h[0];
        int b = this.h[1];
        int c = this.h[2];
        int d = this.h[3];
        int e = this.h[4];
        for (int j2 = 0; j2 < 80; ++j2) {
            int n;
            int n2 = KryptoToolsKt.rotateLeft(a, 5) + e + this.w[j2];
            switch (j2 / 20) {
                case 0: {
                    n = (b & c | ~b & d) + 1518500249;
                    break;
                }
                case 1: {
                    n = (b ^ c ^ d) + 1859775393;
                    break;
                }
                case 2: {
                    n = (b & c ^ b & d ^ c & d) + -1894007588;
                    break;
                }
                default: {
                    n = (b ^ c ^ d) + -899497514;
                }
            }
            int temp = n2 + n;
            e = d;
            d = c;
            c = KryptoToolsKt.rotateLeft(b, 30);
            b = a;
            a = temp;
        }
        int[] nArray = this.h;
        nArray[0] = nArray[0] + a;
        nArray = this.h;
        nArray[1] = nArray[1] + b;
        nArray = this.h;
        nArray[2] = nArray[2] + c;
        nArray = this.h;
        nArray[3] = nArray[3] + d;
        nArray = this.h;
        nArray[4] = nArray[4] + e;
    }

    @Override
    protected void coreDigest(@NotNull byte[] out) {
        int n = out.length;
        for (int n2 = 0; n2 < n; ++n2) {
            out[n2] = (byte)(this.h[n2 / 4] >>> 24 - 8 * (n2 % 4));
        }
    }

    static {
        int[] nArray = new int[]{1732584193, -271733879, -1732584194, 271733878, -1009589776};
        H = nArray;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lkorlibs/crypto/SHA1$Companion;", "Lkorlibs/crypto/HasherFactory;", "()V", "H", "", "K0020", "", "K2040", "K4060", "K6080", "krypto"})
    public static final class Companion
    extends HasherFactory {
        private Companion() {
            super("SHA1", (Function0<? extends Hasher>)((Function0)1.INSTANCE));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

