/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.execution.frontend.split.console;

import com.intellij.execution.console.ConsoleViewWrapperBase;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.execution.ui.layout.PlaceInGrid;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.ui.content.Content;
import com.jetbrains.codeWithMe.model.RunnerContentModel;
import com.jetbrains.codeWithMe.model.RunnerDefaultTab;
import com.jetbrains.codeWithMe.model.RunnerLayoutUiModel;
import com.jetbrains.ide.model.uiautomation.BeControl;
import com.jetbrains.rd.actions.ActionsKt;
import com.jetbrains.rd.ide.model.ActionRegistrationModel;
import com.jetbrains.rd.ide.model.IconModel;
import com.jetbrains.rd.ui.bindable.ViewRegistryKt;
import com.jetbrains.rd.ui.icons.UtilKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/platform/execution/frontend/split/console/ThinClientConsoleViewWrapper;", "Lcom/intellij/execution/console/ConsoleViewWrapperBase;", "delegate", "Lcom/intellij/execution/ui/ConsoleView;", "runnerLayoutUiModel", "Lcom/jetbrains/codeWithMe/model/RunnerLayoutUiModel;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "<init>", "(Lcom/intellij/execution/ui/ConsoleView;Lcom/jetbrains/codeWithMe/model/RunnerLayoutUiModel;Lcom/jetbrains/rd/util/lifetime/Lifetime;)V", "buildUi", "", "layoutUi", "Lcom/intellij/execution/ui/RunnerLayoutUi;", "getPlaceInGrid", "Lcom/intellij/execution/ui/layout/PlaceInGrid;", "placeInGrid", "", "intellij.platform.execution.frontend.split"})
public final class ThinClientConsoleViewWrapper
extends ConsoleViewWrapperBase {
    @NotNull
    private final RunnerLayoutUiModel runnerLayoutUiModel;
    @NotNull
    private final Lifetime lifetime;

    public ThinClientConsoleViewWrapper(@NotNull ConsoleView delegate, @NotNull RunnerLayoutUiModel runnerLayoutUiModel, @NotNull Lifetime lifetime) {
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        Intrinsics.checkNotNullParameter((Object)runnerLayoutUiModel, (String)"runnerLayoutUiModel");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        super(delegate);
        this.runnerLayoutUiModel = runnerLayoutUiModel;
        this.lifetime = lifetime;
    }

    public void buildUi(@NotNull RunnerLayoutUi layoutUi) {
        Intrinsics.checkNotNullParameter((Object)layoutUi, (String)"layoutUi");
        for (RunnerDefaultTab defaultTab : this.runnerLayoutUiModel.getDefaultTabs()) {
            IconModel iconModel = defaultTab.getIcon();
            layoutUi.getDefaults().initTabDefaults(defaultTab.getIndex(), defaultTab.getLabel(), iconModel != null ? UtilKt.fromModel((IconModel)iconModel) : null);
        }
        List contentModels = this.runnerLayoutUiModel.getContents();
        if (contentModels.isEmpty()) {
            super.buildUi(layoutUi);
            return;
        }
        for (RunnerContentModel contentModel : contentModels) {
            Content content = null;
            if (Intrinsics.areEqual((Object)contentModel.getId(), (Object)"ConsoleContent")) {
                IconModel iconModel = contentModel.getIcon();
                Content content2 = layoutUi.createContent(contentModel.getId(), this.getComponent(), contentModel.getDisplayName(), iconModel != null ? UtilKt.fromModel((IconModel)iconModel) : null, this.getPreferredFocusableComponent());
                Intrinsics.checkNotNullExpressionValue((Object)content2, (String)"createContent(...)");
                content = content2;
                AnAction[] anActionArray = this.createConsoleActions();
                content.setActions((ActionGroup)new DefaultActionGroup(Arrays.copyOf(anActionArray, anActionArray.length)), "toolbar", this.getComponent());
            } else {
                ActionGroup actionGroup;
                BeControl hostComponent;
                if (contentModel.getComponent() == null) continue;
                JComponent contentComponent = ViewRegistryKt.getView((BeControl)hostComponent, (Lifetime)this.lifetime);
                IconModel iconModel = contentModel.getIcon();
                Content content3 = layoutUi.createContent(contentModel.getId(), contentComponent, contentModel.getDisplayName(), iconModel != null ? UtilKt.fromModel((IconModel)iconModel) : null, null);
                Intrinsics.checkNotNullExpressionValue((Object)content3, (String)"createContent(...)");
                content = content3;
                ActionRegistrationModel actionRegistrationModel = contentModel.getActions();
                AnAction anAction = actionRegistrationModel != null ? ActionsKt.fromModel((ActionRegistrationModel)actionRegistrationModel) : null;
                ActionGroup actionGroup2 = actionGroup = anAction instanceof ActionGroup ? (ActionGroup)anAction : null;
                if (actionGroup != null) {
                    content.setActions(actionGroup, "toolbar", contentComponent);
                }
            }
            content.setCloseable(contentModel.getClosable());
            Content content4 = contentModel.getTabIndex() < 0 ? layoutUi.addContent(content) : layoutUi.addContent(content, contentModel.getTabIndex(), this.getPlaceInGrid(contentModel.getPlaceInGrid()), contentModel.getDefaultIsMinimized());
        }
        layoutUi.getOptions().setMoveToGridActionEnabled(this.runnerLayoutUiModel.getMoveToGridActionEnabled());
    }

    private final PlaceInGrid getPlaceInGrid(String placeInGrid) {
        try {
            return PlaceInGrid.valueOf((String)placeInGrid);
        }
        catch (IllegalArgumentException e) {
            return PlaceInGrid.center;
        }
    }
}

