/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.KlibCompatibilityInfo;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.KlibCompatibilityInfoUtils;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.LibraryInfo;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.NativeKlibLibraryInfoKt;
import org.jetbrains.kotlin.idea.base.util.K1ModeProjectStructureApi;
import org.jetbrains.kotlin.idea.base.util.LoggingUtils;
import org.jetbrains.kotlin.konan.file.File;
import org.jetbrains.kotlin.library.BaseKotlinLibrary;
import org.jetbrains.kotlin.library.KotlinLibrary;
import org.jetbrains.kotlin.library.KotlinLibraryKt;
import org.jetbrains.kotlin.library.SingleFileKlibResolveStrategy;
import org.jetbrains.kotlin.library.SingleFileResolveKt;
import org.jetbrains.kotlin.library.ToolingSingleFileKlibResolveStrategy;
import org.jetbrains.kotlin.library.metadata.UtilsKt;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.util.Logger;

@K1ModeProjectStructureApi
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0004\b'\u0018\u0000 #2\u00020\u0001:\u0001#B!\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00070\u0017R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001b\u0010\u0010\u001a\u00020\u00118FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0012\u0010\u0013R\u0012\u0010\u0018\u001a\u00020\u0019X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u001d\u0010\u001c\u001a\u0004\u0018\u00010\u00078FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001e\u0010\u0015\u001a\u0004\b\u001d\u0010\u000bR\u001b\u0010\u001f\u001a\u00020 8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\"\u0010\u0015\u001a\u0004\b\u001f\u0010!\u00a8\u0006$"}, d2={"Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/AbstractKlibLibraryInfo;", "Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/LibraryInfo;", "project", "Lcom/intellij/openapi/project/Project;", "library", "Lcom/intellij/openapi/roots/impl/libraries/LibraryEx;", "libraryRoot", "", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/roots/impl/libraries/LibraryEx;Ljava/lang/String;)V", "getLibraryRoot", "()Ljava/lang/String;", "resolvedKotlinLibrary", "Lorg/jetbrains/kotlin/library/KotlinLibrary;", "getResolvedKotlinLibrary", "()Lorg/jetbrains/kotlin/library/KotlinLibrary;", "compatibilityInfo", "Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/KlibCompatibilityInfo;", "getCompatibilityInfo", "()Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/KlibCompatibilityInfo;", "compatibilityInfo$delegate", "Lkotlin/Lazy;", "getLibraryRoots", "", "platform", "Lorg/jetbrains/kotlin/platform/TargetPlatform;", "getPlatform", "()Lorg/jetbrains/kotlin/platform/TargetPlatform;", "uniqueName", "getUniqueName", "uniqueName$delegate", "isInterop", "", "()Z", "isInterop$delegate", "Companion", "kotlin.base.project-structure"})
public abstract class AbstractKlibLibraryInfo
extends LibraryInfo {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String libraryRoot;
    @NotNull
    private final KotlinLibrary resolvedKotlinLibrary;
    @NotNull
    private final Lazy compatibilityInfo$delegate;
    @NotNull
    private final Lazy uniqueName$delegate;
    @NotNull
    private final Lazy isInterop$delegate;
    @NotNull
    private static final Logger LOG;

    public AbstractKlibLibraryInfo(@NotNull Project project, @NotNull LibraryEx library, @NotNull String libraryRoot) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)library, (String)"library");
        Intrinsics.checkNotNullParameter((Object)libraryRoot, (String)"libraryRoot");
        super(project, library);
        this.libraryRoot = libraryRoot;
        this.resolvedKotlinLibrary = SingleFileResolveKt.resolveSingleFileKlib((File)new File(this.libraryRoot), (Logger)LOG, (SingleFileKlibResolveStrategy)((SingleFileKlibResolveStrategy)ToolingSingleFileKlibResolveStrategy.INSTANCE));
        this.compatibilityInfo$delegate = LazyKt.lazy(() -> AbstractKlibLibraryInfo.compatibilityInfo_delegate$lambda$0(this));
        this.uniqueName$delegate = LazyKt.lazy(() -> AbstractKlibLibraryInfo.uniqueName_delegate$lambda$2(this));
        this.isInterop$delegate = LazyKt.lazy(() -> AbstractKlibLibraryInfo.isInterop_delegate$lambda$3(this));
    }

    @NotNull
    public final String getLibraryRoot() {
        return this.libraryRoot;
    }

    @NotNull
    public final KotlinLibrary getResolvedKotlinLibrary() {
        return this.resolvedKotlinLibrary;
    }

    @NotNull
    public final KlibCompatibilityInfo getCompatibilityInfo() {
        Lazy lazy = this.compatibilityInfo$delegate;
        return (KlibCompatibilityInfo)lazy.getValue();
    }

    @NotNull
    public final List<String> getLibraryRoots() {
        return CollectionsKt.listOf((Object)this.libraryRoot);
    }

    @Override
    @NotNull
    public abstract TargetPlatform getPlatform();

    @Nullable
    public final String getUniqueName() {
        Lazy lazy = this.uniqueName$delegate;
        return (String)lazy.getValue();
    }

    public final boolean isInterop() {
        Lazy lazy = this.isInterop$delegate;
        return (Boolean)lazy.getValue();
    }

    private static final KlibCompatibilityInfo compatibilityInfo_delegate$lambda$0(AbstractKlibLibraryInfo this$0) {
        return KlibCompatibilityInfoUtils.getCompatibilityInfo(this$0.resolvedKotlinLibrary);
    }

    private static final String uniqueName_delegate$lambda$2$lambda$1(KotlinLibrary $this$safeRead) {
        Intrinsics.checkNotNullParameter((Object)$this$safeRead, (String)"$this$safeRead");
        return KotlinLibraryKt.getUniqueName((BaseKotlinLibrary)((BaseKotlinLibrary)$this$safeRead));
    }

    private static final String uniqueName_delegate$lambda$2(AbstractKlibLibraryInfo this$0) {
        return NativeKlibLibraryInfoKt.safeRead(this$0.resolvedKotlinLibrary, null, AbstractKlibLibraryInfo::uniqueName_delegate$lambda$2$lambda$1);
    }

    private static final boolean isInterop_delegate$lambda$3(AbstractKlibLibraryInfo this$0) {
        return UtilsKt.isCInteropLibrary((BaseKotlinLibrary)((BaseKotlinLibrary)this$0.resolvedKotlinLibrary)) || UtilsKt.isCommonizedCInteropLibrary((BaseKotlinLibrary)((BaseKotlinLibrary)this$0.resolvedKotlinLibrary));
    }

    static {
        com.intellij.openapi.diagnostic.Logger logger = com.intellij.openapi.diagnostic.Logger.getInstance(AbstractKlibLibraryInfo.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = LoggingUtils.asKotlinLogger(logger);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/AbstractKlibLibraryInfo$Companion;", "", "<init>", "()V", "LOG", "Lorg/jetbrains/kotlin/util/Logger;", "kotlin.base.project-structure"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

