/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.core.stackFrame;

import com.intellij.debugger.engine.jdi.StackFrameProxy;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.sun.jdi.Location;
import com.sun.jdi.StackFrame;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.base.util.SafeUtilKt;
import org.jetbrains.kotlin.idea.debugger.core.stackFrame.InlineStackFrameProxyImpl;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u0016\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\u001a0\u0010\u0000\u001a\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0005\u00a8\u0006\t"}, d2={"safeInlineStackFrameProxy", "Lcom/intellij/debugger/jdi/StackFrameProxyImpl;", "location", "Lcom/sun/jdi/Location;", "inlineDepth", "", "frameProxy", "inlineScopeNumber", "surroundingScopeNumber", "kotlin.jvm-debugger.core"})
public final class InlineStackFrameProxyKt {
    @NotNull
    public static final StackFrameProxyImpl safeInlineStackFrameProxy(@Nullable Location location, int inlineDepth, @NotNull StackFrameProxyImpl frameProxy, int inlineScopeNumber, int surroundingScopeNumber) {
        Intrinsics.checkNotNullParameter((Object)frameProxy, (String)"frameProxy");
        ThreadReferenceProxyImpl threadReferenceProxyImpl = SafeUtilKt.safeThreadProxy(frameProxy);
        if (threadReferenceProxyImpl == null) {
            return frameProxy;
        }
        ThreadReferenceProxyImpl threadProxy = threadReferenceProxyImpl;
        StackFrame stackFrame = SafeUtilKt.safeStackFrame((StackFrameProxy)frameProxy);
        if (stackFrame == null) {
            return frameProxy;
        }
        StackFrame stackFrame2 = stackFrame;
        return new InlineStackFrameProxyImpl(location, inlineDepth, threadProxy, stackFrame2, frameProxy.getIndexFromBottom(), inlineScopeNumber, surroundingScopeNumber);
    }
}

