/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageChecker.service;

import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.packageChecker.api.BuildFileProvider;
import com.intellij.packageChecker.api.PackageDeclaration;
import com.intellij.packageChecker.fus.PackageCheckerUsageStat;
import com.intellij.packageChecker.model.Package;
import com.intellij.packageChecker.model.ProjectDependenciesModel;
import com.intellij.packageChecker.model.ProjectSnapshot;
import com.intellij.packageChecker.service.PackageServiceKt;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000  2\u00020\u0001:\u0001 B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\b\u001a\u00020\tJ\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eJ\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010J.\u0010\u0012\u001a\u0014\u0012\u0004\u0012\u00020\u0011\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u000b0\u00132\u0006\u0010\u0014\u001a\u00020\t2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00110\u000bJ \u0010\u0012\u001a\u0014\u0012\u0004\u0012\u00020\u0011\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u000b0\u00132\u0006\u0010\r\u001a\u00020\u000eJ\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00110\u000b2\u0006\u0010\b\u001a\u00020\tJ\u001e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u001bJ\u000e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u000bH\u0002J\u000e\u0010\u001e\u001a\u0004\u0018\u00010\u001f*\u00020\tH\u0002J\u000e\u0010\u001e\u001a\u0004\u0018\u00010\u001f*\u00020\u000eH\u0002J\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00110\u000b2\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/intellij/packageChecker/service/PackageService;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "isBuildFile", "", "psiFile", "Lcom/intellij/psi/PsiFile;", "declaredDependencies", "", "Lcom/intellij/packageChecker/api/PackageDeclaration;", "module", "Lcom/intellij/openapi/module/Module;", "scanAllModules", "", "Lcom/intellij/packageChecker/model/Package;", "calculateRoots", "", "file", "packages", "importedDependencies", "updateDependency", "", "pkg", "version", "", "dependencyModelsProvider", "Lcom/intellij/packageChecker/model/ProjectDependenciesModel;", "fileProvider", "Lcom/intellij/packageChecker/api/BuildFileProvider;", "Companion", "intellij.packageChecker"})
@SourceDebugExtension(value={"SMAP\nPackageService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PackageService.kt\ncom/intellij/packageChecker/service/PackageService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,133:1\n774#2:134\n865#2,2:135\n1374#2:137\n1460#2,5:138\n1374#2:143\n1460#2,5:144\n1285#2,2:149\n1299#2,2:151\n774#2:153\n865#2,2:154\n1302#2:156\n774#2:173\n865#2,2:174\n536#3:157\n521#3,6:158\n126#4:164\n153#4,3:165\n97#4,5:168\n*S KotlinDebug\n*F\n+ 1 PackageService.kt\ncom/intellij/packageChecker/service/PackageService\n*L\n29#1:134\n29#1:135,2\n33#1:137\n33#1:138,5\n40#1:143\n40#1:144,5\n50#1:149,2\n50#1:151,2\n52#1:153\n52#1:154,2\n50#1:156\n100#1:173\n100#1:174,2\n59#1:157\n59#1:158,6\n61#1:164\n61#1:165,3\n69#1:168,5\n*E\n"})
public final class PackageService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;

    public PackageService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    public final boolean isBuildFile(@NotNull PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        return this.fileProvider(psiFile) != null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<PackageDeclaration> declaredDependencies(@NotNull PsiFile psiFile) {
        void $this$flatMapTo$iv$iv;
        ProjectDependenciesModel projectDependenciesModel;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        Iterable $this$filter$iv = this.dependencyModelsProvider();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            projectDependenciesModel = (ProjectDependenciesModel)element$iv$iv;
            boolean bl = false;
            ProgressManager.checkCanceled();
            if (!projectDependenciesModel.supports(psiFile)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$flatMap = false;
        $this$filterTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            projectDependenciesModel = (ProjectDependenciesModel)element$iv$iv;
            boolean bl = false;
            ProgressManager.checkCanceled();
            Iterable list$iv$iv = projectDependenciesModel.declaredDependencies(psiFile);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<PackageDeclaration> declaredDependencies(@NotNull Module module) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Iterable $this$flatMap$iv = this.dependencyModelsProvider();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            ProjectDependenciesModel projectDependenciesModel = (ProjectDependenciesModel)element$iv$iv;
            boolean bl = false;
            ProgressManager.checkCanceled();
            Iterable list$iv$iv = projectDependenciesModel.declaredDependencies(module);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<Package> scanAllModules() {
        void destination$iv;
        void $this$flatMapTo$iv;
        Object providersToModules;
        Object object;
        Object element$iv$iv;
        List modules = ArraysKt.toList((Object[])ModuleManager.Companion.getInstance(this.project).getModules());
        Object[] objectArray = new Object[]{modules.size()};
        PackageServiceKt.access$getLogger$p().debug("Count of found modules: ", objectArray);
        Iterable $this$associateWith$iv = this.dependencyModelsProvider();
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Object $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        Iterator iterator = $this$associateWithTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void $this$filterTo$iv$iv;
            element$iv$iv = iterator.next();
            ProjectDependenciesModel projectDependenciesModel = (ProjectDependenciesModel)element$iv$iv;
            Object t = element$iv$iv;
            object = result$iv;
            boolean bl = false;
            ProgressManager.checkCanceled();
            Iterable $this$filter$iv = modules;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv2 : $this$filterTo$iv$iv) {
                void provider;
                Module it = (Module)element$iv$iv2;
                boolean bl2 = false;
                ProgressManager.checkCanceled();
                if (!provider.supports(it)) continue;
                destination$iv$iv.add(element$iv$iv2);
            }
            List list = (List)destination$iv$iv;
            object.put(t, list);
        }
        Map providerToModulesList = result$iv;
        if (PackageServiceKt.access$getLogger$p().isDebugEnabled()) {
            void $this$mapTo$iv$iv;
            Object[] $this$map$iv;
            void $this$filterTo$iv$iv;
            Map $this$filter$iv = providerToModulesList;
            boolean $i$f$filter = false;
            $this$associateWithTo$iv$iv = $this$filter$iv;
            Object destination$iv$iv = new LinkedHashMap();
            boolean $i$f$filterTo = false;
            element$iv$iv = $this$filterTo$iv$iv.entrySet().iterator();
            while (element$iv$iv.hasNext()) {
                Map.Entry element$iv$iv3;
                Map.Entry it = element$iv$iv3 = (Map.Entry)element$iv$iv.next();
                boolean bl = false;
                boolean bl3 = !((Collection)it.getValue()).isEmpty();
                if (!bl3) continue;
                destination$iv$iv.put(element$iv$iv3.getKey(), element$iv$iv3.getValue());
            }
            $this$filter$iv = destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            element$iv$iv = $this$mapTo$iv$iv.entrySet().iterator();
            while (element$iv$iv.hasNext()) {
                void providerWithModules;
                Map.Entry item$iv$iv;
                Map.Entry it = item$iv$iv = (Map.Entry)element$iv$iv.next();
                object = destination$iv$iv;
                boolean bl = false;
                object.add(providerWithModules.getKey().getClass().getSimpleName() + ": \n-" + CollectionsKt.joinToString$default((Iterable)((Iterable)providerWithModules.getValue()), (CharSequence)"\n-", null, null, (int)0, null, PackageService::scanAllModules$lambda$7$lambda$6, (int)30, null));
            }
            providersToModules = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
            $this$map$iv = new Object[]{providersToModules};
            PackageServiceKt.access$getLogger$p().debug("Modules by related providers: \n", $this$map$iv);
        }
        providersToModules = providerToModulesList;
        Collection $this$map$iv = new LinkedHashSet();
        boolean $i$f$flatMapTo = false;
        Iterator iterator2 = $this$flatMapTo$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv;
            Map.Entry it = element$iv = iterator2.next();
            boolean bl = false;
            ProgressManager.checkCanceled();
            Iterable list$iv = ((ProjectDependenciesModel)it.getKey()).declaredDependencies(new ProjectSnapshot(this.project, (List)it.getValue()));
            CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
        }
        return (Set)destination$iv;
    }

    @NotNull
    public final Map<Package, List<Package>> calculateRoots(@NotNull PsiFile file, @NotNull List<Package> packages) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter(packages, (String)"packages");
        BuildFileProvider buildFileProvider = this.fileProvider(file);
        if (buildFileProvider == null) {
            return MapsKt.emptyMap();
        }
        BuildFileProvider provider = buildFileProvider;
        return provider.getRoots(file, packages);
    }

    @NotNull
    public final Map<Package, List<Package>> calculateRoots(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        BuildFileProvider buildFileProvider = this.fileProvider(module);
        if (buildFileProvider == null) {
            return MapsKt.emptyMap();
        }
        BuildFileProvider provider = buildFileProvider;
        return provider.getRoots(module);
    }

    @NotNull
    public final List<Package> importedDependencies(@NotNull PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        BuildFileProvider buildFileProvider = this.fileProvider(psiFile);
        if (buildFileProvider == null) {
            throw new IllegalStateException(("Unmanaged file: " + psiFile.getName()).toString());
        }
        BuildFileProvider provider = buildFileProvider;
        return provider.importedPackages(psiFile);
    }

    public final void updateDependency(@NotNull PsiFile psiFile, @NotNull Package pkg, @NotNull String version) {
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        Intrinsics.checkNotNullParameter((Object)pkg, (String)"pkg");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        BuildFileProvider buildFileProvider = this.fileProvider(psiFile);
        if (buildFileProvider == null) {
            throw new IllegalStateException(("Unmanaged file: " + psiFile.getName()).toString());
        }
        BuildFileProvider provider = buildFileProvider;
        PackageCheckerUsageStat.INSTANCE.getFixLocal().log(this.project);
        WriteCommandAction.runWriteCommandAction((Project)psiFile.getProject(), () -> PackageService.updateDependency$lambda$9(provider, psiFile, pkg, version));
    }

    /*
     * WARNING - void declaration
     */
    private final List<ProjectDependenciesModel> dependencyModelsProvider() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = ProjectDependenciesModel.Companion.getEP_NAME().getExtensions((AreaInstance)this.project);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ProjectDependenciesModel projectDependenciesModel = (ProjectDependenciesModel)element$iv$iv;
            boolean bl = false;
            ProgressManager.checkCanceled();
            if (!projectDependenciesModel.supports(this.project)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final BuildFileProvider fileProvider(PsiFile $this$fileProvider) {
        Object v1;
        block1: {
            Project project = $this$fileProvider.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            Project project2 = project;
            Iterable iterable = BuildFileProvider.Companion.getEP_NAME().getExtensions((AreaInstance)project2);
            for (Object t : iterable) {
                BuildFileProvider buildFileProvider = (BuildFileProvider)t;
                boolean bl = false;
                ProgressManager.checkCanceled();
                if (!buildFileProvider.supports($this$fileProvider)) continue;
                v1 = t;
                break block1;
            }
            v1 = null;
        }
        return v1;
    }

    private final BuildFileProvider fileProvider(Module $this$fileProvider) {
        Object v1;
        block1: {
            Project project = $this$fileProvider.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            Project project2 = project;
            Iterable iterable = BuildFileProvider.Companion.getEP_NAME().getExtensions((AreaInstance)project2);
            for (Object t : iterable) {
                BuildFileProvider buildFileProvider = (BuildFileProvider)t;
                boolean bl = false;
                ProgressManager.checkCanceled();
                if (!buildFileProvider.supports($this$fileProvider)) continue;
                v1 = t;
                break block1;
            }
            v1 = null;
        }
        return v1;
    }

    @NotNull
    public final List<Package> importedDependencies(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        BuildFileProvider buildFileProvider = this.fileProvider(module);
        if (buildFileProvider == null) {
            return CollectionsKt.emptyList();
        }
        BuildFileProvider provider = buildFileProvider;
        return provider.importedPackages(module);
    }

    private static final CharSequence scanAllModules$lambda$7$lambda$6(Module it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "Module: " + it.getName() + " " + it;
    }

    private static final Unit updateDependency$lambda$9(BuildFileProvider $provider, PsiFile $psiFile, Package $pkg, String $version) {
        $provider.updatePackageDeclaration($psiFile, $pkg, $version);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/packageChecker/service/PackageService$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/packageChecker/service/PackageService;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.packageChecker"})
    @SourceDebugExtension(value={"SMAP\nPackageService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PackageService.kt\ncom/intellij/packageChecker/service/PackageService$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,133:1\n30#2,2:134\n*S KotlinDebug\n*F\n+ 1 PackageService.kt\ncom/intellij/packageChecker/service/PackageService$Companion\n*L\n129#1:134,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final PackageService getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<PackageService> serviceClass$iv = PackageService.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (PackageService)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

