/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data.attestation.statement;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.exc.InvalidFormatException;
import com.webauthn4j.util.ECUtil;
import com.webauthn4j.util.UnsignedNumberUtil;
import com.webauthn4j.util.exception.NotImplementedException;
import java.security.spec.EllipticCurve;
import org.jetbrains.annotations.NotNull;

public enum TPMEccCurve {
    TPM_ECC_NONE(0),
    TPM_ECC_NIST_P192(1),
    TPM_ECC_NIST_P224(2),
    TPM_ECC_NIST_P256(3),
    TPM_ECC_NIST_P384(4),
    TPM_ECC_NIST_P521(5),
    TPM_ECC_BN_P256(16),
    TPM_ECC_BN_P638(17),
    TPM_ECC_SM2_P256(32);

    private final int value;

    private TPMEccCurve(int value) {
        this.value = value;
    }

    @NotNull
    public static TPMEccCurve create(int value) {
        switch (value) {
            case 0: {
                return TPM_ECC_NONE;
            }
            case 1: {
                return TPM_ECC_NIST_P192;
            }
            case 2: {
                return TPM_ECC_NIST_P224;
            }
            case 3: {
                return TPM_ECC_NIST_P256;
            }
            case 4: {
                return TPM_ECC_NIST_P384;
            }
            case 5: {
                return TPM_ECC_NIST_P521;
            }
            case 16: {
                return TPM_ECC_BN_P256;
            }
            case 17: {
                return TPM_ECC_BN_P638;
            }
            case 32: {
                return TPM_ECC_SM2_P256;
            }
        }
        throw new IllegalArgumentException("value '" + value + "' is out of range");
    }

    @NotNull
    public static TPMEccCurve create(@NotNull EllipticCurve value) {
        if (ECUtil.P_256_SPEC.getCurve().equals(value)) {
            return TPM_ECC_NIST_P256;
        }
        if (ECUtil.P_384_SPEC.getCurve().equals(value)) {
            return TPM_ECC_NIST_P384;
        }
        if (ECUtil.P_521_SPEC.getCurve().equals(value)) {
            return TPM_ECC_NIST_P521;
        }
        throw new IllegalArgumentException("value '" + String.valueOf(value) + "' is out of range");
    }

    @JsonCreator
    @NotNull
    private static TPMEccCurve deserialize(int value) throws InvalidFormatException {
        try {
            return TPMEccCurve.create(value);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidFormatException(null, "value is out of range", (Object)value, TPMEccCurve.class);
        }
    }

    @NotNull
    public byte[] getBytes() {
        return UnsignedNumberUtil.toBytes(this.getValue());
    }

    @JsonValue
    public int getValue() {
        return this.value;
    }

    @NotNull
    public EllipticCurve getEllipticCurve() {
        switch (this) {
            case TPM_ECC_NIST_P256: {
                return ECUtil.P_256_SPEC.getCurve();
            }
            case TPM_ECC_NIST_P384: {
                return ECUtil.P_384_SPEC.getCurve();
            }
            case TPM_ECC_NIST_P521: {
                return ECUtil.P_521_SPEC.getCurve();
            }
        }
        throw new NotImplementedException();
    }
}

