/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.grpc.v1_6;

import io.grpc.ClientInterceptor;
import io.grpc.ServerInterceptor;
import io.grpc.Status;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.context.propagation.ContextPropagators;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.grpc.v1_6.GrpcRequest;
import io.opentelemetry.instrumentation.grpc.v1_6.GrpcTelemetryBuilder;
import io.opentelemetry.instrumentation.grpc.v1_6.TracingClientInterceptor;
import io.opentelemetry.instrumentation.grpc.v1_6.TracingServerInterceptor;

public final class GrpcTelemetry {
    private final Instrumenter<GrpcRequest, Status> serverInstrumenter;
    private final Instrumenter<GrpcRequest, Status> clientInstrumenter;
    private final ContextPropagators propagators;
    private final boolean captureExperimentalSpanAttributes;

    public static GrpcTelemetry create(OpenTelemetry openTelemetry) {
        return GrpcTelemetry.builder(openTelemetry).build();
    }

    public static GrpcTelemetryBuilder builder(OpenTelemetry openTelemetry) {
        return new GrpcTelemetryBuilder(openTelemetry);
    }

    GrpcTelemetry(Instrumenter<GrpcRequest, Status> serverInstrumenter, Instrumenter<GrpcRequest, Status> clientInstrumenter, ContextPropagators propagators, boolean captureExperimentalSpanAttributes) {
        this.serverInstrumenter = serverInstrumenter;
        this.clientInstrumenter = clientInstrumenter;
        this.propagators = propagators;
        this.captureExperimentalSpanAttributes = captureExperimentalSpanAttributes;
    }

    public ClientInterceptor newClientInterceptor() {
        return new TracingClientInterceptor(this.clientInstrumenter, this.propagators);
    }

    public ServerInterceptor newServerInterceptor() {
        return new TracingServerInterceptor(this.serverInstrumenter, this.captureExperimentalSpanAttributes);
    }
}

