/*
 * Decompiled with CFR 0.152.
 */
package org.ice4j.ice.harvest;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ice4j.StackProperties;
import org.ice4j.Transport;
import org.ice4j.TransportAddress;
import org.ice4j.attribute.UsernameAttribute;
import org.ice4j.ice.harvest.HarvestConfig;
import org.ice4j.ice.harvest.HostCandidateHarvester;
import org.ice4j.message.Message;
import org.jitsi.utils.queue.QueueStatistics;

public abstract class AbstractUdpListener {
    private static final Logger logger = Logger.getLogger(AbstractUdpListener.class.getName());
    private static final int BUFFER_SIZE = 1472;
    private static final int POOL_SIZE = 256;
    private final Map<SocketAddress, MySocket> sockets = new ConcurrentHashMap<SocketAddress, MySocket>();
    private final ArrayBlockingQueue<Buffer> pool = new ArrayBlockingQueue(256);
    protected final TransportAddress localAddress;
    private final DatagramSocket socket;
    private final Thread thread;
    private boolean close = false;

    public static List<TransportAddress> getAllowedAddresses(int port) {
        LinkedList<TransportAddress> addresses = new LinkedList<TransportAddress>();
        for (InetAddress address : HostCandidateHarvester.getAllAllowedAddresses()) {
            addresses.add(new TransportAddress(address, port, Transport.UDP));
        }
        return addresses;
    }

    static String getUfrag(byte[] buf, int off, int len) {
        if (buf == null || buf.length < off + len || len < 20) {
            return null;
        }
        if ((buf[off + 4] & 0xFF) != 33 || (buf[off + 5] & 0xFF) != 18 || (buf[off + 6] & 0xFF) != 164 || (buf[off + 7] & 0xFF) != 66) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Not a STUN packet, magic cookie not found.");
            }
            return null;
        }
        try {
            Message stunMessage = Message.decode(buf, off, len);
            if (stunMessage.getMessageType() != '\u0001') {
                return null;
            }
            UsernameAttribute usernameAttribute = (UsernameAttribute)stunMessage.getAttribute('\u0006');
            if (usernameAttribute == null) {
                return null;
            }
            String usernameString = new String(usernameAttribute.getUsername());
            return usernameString.split(":")[0];
        }
        catch (Exception e) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Failed to extract local ufrag: " + e);
            }
            return null;
        }
    }

    protected AbstractUdpListener(TransportAddress localAddress) throws IOException {
        boolean bindWildcard = StackProperties.getBoolean("org.ice4j.BIND_WILDCARD", false);
        this.localAddress = bindWildcard ? new TransportAddress((InetAddress)null, localAddress.getPort(), localAddress.getTransport()) : localAddress;
        this.socket = new DatagramSocket(this.localAddress);
        Integer receiveBufferSize = HarvestConfig.config.udpReceiveBufferSize();
        if (receiveBufferSize != null) {
            this.socket.setReceiveBufferSize(receiveBufferSize);
        }
        String logMessage = "Initialized AbstractUdpListener with address " + this.localAddress;
        logMessage = logMessage + ". Receive buffer size " + this.socket.getReceiveBufferSize();
        if (receiveBufferSize != null) {
            logMessage = logMessage + " (asked for " + receiveBufferSize + ")";
        }
        logger.info(logMessage);
        this.thread = new Thread(){

            @Override
            public void run() {
                AbstractUdpListener.this.runInHarvesterThread();
            }
        };
        this.thread.setName(AbstractUdpListener.class.getName() + " thread for " + this.localAddress);
        this.thread.setDaemon(true);
        this.thread.start();
    }

    public void close() {
        this.close = true;
        this.socket.close();
    }

    private void runInHarvesterThread() {
        DatagramPacket pkt = null;
        while (!this.close) {
            Buffer buf = this.getFreeBuffer();
            if (pkt == null) {
                pkt = new DatagramPacket(buf.buffer, 0, buf.buffer.length);
            } else {
                pkt.setData(buf.buffer, 0, buf.buffer.length);
            }
            try {
                this.socket.receive(pkt);
            }
            catch (IOException ioe) {
                if (this.close) break;
                logger.severe("Failed to receive from socket: " + ioe);
                break;
            }
            buf.len = pkt.getLength();
            InetSocketAddress remoteAddress = (InetSocketAddress)pkt.getSocketAddress();
            MySocket destinationSocket = this.sockets.get(remoteAddress);
            if (destinationSocket != null) {
                destinationSocket.addBuffer(buf);
                continue;
            }
            String ufrag = AbstractUdpListener.getUfrag(buf.buffer, 0, buf.len);
            if (ufrag == null) continue;
            this.maybeAcceptNewSession(buf, remoteAddress, ufrag);
        }
        for (MySocket candidateSocket : new ArrayList<MySocket>(this.sockets.values())) {
            candidateSocket.close();
        }
        this.socket.close();
    }

    protected abstract void maybeAcceptNewSession(Buffer var1, InetSocketAddress var2, String var3);

    private Buffer getFreeBuffer() {
        Buffer buf = this.pool.poll();
        if (buf == null) {
            buf = new Buffer(new byte[1472], 0);
        }
        return buf;
    }

    protected MySocket addSocket(InetSocketAddress remoteAddress, String ufrag) throws SocketException {
        MySocket newSocket = new MySocket(remoteAddress, ufrag);
        this.sockets.put(remoteAddress, newSocket);
        return newSocket;
    }

    protected class Buffer {
        byte[] buffer;
        int len;

        private Buffer(byte[] buffer, int len) {
            this.buffer = buffer;
            this.len = len;
        }
    }

    protected class MySocket
    extends DatagramSocket {
        private static final int QUEUE_SIZE = 128;
        private final ArrayBlockingQueue<Buffer> queue;
        private final QueueStatistics queueStatistics;
        private InetSocketAddress remoteAddress;
        private boolean closed;
        private final String ufrag;

        MySocket(InetSocketAddress remoteAddress, String ufrag) throws SocketException {
            super((SocketAddress)null);
            this.queue = new ArrayBlockingQueue(128);
            this.closed = false;
            this.ufrag = ufrag;
            this.remoteAddress = remoteAddress;
            this.queueStatistics = logger.isLoggable(Level.FINEST) ? new QueueStatistics() : null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addBuffer(Buffer buf) {
            ArrayBlockingQueue<Buffer> arrayBlockingQueue = this.queue;
            synchronized (arrayBlockingQueue) {
                if (this.queue.size() == 128) {
                    logger.info("Dropping a packet because the queue is full. Remote address = " + this.remoteAddress + " ufrag=" + this.ufrag);
                    if (this.queueStatistics != null) {
                        this.queueStatistics.remove(System.currentTimeMillis());
                    }
                    this.queue.poll();
                }
                this.queue.offer(buf);
                if (this.queueStatistics != null) {
                    this.queueStatistics.add(System.currentTimeMillis());
                }
                this.queue.notify();
            }
        }

        @Override
        public InetAddress getLocalAddress() {
            return AbstractUdpListener.this.localAddress.getAddress();
        }

        @Override
        public int getLocalPort() {
            return AbstractUdpListener.this.localAddress.getPort();
        }

        @Override
        public SocketAddress getLocalSocketAddress() {
            return AbstractUdpListener.this.localAddress;
        }

        @Override
        public SocketAddress getRemoteSocketAddress() {
            return this.remoteAddress;
        }

        @Override
        public InetAddress getInetAddress() {
            return this.remoteAddress.getAddress();
        }

        @Override
        public int getPort() {
            return this.remoteAddress.getPort();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            ArrayBlockingQueue<Buffer> arrayBlockingQueue = this.queue;
            synchronized (arrayBlockingQueue) {
                this.closed = true;
                this.queue.notifyAll();
            }
            if (this.remoteAddress != null) {
                AbstractUdpListener.this.sockets.remove(this.remoteAddress);
            }
            super.close();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void receive(DatagramPacket p) throws IOException {
            Buffer buf = null;
            while (buf == null) {
                ArrayBlockingQueue<Buffer> arrayBlockingQueue = this.queue;
                synchronized (arrayBlockingQueue) {
                    if (this.closed) {
                        throw new SocketException("Socket closed");
                    }
                    if (this.queue.isEmpty()) {
                        try {
                            this.queue.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    buf = this.queue.poll();
                    if (this.queueStatistics != null) {
                        this.queueStatistics.remove(System.currentTimeMillis());
                    }
                }
            }
            byte[] pData = p.getData();
            if (pData == null || pData.length < buf.len) {
                throw new IOException("packet buffer not available");
            }
            System.arraycopy(buf.buffer, 0, pData, 0, buf.len);
            p.setLength(buf.len);
            p.setSocketAddress(this.remoteAddress);
            AbstractUdpListener.this.pool.offer(buf);
        }

        @Override
        public void send(DatagramPacket p) throws IOException {
            AbstractUdpListener.this.socket.send(p);
        }
    }
}

