/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.ddl;

import ca.sqlpower.architect.ArchitectUtils;
import ca.sqlpower.architect.DepthFirstSearch;
import ca.sqlpower.architect.ddl.CaseInsensitiveHashMap;
import ca.sqlpower.architect.ddl.DDLGenerator;
import ca.sqlpower.architect.ddl.DDLStatement;
import ca.sqlpower.architect.ddl.DDLUtils;
import ca.sqlpower.architect.ddl.GenericTypeDescriptor;
import ca.sqlpower.architect.profile.ProfileFunctionDescriptor;
import ca.sqlpower.diff.DiffChunk;
import ca.sqlpower.object.SPObject;
import ca.sqlpower.object.SPResolverRegistry;
import ca.sqlpower.object.SPVariableHelper;
import ca.sqlpower.object.SPVariableResolver;
import ca.sqlpower.sqlobject.SQLCheckConstraint;
import ca.sqlpower.sqlobject.SQLColumn;
import ca.sqlpower.sqlobject.SQLDatabase;
import ca.sqlpower.sqlobject.SQLEnumeration;
import ca.sqlpower.sqlobject.SQLIndex;
import ca.sqlpower.sqlobject.SQLObject;
import ca.sqlpower.sqlobject.SQLObjectException;
import ca.sqlpower.sqlobject.SQLRelationship;
import ca.sqlpower.sqlobject.SQLTable;
import ca.sqlpower.sqlobject.SQLTypePhysicalProperties;
import ca.sqlpower.sqlobject.SQLTypePhysicalPropertiesProvider;
import ca.sqlpower.sqlobject.UserDefinedSQLType;
import ca.sqlpower.util.SQLPowerUtils;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class GenericDDLGenerator
implements DDLGenerator {
    public static final String GENERATOR_VERSION = "$Revision: 3995 $";
    private static final Logger logger = Logger.getLogger(GenericDDLGenerator.class);
    protected boolean allowConnection;
    private StringBuffer ddl;
    private List<DDLStatement> ddlStatements;
    protected static final String EOL = System.getProperty("line.separator");
    protected Map<Integer, GenericTypeDescriptor> typeMap;
    protected Connection con;
    protected Map<String, SQLObject> topLevelNames;
    protected String targetCatalog;
    protected String targetSchema;
    protected Map<String, ProfileFunctionDescriptor> profileFunctionMap;

    @Override
    public String getName() {
        return "Generic SQL-92";
    }

    @Override
    public boolean isReservedWord(String word) {
        return false;
    }

    public GenericDDLGenerator(boolean allowConnection) throws SQLException {
        this.allowConnection = allowConnection;
        this.ddlStatements = new ArrayList<DDLStatement>();
        this.ddl = new StringBuffer(500);
        this.println("");
        this.topLevelNames = new CaseInsensitiveHashMap();
        this.createTypeMap();
    }

    public GenericDDLGenerator() throws SQLException {
        this(true);
    }

    @Override
    public String generateDDLScript(Collection<SQLTable> tables) throws SQLException, SQLObjectException {
        List<DDLStatement> statements = this.generateDDLStatements(tables);
        this.ddl = new StringBuffer(4000);
        this.writeHeader();
        this.writeDDLTransactionBegin();
        for (DDLStatement ddlStmt : statements) {
            this.ddl.append(ddlStmt.getSQLText());
            this.println(this.getStatementTerminator());
        }
        this.writeDDLTransactionEnd();
        return this.ddl.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final List<DDLStatement> generateDDLStatements(Collection<SQLTable> tables) throws SQLException, SQLObjectException {
        this.ddlStatements = new ArrayList<DDLStatement>();
        this.ddl = new StringBuffer(500);
        this.topLevelNames = new CaseInsensitiveHashMap();
        List<SQLTable> tableList = new ArrayList<SQLTable>(tables);
        DepthFirstSearch dfs = new DepthFirstSearch(tableList);
        tableList = dfs.getFinishOrder();
        try {
            SQLDatabase parentDb;
            this.con = this.allowConnection && tableList.size() > 0 ? ((parentDb = (SQLDatabase)SQLPowerUtils.getAncestor((SPObject)((SPObject)tableList.get(0)), SQLDatabase.class)).isPlayPenDatabase() ? null : parentDb.getConnection()) : null;
            this.createTypeMap();
            for (SQLTable t : tableList) {
                this.addTable(t);
                for (SQLIndex index : t.getIndices()) {
                    if (index.isPrimaryKeyIndex()) continue;
                    this.addIndex(index);
                }
            }
            for (SQLTable t : tableList) {
                this.writeExportedRelationships(t);
            }
        }
        finally {
            try {
                if (this.con != null) {
                    this.con.close();
                }
            }
            catch (SQLException ex) {
                logger.error((Object)"Couldn't close connection", (Throwable)ex);
            }
        }
        return this.ddlStatements;
    }

    public final void endStatement(DDLStatement.StatementType type, SQLObject sqlObject) {
        if (logger.isInfoEnabled()) {
            logger.info((Object)("endStatement: " + this.ddl.toString()));
        }
        this.ddlStatements.add(new DDLStatement(sqlObject, type, this.ddl.toString(), this.getStatementTerminator(), this.getTargetCatalog(), this.getTargetSchema()));
        this.ddl = new StringBuffer(500);
        this.println("");
    }

    public void writeHeader() {
        this.println("-- Created by SQLPower Generic DDL Generator $Revision: 3995 $ --");
    }

    @Override
    public String getStatementTerminator() {
        return ";";
    }

    public void writeDDLTransactionBegin() {
    }

    public void writeDDLTransactionEnd() {
    }

    public void writeCreateDB(SQLDatabase db) {
        this.println("-- Would Create Database " + db.getName() + " here. --");
    }

    @Override
    public void renameRelationship(SQLRelationship oldFK, SQLRelationship newFK) {
        this.dropRelationship(oldFK);
        this.addRelationship(newFK);
    }

    @Override
    public void dropRelationship(SQLRelationship r) {
        this.print("\nALTER TABLE ");
        this.print(this.toQualifiedName(r.getFkTable()));
        this.print(" DROP CONSTRAINT ");
        this.print(this.createPhysicalName(this.topLevelNames, (SQLObject)r));
        this.endStatement(DDLStatement.StatementType.DROP, (SQLObject)r);
    }

    @Override
    public void addRelationship(SQLRelationship r) {
        SQLColumn c;
        StringBuilder sql = new StringBuilder();
        StringBuilder errorMsg = new StringBuilder();
        boolean skipStatement = false;
        StringBuilder typesMismatchMsg = new StringBuilder();
        sql.append("\nALTER TABLE ");
        sql.append(this.toQualifiedName(r.getFkTable()));
        sql.append(" ADD CONSTRAINT ");
        sql.append(this.createPhysicalName(this.topLevelNames, (SQLObject)r));
        sql.append("\nFOREIGN KEY (");
        HashMap<String, SQLObject> colNameMap = new HashMap<String, SQLObject>();
        boolean firstColumn = true;
        for (SQLRelationship.ColumnMapping cm : r.getChildren(SQLRelationship.ColumnMapping.class)) {
            c = cm.getFkColumn();
            if (colNameMap.get(c.getName()) != null) continue;
            if (firstColumn) {
                firstColumn = false;
                sql.append(this.createPhysicalName(colNameMap, (SQLObject)c));
            } else {
                sql.append(", " + this.createPhysicalName(colNameMap, (SQLObject)c));
            }
            colNameMap.put(c.getName(), (SQLObject)c);
        }
        sql.append(")");
        sql.append("\nREFERENCES ");
        sql.append(this.toQualifiedName(r.getPkTable()));
        sql.append(" (");
        colNameMap.clear();
        firstColumn = true;
        if (r.getChildren().isEmpty()) {
            errorMsg.append("Warning: Relationship has no columns to map:\n");
        }
        for (SQLRelationship.ColumnMapping cm : r.getChildren(SQLRelationship.ColumnMapping.class)) {
            c = cm.getPkColumn();
            SQLColumn fkCol = cm.getFkColumn();
            if (ArchitectUtils.columnTypesDiffer(c.getType(), fkCol.getType())) {
                typesMismatchMsg.append("        " + c + " -- " + fkCol + "\n");
            }
            if (colNameMap.get(c.getName()) != null) continue;
            if (firstColumn) {
                firstColumn = false;
                sql.append(this.createPhysicalName(colNameMap, (SQLObject)c));
            } else {
                sql.append(", " + this.createPhysicalName(colNameMap, (SQLObject)c));
            }
            colNameMap.put(c.getName(), (SQLObject)c);
        }
        sql.append(")");
        if (typesMismatchMsg.length() != 0) {
            errorMsg.append("Warning: Column types mismatch in the following column mapping(s):\n");
            errorMsg.append(typesMismatchMsg.toString());
        }
        if (this.supportsDeleteAction(r)) {
            String deleteActionClause = this.getDeleteActionClause(r);
            if (deleteActionClause.length() > 0) {
                sql.append("\n").append(deleteActionClause);
            }
        } else {
            errorMsg.append("Warning: " + this.getName() + " does not support this relationship's " + "delete action (" + r.getDeleteRule() + ").\n");
        }
        if (this.supportsUpdateAction(r)) {
            String updateActionClause = this.getUpdateActionClause(r);
            if (updateActionClause.length() > 0) {
                sql.append("\n").append(updateActionClause);
            }
        } else {
            errorMsg.append("Warning: " + this.getName() + " does not support this relationship's " + "update action (" + r.getUpdateRule() + ").\n");
        }
        if (this.supportsDeferrabilityPolicy(r)) {
            String deferrabilityClause = this.getDeferrabilityClause(r);
            if (deferrabilityClause.length() > 0) {
                sql.append("\n").append(deferrabilityClause);
            }
        } else {
            errorMsg.append("Warning: " + this.getName() + " does not support this relationship's " + "deferrability policy (" + r.getDeferrability() + ").\n");
        }
        if (errorMsg.length() != 0) {
            if (skipStatement) {
                sql.append("*/");
            } else {
                errorMsg.append("*/");
            }
            sql.insert(0, "\n/*\n" + errorMsg.toString());
        }
        this.print(sql.toString());
        this.endStatement(DDLStatement.StatementType.CREATE, (SQLObject)r);
    }

    public boolean supportsDeleteAction(SQLRelationship r) {
        return true;
    }

    public String getDeleteActionClause(SQLRelationship r) {
        return "ON DELETE " + this.getUpdateDeleteRule(r.getDeleteRule());
    }

    private String getUpdateDeleteRule(SQLRelationship.UpdateDeleteRule rule) {
        String action;
        if (rule == SQLRelationship.UpdateDeleteRule.CASCADE) {
            action = "CASCADE";
        } else if (rule == SQLRelationship.UpdateDeleteRule.NO_ACTION) {
            action = "NO ACTION";
        } else if (rule == SQLRelationship.UpdateDeleteRule.RESTRICT) {
            action = "RESTRICT";
        } else if (rule == SQLRelationship.UpdateDeleteRule.SET_DEFAULT) {
            action = "SET DEFAULT";
        } else if (rule == SQLRelationship.UpdateDeleteRule.SET_NULL) {
            action = "SET NULL";
        } else {
            throw new IllegalArgumentException("Unknown enum value: " + rule);
        }
        return action;
    }

    public boolean supportsUpdateAction(SQLRelationship r) {
        return true;
    }

    public String getUpdateActionClause(SQLRelationship r) {
        return "ON UPDATE " + this.getUpdateDeleteRule(r.getUpdateRule());
    }

    public String getDeferrabilityClause(SQLRelationship r) {
        if (this.supportsDeferrabilityPolicy(r)) {
            if (r.getDeferrability() == SQLRelationship.Deferrability.NOT_DEFERRABLE) {
                return "NOT DEFERRABLE";
            }
            if (r.getDeferrability() == SQLRelationship.Deferrability.INITIALLY_DEFERRED) {
                return "DEFERRABLE INITIALLY DEFERRED";
            }
            if (r.getDeferrability() == SQLRelationship.Deferrability.INITIALLY_IMMEDIATE) {
                return "DEFERRABLE INITIALLY IMMEDIATE";
            }
            throw new IllegalArgumentException("Unknown deferrability policy: " + r.getDeferrability());
        }
        throw new UnsupportedOperationException(this.getName() + " does not support " + r.getName() + "'s deferrability policy (" + r.getDeferrability() + ").");
    }

    public boolean supportsDeferrabilityPolicy(SQLRelationship r) {
        if (!Arrays.asList(SQLRelationship.Deferrability.values()).contains(r.getDeferrability())) {
            throw new IllegalArgumentException("Unknown deferrability policy: " + r.getDeferrability());
        }
        return true;
    }

    @Override
    public void renameTable(SQLTable oldTable, SQLTable newTable) {
        this.println("ALTER TABLE " + oldTable.getPhysicalName() + " RENAME TO " + newTable.getPhysicalName());
        this.endStatement(DDLStatement.StatementType.ALTER, (SQLObject)newTable);
    }

    @Override
    public void addComment(SQLObject o) {
    }

    @Override
    public void modifyComment(SQLObject o) {
        if (o instanceof SQLTable) {
            this.addComment((SQLTable)o, false);
        } else if (o instanceof SQLColumn) {
            this.addComment((SQLColumn)o);
        }
    }

    public void addComment(SQLColumn c) {
        if (c.getRemarks() == null || c.getRemarks().trim().length() == 0) {
            return;
        }
        this.print("COMMENT ON COLUMN ");
        this.print(this.toQualifiedName(c.getParent()));
        this.print(".");
        this.print(c.getPhysicalName());
        this.print(" IS '");
        this.print(c.getRemarks().replaceAll("'", "''"));
        this.print("'");
        this.endStatement(DDLStatement.StatementType.COMMENT, (SQLObject)c);
    }

    public void addComment(SQLTable t, boolean includeColumns) {
        if (t.getRemarks() != null && t.getRemarks().trim().length() > 0) {
            this.print("COMMENT ON TABLE ");
            this.print(this.toQualifiedName(t));
            this.print(" IS '");
            this.print(t.getRemarks().replaceAll("'", "''"));
            this.print("'");
            this.endStatement(DDLStatement.StatementType.COMMENT, (SQLObject)t);
        }
        if (includeColumns) {
            this.addColumnComments(t);
        }
    }

    protected void addColumnComments(SQLTable t) {
        try {
            for (SQLColumn col : t.getColumns()) {
                this.addComment(col);
            }
        }
        catch (SQLObjectException ex) {
            logger.error((Object)("Could not add column remarks for table " + t), (Throwable)ex);
        }
        this.print("\n");
    }

    @Override
    public void renameColumn(SQLColumn oldCol, SQLColumn newCol) {
        HashMap<String, SQLObject> colNameMap = new HashMap<String, SQLObject>();
        this.print("\nALTER TABLE ");
        this.print(this.toQualifiedName(oldCol.getParent()));
        this.print(" RENAME COLUMN ");
        this.print(this.createPhysicalName(colNameMap, (SQLObject)oldCol));
        this.print(" TO ");
        this.print(this.createPhysicalName(colNameMap, (SQLObject)newCol));
        this.endStatement(DDLStatement.StatementType.ALTER, (SQLObject)oldCol);
    }

    @Override
    public void addColumn(SQLColumn c) {
        HashMap<String, SQLObject> colNameMap = new HashMap<String, SQLObject>();
        this.print("\nALTER TABLE ");
        this.print(this.toQualifiedName(c.getParent()));
        this.print(" ADD COLUMN ");
        this.print(this.columnDefinition(c, colNameMap));
        this.endStatement(DDLStatement.StatementType.CREATE, (SQLObject)c);
    }

    @Override
    public void dropColumn(SQLColumn c) {
        HashMap<String, SQLObject> colNameMap = new HashMap<String, SQLObject>();
        this.print("\nALTER TABLE ");
        this.print(this.toQualifiedName(c.getParent()));
        this.print(" DROP COLUMN ");
        this.print(this.createPhysicalName(colNameMap, (SQLObject)c));
        this.endStatement(DDLStatement.StatementType.DROP, (SQLObject)c);
    }

    @Override
    public void modifyColumn(SQLColumn c, DiffChunk<SQLObject> diffChunk) {
        HashMap<String, SQLObject> colNameMap = new HashMap<String, SQLObject>();
        SQLTable t = c.getParent();
        this.print("\nALTER TABLE ");
        this.print(this.toQualifiedName(t));
        this.print(" ALTER COLUMN ");
        this.print(this.columnDefinition(c, colNameMap));
        this.endStatement(DDLStatement.StatementType.MODIFY, (SQLObject)c);
        this.addComment(c);
    }

    @Override
    public void dropTable(SQLTable t) {
        this.print(this.makeDropTableSQL(t.getName()));
        this.endStatement(DDLStatement.StatementType.DROP, (SQLObject)t);
    }

    protected String columnDefinition(SQLColumn c, Map<String, SQLObject> colNameMap) {
        return this.columnDefinition(c, colNameMap, true);
    }

    protected String columnDefinition(SQLColumn c, Map<String, SQLObject> colNameMap, boolean alterNullability) {
        String columnEnumeration;
        List enumerations;
        List checkConstraints;
        SQLTypePhysicalProperties.SQLTypeConstraint constraintType;
        StringBuffer def = new StringBuffer();
        def.append(this.createPhysicalName(colNameMap, (SQLObject)c));
        def.append(" ");
        def.append(this.columnType(c));
        UserDefinedSQLType type = c.getUserDefinedSQLType();
        String defaultValue = type.getDefaultValue(this.getPlatformName());
        if (defaultValue != null && !defaultValue.equals("")) {
            def.append(" ");
            def.append("DEFAULT ");
            def.append(defaultValue);
        }
        if (alterNullability) {
            def.append(this.columnNullability(c));
        }
        if ((constraintType = type.getConstraintType(this.getPlatformName())) == null) {
            constraintType = type.getDefaultPhysicalProperties().getConstraintType();
            checkConstraints = type.getDefaultPhysicalProperties().getChildrenWithoutPopulating(SQLCheckConstraint.class);
            enumerations = type.getDefaultPhysicalProperties().getChildrenWithoutPopulating(SQLEnumeration.class);
        } else {
            checkConstraints = type.getCheckConstraints(this.getPlatformName());
            enumerations = type.getEnumerations(this.getPlatformName());
        }
        if (constraintType == SQLTypePhysicalProperties.SQLTypeConstraint.CHECK) {
            String columnCheckConstraint = this.columnCheckConstraint(c, checkConstraints);
            if (columnCheckConstraint != null && columnCheckConstraint.length() > 0) {
                def.append(" " + columnCheckConstraint);
            }
        } else if (constraintType == SQLTypePhysicalProperties.SQLTypeConstraint.ENUM && (columnEnumeration = this.columnEnumeration(c, enumerations)) != null && columnEnumeration.length() > 0) {
            def.append(" " + columnEnumeration);
        }
        logger.debug((Object)("column definition " + def.toString()));
        return def.toString();
    }

    protected String columnNullability(SQLColumn c) {
        GenericTypeDescriptor td = this.failsafeGetTypeDescriptor(c);
        if (c.isDefinitelyNullable()) {
            if (!td.isNullable()) {
                throw new UnsupportedOperationException("The data type " + td.getName() + " is not nullable on the target database platform.");
            }
            return "";
        }
        return " NOT NULL";
    }

    protected String columnCheckConstraint(SQLColumn c, List<SQLCheckConstraint> checkConstraints) {
        if (!this.supportsCheckConstraint() || c == null || checkConstraints == null || checkConstraints.isEmpty()) {
            return "";
        }
        SPVariableResolver resolver = c.getVariableResolver();
        SPVariableHelper helper = new SPVariableHelper((SPObject)c);
        SPResolverRegistry.register((SPObject)c, (SPVariableResolver)resolver);
        StringBuilder sb = new StringBuilder();
        for (SQLCheckConstraint constraint : checkConstraints) {
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append(String.format("CONSTRAINT %s CHECK (%s)", constraint.getName(), helper.substitute(constraint.getConstraint())));
        }
        SPResolverRegistry.deregister((SPObject)c, (SPVariableResolver)resolver);
        return sb.toString();
    }

    protected String columnEnumeration(SQLColumn c, List<SQLEnumeration> enumerations) {
        if (this.supportsCheckConstraint()) {
            return this.columnEnumToCheckConstraint(c, enumerations);
        }
        return "";
    }

    protected String columnEnumToCheckConstraint(SQLColumn c, List<SQLEnumeration> enumerations) {
        if (c == null || enumerations == null || enumerations.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (SQLEnumeration enumeration : enumerations) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append("'" + enumeration.getName() + "'");
        }
        return "CHECK (" + c.getPhysicalName() + " IN (" + sb.toString() + "))";
    }

    protected String getPlatformName() {
        return "GENERIC";
    }

    @Override
    public String columnType(SQLColumn c) {
        StringBuffer def = new StringBuffer();
        UserDefinedSQLType columnType = c.getUserDefinedSQLType();
        if (columnType.getUpstreamType() != null) {
            def.append(columnType.getUpstreamType().getPhysicalName(this.getPlatformName()));
        } else {
            def.append(columnType.getPhysicalName(this.getPlatformName()));
        }
        int precision = columnType.getPrecision(this.getPlatformName());
        int scale = columnType.getScale(this.getPlatformName());
        SQLTypePhysicalPropertiesProvider.PropertyType precisionType = columnType.getPrecisionType(this.getPlatformName());
        SQLTypePhysicalPropertiesProvider.PropertyType scaleType = columnType.getScaleType(this.getPlatformName());
        if (precisionType != SQLTypePhysicalPropertiesProvider.PropertyType.NOT_APPLICABLE && scaleType != SQLTypePhysicalPropertiesProvider.PropertyType.NOT_APPLICABLE && precision > 0 && scale > 0) {
            def.append("(" + columnType.getPrecision(this.getPlatformName()));
            def.append("," + columnType.getScale(this.getPlatformName()) + ")");
        } else if (precisionType != SQLTypePhysicalPropertiesProvider.PropertyType.NOT_APPLICABLE && precision > 0) {
            def.append("(" + columnType.getPrecision(this.getPlatformName()) + ")");
        } else if (scaleType != SQLTypePhysicalPropertiesProvider.PropertyType.NOT_APPLICABLE && scale > 0) {
            def.append("(" + columnType.getScale(this.getPlatformName()) + ")");
        }
        return def.toString();
    }

    public String getColumnDataTypeName(SQLColumn c) {
        StringBuffer def = new StringBuffer();
        GenericTypeDescriptor td = this.failsafeGetTypeDescriptor(c);
        def.append(td.getName());
        if (td.getHasPrecision()) {
            def.append("(" + c.getPrecision());
            if (td.getHasScale()) {
                def.append("," + c.getScale());
            }
            def.append(")");
        }
        return def.toString();
    }

    protected GenericTypeDescriptor failsafeGetTypeDescriptor(SQLColumn c) {
        GenericTypeDescriptor td = this.typeMap.get(c.getType());
        if (td == null && (td = this.typeMap.get(this.getDefaultType())) == null) {
            throw new NullPointerException("Current type map does not have entry for default datatype!");
        }
        return td;
    }

    @Override
    public void addTable(SQLTable t) throws SQLException, SQLObjectException {
        HashMap<String, SQLObject> colNameMap = new HashMap<String, SQLObject>();
        this.createPhysicalName(this.topLevelNames, (SQLObject)t);
        this.print("\nCREATE TABLE ");
        this.print(this.toQualifiedName(t));
        this.println(" (");
        boolean firstCol = true;
        for (SQLColumn c : t.getColumns()) {
            if (!firstCol) {
                this.println(",");
            }
            this.print("                ");
            this.print(this.columnDefinition(c, colNameMap));
            firstCol = false;
        }
        SQLIndex pk = t.getPrimaryKeyIndex();
        if (pk.getChildCount() > 0) {
            this.print(",\n");
            this.print("                ");
            this.writePKConstraintClause(pk);
        }
        this.print("\n)");
        this.endStatement(DDLStatement.StatementType.CREATE, (SQLObject)t);
        this.addComment(t, true);
    }

    protected Object getDefaultType() {
        return 12;
    }

    protected void writePKConstraintClause(SQLIndex pk) throws SQLObjectException {
        if (!pk.isPrimaryKeyIndex()) {
            throw new IllegalArgumentException("The given index is not a primary key");
        }
        this.createPhysicalName(this.topLevelNames, (SQLObject)pk);
        this.print("CONSTRAINT ");
        this.print(pk.getPhysicalName());
        this.print(" PRIMARY KEY (");
        boolean firstCol = true;
        for (SQLIndex.Column col : pk.getChildren(SQLIndex.Column.class)) {
            if (!firstCol) {
                this.print(", ");
            }
            if (col.getColumn() == null) {
                throw new IllegalStateException("Index column is not associated with the real column in the table.");
            }
            this.print(col.getColumn().getPhysicalName());
            firstCol = false;
        }
        this.print(")");
    }

    protected void writePrimaryKey(SQLTable t) throws SQLObjectException {
        this.println("");
        this.print("ALTER TABLE ");
        this.print(this.toQualifiedName(t));
        this.print(" ADD ");
        this.writePKConstraintClause(t.getPrimaryKeyIndex());
        this.endStatement(DDLStatement.StatementType.ADD_PK, (SQLObject)t);
    }

    protected void writeExportedRelationships(SQLTable t) throws SQLObjectException {
        for (SQLRelationship rel : t.getExportedKeys()) {
            this.addRelationship(rel);
        }
    }

    protected void createTypeMap() throws SQLException {
        this.typeMap = new HashMap<Integer, GenericTypeDescriptor>();
        if (this.con == null || !this.allowConnection) {
            this.typeMap.put(-5, new GenericTypeDescriptor("BIGINT", -5, 38L, null, null, 1, false, false));
            this.typeMap.put(-2, new GenericTypeDescriptor("BINARY", -2, 2000L, "0x", null, 1, true, false));
            this.typeMap.put(-7, new GenericTypeDescriptor("BIT", -7, 1L, null, null, 1, false, false));
            this.typeMap.put(16, new GenericTypeDescriptor("BOOLEAN", 16, 1L, null, null, 1, false, false));
            this.typeMap.put(2004, new GenericTypeDescriptor("BLOB", 2004, Integer.MAX_VALUE, "0x", null, 1, true, false));
            this.typeMap.put(1, new GenericTypeDescriptor("CHAR", 1, 8000L, "'", "'", 1, true, false));
            this.typeMap.put(2005, new GenericTypeDescriptor("CLOB", 2005, Integer.MAX_VALUE, "'", "'", 1, true, false));
            this.typeMap.put(91, new GenericTypeDescriptor("DATE", 91, 23L, "'", "'", 1, false, false));
            this.typeMap.put(3, new GenericTypeDescriptor("DECIMAL", 3, 38L, null, null, 1, true, true));
            this.typeMap.put(8, new GenericTypeDescriptor("DOUBLE", 8, 38L, null, null, 1, false, false));
            this.typeMap.put(6, new GenericTypeDescriptor("FLOAT", 6, 38L, null, null, 1, false, false));
            this.typeMap.put(4, new GenericTypeDescriptor("INTEGER", 4, 10L, null, null, 1, false, false));
            this.typeMap.put(-4, new GenericTypeDescriptor("LONGVARBINARY", -4, Integer.MAX_VALUE, "0x", null, 1, true, false));
            this.typeMap.put(-1, new GenericTypeDescriptor("LONGVARCHAR", -1, Integer.MAX_VALUE, "'", "'", 1, true, false));
            this.typeMap.put(2, new GenericTypeDescriptor("NUMERIC", 2, 38L, null, null, 1, true, true));
            this.typeMap.put(7, new GenericTypeDescriptor("REAL", 7, 38L, null, null, 1, false, false));
            this.typeMap.put(5, new GenericTypeDescriptor("SMALLINT", 5, 5L, null, null, 1, false, false));
            this.typeMap.put(92, new GenericTypeDescriptor("TIME", 92, 23L, "'", "'", 1, false, false));
            this.typeMap.put(93, new GenericTypeDescriptor("TIMESTAMP", 93, 23L, "'", "'", 1, false, false));
            this.typeMap.put(-6, new GenericTypeDescriptor("TINYINT", -6, 3L, null, null, 1, false, false));
            this.typeMap.put(-3, new GenericTypeDescriptor("VARBINARY", -3, 8000L, null, null, 1, true, false));
            this.typeMap.put(12, new GenericTypeDescriptor("VARCHAR", 12, 8000L, "'", "'", 1, true, false));
            this.typeMap.put(-9, new GenericTypeDescriptor("NVARCHAR", -9, 8000L, "'", "'", 1, true, false));
            this.typeMap.put(-15, new GenericTypeDescriptor("NCHAR", -15, 8000L, "'", "'", 1, true, false));
            this.typeMap.put(2011, new GenericTypeDescriptor("NCLOB", 2011, Integer.MAX_VALUE, "'", "'", 1, false, false));
        } else {
            DatabaseMetaData dbmd = this.con.getMetaData();
            ResultSet rs = dbmd.getTypeInfo();
            while (rs.next()) {
                GenericTypeDescriptor td = new GenericTypeDescriptor(rs);
                this.typeMap.put(td.getDataType(), td);
            }
            rs.close();
        }
    }

    protected void println(String text) {
        this.ddl.append(text).append(EOL);
    }

    protected void print(String text) {
        this.ddl.append(text);
    }

    @Override
    public String toIdentifier(String name) {
        if (name == null) {
            return null;
        }
        return name.replace(' ', '_');
    }

    public String toQualifiedName(SQLTable t) {
        return this.toQualifiedName(t.getPhysicalName());
    }

    public String toQualifiedName(SQLIndex i) {
        return this.toQualifiedName(i.getPhysicalName());
    }

    public String toQualifiedName(String tname) {
        String catalog = this.getTargetCatalog();
        String schema = this.getTargetSchema();
        return DDLUtils.toQualifiedName(catalog, schema, tname);
    }

    @Override
    public boolean getAllowConnection() {
        return this.allowConnection;
    }

    @Override
    public void setAllowConnection(boolean argAllowConnection) {
        this.allowConnection = argAllowConnection;
    }

    @Override
    public Map<Integer, GenericTypeDescriptor> getTypeMap() {
        return this.typeMap;
    }

    @Override
    public void setTypeMap(Map<Integer, GenericTypeDescriptor> argTypeMap) {
        this.typeMap = argTypeMap;
    }

    public Map<String, ProfileFunctionDescriptor> getProfileFunctionMap() {
        return this.profileFunctionMap;
    }

    public void setProfileFunctionMap(Map<String, ProfileFunctionDescriptor> profileFunctionMap) {
        this.profileFunctionMap = profileFunctionMap;
    }

    public Connection getCon() {
        return this.con;
    }

    public void setCon(Connection argCon) {
        this.con = argCon;
    }

    @Override
    public String getTargetCatalog() {
        return this.targetCatalog;
    }

    @Override
    public void setTargetCatalog(String argTargetCatalog) {
        this.targetCatalog = argTargetCatalog;
    }

    @Override
    public String getTargetSchema() {
        return this.targetSchema;
    }

    @Override
    public void setTargetSchema(String argTargetSchema) {
        this.targetSchema = argTargetSchema;
    }

    @Override
    public String getCatalogTerm() {
        return null;
    }

    @Override
    public String getSchemaTerm() {
        return null;
    }

    protected String createPhysicalName(Map<String, SQLObject> dupCheck, SQLObject so) {
        logger.debug((Object)("transform identifier source: " + so.getPhysicalName()));
        if ((so instanceof SQLTable || so instanceof SQLColumn) && so.getPhysicalName() != null && !so.getPhysicalName().trim().equals("")) {
            String physicalName = so.getPhysicalName();
            logger.debug((Object)("The physical name for this SQLObject is: " + physicalName));
        } else {
            so.setPhysicalName(this.toIdentifier(so.getName()));
        }
        logger.debug((Object)("The logical name field now is: " + so.getName()));
        return so.getPhysicalName();
    }

    @Override
    public String makeDropTableSQL(String table) {
        return "\nDROP TABLE " + this.toQualifiedName(table);
    }

    @Override
    public String makeDropForeignKeySQL(String fkTable, String fkName) {
        return "\nALTER TABLE " + this.toQualifiedName(fkTable) + " DROP FOREIGN KEY " + fkName;
    }

    @Override
    public List<DDLStatement> getDdlStatements() {
        return this.ddlStatements;
    }

    @Override
    public void dropPrimaryKey(SQLTable t) throws SQLObjectException {
        SQLIndex pk = t.getPrimaryKeyIndex();
        this.print("\nALTER TABLE " + this.toQualifiedName(t.getName()) + " DROP CONSTRAINT " + pk.getPhysicalName());
        this.endStatement(DDLStatement.StatementType.DROP, (SQLObject)t);
    }

    @Override
    public void addPrimaryKey(SQLTable t) throws SQLObjectException {
        HashMap<String, SQLObject> colNameMap = new HashMap<String, SQLObject>();
        StringBuffer sqlStatement = new StringBuffer();
        boolean first = true;
        sqlStatement.append("\nALTER TABLE " + this.toQualifiedName(t.getName()) + " ADD PRIMARY KEY (");
        for (SQLColumn c : t.getColumns()) {
            if (!c.isPrimaryKey()) continue;
            if (!first) {
                sqlStatement.append(",");
            } else {
                first = false;
            }
            sqlStatement.append(this.createPhysicalName(colNameMap, (SQLObject)c));
        }
        sqlStatement.append(")");
        if (!first) {
            this.print(sqlStatement.toString());
            this.endStatement(DDLStatement.StatementType.CREATE, (SQLObject)t);
        }
    }

    @Override
    public void dropIndex(SQLIndex index) throws SQLObjectException {
        this.print("DROP INDEX ");
        this.println(this.toQualifiedName(index));
        this.endStatement(DDLStatement.StatementType.DROP, (SQLObject)index);
    }

    @Override
    public void renameIndex(SQLIndex oldIndex, SQLIndex newIndex) throws SQLObjectException {
        this.print("ALTER INDEX ");
        this.print(this.toQualifiedName(oldIndex));
        this.print(" RENAME TO ");
        this.println(this.toQualifiedName(newIndex.getName()));
        this.endStatement(DDLStatement.StatementType.ALTER, (SQLObject)oldIndex);
    }

    @Override
    public void addIndex(SQLIndex index) throws SQLObjectException {
        this.createPhysicalName(this.topLevelNames, (SQLObject)index);
        this.println("");
        this.print("CREATE ");
        if (index.isUnique()) {
            this.print("UNIQUE ");
        }
        this.print("INDEX ");
        this.print(this.toQualifiedName(index.getName()));
        this.print("\n ON ");
        this.print(this.toQualifiedName(index.getParent()));
        this.print("\n ( ");
        boolean first = true;
        for (SQLIndex.Column c : index.getChildren(SQLIndex.Column.class)) {
            if (!first) {
                this.print(", ");
            }
            if (c.getColumn() != null) {
                this.print(c.getColumn().getPhysicalName());
            } else {
                this.print(c.getName());
            }
            this.print(c.getAscendingOrDescending() == SQLIndex.AscendDescend.ASCENDING ? " ASC" : "");
            this.print(c.getAscendingOrDescending() == SQLIndex.AscendDescend.DESCENDING ? " DESC" : "");
            first = false;
        }
        this.print(" )");
        this.endStatement(DDLStatement.StatementType.CREATE, (SQLObject)index);
    }

    @Override
    public boolean supportsRollback() {
        return true;
    }

    @Override
    public boolean supportsCheckConstraint() {
        return true;
    }

    @Override
    public boolean supportsEnumeration() {
        return false;
    }
}

