/*
 * Decompiled with CFR 0.152.
 */
package javolution.xml;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import javolution.context.ObjectFactory;
import javolution.lang.Reusable;
import javolution.xml.XMLBinding;
import javolution.xml.XMLFormat;
import javolution.xml.XMLReferenceResolver;
import javolution.xml.stream.XMLStreamException;
import javolution.xml.stream.XMLStreamReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLObjectReader
implements Reusable {
    private static final ObjectFactory FACTORY = new ObjectFactory(){

        protected Object create() {
            return new XMLObjectReader();
        }

        protected void cleanup(Object object) {
            ((XMLObjectReader)object).reset();
        }
    };
    private final XMLFormat.InputElement _xml = new XMLFormat.InputElement();
    private Reader _reader;
    private InputStream _inputStream;
    private boolean _isFactoryProduced;

    public static XMLObjectReader newInstance(InputStream inputStream) throws XMLStreamException {
        XMLObjectReader xMLObjectReader = (XMLObjectReader)FACTORY.object();
        xMLObjectReader._isFactoryProduced = true;
        xMLObjectReader.setInput(inputStream);
        return xMLObjectReader;
    }

    public static XMLObjectReader newInstance(InputStream inputStream, String string) throws XMLStreamException {
        XMLObjectReader xMLObjectReader = (XMLObjectReader)FACTORY.object();
        xMLObjectReader._isFactoryProduced = true;
        xMLObjectReader.setInput(inputStream, string);
        return xMLObjectReader;
    }

    public static XMLObjectReader newInstance(Reader reader) throws XMLStreamException {
        XMLObjectReader xMLObjectReader = (XMLObjectReader)FACTORY.object();
        xMLObjectReader._isFactoryProduced = true;
        xMLObjectReader.setInput(reader);
        return xMLObjectReader;
    }

    public XMLStreamReader getStreamReader() {
        return this._xml._reader;
    }

    public XMLObjectReader setInput(InputStream inputStream) throws XMLStreamException {
        if (this._inputStream != null || this._reader != null) {
            throw new IllegalStateException("Reader not closed or reset");
        }
        this._xml._reader.setInput(inputStream);
        this._inputStream = inputStream;
        return this;
    }

    public XMLObjectReader setInput(InputStream inputStream, String string) throws XMLStreamException {
        if (this._inputStream != null || this._reader != null) {
            throw new IllegalStateException("Reader not closed or reset");
        }
        this._xml._reader.setInput(inputStream, string);
        this._inputStream = inputStream;
        return this;
    }

    public XMLObjectReader setInput(Reader reader) throws XMLStreamException {
        if (this._inputStream != null || this._reader != null) {
            throw new IllegalStateException("Reader not closed or reset");
        }
        this._xml._reader.setInput(reader);
        this._reader = reader;
        return this;
    }

    public XMLObjectReader setBinding(XMLBinding xMLBinding) {
        this._xml.setBinding(xMLBinding);
        return this;
    }

    public XMLObjectReader setReferenceResolver(XMLReferenceResolver xMLReferenceResolver) {
        this._xml.setReferenceResolver(xMLReferenceResolver);
        return this;
    }

    public boolean hasNext() throws XMLStreamException {
        return this._xml.hasNext();
    }

    public <T> T read() throws XMLStreamException {
        return this._xml.getNext();
    }

    public <T> T read(String string) throws XMLStreamException {
        return this._xml.get(string);
    }

    public <T> T read(String string, String string2) throws XMLStreamException {
        return this._xml.get(string, string2);
    }

    public <T> T read(String string, Class<T> clazz) throws XMLStreamException {
        return this._xml.get(string, clazz);
    }

    public <T> T read(String string, String string2, Class<T> clazz) throws XMLStreamException {
        return this._xml.get(string, string2, clazz);
    }

    public void close() throws XMLStreamException {
        try {
            if (this._inputStream != null) {
                this._inputStream.close();
                this.reset();
            } else if (this._reader != null) {
                this._reader.close();
                this.reset();
            }
            if (this._isFactoryProduced) {
                FACTORY.recycle(this);
            }
        }
        catch (IOException iOException) {
            throw new XMLStreamException(iOException);
        }
    }

    @Override
    public void reset() {
        this._xml.reset();
        this._reader = null;
        this._inputStream = null;
    }
}

