/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.control;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.sf.freecol.common.model.Ability;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.AbstractUnit;
import net.sf.freecol.common.model.Building;
import net.sf.freecol.common.model.BuildingType;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.CombatModel;
import net.sf.freecol.common.model.Direction;
import net.sf.freecol.common.model.Europe;
import net.sf.freecol.common.model.Event;
import net.sf.freecol.common.model.FoundingFather;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.Nation;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Role;
import net.sf.freecol.common.model.Scope;
import net.sf.freecol.common.model.SimpleCombatModel;
import net.sf.freecol.common.model.Stance;
import net.sf.freecol.common.model.StanceTradeItem;
import net.sf.freecol.common.model.Tension;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TileImprovementType;
import net.sf.freecol.common.model.TileType;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.model.WorkLocation;
import net.sf.freecol.common.util.CollectionUtils;
import net.sf.freecol.server.ServerTestHelper;
import net.sf.freecol.server.control.InGameController;
import net.sf.freecol.server.model.ServerBuilding;
import net.sf.freecol.server.model.ServerColony;
import net.sf.freecol.server.model.ServerGame;
import net.sf.freecol.server.model.ServerIndianSettlement;
import net.sf.freecol.server.model.ServerPlayer;
import net.sf.freecol.server.model.ServerUnit;
import net.sf.freecol.util.test.FreeColTestCase;
import net.sf.freecol.util.test.FreeColTestUtils;

public class InGameControllerTest
extends FreeColTestCase {
    private static BuildingType carpenterHouse = InGameControllerTest.spec().getBuildingType("model.building.carpenterHouse");
    private static BuildingType press = InGameControllerTest.spec().getBuildingType("model.building.printingPress");
    private static final BuildingType schoolHouseType = InGameControllerTest.spec().getBuildingType("model.building.schoolhouse");
    private static final BuildingType stockadeType = InGameControllerTest.spec().getBuildingType("model.building.stockade");
    private static final GoodsType bellsType = InGameControllerTest.spec().getGoodsType("model.goods.bells");
    private static final GoodsType cottonType = InGameControllerTest.spec().getGoodsType("model.goods.cotton");
    private static final GoodsType foodType = InGameControllerTest.spec().getPrimaryFoodType();
    private static final GoodsType grainType = InGameControllerTest.spec().getGoodsType("model.goods.grain");
    private static final GoodsType hammersType = InGameControllerTest.spec().getGoodsType("model.goods.hammers");
    private static final GoodsType horsesType = InGameControllerTest.spec().getGoodsType("model.goods.horses");
    private static final GoodsType lumberType = InGameControllerTest.spec().getGoodsType("model.goods.lumber");
    private static final GoodsType musketsType = InGameControllerTest.spec().getGoodsType("model.goods.muskets");
    private static final GoodsType toolsType = InGameControllerTest.spec().getGoodsType("model.goods.tools");
    private static final Role scoutRole = InGameControllerTest.spec().getRole("model.role.scout");
    private static final Role soldierRole = InGameControllerTest.spec().getRole("model.role.soldier");
    private static final Role dragoonRole = InGameControllerTest.spec().getRole("model.role.dragoon");
    private static final Role pioneerRole = InGameControllerTest.spec().getRole("model.role.pioneer");
    private static final Role missionaryRole = InGameControllerTest.spec().getRole("model.role.missionary");
    private static final Role infantryRole = InGameControllerTest.spec().getRole("model.role.infantry");
    private static final Role cavalryRole = InGameControllerTest.spec().getRole("model.role.cavalry");
    private static final Role armedBraveRole = InGameControllerTest.spec().getRole("model.role.armedBrave");
    private static final Role mountedBraveRole = InGameControllerTest.spec().getRole("model.role.mountedBrave");
    private static final Role nativeDragoonRole = InGameControllerTest.spec().getRole("model.role.nativeDragoon");
    private static final TileImprovementType clear = InGameControllerTest.spec().getTileImprovementType("model.improvement.clearForest");
    private static final TileImprovementType plow = InGameControllerTest.spec().getTileImprovementType("model.improvement.plow");
    private static final TileImprovementType road = InGameControllerTest.spec().getTileImprovementType("model.improvement.road");
    private static final TileType arctic = InGameControllerTest.spec().getTileType("model.tile.arctic");
    private static final TileType desert = InGameControllerTest.spec().getTileType("model.tile.desert");
    private static final TileType desertForest = InGameControllerTest.spec().getTileType("model.tile.scrubForest");
    private static final TileType grassland = InGameControllerTest.spec().getTileType("model.tile.grassland");
    private static final TileType grasslandForest = InGameControllerTest.spec().getTileType("model.tile.coniferForest");
    private static final TileType hills = InGameControllerTest.spec().getTileType("model.tile.hills");
    private static final TileType marsh = InGameControllerTest.spec().getTileType("model.tile.marsh");
    private static final TileType marshForest = InGameControllerTest.spec().getTileType("model.tile.wetlandForest");
    private static final TileType mountains = InGameControllerTest.spec().getTileType("model.tile.mountains");
    private static final TileType ocean = InGameControllerTest.spec().getTileType("model.tile.ocean");
    private static final TileType plains = InGameControllerTest.spec().getTileType("model.tile.plains");
    private static final TileType plainsForest = InGameControllerTest.spec().getTileType("model.tile.mixedForest");
    private static final TileType prairie = InGameControllerTest.spec().getTileType("model.tile.prairie");
    private static final TileType prairieForest = InGameControllerTest.spec().getTileType("model.tile.broadleafForest");
    private static final TileType savannah = InGameControllerTest.spec().getTileType("model.tile.savannah");
    private static final TileType savannahForest = InGameControllerTest.spec().getTileType("model.tile.tropicalForest");
    private static final TileType swamp = InGameControllerTest.spec().getTileType("model.tile.swamp");
    private static final TileType swampForest = InGameControllerTest.spec().getTileType("model.tile.rainForest");
    private static final TileType tundra = InGameControllerTest.spec().getTileType("model.tile.tundra");
    private static final TileType tundraForest = InGameControllerTest.spec().getTileType("model.tile.borealForest");
    private static final UnitType braveType = InGameControllerTest.spec().getUnitType("model.unit.brave");
    private static final UnitType colonistType = InGameControllerTest.spec().getUnitType("model.unit.freeColonist");
    private static final UnitType farmerType = InGameControllerTest.spec().getUnitType("model.unit.expertFarmer");
    private static final UnitType colonialType = InGameControllerTest.spec().getUnitType("model.unit.colonialRegular");
    private static final UnitType veteranType = InGameControllerTest.spec().getUnitType("model.unit.veteranSoldier");
    private static final UnitType pettyCriminalType = InGameControllerTest.spec().getUnitType("model.unit.pettyCriminal");
    private static final UnitType indenturedServantType = InGameControllerTest.spec().getUnitType("model.unit.indenturedServant");
    private static final UnitType kingsRegularType = InGameControllerTest.spec().getUnitType("model.unit.kingsRegular");
    private static final UnitType indianConvertType = InGameControllerTest.spec().getUnitType("model.unit.indianConvert");
    private static final UnitType hardyPioneerType = InGameControllerTest.spec().getUnitType("model.unit.hardyPioneer");
    private static final UnitType statesmanType = InGameControllerTest.spec().getUnitType("model.unit.elderStatesman");
    private static final UnitType wagonTrainType = InGameControllerTest.spec().getUnitType("model.unit.wagonTrain");
    private static final UnitType caravelType = InGameControllerTest.spec().getUnitType("model.unit.caravel");
    private static final UnitType galleonType = InGameControllerTest.spec().getUnitType("model.unit.galleon");
    private static final UnitType privateerType = InGameControllerTest.spec().getUnitType("model.unit.privateer");
    private static final UnitType missionaryType = InGameControllerTest.spec().getUnitType("model.unit.jesuitMissionary");
    private static final UnitType artilleryType = InGameControllerTest.spec().getUnitType("model.unit.artillery");
    private static final UnitType damagedArtilleryType = InGameControllerTest.spec().getUnitType("model.unit.damagedArtillery");
    private static final UnitType treasureTrainType = InGameControllerTest.spec().getUnitType("model.unit.treasureTrain");
    private SimpleCombatModel combatModel = new SimpleCombatModel();

    @Override
    public void tearDown() throws Exception {
        ServerTestHelper.stopServerGame();
        super.tearDown();
    }

    public void testDeclarationOfWarFromPeace() {
        ServerGame game = ServerTestHelper.startServerGame(InGameControllerTest.getTestMap());
        InGameController igc = ServerTestHelper.getInGameController();
        ServerPlayer dutch = this.getServerPlayer(game, "model.nation.dutch");
        ServerPlayer french = this.getServerPlayer(game, "model.nation.french");
        int initialTensionValue = 500;
        dutch.setStance(french, Stance.PEACE);
        french.setStance(dutch, Stance.PEACE);
        dutch.setTension(french, new Tension(initialTensionValue));
        french.setTension(dutch, new Tension(initialTensionValue));
        int initialDutchTension = dutch.getTension(french).getValue();
        int initialFrenchTension = french.getTension(dutch).getValue();
        InGameControllerTest.assertEquals((String)"The Dutch must be at peace with the French", (Object)Stance.PEACE, (Object)dutch.getStance(french));
        InGameControllerTest.assertEquals((String)"The French must be at peace with the Dutch", (Object)Stance.PEACE, (Object)french.getStance(dutch));
        InGameControllerTest.assertEquals((String)"Wrong initial dutch tension", (int)initialTensionValue, (int)initialDutchTension);
        InGameControllerTest.assertEquals((String)"Wrong initial french tension", (int)initialTensionValue, (int)initialFrenchTension);
        igc.changeStance(french, Stance.WAR, dutch, true);
        InGameControllerTest.assertTrue((String)"The Dutch should be at war with the French", (dutch.getStance(french) == Stance.WAR ? 1 : 0) != 0);
        InGameControllerTest.assertTrue((String)"The French should be at war with the Dutch", (french.getStance(dutch) == Stance.WAR ? 1 : 0) != 0);
        int currDutchTension = dutch.getTension(french).getValue();
        int currFrenchTension = french.getTension(dutch).getValue();
        int expectedDutchTension = Math.min(Tension.TENSION_MAX, initialDutchTension + Tension.WAR_MODIFIER);
        int expectedFrenchTension = Math.min(Tension.TENSION_MAX, initialFrenchTension + Tension.WAR_MODIFIER);
        InGameControllerTest.assertEquals((String)"Wrong dutch tension", (int)expectedDutchTension, (int)currDutchTension);
        InGameControllerTest.assertEquals((String)"Wrong french tension", (int)expectedFrenchTension, (int)currFrenchTension);
    }

    public void testCreateMission() {
        ServerGame game = ServerTestHelper.startServerGame(InGameControllerTest.getTestMap());
        InGameController igc = ServerTestHelper.getInGameController();
        ServerPlayer dutch = this.getServerPlayer(game, "model.nation.dutch");
        ServerPlayer french = this.getServerPlayer(game, "model.nation.french");
        FreeColTestCase.IndianSettlementBuilder builder = new FreeColTestCase.IndianSettlementBuilder(game);
        ServerIndianSettlement camp = (ServerIndianSettlement)builder.build();
        camp.setContacted(dutch);
        camp.setContacted(french);
        Tile tile = camp.getTile().getNeighbourOrNull(Direction.N);
        ServerUnit dutchJesuit = new ServerUnit(game, tile, dutch, missionaryType);
        dutch.exploreForUnit(dutchJesuit);
        ServerUnit frenchJesuit = new ServerUnit(game, tile, french, missionaryType);
        french.exploreForUnit(frenchJesuit);
        Tension tension = new Tension(Tension.Level.HATEFUL.getLimit());
        camp.setAlarm(dutch, tension);
        InGameControllerTest.assertEquals((String)"Wrong camp alarm", (Object)tension, (Object)camp.getAlarm(dutch));
        igc.establishMission(dutch, dutchJesuit, camp);
        InGameControllerTest.assertTrue((String)"Dutch Jesuit should be dead", (boolean)dutchJesuit.isDisposed());
        InGameControllerTest.assertTrue((String)"Indian settlement should not have a mission", (!camp.hasMissionary() ? 1 : 0) != 0);
        igc.establishMission(french, frenchJesuit, camp);
        InGameControllerTest.assertTrue((String)"French Jesuit should not be dead", (!frenchJesuit.isDisposed() ? 1 : 0) != 0);
        InGameControllerTest.assertTrue((String)"Indian settlement should have a mission", (boolean)camp.hasMissionary());
    }

    public void testDumpGoods() {
        ServerGame game = ServerTestHelper.startServerGame(InGameControllerTest.getTestMap(ocean));
        Map map = game.getMap();
        InGameController igc = ServerTestHelper.getInGameController();
        ServerPlayer dutch = this.getServerPlayer(game, "model.nation.dutch");
        Tile tile = map.getTile(1, 1);
        ServerUnit privateer = new ServerUnit(game, tile, dutch, privateerType);
        InGameControllerTest.assertEquals((String)"Privateer should not carry anything", (int)0, (int)privateer.getGoodsSpaceTaken());
        privateer.addGoods(cottonType, 75);
        InGameControllerTest.assertEquals((String)"Privateer should carry cotton", (int)75, (int)privateer.getGoodsCount(cottonType));
        igc.unloadGoods(dutch, cottonType, 100, privateer);
        InGameControllerTest.assertEquals((int)75, (int)privateer.getGoodsCount(cottonType));
        igc.unloadGoods(dutch, cottonType, 25, privateer);
        InGameControllerTest.assertEquals((int)50, (int)privateer.getGoodsCount(cottonType));
        Europe europe = dutch.getEurope();
        privateer.setLocation(europe);
        dutch.getMarket().setArrears(cottonType, 1);
        int gold = dutch.getGold();
        igc.unloadGoods(dutch, cottonType, 50, privateer);
        InGameControllerTest.assertEquals((String)"Privateer in Europe should no longer carry cotton", (int)0, (int)privateer.getGoodsCount(cottonType));
        InGameControllerTest.assertEquals((String)"No payment for boycotted goods", (int)gold, (int)dutch.getGold());
    }

    public void testCashInTreasure() {
        ServerGame game = ServerTestHelper.startServerGame(InGameControllerTest.getCoastTestMap(plains, true));
        Map map = game.getMap();
        InGameController igc = ServerTestHelper.getInGameController();
        ServerPlayer dutch = this.getServerPlayer(game, "model.nation.dutch");
        Tile tile = map.getTile(10, 4);
        ServerUnit ship = new ServerUnit(game, tile, dutch, galleonType);
        ServerUnit treasure = new ServerUnit(game, tile, dutch, treasureTrainType);
        InGameControllerTest.assertTrue((String)"Treasure train can carry treasure", (boolean)treasure.canCarryTreasure());
        treasure.setTreasureAmount(100);
        InGameControllerTest.assertFalse((String)"Can not cash in treasure from a tile", (boolean)treasure.canCashInTreasureTrain());
        treasure.setLocation(ship);
        InGameControllerTest.assertFalse((String)"Can not cash in treasure from a ship", (boolean)treasure.canCashInTreasureTrain());
        ship.setLocation(dutch.getEurope());
        InGameControllerTest.assertTrue((String)"Can cash in treasure in Europe", (boolean)treasure.canCashInTreasureTrain());
        int fee = treasure.getTransportFee();
        InGameControllerTest.assertEquals((String)"Cash in transport fee is zero in Europe", (int)0, (int)fee);
        int oldGold = dutch.getGold();
        igc.cashInTreasureTrain(dutch, treasure);
        InGameControllerTest.assertEquals((String)"Cash in increases gold by the treasure amount", (int)100, (int)(dutch.getGold() - oldGold));
        treasure = new ServerUnit(game, tile, dutch, treasureTrainType);
        treasure.setTreasureAmount(100);
        Colony port = this.getStandardColony(1, 9, 4);
        InGameControllerTest.assertFalse((String)"Standard colony is not landlocked", (boolean)port.isLandLocked());
        InGameControllerTest.assertTrue((String)"Standard colony is connected to Europe", (boolean)port.isConnectedPort());
        treasure.setLocation(port.getTile());
        InGameControllerTest.assertFalse((String)"Can not cash in treasure from a port (galleon exists)", (boolean)treasure.canCashInTreasureTrain());
        dutch.removeUnit(ship);
        InGameControllerTest.assertTrue((String)"Can cash in treasure from a port (galleon gone)", (boolean)treasure.canCashInTreasureTrain());
        Colony inland = this.getStandardColony(1, 7, 7);
        InGameControllerTest.assertTrue((String)"Inland colony is landlocked", (boolean)inland.isLandLocked());
        InGameControllerTest.assertFalse((String)"Inland colony is not connected to Europe", (boolean)inland.isConnectedPort());
        treasure.setLocation(inland.getTile());
        InGameControllerTest.assertFalse((String)"Can not cash in treasure from inland colony", (boolean)treasure.canCashInTreasureTrain());
        map.getTile(5, 5).setType(InGameControllerTest.spec().getTileType("model.tile.lake"));
        Colony lake = this.getStandardColony(1, 4, 5);
        InGameControllerTest.assertFalse((String)"Lake colony is not landlocked", (boolean)lake.isLandLocked());
        InGameControllerTest.assertFalse((String)"Lake colony is not connected to Europe", (boolean)lake.isConnectedPort());
        treasure.setLocation(lake.getTile());
        InGameControllerTest.assertFalse((String)"Can not cash in treasure from lake colony", (boolean)treasure.canCashInTreasureTrain());
    }

    public void testEmbark() {
        ServerGame game = ServerTestHelper.startServerGame(InGameControllerTest.getCoastTestMap(plains));
        Map map = game.getMap();
        InGameController igc = ServerTestHelper.getInGameController();
        ServerPlayer dutch = this.getServerPlayer(game, "model.nation.dutch");
        Tile landTile = map.getTile(9, 9);
        Tile seaTile = map.getTile(10, 9);
        ServerUnit colonist = new ServerUnit(game, landTile, dutch, colonistType);
        ServerUnit galleon = new ServerUnit(game, seaTile, dutch, galleonType);
        ServerUnit caravel = new ServerUnit(game, seaTile, dutch, caravelType);
        caravel.getType().setSpaceTaken(2);
        ServerUnit wagon = new ServerUnit(game, landTile, dutch, wagonTrainType);
        igc.embarkUnit(dutch, caravel, galleon);
        InGameControllerTest.assertTrue((String)"Caravel can not be put on galleon", (caravel.getLocation() == seaTile ? 1 : 0) != 0);
        wagon.getType().setSpaceTaken(12);
        igc.embarkUnit(dutch, wagon, galleon);
        InGameControllerTest.assertTrue((String)"Large wagon can not be put on galleon", (wagon.getLocation() == landTile ? 1 : 0) != 0);
        wagon.getType().setSpaceTaken(2);
        igc.embarkUnit(dutch, wagon, galleon);
        InGameControllerTest.assertTrue((String)"Wagon should now fit on galleon", (wagon.getLocation() == galleon ? 1 : 0) != 0);
        InGameControllerTest.assertEquals((String)"Embarked wagon should be in SENTRY state", (Object)((Object)Unit.UnitState.SENTRY), (Object)((Object)wagon.getState()));
        igc.embarkUnit(dutch, colonist, caravel);
        InGameControllerTest.assertTrue((String)"Colonist should embark on caravel", (colonist.getLocation() == caravel ? 1 : 0) != 0);
        InGameControllerTest.assertEquals((String)"Embarked colonist should be in SENTRY state", (Object)((Object)Unit.UnitState.SENTRY), (Object)((Object)colonist.getState()));
    }

    public void testClearSpecialty() {
        ServerGame game = ServerTestHelper.startServerGame(InGameControllerTest.getTestMap());
        Map map = game.getMap();
        InGameController igc = ServerTestHelper.getInGameController();
        ServerPlayer dutch = this.getServerPlayer(game, "model.nation.dutch");
        ServerUnit unit = new ServerUnit(game, map.getTile(5, 8), dutch, hardyPioneerType);
        InGameControllerTest.assertTrue((String)"Unit should be a hardy pioneer", (unit.getType() == hardyPioneerType ? 1 : 0) != 0);
        igc.clearSpeciality(dutch, unit);
        InGameControllerTest.assertTrue((String)"Unit should be cleared of its specialty", (unit.getType() != hardyPioneerType ? 1 : 0) != 0);
        Colony colony = this.getStandardColony();
        ServerBuilding school = new ServerBuilding(game, colony, schoolHouseType);
        colony.addBuilding(school);
        ServerUnit teacher = new ServerUnit(game, map.getTile(5, 8), dutch, hardyPioneerType);
        InGameControllerTest.assertEquals((String)"Unit should be a hardy pioneer", (Object)hardyPioneerType, (Object)teacher.getType());
        boolean selection = FreeColTestUtils.setStudentSelection(false);
        teacher.setLocation(school);
        InGameControllerTest.assertNotNull((String)"Teacher should have student", (Object)teacher.getStudent());
        igc.clearSpeciality(dutch, teacher);
        InGameControllerTest.assertEquals((String)"Teacher specialty cannot be cleared", (Object)hardyPioneerType, (Object)teacher.getType());
        FreeColTestUtils.setStudentSelection(selection);
    }

    public void testAtackedNavalUnitIsDamaged() {
        ServerGame game = ServerTestHelper.startServerGame(InGameControllerTest.getTestMap(ocean));
        Map map = game.getMap();
        InGameController igc = ServerTestHelper.getInGameController();
        ServerPlayer dutch = this.getServerPlayer(game, "model.nation.dutch");
        ServerPlayer french = this.getServerPlayer(game, "model.nation.french");
        igc.changeStance(french, Stance.WAR, dutch, true);
        InGameControllerTest.assertEquals((String)"Dutch should be at war with french", (Object)dutch.getStance(french), (Object)Stance.WAR);
        InGameControllerTest.assertEquals((String)"French should be at war with dutch", (Object)french.getStance(dutch), (Object)Stance.WAR);
        Tile tile1 = map.getTile(5, 8);
        tile1.setExplored(dutch, true);
        tile1.setExplored(french, true);
        Tile tile2 = map.getTile(4, 8);
        tile2.setExplored(dutch, true);
        tile2.setExplored(french, true);
        Tile tile3 = map.getTile(6, 8);
        tile3.setExplored(dutch, true);
        tile3.setExplored(french, true);
        ServerUnit galleon = new ServerUnit(game, tile1, dutch, galleonType);
        ServerUnit privateer = new ServerUnit(game, tile2, french, privateerType);
        InGameControllerTest.assertEquals((String)"Galleon should be empty", (int)0, (int)galleon.getGoodsSpaceTaken());
        Goods cargo = new Goods(game, galleon, musketsType, 100);
        galleon.add(cargo);
        InGameControllerTest.assertEquals((String)"Galleon should be loaded", (int)1, (int)galleon.getGoodsSpaceTaken());
        InGameControllerTest.assertFalse((String)"Galleon should not be repairing", (boolean)galleon.isDamagedAndUnderForcedRepair());
        galleon.setDestination(tile3);
        InGameControllerTest.assertEquals((String)"Wrong destination for Galleon", (Object)tile3, (Object)galleon.getDestination());
        galleon.getTile().setHighSeasCount(5);
        InGameControllerTest.assertEquals((String)"Galleon repair location is Europe", (Object)dutch.getEurope(), (Object)galleon.getRepairLocation());
        List<CombatModel.CombatEffectType> crs = this.fakeAttackResult(CombatModel.CombatEffectType.WIN, privateer, galleon);
        this.checkCombat("Privateer v galleon", crs, CombatModel.CombatEffectType.WIN, CombatModel.CombatEffectType.LOOT_SHIP, CombatModel.CombatEffectType.DAMAGE_SHIP_ATTACK);
        igc.combat(dutch, privateer, galleon, crs);
        InGameControllerTest.assertTrue((String)"Galleon should be in Europe repairing", (boolean)galleon.isDamagedAndUnderForcedRepair());
        InGameControllerTest.assertEquals((String)"Galleon should be empty", (int)0, (int)galleon.getGoodsSpaceTaken());
        InGameControllerTest.assertNull((String)"Galleon should no longer have a destination", (Object)galleon.getDestination());
    }

    public void testUnarmedAttack() {
        ServerGame game = ServerTestHelper.startServerGame(InGameControllerTest.getTestMap(plains));
        Map map = game.getMap();
        InGameController igc = ServerTestHelper.getInGameController();
        ServerPlayer dutch = this.getServerPlayer(game, "model.nation.dutch");
        ServerPlayer french = this.getServerPlayer(game, "model.nation.french");
        igc.changeStance(french, Stance.WAR, dutch, true);
        dutch.addAbility(new Ability("model.ability.independenceDeclared"));
        Tile tile1 = map.getTile(5, 8);
        tile1.setExplored(dutch, true);
        tile1.setExplored(french, true);
        Tile tile2 = map.getTile(4, 8);
        tile2.setExplored(dutch, true);
        tile2.setExplored(french, true);
        ServerUnit colonial = new ServerUnit(game, tile1, dutch, colonialType, InGameControllerTest.spec().getDefaultRole());
        InGameControllerTest.assertEquals((String)"Must be Colonial Regular", (Object)colonialType, (Object)colonial.getType());
        InGameControllerTest.assertEquals((String)"Only has default base offence", (int)0, (int)colonial.getType().getBaseOffence());
        InGameControllerTest.assertEquals((String)"Only has default base defence", (int)1, (int)colonial.getType().getBaseDefence());
        InGameControllerTest.assertTrue((String)"Has default role", (boolean)colonial.hasDefaultRole());
        ServerUnit soldier = new ServerUnit(game, tile2, french, veteranType);
        InGameControllerTest.assertTrue((String)"Veteran is armed", (boolean)soldier.isArmed());
        InGameControllerTest.assertTrue((String)"Veteran is an offensive unit", (boolean)soldier.isOffensiveUnit());
        InGameControllerTest.assertEquals((String)"Has soldier role", (Object)soldierRole, (Object)soldier.getRole());
        InGameControllerTest.assertEquals((String)"Unarmed Colonial Regular can not attack!", (Object)((Object)Unit.MoveType.MOVE_NO_ATTACK_CIVILIAN), (Object)((Object)colonial.getMoveType(tile2)));
        colonial.changeRole(soldierRole, 1);
        InGameControllerTest.assertEquals((String)"Colonial Regular can attack", (Object)((Object)Unit.MoveType.ATTACK_UNIT), (Object)((Object)colonial.getMoveType(tile2)));
        List<CombatModel.CombatEffectType> crs = this.fakeAttackResult(CombatModel.CombatEffectType.WIN, soldier, colonial);
        this.checkCombat("Soldier v Colonial (1)", crs, CombatModel.CombatEffectType.WIN, CombatModel.CombatEffectType.LOSE_EQUIP, CombatModel.CombatEffectType.DEMOTE_UNIT);
        igc.combat(french, soldier, colonial, crs);
        InGameControllerTest.assertEquals((String)"Colonial Regular is demoted", (Object)veteranType, (Object)colonial.getType());
        crs = this.fakeAttackResult(CombatModel.CombatEffectType.WIN, soldier, colonial);
        this.checkCombat("Soldier v Colonial (2)", crs, CombatModel.CombatEffectType.WIN, CombatModel.CombatEffectType.CAPTURE_UNIT);
        igc.combat(french, soldier, colonial, crs);
        InGameControllerTest.assertEquals((String)"Colonial Regular is demoted", (Object)colonistType, (Object)colonial.getType());
        InGameControllerTest.assertEquals((String)"Colonial Regular should be captured", (Object)french, (Object)colonial.getOwner());
        InGameControllerTest.assertEquals((String)"Colonial Regular is moved to the Veterans tile", (Object)tile2, (Object)colonial.getTile());
    }

    public void testAttackColonyWithVeteran() {
        ServerGame game = ServerTestHelper.startServerGame(InGameControllerTest.getTestMap(true));
        Map map = game.getMap();
        InGameController igc = ServerTestHelper.getInGameController();
        ServerPlayer dutch = this.getServerPlayer(game, "model.nation.dutch");
        ServerPlayer french = this.getServerPlayer(game, "model.nation.french");
        igc.changeStance(french, Stance.WAR, dutch, true);
        Colony colony = this.getStandardColony();
        Tile tile2 = map.getTile(4, 8);
        tile2.setExplored(dutch, true);
        tile2.setExplored(french, true);
        dutch.addAbility(new Ability("model.ability.independenceDeclared"));
        Unit colonist = CollectionUtils.first(colony.getUnits());
        colonist.changeType(colonialType);
        InGameControllerTest.assertEquals((String)"Colonist should be Colonial Regular", (Object)colonialType, (Object)colonist.getType());
        ServerUnit defender = new ServerUnit(InGameControllerTest.getGame(), colony.getTile(), dutch, veteranType, dragoonRole);
        ServerUnit attacker = new ServerUnit(InGameControllerTest.getGame(), tile2, french, veteranType, dragoonRole);
        InGameControllerTest.assertEquals((String)"Colony defender is Veteran Soldier", (Object)defender, (Object)colony.getTile().getDefendingUnit(attacker));
        List<CombatModel.CombatEffectType> crs = this.fakeAttackResult(CombatModel.CombatEffectType.WIN, attacker, defender);
        this.checkCombat("Veteran v Colony (1)", crs, CombatModel.CombatEffectType.WIN, CombatModel.CombatEffectType.LOSE_EQUIP);
        igc.combat(french, attacker, defender, crs);
        InGameControllerTest.assertTrue((String)"Attacker should be mounted", (boolean)attacker.isMounted());
        InGameControllerTest.assertTrue((String)"Attacker should be armed", (boolean)attacker.isArmed());
        InGameControllerTest.assertEquals((String)"Attacker should be a Veteran Soldier", (Object)veteranType, (Object)attacker.getType());
        InGameControllerTest.assertFalse((String)"Defender should not be mounted", (boolean)defender.isMounted());
        InGameControllerTest.assertTrue((String)"Defender should be armed", (boolean)defender.isArmed());
        InGameControllerTest.assertEquals((String)"Defender should be a Veteran Soldier", (Object)veteranType, (Object)defender.getType());
        InGameControllerTest.assertEquals((String)"Defender is still the best colony defender", (Object)defender, (Object)colony.getTile().getDefendingUnit(attacker));
        crs = this.fakeAttackResult(CombatModel.CombatEffectType.LOSE, attacker, defender);
        this.checkCombat("Veteran v Colony (2) ", crs, CombatModel.CombatEffectType.LOSE, CombatModel.CombatEffectType.LOSE_EQUIP);
        igc.combat(french, attacker, defender, crs);
        InGameControllerTest.assertFalse((String)"Attacker should not be mounted", (boolean)attacker.isMounted());
        InGameControllerTest.assertTrue((String)"Attacker should be armed", (boolean)attacker.isArmed());
        InGameControllerTest.assertEquals((String)"Attacker should be a Veteran Soldier", (Object)veteranType, (Object)attacker.getType());
        InGameControllerTest.assertFalse((String)"Defender should not be mounted", (boolean)defender.isMounted());
        InGameControllerTest.assertTrue((String)"Defender should be armed", (boolean)defender.isArmed());
        InGameControllerTest.assertEquals((String)"Defender should be a Veteran Soldier", (Object)veteranType, (Object)defender.getType());
        InGameControllerTest.assertEquals((String)"Defender is still the best colony defender", (Object)defender, (Object)colony.getTile().getDefendingUnit(attacker));
        crs = this.fakeAttackResult(CombatModel.CombatEffectType.WIN, attacker, defender);
        this.checkCombat("Veteran v Colony (3)", crs, CombatModel.CombatEffectType.WIN, CombatModel.CombatEffectType.LOSE_EQUIP);
        igc.combat(french, attacker, defender, crs);
        InGameControllerTest.assertFalse((String)"Attacker should not be mounted", (boolean)attacker.isMounted());
        InGameControllerTest.assertTrue((String)"Attacker should be armed", (boolean)attacker.isArmed());
        InGameControllerTest.assertEquals((String)"Attacker should be a Veteran Soldier", (Object)veteranType, (Object)attacker.getType());
        InGameControllerTest.assertFalse((String)"Defender should not be mounted", (boolean)defender.isMounted());
        InGameControllerTest.assertFalse((String)"Defender should not be armed", (boolean)defender.isArmed());
        InGameControllerTest.assertEquals((String)"Defender should be a Veteran Soldier", (Object)veteranType, (Object)defender.getType());
        InGameControllerTest.assertFalse((String)"Defender should not be a defensive unit", (boolean)defender.isDefensiveUnit());
        crs = this.fakeAttackResult(CombatModel.CombatEffectType.WIN, attacker, defender);
        this.checkCombat("Veteran v Colony (4)", crs, CombatModel.CombatEffectType.WIN, CombatModel.CombatEffectType.CAPTURE_COLONY);
        igc.combat(french, attacker, defender, crs);
        InGameControllerTest.assertFalse((String)"Attacker should not be mounted", (boolean)attacker.isMounted());
        InGameControllerTest.assertTrue((String)"Attacker should be armed", (boolean)attacker.isArmed());
        InGameControllerTest.assertEquals((String)"Attacker should be a Veteran Soldier", (Object)veteranType, (Object)attacker.getType());
        InGameControllerTest.assertFalse((String)"Defender should not be mounted", (boolean)defender.isMounted());
        InGameControllerTest.assertFalse((String)"Defender should not be armed", (boolean)defender.isArmed());
        InGameControllerTest.assertEquals((String)"Defender should be demoted", (Object)colonistType, (Object)defender.getType());
        InGameControllerTest.assertEquals((String)"Attacker should be on the colony tile", (Object)colony.getTile(), (Object)attacker.getTile());
        InGameControllerTest.assertEquals((String)"Defender should be on the colony tile", (Object)colony.getTile(), (Object)defender.getTile());
        InGameControllerTest.assertEquals((String)"Colony should be owned by the attacker", (Object)attacker.getOwner(), (Object)colony.getOwner());
        InGameControllerTest.assertEquals((String)"Colony colonist should be demoted", (Object)veteranType, (Object)colonist.getType());
    }

    public void testAttackColonyWithBrave() {
        ServerGame game = ServerTestHelper.startServerGame(InGameControllerTest.getTestMap(true));
        Map map = game.getMap();
        InGameController igc = ServerTestHelper.getInGameController();
        ServerPlayer dutch = this.getServerPlayer(game, "model.nation.dutch");
        ServerPlayer inca = this.getServerPlayer(game, "model.nation.inca");
        igc.changeStance(dutch, Stance.WAR, inca, true);
        Colony colony = this.getStandardColony(1, 5, 8);
        Tile tile2 = map.getTile(4, 8);
        tile2.setExplored(dutch, true);
        Unit colonist = CollectionUtils.first(colony.getUnits());
        Unit defender = new ServerUnit(InGameControllerTest.getGame(), colony.getTile(), dutch, veteranType, dragoonRole);
        ServerUnit attacker = new ServerUnit(InGameControllerTest.getGame(), tile2, inca, braveType, nativeDragoonRole);
        InGameControllerTest.assertTrue((String)"Attacker should be armed", (boolean)attacker.isArmed());
        InGameControllerTest.assertTrue((String)"Attacker should be mounted", (boolean)attacker.isMounted());
        InGameControllerTest.assertTrue((String)"Inca is indian", (boolean)inca.isIndian());
        InGameControllerTest.assertEquals((String)"Defender is the colony best defender", (Object)defender, (Object)colony.getTile().getDefendingUnit(attacker));
        List<CombatModel.CombatEffectType> crs = this.fakeAttackResult(CombatModel.CombatEffectType.WIN, attacker, defender);
        this.checkCombat("Brave v Colony (1)", crs, CombatModel.CombatEffectType.WIN, CombatModel.CombatEffectType.LOSE_EQUIP);
        igc.combat(inca, attacker, defender, crs);
        InGameControllerTest.assertEquals((String)"Colony size should be 1", (int)1, (int)colony.getUnitCount());
        InGameControllerTest.assertTrue((String)"Attacker should be mounted", (boolean)attacker.isMounted());
        InGameControllerTest.assertTrue((String)"Attacker should be armed", (boolean)attacker.isArmed());
        InGameControllerTest.assertEquals((String)"Attacker should be a brave", (Object)braveType, (Object)attacker.getType());
        InGameControllerTest.assertFalse((String)"Defender should not be mounted", (boolean)defender.isMounted());
        InGameControllerTest.assertTrue((String)"Defender should be armed", (boolean)defender.isArmed());
        InGameControllerTest.assertEquals((String)"Defender should be Veteran Soldier", (Object)veteranType, (Object)defender.getType());
        InGameControllerTest.assertTrue((String)"Defender should be a defensive unit", (boolean)defender.isDefensiveUnit());
        InGameControllerTest.assertEquals((String)"Defender is the colony best defender", (Object)defender, (Object)colony.getTile().getDefendingUnit(attacker));
        crs = this.fakeAttackResult(CombatModel.CombatEffectType.WIN, attacker, defender);
        this.checkCombat("Brave v Colony (2)", crs, CombatModel.CombatEffectType.WIN, CombatModel.CombatEffectType.LOSE_EQUIP);
        igc.combat(inca, attacker, defender, crs);
        InGameControllerTest.assertEquals((String)"Colony size should be 1", (int)1, (int)colony.getUnitCount());
        InGameControllerTest.assertTrue((String)"Attacker should be mounted", (boolean)attacker.isMounted());
        InGameControllerTest.assertTrue((String)"Attacker should be armed", (boolean)attacker.isArmed());
        InGameControllerTest.assertEquals((String)"Attacker should be a brave", (Object)braveType, (Object)attacker.getType());
        InGameControllerTest.assertFalse((String)"Defender should not be mounted", (boolean)defender.isMounted());
        InGameControllerTest.assertFalse((String)"Defender should not be armed", (boolean)defender.isArmed());
        InGameControllerTest.assertEquals((String)"Defender should be Veteran Soldier", (Object)veteranType, (Object)defender.getType());
        InGameControllerTest.assertFalse((String)"Defender should not be a defensive unit", (boolean)defender.isDefensiveUnit());
        InGameControllerTest.assertFalse((String)"Colony can not be plundered", (boolean)colony.canBePlundered());
        InGameControllerTest.assertFalse((String)"Colony can not be pillaged", (boolean)colony.canBePillaged(attacker));
        crs = this.fakeAttackResult(CombatModel.CombatEffectType.WIN, attacker, defender);
        this.checkCombat("Brave v Colony (3)", crs, CombatModel.CombatEffectType.WIN, CombatModel.CombatEffectType.SLAUGHTER_UNIT);
        igc.combat(inca, attacker, defender, crs);
        InGameControllerTest.assertEquals((String)"Colony size should be 1", (int)1, (int)colony.getUnitCount());
        InGameControllerTest.assertTrue((String)"Attacker should be mounted", (boolean)attacker.isMounted());
        InGameControllerTest.assertTrue((String)"Attacker should be armed", (boolean)attacker.isArmed());
        InGameControllerTest.assertEquals((String)"Attacker should be a brave", (Object)braveType, (Object)attacker.getType());
        InGameControllerTest.assertTrue((String)"Defender should be disposed", (boolean)defender.isDisposed());
        InGameControllerTest.assertFalse((String)"Colony should not be disposed", (boolean)colony.isDisposed());
        defender = colony.getDefendingUnit(attacker);
        InGameControllerTest.assertFalse((String)"Colony should not be pillageable", (boolean)colony.canBePillaged(attacker));
        ServerBuilding school = new ServerBuilding(game, colony, schoolHouseType);
        colony.addBuilding(school);
        InGameControllerTest.assertTrue((String)"Colony has school, should be pillageable", (boolean)colony.canBePillaged(attacker));
        crs = this.fakeAttackResult(CombatModel.CombatEffectType.WIN, attacker, defender);
        this.checkCombat("Brave v Colony (4)", crs, CombatModel.CombatEffectType.WIN, CombatModel.CombatEffectType.PILLAGE_COLONY);
        igc.combat(inca, attacker, defender, crs);
        InGameControllerTest.assertTrue((String)"Attacker should be mounted", (boolean)attacker.isMounted());
        InGameControllerTest.assertTrue((String)"Attacker should be armed", (boolean)attacker.isArmed());
        InGameControllerTest.assertEquals((String)"Attacker should be a brave", (Object)braveType, (Object)attacker.getType());
        InGameControllerTest.assertTrue((String)"Colony should not be disposed", (!colony.isDisposed() ? 1 : 0) != 0);
        InGameControllerTest.assertTrue((String)"Colony should not have a school", (boolean)colony.getBurnableBuildings().isEmpty());
        InGameControllerTest.assertFalse((String)"Colony should not be pillageable", (boolean)colony.canBePillaged(attacker));
        ServerUnit privateer = new ServerUnit(game, colony.getTile(), dutch, privateerType);
        colony.getTile().setHighSeasCount(-1);
        InGameControllerTest.assertTrue((String)"Colony has ship, should be pillageable", (boolean)colony.canBePillaged(attacker));
        crs = this.fakeAttackResult(CombatModel.CombatEffectType.WIN, attacker, defender);
        this.checkCombat("Brave v Colony (5)", crs, CombatModel.CombatEffectType.WIN, CombatModel.CombatEffectType.PILLAGE_COLONY);
        igc.combat(inca, attacker, defender, crs);
        InGameControllerTest.assertTrue((String)"Attacker should be mounted", (boolean)attacker.isMounted());
        InGameControllerTest.assertTrue((String)"Attacker should be armed", (boolean)attacker.isArmed());
        InGameControllerTest.assertEquals((String)"Attacker should be a brave", (Object)braveType, (Object)attacker.getType());
        InGameControllerTest.assertTrue((String)"Colony should not be disposed", (!colony.isDisposed() ? 1 : 0) != 0);
        InGameControllerTest.assertTrue((String)"Privateer should be under repair", (boolean)privateer.isDamagedAndUnderForcedRepair());
        InGameControllerTest.assertEquals((String)"Privateer should be in Europe", (Object)dutch.getEurope(), (Object)privateer.getLocation());
        InGameControllerTest.assertFalse((String)"Colony should not be pillageable", (boolean)colony.canBePillaged(attacker));
        colony.addGoods(cottonType, 100);
        InGameControllerTest.assertTrue((String)"Colony has goods, should be pillageable", (boolean)colony.canBePillaged(attacker));
        crs = this.fakeAttackResult(CombatModel.CombatEffectType.WIN, attacker, defender);
        this.checkCombat("Brave v Colony (6)", crs, CombatModel.CombatEffectType.WIN, CombatModel.CombatEffectType.PILLAGE_COLONY);
        igc.combat(inca, attacker, defender, crs);
        InGameControllerTest.assertTrue((String)"Attacker should be mounted", (boolean)attacker.isMounted());
        InGameControllerTest.assertTrue((String)"Attacker should be armed", (boolean)attacker.isArmed());
        InGameControllerTest.assertEquals((String)"Attacker should be a brave", (Object)braveType, (Object)attacker.getType());
        InGameControllerTest.assertTrue((String)"Colony should not be disposed", (!colony.isDisposed() ? 1 : 0) != 0);
        InGameControllerTest.assertTrue((String)"Colony should have lost cotton", (colony.getGoodsCount(cottonType) < 100 ? 1 : 0) != 0);
        colony.removeGoods(cottonType);
        InGameControllerTest.assertFalse((String)"Colony should not be pillageable", (boolean)colony.canBePillaged(attacker));
        dutch.setGold(100);
        InGameControllerTest.assertTrue((String)"Dutch have gold, colony should be pillageable", (boolean)colony.canBePillaged(attacker));
        crs = this.fakeAttackResult(CombatModel.CombatEffectType.WIN, attacker, defender);
        this.checkCombat("Brave v Colony (7)", crs, CombatModel.CombatEffectType.WIN, CombatModel.CombatEffectType.PILLAGE_COLONY);
        igc.combat(inca, attacker, defender, crs);
        InGameControllerTest.assertTrue((String)"Attacker should be mounted", (boolean)attacker.isMounted());
        InGameControllerTest.assertTrue((String)"Attacker should be armed", (boolean)attacker.isArmed());
        InGameControllerTest.assertEquals((String)"Attacker should be a brave", (Object)braveType, (Object)attacker.getType());
        InGameControllerTest.assertTrue((String)"Colony should not be disposed", (!colony.isDisposed() ? 1 : 0) != 0);
        InGameControllerTest.assertTrue((String)"Dutch should have lost gold", (dutch.getGold() < 100 ? 1 : 0) != 0);
        dutch.setGold(0);
        InGameControllerTest.assertFalse((String)"Colony should not be pillageable", (boolean)colony.canBePillaged(attacker));
        crs = this.fakeAttackResult(CombatModel.CombatEffectType.WIN, attacker, defender);
        this.checkCombat("Brave v Colony (8)", crs, CombatModel.CombatEffectType.WIN, CombatModel.CombatEffectType.SLAUGHTER_UNIT, CombatModel.CombatEffectType.DESTROY_COLONY);
        igc.combat(inca, attacker, defender, crs);
        InGameControllerTest.assertTrue((String)"Attacker should be mounted", (boolean)attacker.isMounted());
        InGameControllerTest.assertTrue((String)"Attacker should be armed", (boolean)attacker.isArmed());
        InGameControllerTest.assertEquals((String)"Attacker should be a brave", (Object)braveType, (Object)attacker.getType());
        InGameControllerTest.assertTrue((String)"Colony should be disposed", (boolean)colony.isDisposed());
        InGameControllerTest.assertEquals((String)"Attacker should have moved into the colony tile", (Object)colony.getTile(), (Object)attacker.getTile());
    }

    public void testLoseColonyDefenceWithRevere() {
        ServerGame game = ServerTestHelper.startServerGame(InGameControllerTest.getTestMap(true));
        Map map = game.getMap();
        InGameController igc = ServerTestHelper.getInGameController();
        ServerPlayer dutch = this.getServerPlayer(game, "model.nation.dutch");
        ServerPlayer inca = this.getServerPlayer(game, "model.nation.inca");
        igc.changeStance(dutch, Stance.WAR, inca, true);
        Colony colony = this.getStandardColony();
        dutch.setStance(inca, Stance.WAR);
        inca.setStance(dutch, Stance.WAR);
        Tile tile2 = map.getTile(4, 8);
        tile2.setExplored(dutch, true);
        Unit colonist = CollectionUtils.first(colony.getUnits());
        ServerUnit attacker = new ServerUnit(InGameControllerTest.getGame(), tile2, inca, braveType, nativeDragoonRole);
        InGameControllerTest.assertEquals((String)"Colonist should be the colony best defender", (Object)colonist, (Object)colony.getDefendingUnit(attacker));
        dutch.addFather(InGameControllerTest.spec().getFoundingFather("model.foundingFather.paulRevere"));
        HashMap<GoodsType, Integer> goodsAdded = new HashMap<GoodsType, Integer>();
        for (AbstractGoods goods : soldierRole.getRequiredGoodsList()) {
            colony.addGoods(goods);
            goodsAdded.put(goods.getType(), goods.getAmount());
        }
        List<CombatModel.CombatEffectType> crs = this.fakeAttackResult(CombatModel.CombatEffectType.WIN, attacker, colonist);
        this.checkCombat("Inca v Colony", crs, CombatModel.CombatEffectType.WIN, CombatModel.CombatEffectType.AUTOEQUIP_UNIT, CombatModel.CombatEffectType.LOSE_AUTOEQUIP);
        igc.combat(inca, attacker, colonist, crs);
        InGameControllerTest.assertFalse((String)"Colonist should not be disposed", (boolean)colonist.isDisposed());
        InGameControllerTest.assertFalse((String)"Colonist should not be captured", (colonist.getOwner() == attacker.getOwner() ? 1 : 0) != 0);
        for (AbstractGoods goods : soldierRole.getRequiredGoodsList()) {
            boolean goodsLost = colony.getGoodsCount(goods.getType()) < (Integer)goodsAdded.get(goods.getType());
            InGameControllerTest.assertTrue((String)("Colony should have lost " + goods.getType().toString()), (boolean)goodsLost);
        }
    }

    public void testPioneerDiesNotLosesEquipment() {
        ServerGame game = ServerTestHelper.startServerGame(InGameControllerTest.getTestMap());
        Map map = game.getMap();
        InGameController igc = ServerTestHelper.getInGameController();
        ServerPlayer dutch = this.getServerPlayer(game, "model.nation.dutch");
        ServerPlayer french = this.getServerPlayer(game, "model.nation.french");
        Tile tile1 = map.getTile(5, 8);
        tile1.setExplored(dutch, true);
        tile1.setExplored(french, true);
        Tile tile2 = map.getTile(4, 8);
        tile2.setExplored(dutch, true);
        tile2.setExplored(french, true);
        ServerUnit pioneer = new ServerUnit(game, tile1, dutch, colonistType, pioneerRole);
        ServerUnit soldier = new ServerUnit(game, tile2, french, veteranType, dragoonRole);
        soldier.setMovesLeft(1);
        List<CombatModel.CombatEffectType> crs = this.fakeAttackResult(CombatModel.CombatEffectType.WIN, soldier, pioneer);
        this.checkCombat("Soldier v Pioneer", crs, CombatModel.CombatEffectType.WIN, CombatModel.CombatEffectType.SLAUGHTER_UNIT);
        igc.combat(french, soldier, pioneer, crs);
        InGameControllerTest.assertTrue((String)"Pioneer should be dead", (boolean)pioneer.isDisposed());
    }

    public void testScoutDiesNotLosesEquipment() {
        ServerGame game = ServerTestHelper.startServerGame(InGameControllerTest.getTestMap());
        Map map = game.getMap();
        InGameController igc = ServerTestHelper.getInGameController();
        ServerPlayer dutch = this.getServerPlayer(game, "model.nation.dutch");
        ServerPlayer french = this.getServerPlayer(game, "model.nation.french");
        igc.changeStance(dutch, Stance.WAR, french, true);
        Tile tile1 = map.getTile(5, 8);
        tile1.setExplored(dutch, true);
        tile1.setExplored(french, true);
        Tile tile2 = map.getTile(4, 8);
        tile2.setExplored(dutch, true);
        tile2.setExplored(french, true);
        ServerUnit scout = new ServerUnit(game, tile1, dutch, colonistType, scoutRole);
        ServerUnit soldier = new ServerUnit(game, tile2, french, veteranType, soldierRole);
        scout.setMovesLeft(1);
        List<CombatModel.CombatEffectType> crs = this.fakeAttackResult(CombatModel.CombatEffectType.WIN, soldier, scout);
        this.checkCombat("Soldier v scout", crs, CombatModel.CombatEffectType.WIN, CombatModel.CombatEffectType.SLAUGHTER_UNIT);
        igc.combat(french, soldier, scout, crs);
        InGameControllerTest.assertTrue((String)"Scout should be dead", (boolean)scout.isDisposed());
        InGameControllerTest.assertEquals((Object)soldierRole, (Object)soldier.getRole());
    }

    public void testPromotion() {
        ServerGame game = ServerTestHelper.startServerGame(InGameControllerTest.getTestMap(plains));
        Map map = game.getMap();
        InGameController igc = ServerTestHelper.getInGameController();
        ServerPlayer dutch = this.getServerPlayer(game, "model.nation.dutch");
        ServerPlayer french = this.getServerPlayer(game, "model.nation.french");
        igc.changeStance(dutch, Stance.WAR, french, true);
        InGameControllerTest.assertEquals((String)"Criminals should promote to servants", (Object)indenturedServantType, (Object)InGameControllerTest.spec().getUnitChange((String)"model.unitChange.promotion", (UnitType)InGameControllerTest.pettyCriminalType).to);
        InGameControllerTest.assertEquals((String)"Servants should promote to colonists", (Object)colonistType, (Object)InGameControllerTest.spec().getUnitChange((String)"model.unitChange.promotion", (UnitType)InGameControllerTest.indenturedServantType).to);
        InGameControllerTest.assertEquals((String)"Colonists should promote to Veterans", (Object)veteranType, (Object)InGameControllerTest.spec().getUnitChange((String)"model.unitChange.promotion", (UnitType)InGameControllerTest.colonistType).to);
        InGameControllerTest.assertEquals((String)"Veterans should promote to Colonials", (Object)colonialType, (Object)InGameControllerTest.spec().getUnitChange((String)"model.unitChange.promotion", (UnitType)InGameControllerTest.veteranType).to);
        InGameControllerTest.assertNull((String)"Colonials should not be promotable", (Object)InGameControllerTest.spec().getUnitChange("model.unitChange.promotion", colonialType));
        InGameControllerTest.assertNull((String)"Artillery should not be promotable", (Object)InGameControllerTest.spec().getUnitChange("model.unitChange.promotion", artilleryType));
        InGameControllerTest.assertNull((String)"Kings regulars should not be promotable", (Object)InGameControllerTest.spec().getUnitChange("model.unitChange.promotion", kingsRegularType));
        InGameControllerTest.assertNull((String)"Indian converts should not be promotable", (Object)InGameControllerTest.spec().getUnitChange("model.unitChange.promotion", indianConvertType));
        Tile tile1 = map.getTile(5, 8);
        tile1.setExplored(dutch, true);
        tile1.setExplored(french, true);
        Tile tile2 = map.getTile(4, 8);
        tile2.setExplored(dutch, true);
        tile2.setExplored(french, true);
        ServerUnit unit = new ServerUnit(game, tile1, dutch, pettyCriminalType, soldierRole);
        ServerUnit soldier = new ServerUnit(game, tile2, french, colonistType, soldierRole);
        dutch.addAbility(new Ability("model.ability.automaticPromotion"));
        List<CombatModel.CombatEffectType> crs = this.fakeAttackResult(CombatModel.CombatEffectType.WIN, unit, soldier);
        this.checkCombat("Criminal promotion", crs, CombatModel.CombatEffectType.WIN, CombatModel.CombatEffectType.LOSE_EQUIP, CombatModel.CombatEffectType.PROMOTE_UNIT);
        igc.combat(dutch, unit, soldier, crs);
        InGameControllerTest.assertEquals((String)"Criminal should be promoted to servant", (Object)unit.getType(), (Object)indenturedServantType);
        soldier.changeRole(soldierRole, 1);
        crs = this.fakeAttackResult(CombatModel.CombatEffectType.WIN, unit, soldier);
        this.checkCombat("Servant promotion", crs, CombatModel.CombatEffectType.WIN, CombatModel.CombatEffectType.LOSE_EQUIP, CombatModel.CombatEffectType.PROMOTE_UNIT);
        igc.combat(dutch, unit, soldier, crs);
        InGameControllerTest.assertEquals((String)"Servant should be promoted to colonist", (Object)unit.getType(), (Object)colonistType);
        soldier.changeRole(soldierRole, 1);
        crs = this.fakeAttackResult(CombatModel.CombatEffectType.WIN, unit, soldier);
        this.checkCombat("Colonist promotion failed", crs, CombatModel.CombatEffectType.WIN, CombatModel.CombatEffectType.LOSE_EQUIP, CombatModel.CombatEffectType.PROMOTE_UNIT);
        igc.combat(dutch, unit, soldier, crs);
        InGameControllerTest.assertEquals((String)"Colonist should be promoted to Veteran", (Object)unit.getType(), (Object)veteranType);
        InGameControllerTest.assertFalse((String)"Colonial Regulars should not yet be available", (boolean)colonialType.isAvailableTo(dutch));
        dutch.changePlayerType(Player.PlayerType.REBEL);
        dutch.setIndependentNationName("Vrije Nederlands");
        InGameControllerTest.assertTrue((String)"Colonial Regulars should be available", (boolean)colonialType.isAvailableTo(dutch));
        InGameControllerTest.assertEquals((String)"Veterans should promote to Colonial Regulars", (Object)colonialType, (Object)InGameControllerTest.spec().getUnitChange((String)"model.unitChange.promotion", (UnitType)InGameControllerTest.veteranType).to);
        soldier.changeRole(soldierRole, 1);
        crs = this.fakeAttackResult(CombatModel.CombatEffectType.WIN, unit, soldier);
        this.checkCombat("Veteran promotion", crs, CombatModel.CombatEffectType.WIN, CombatModel.CombatEffectType.LOSE_EQUIP, CombatModel.CombatEffectType.PROMOTE_UNIT);
        igc.combat(dutch, unit, soldier, crs);
        InGameControllerTest.assertEquals((String)"Veteran should be promoted to Colonial Regular", (Object)unit.getType(), (Object)colonialType);
        soldier.changeRole(soldierRole, 1);
        crs = this.fakeAttackResult(CombatModel.CombatEffectType.WIN, unit, soldier);
        this.checkCombat("Colonial Regular over-promotion failed", crs, CombatModel.CombatEffectType.WIN, CombatModel.CombatEffectType.LOSE_EQUIP);
        igc.combat(dutch, unit, soldier, crs);
        InGameControllerTest.assertEquals((String)"Colonial Regular should still be Colonial Regular", (Object)unit.getType(), (Object)colonialType);
    }

    public void testColonistDemotedBySoldier() {
        ServerGame game = ServerTestHelper.startServerGame(InGameControllerTest.getTestMap(plains));
        Map map = game.getMap();
        InGameController igc = ServerTestHelper.getInGameController();
        ServerPlayer dutch = this.getServerPlayer(game, "model.nation.dutch");
        ServerPlayer french = this.getServerPlayer(game, "model.nation.french");
        igc.changeStance(dutch, Stance.WAR, french, true);
        Tile tile1 = map.getTile(5, 8);
        tile1.setExplored(dutch, true);
        tile1.setExplored(french, true);
        Tile tile2 = map.getTile(4, 8);
        tile2.setExplored(dutch, true);
        tile2.setExplored(french, true);
        ServerUnit colonist = new ServerUnit(game, tile1, dutch, colonistType);
        InGameControllerTest.assertTrue((String)"Colonists should be capturable", (boolean)colonist.hasAbility("model.ability.canBeCaptured"));
        ServerUnit soldier = new ServerUnit(game, tile2, french, colonistType);
        InGameControllerTest.assertTrue((String)"Soldier should be capturable", (boolean)soldier.hasAbility("model.ability.canBeCaptured"));
        soldier.changeRole(soldierRole, 1);
        InGameControllerTest.assertFalse((String)"Armed soldier should not be capturable", (boolean)soldier.hasAbility("model.ability.canBeCaptured"));
        List<CombatModel.CombatEffectType> crs = this.fakeAttackResult(CombatModel.CombatEffectType.LOSE, colonist, soldier);
        this.checkCombat("Colonist v Soldier", crs, CombatModel.CombatEffectType.LOSE, CombatModel.CombatEffectType.CAPTURE_UNIT);
        igc.combat(dutch, colonist, soldier, crs);
        InGameControllerTest.assertEquals((String)"Colonist should still be a colonist", (Object)colonistType, (Object)colonist.getType());
        InGameControllerTest.assertEquals((String)"Colonist should be captured", (Object)french, (Object)colonist.getOwner());
        InGameControllerTest.assertEquals((String)"Colonist should have moved to the soldier tile", (Object)tile2, (Object)colonist.getTile());
    }

    public void testSoldierDemotedBySoldier() {
        ServerGame game = ServerTestHelper.startServerGame(InGameControllerTest.getTestMap(plains));
        Map map = game.getMap();
        InGameController igc = ServerTestHelper.getInGameController();
        ServerPlayer dutch = this.getServerPlayer(game, "model.nation.dutch");
        ServerPlayer french = this.getServerPlayer(game, "model.nation.french");
        igc.changeStance(dutch, Stance.WAR, french, true);
        Tile tile1 = map.getTile(5, 8);
        tile1.setExplored(dutch, true);
        tile1.setExplored(french, true);
        Tile tile2 = map.getTile(4, 8);
        tile2.setExplored(dutch, true);
        tile2.setExplored(french, true);
        ServerUnit soldier1 = new ServerUnit(game, tile1, dutch, colonistType, soldierRole);
        ServerUnit soldier2 = new ServerUnit(game, tile2, french, colonistType, soldierRole);
        List<CombatModel.CombatEffectType> crs = this.fakeAttackResult(CombatModel.CombatEffectType.LOSE, soldier1, soldier2);
        this.checkCombat("Soldier should lose equipment", crs, CombatModel.CombatEffectType.LOSE, CombatModel.CombatEffectType.LOSE_EQUIP);
        igc.combat(dutch, soldier1, soldier2, crs);
        InGameControllerTest.assertEquals((String)"Soldier should be a colonist", (Object)colonistType, (Object)soldier1.getType());
        InGameControllerTest.assertEquals((String)"Soldier should still be Dutch", (Object)dutch, (Object)soldier1.getOwner());
        InGameControllerTest.assertEquals((String)"Soldier should not have moved", (Object)tile1, (Object)soldier1.getTile());
        InGameControllerTest.assertTrue((String)"Soldier should have default role", (boolean)soldier1.hasDefaultRole());
        crs = this.fakeAttackResult(CombatModel.CombatEffectType.LOSE, soldier1, soldier2);
        this.checkCombat("Soldier v soldier", crs, CombatModel.CombatEffectType.LOSE, CombatModel.CombatEffectType.CAPTURE_UNIT);
        igc.combat(dutch, soldier1, soldier2, crs);
        InGameControllerTest.assertEquals((String)"Soldier should be a colonist", (Object)colonistType, (Object)soldier1.getType());
        InGameControllerTest.assertEquals((String)"Soldier should now be French", (Object)french, (Object)soldier1.getOwner());
        InGameControllerTest.assertEquals((String)"Soldier should have moved", (Object)tile2, (Object)soldier1.getTile());
    }

    public void testDragoonDemotedBySoldier() {
        ServerGame game = ServerTestHelper.startServerGame(InGameControllerTest.getTestMap(plains));
        Map map = game.getMap();
        InGameController igc = ServerTestHelper.getInGameController();
        ServerPlayer dutch = this.getServerPlayer(game, "model.nation.dutch");
        ServerPlayer french = this.getServerPlayer(game, "model.nation.french");
        igc.changeStance(dutch, Stance.WAR, french, true);
        Tile tile1 = map.getTile(5, 8);
        tile1.setExplored(dutch, true);
        tile1.setExplored(french, true);
        Tile tile2 = map.getTile(4, 8);
        tile2.setExplored(dutch, true);
        tile2.setExplored(french, true);
        ServerUnit dragoon = new ServerUnit(game, tile1, dutch, colonistType, dragoonRole);
        ServerTestHelper.newTurn();
        InGameControllerTest.assertEquals((String)"Dragoon has 12 moves", (int)12, (int)dragoon.getInitialMovesLeft());
        InGameControllerTest.assertEquals((String)"Dragoon has 12 moves left", (int)12, (int)dragoon.getMovesLeft());
        ServerUnit soldier = new ServerUnit(game, tile2, french, colonistType, soldierRole);
        List<CombatModel.CombatEffectType> crs = this.fakeAttackResult(CombatModel.CombatEffectType.LOSE, dragoon, soldier);
        this.checkCombat("Dragoon v soldier (1)", crs, CombatModel.CombatEffectType.LOSE, CombatModel.CombatEffectType.LOSE_EQUIP);
        igc.combat(dutch, dragoon, soldier, crs);
        InGameControllerTest.assertEquals((String)"Attacker should be a colonist", (Object)colonistType, (Object)dragoon.getType());
        InGameControllerTest.assertEquals((String)"Attacker should be Dutch", (Object)dutch, (Object)dragoon.getOwner());
        InGameControllerTest.assertEquals((String)"Attacker should be on tile1", (Object)tile1, (Object)dragoon.getTile());
        InGameControllerTest.assertEquals((String)"Attacker should be a soldier", (Object)soldierRole, (Object)dragoon.getRole());
        InGameControllerTest.assertTrue((String)"Attacker should still be armed", (boolean)dragoon.isArmed());
        InGameControllerTest.assertFalse((String)"Attacker should not still be mounted", (boolean)dragoon.isMounted());
        InGameControllerTest.assertEquals((String)"Attacker has 3 moves", (int)3, (int)dragoon.getInitialMovesLeft());
        InGameControllerTest.assertEquals((String)"Attacker has 0 moves left", (int)0, (int)dragoon.getMovesLeft());
        crs = this.fakeAttackResult(CombatModel.CombatEffectType.LOSE, dragoon, soldier);
        this.checkCombat("Dragoon v soldier (2)", crs, CombatModel.CombatEffectType.LOSE, CombatModel.CombatEffectType.LOSE_EQUIP);
        igc.combat(dutch, dragoon, soldier, crs);
        InGameControllerTest.assertEquals((String)"Attacker should be a colonist", (Object)colonistType, (Object)dragoon.getType());
        InGameControllerTest.assertEquals((String)"Attacker should be Dutch", (Object)dutch, (Object)dragoon.getOwner());
        InGameControllerTest.assertEquals((String)"Attacker should be on tile1", (Object)tile1, (Object)dragoon.getTile());
        InGameControllerTest.assertTrue((String)"Attacker should have default role", (boolean)dragoon.hasDefaultRole());
        crs = this.fakeAttackResult(CombatModel.CombatEffectType.WIN, soldier, dragoon);
        this.checkCombat("Soldier v ex-dragoon", crs, CombatModel.CombatEffectType.WIN, CombatModel.CombatEffectType.CAPTURE_UNIT);
        igc.combat(french, soldier, dragoon, crs);
        InGameControllerTest.assertEquals((String)"Defender should be a colonist", (Object)colonistType, (Object)dragoon.getType());
        InGameControllerTest.assertEquals((String)"Defender should be French", (Object)french, (Object)dragoon.getOwner());
        InGameControllerTest.assertEquals((String)"Defender should be on tile2", (Object)tile2, (Object)dragoon.getTile());
    }

    public void testDragoonDemotedByBrave() {
        ServerGame game = ServerTestHelper.startServerGame(InGameControllerTest.getTestMap(plains));
        Map map = game.getMap();
        InGameController igc = ServerTestHelper.getInGameController();
        ServerPlayer dutch = this.getServerPlayer(game, "model.nation.dutch");
        ServerPlayer inca = this.getServerPlayer(game, "model.nation.inca");
        igc.changeStance(dutch, Stance.WAR, inca, true);
        Tile tile1 = map.getTile(5, 8);
        tile1.setExplored(dutch, true);
        Tile tile2 = map.getTile(4, 8);
        tile2.setExplored(dutch, true);
        FreeColTestCase.IndianSettlementBuilder builder = new FreeColTestCase.IndianSettlementBuilder(game);
        builder.player(inca).settlementTile(map.getTile(1, 1)).capital(true).skillToTeach(null);
        IndianSettlement settlement1 = builder.build();
        builder.reset().player(inca).settlementTile(map.getTile(8, 8)).skillToTeach(null);
        IndianSettlement settlement2 = builder.build();
        ServerUnit dragoon = new ServerUnit(game, tile1, dutch, colonistType, dragoonRole);
        ServerUnit brave = new ServerUnit(game, tile2, inca, braveType, InGameControllerTest.spec().getDefaultRole());
        brave.changeHomeIndianSettlement(settlement1);
        List<CombatModel.CombatEffectType> crs = this.fakeAttackResult(CombatModel.CombatEffectType.LOSE, dragoon, brave);
        this.checkCombat("Dragoon v Brave (1)", crs, CombatModel.CombatEffectType.LOSE, CombatModel.CombatEffectType.CAPTURE_EQUIP);
        igc.combat(dutch, dragoon, brave, crs);
        InGameControllerTest.assertEquals((String)"Dragoon should be a colonist", (Object)colonistType, (Object)dragoon.getType());
        InGameControllerTest.assertEquals((String)"Dragoon should be Dutch", (Object)dutch, (Object)dragoon.getOwner());
        InGameControllerTest.assertEquals((String)"Dragoon should be on Tile1", (Object)tile1, (Object)dragoon.getTile());
        InGameControllerTest.assertEquals((String)"Dragoon should now be soldier", (Object)soldierRole, (Object)dragoon.getRole());
        InGameControllerTest.assertEquals((String)"Brave should now be mounted", (Object)mountedBraveRole, (Object)brave.getRole());
        InGameControllerTest.assertEquals((String)"Brave settlement should have Horses", (int)25, (int)settlement1.getGoodsCount(horsesType));
        InGameControllerTest.assertEquals((String)"Other settlement should not have horses", (int)0, (int)settlement2.getGoodsCount(horsesType));
        crs = this.fakeAttackResult(CombatModel.CombatEffectType.LOSE, dragoon, brave);
        this.checkCombat("Dragoon v Brave (2)", crs, CombatModel.CombatEffectType.LOSE, CombatModel.CombatEffectType.CAPTURE_EQUIP);
        igc.combat(dutch, dragoon, brave, crs);
        InGameControllerTest.assertEquals((String)"Attacker should be a colonist", (Object)colonistType, (Object)dragoon.getType());
        InGameControllerTest.assertEquals((String)"Attacker should be Dutch", (Object)dutch, (Object)dragoon.getOwner());
        InGameControllerTest.assertEquals((String)"Attacker should be on Tile1", (Object)tile1, (Object)dragoon.getTile());
        InGameControllerTest.assertTrue((String)"Attacker should have default role", (boolean)dragoon.hasDefaultRole());
        InGameControllerTest.assertEquals((String)"Brave should be nativeDragoon", (Object)nativeDragoonRole, (Object)brave.getRole());
        InGameControllerTest.assertEquals((String)"Braves settlement should have 25 muskets", (int)25, (int)settlement1.getGoodsCount(musketsType));
        InGameControllerTest.assertEquals((String)"Other settlement should not have muskets", (int)0, (int)settlement2.getGoodsCount(musketsType));
        crs = this.fakeAttackResult(CombatModel.CombatEffectType.LOSE, dragoon, brave);
        this.checkCombat("Dragoon v Brave (3)", crs, CombatModel.CombatEffectType.LOSE, CombatModel.CombatEffectType.SLAUGHTER_UNIT);
        igc.combat(dutch, dragoon, brave, crs);
        InGameControllerTest.assertTrue((String)"Dragoon should be disposed", (boolean)dragoon.isDisposed());
    }

    public void testScoutDefeatedBySoldier() {
        ServerGame game = ServerTestHelper.startServerGame(InGameControllerTest.getTestMap(plains));
        Map map = game.getMap();
        InGameController igc = ServerTestHelper.getInGameController();
        ServerPlayer dutch = this.getServerPlayer(game, "model.nation.dutch");
        ServerPlayer french = this.getServerPlayer(game, "model.nation.french");
        igc.changeStance(dutch, Stance.WAR, french, true);
        Tile tile1 = map.getTile(5, 8);
        tile1.setExplored(dutch, true);
        tile1.setExplored(french, true);
        Tile tile2 = map.getTile(4, 8);
        tile2.setExplored(dutch, true);
        tile2.setExplored(french, true);
        ServerUnit scout = new ServerUnit(game, tile1, dutch, colonistType, scoutRole);
        ServerUnit soldier = new ServerUnit(game, tile2, french, colonistType, soldierRole);
        List<CombatModel.CombatEffectType> crs = this.fakeAttackResult(CombatModel.CombatEffectType.LOSE, scout, soldier);
        this.checkCombat("Scout v Soldier", crs, CombatModel.CombatEffectType.LOSE, CombatModel.CombatEffectType.SLAUGHTER_UNIT);
        igc.combat(dutch, scout, soldier, crs);
        InGameControllerTest.assertTrue((String)"Scout should be disposed", (boolean)scout.isDisposed());
        InGameControllerTest.assertEquals((Object)soldierRole, (Object)soldier.getRole());
    }

    public void testVeteranSoldierDemotedBySoldier() {
        ServerGame game = ServerTestHelper.startServerGame(InGameControllerTest.getTestMap(plains));
        Map map = game.getMap();
        InGameController igc = ServerTestHelper.getInGameController();
        ServerPlayer dutch = this.getServerPlayer(game, "model.nation.dutch");
        ServerPlayer french = this.getServerPlayer(game, "model.nation.french");
        igc.changeStance(dutch, Stance.WAR, french, true);
        Tile tile1 = map.getTile(5, 8);
        tile1.setExplored(dutch, true);
        tile1.setExplored(french, true);
        Tile tile2 = map.getTile(4, 8);
        tile2.setExplored(dutch, true);
        tile2.setExplored(french, true);
        ServerUnit soldier1 = new ServerUnit(game, tile1, dutch, veteranType, soldierRole);
        ServerUnit soldier2 = new ServerUnit(game, tile2, french, colonistType, soldierRole);
        InGameControllerTest.assertEquals((String)"Veterans should become colonists on capture", (Object)colonistType, (Object)InGameControllerTest.spec().getUnitChange((String)"model.unitChange.capture", (UnitType)InGameControllerTest.veteranType).to);
        List<CombatModel.CombatEffectType> crs = this.fakeAttackResult(CombatModel.CombatEffectType.LOSE, soldier1, soldier2);
        this.checkCombat("Soldier v Soldier", crs, CombatModel.CombatEffectType.LOSE, CombatModel.CombatEffectType.LOSE_EQUIP);
        igc.combat(dutch, soldier1, soldier2, crs);
        InGameControllerTest.assertEquals((String)"Soldier1 should be a Veteran", (Object)veteranType, (Object)soldier1.getType());
        InGameControllerTest.assertEquals((String)"Soldier1 should be Dutch", (Object)dutch, (Object)soldier1.getOwner());
        InGameControllerTest.assertEquals((String)"Soldier1 should be on tile1", (Object)tile1, (Object)soldier1.getTile());
        InGameControllerTest.assertTrue((String)"Soldier1 should have default role", (boolean)soldier1.hasDefaultRole());
        crs = this.fakeAttackResult(CombatModel.CombatEffectType.LOSE, soldier1, soldier2);
        this.checkCombat("Soldier1 v Soldier2", crs, CombatModel.CombatEffectType.LOSE, CombatModel.CombatEffectType.CAPTURE_UNIT);
        igc.combat(dutch, soldier1, soldier2, crs);
        InGameControllerTest.assertEquals((String)"Soldier1 should be a colonist", (Object)colonistType, (Object)soldier1.getType());
        InGameControllerTest.assertEquals((String)"Soldier1 should be French", (Object)french, (Object)soldier1.getOwner());
        InGameControllerTest.assertEquals((String)"Soldier1 should be have moved", (Object)tile2, (Object)soldier1.getTile());
    }

    public void testArtilleryDemotedBySoldier() {
        ServerGame game = ServerTestHelper.startServerGame(InGameControllerTest.getTestMap(plains));
        Map map = game.getMap();
        InGameController igc = ServerTestHelper.getInGameController();
        ServerPlayer dutch = this.getServerPlayer(game, "model.nation.dutch");
        ServerPlayer french = this.getServerPlayer(game, "model.nation.french");
        igc.changeStance(dutch, Stance.WAR, french, true);
        Tile tile1 = map.getTile(5, 8);
        tile1.setExplored(dutch, true);
        tile1.setExplored(french, true);
        Tile tile2 = map.getTile(4, 8);
        tile2.setExplored(dutch, true);
        tile2.setExplored(french, true);
        ServerUnit artillery = new ServerUnit(game, tile1, dutch, artilleryType);
        ServerUnit soldier = new ServerUnit(game, tile2, french, colonistType, soldierRole);
        InGameControllerTest.assertEquals((String)"Artillery should demote to damaged artillery", (Object)damagedArtilleryType, (Object)artillery.getUnitChange((String)"model.unitChange.demotion").to);
        List<CombatModel.CombatEffectType> crs = this.fakeAttackResult(CombatModel.CombatEffectType.LOSE, artillery, soldier);
        this.checkCombat("Artillery v Soldier (1)", crs, CombatModel.CombatEffectType.LOSE, CombatModel.CombatEffectType.DEMOTE_UNIT);
        igc.combat(dutch, artillery, soldier, crs);
        InGameControllerTest.assertEquals((String)"Artillery should be damaged artillery", (Object)damagedArtilleryType, (Object)artillery.getType());
        InGameControllerTest.assertEquals((String)"Artillery should be Dutch", (Object)dutch, (Object)artillery.getOwner());
        InGameControllerTest.assertEquals((String)"Artillery should be on Tile1", (Object)tile1, (Object)artillery.getTile());
        crs = this.fakeAttackResult(CombatModel.CombatEffectType.LOSE, artillery, soldier);
        this.checkCombat("Artillery v Soldier (2)", crs, CombatModel.CombatEffectType.LOSE, CombatModel.CombatEffectType.SLAUGHTER_UNIT);
        igc.combat(dutch, artillery, soldier, crs);
        InGameControllerTest.assertTrue((String)"Artillery should be disposed", (boolean)artillery.isDisposed());
    }

    private void setPlayersAt(Stance stance, Tension tension) {
        Game game = InGameControllerTest.getGame();
        ServerPlayer dutch = this.getServerPlayer(game, "model.nation.dutch");
        ServerPlayer french = this.getServerPlayer(game, "model.nation.french");
        dutch.setStance(french, stance);
        dutch.setTension(french, new Tension(tension.getValue()));
        french.setStance(dutch, stance);
        french.setTension(dutch, new Tension(tension.getValue()));
        Tension.Level expectedTension = tension.getLevel();
        InGameControllerTest.assertEquals((String)"Wrong Dutch player stance with french player", (Object)dutch.getStance(french), (Object)stance);
        InGameControllerTest.assertEquals((String)"Wrong French player stance with dutch player", (Object)french.getStance(dutch), (Object)stance);
        InGameControllerTest.assertEquals((String)"Tension of dutch player towards french player wrong", (Object)((Object)expectedTension), (Object)((Object)dutch.getTension(french).getLevel()));
        InGameControllerTest.assertEquals((String)"Tension of french player towards dutch player wrong", (Object)((Object)expectedTension), (Object)((Object)french.getTension(dutch).getLevel()));
    }

    private void verifyTreatyResults(ServerPlayer player1, ServerPlayer player2, Stance expectedStance, int expectedTension) {
        InGameControllerTest.assertFalse((String)(player1 + " player should not be at war"), (boolean)player1.isAtWar());
        InGameControllerTest.assertEquals((String)(player1 + " player should be at peace with " + player2 + " player"), (Object)player1.getStance(player2), (Object)expectedStance);
        int player1CurrTension = player1.getTension(player2).getValue();
        InGameControllerTest.assertEquals((String)(player1 + " player tension values wrong"), (int)expectedTension, (int)player1CurrTension);
    }

    public void testPeaceTreatyFromWarStance() {
        ServerGame game = ServerTestHelper.startServerGame(InGameControllerTest.getTestMap());
        InGameController igc = ServerTestHelper.getInGameController();
        ServerPlayer dutch = this.getServerPlayer(game, "model.nation.dutch");
        ServerPlayer french = this.getServerPlayer(game, "model.nation.french");
        Tension hateful = new Tension(Tension.Level.HATEFUL.getLimit());
        Stance initialStance = Stance.WAR;
        Stance newStance = Stance.PEACE;
        this.setPlayersAt(initialStance, hateful);
        int dutchInitialTension = dutch.getTension(french).getValue();
        int frenchInitialTension = french.getTension(dutch).getValue();
        igc.changeStance(dutch, newStance, french, true);
        int dutchExpectedTension = Math.max(0, dutchInitialTension + -250 + -250);
        int frenchExpectedTension = Math.max(0, frenchInitialTension + -250 + -250);
        this.verifyTreatyResults(dutch, french, newStance, dutchExpectedTension);
        this.verifyTreatyResults(french, dutch, newStance, frenchExpectedTension);
    }

    public void testPeaceTreatyFromCeaseFireStance() {
        ServerGame game = ServerTestHelper.startServerGame(InGameControllerTest.getTestMap());
        InGameController igc = ServerTestHelper.getInGameController();
        ServerPlayer dutch = this.getServerPlayer(game, "model.nation.dutch");
        ServerPlayer french = this.getServerPlayer(game, "model.nation.french");
        Tension hateful = new Tension(Tension.Level.HATEFUL.getLimit());
        Stance initialStance = Stance.CEASE_FIRE;
        Stance newStance = Stance.PEACE;
        this.setPlayersAt(Stance.WAR, hateful);
        this.setPlayersAt(initialStance, hateful);
        int dutchInitialTension = dutch.getTension(french).getValue();
        int frenchInitialTension = french.getTension(dutch).getValue();
        StanceTradeItem peaceTreaty = new StanceTradeItem((Game)game, dutch, (Player)french, newStance);
        igc.changeStance(dutch, newStance, french, true);
        int dutchExpectedTension = Math.max(0, dutchInitialTension + -250);
        int frenchExpectedTension = Math.max(0, frenchInitialTension + -250);
        this.verifyTreatyResults(dutch, french, newStance, dutchExpectedTension);
        this.verifyTreatyResults(french, dutch, newStance, frenchExpectedTension);
    }

    public void testCeaseFireTreaty() {
        ServerGame game = ServerTestHelper.startServerGame(InGameControllerTest.getTestMap());
        InGameController igc = ServerTestHelper.getInGameController();
        ServerPlayer dutch = this.getServerPlayer(game, "model.nation.dutch");
        ServerPlayer french = this.getServerPlayer(game, "model.nation.french");
        Tension hateful = new Tension(Tension.Level.HATEFUL.getLimit());
        Stance initialStance = Stance.WAR;
        Stance newStance = Stance.CEASE_FIRE;
        this.setPlayersAt(initialStance, hateful);
        int dutchInitialTension = dutch.getTension(french).getValue();
        int frenchInitialTension = french.getTension(dutch).getValue();
        igc.changeStance(dutch, newStance, french, true);
        int dutchExpectedTension = Math.max(0, dutchInitialTension + -250);
        int frenchExpectedTension = Math.max(0, frenchInitialTension + -250);
        this.verifyTreatyResults(dutch, french, newStance, dutchExpectedTension);
        this.verifyTreatyResults(french, dutch, newStance, frenchExpectedTension);
    }

    public void testWarDeclarationAffectsSettlementAlarm() {
        ServerGame game = ServerTestHelper.startServerGame(InGameControllerTest.getTestMap());
        InGameController igc = ServerTestHelper.getInGameController();
        ServerPlayer dutch = this.getServerPlayer(game, "model.nation.dutch");
        ServerPlayer inca = this.getServerPlayer(game, "model.nation.inca");
        Player.makeContact(inca, dutch);
        FreeColTestCase.IndianSettlementBuilder builder = new FreeColTestCase.IndianSettlementBuilder(game);
        IndianSettlement camp = builder.player(inca).build();
        camp.setContacted(dutch);
        InGameControllerTest.assertEquals((String)"Inca should be at peace with dutch", (Object)Stance.PEACE, (Object)inca.getStance(dutch));
        Tension campAlarm = camp.getAlarm(dutch);
        InGameControllerTest.assertNotNull((String)"Camp should have had contact with Dutch", (Object)campAlarm);
        InGameControllerTest.assertEquals((String)"Camp should be happy", (Object)((Object)Tension.Level.HAPPY), (Object)((Object)campAlarm.getLevel()));
        igc.changeStance(dutch, Stance.WAR, inca, false);
        InGameControllerTest.assertEquals((String)"Inca should not yet be at war with the Dutch", (Object)Stance.PEACE, (Object)inca.getStance(dutch));
        igc.changeStance(dutch, Stance.WAR, inca, true);
        InGameControllerTest.assertEquals((String)"Inca should be at war with the Dutch", (Object)Stance.WAR, (Object)inca.getStance(dutch));
        campAlarm = camp.getAlarm(dutch);
        InGameControllerTest.assertEquals((String)"Camp should be hateful", (Object)((Object)Tension.Level.HATEFUL), (Object)((Object)campAlarm.getLevel()));
    }

    public void testEquipIndian() {
        ServerGame game = ServerTestHelper.startServerGame(InGameControllerTest.getTestMap());
        InGameController igc = ServerTestHelper.getInGameController();
        FreeColTestCase.IndianSettlementBuilder builder = new FreeColTestCase.IndianSettlementBuilder(game);
        IndianSettlement camp = builder.build();
        ServerPlayer indian = (ServerPlayer)camp.getOwner();
        List<AbstractGoods> required = nativeDragoonRole.getRequiredGoodsList();
        int horsesReqPerUnit = AbstractGoods.getCount(horsesType, required);
        int musketsReqPerUnit = AbstractGoods.getCount(musketsType, required);
        camp.addGoods(horsesType, horsesReqPerUnit);
        camp.addGoods(musketsType, musketsReqPerUnit);
        InGameControllerTest.assertEquals((String)"Initial number of horses in Indian camp not as expected", (int)horsesReqPerUnit, (int)camp.getGoodsCount(horsesType));
        InGameControllerTest.assertEquals((String)"Initial number of muskets in Indian camp not as expected", (int)musketsReqPerUnit, (int)camp.getGoodsCount(musketsType));
        Unit brave = camp.getUnitList().get(0);
        InGameControllerTest.assertFalse((String)"Brave should not be mounted", (boolean)brave.isMounted());
        InGameControllerTest.assertFalse((String)"Brave should not be armed", (boolean)brave.isArmed());
        InGameControllerTest.assertFalse((String)"Brave should not be a pioneer", (boolean)brave.roleIsAvailable(pioneerRole));
        InGameControllerTest.assertTrue((String)"Brave can become a mounted brave", (boolean)brave.roleIsAvailable(mountedBraveRole));
        InGameControllerTest.assertTrue((String)"Brave can become a armed brave", (boolean)brave.roleIsAvailable(armedBraveRole));
        InGameControllerTest.assertTrue((String)"Brave can become a native dragoon", (boolean)brave.roleIsAvailable(nativeDragoonRole));
        camp.equipForRole(brave, nativeDragoonRole, 1);
        InGameControllerTest.assertEquals((String)"Brave should have native dragoon role", (Object)nativeDragoonRole, (Object)brave.getRole());
        InGameControllerTest.assertTrue((String)"Brave should be mounted", (boolean)brave.isMounted());
        InGameControllerTest.assertTrue((String)"Brave should be armed", (boolean)brave.isArmed());
        InGameControllerTest.assertEquals((String)"No muskets should remain in camp", (int)0, (int)camp.getGoodsCount(musketsType));
        InGameControllerTest.assertEquals((String)"No horses should remain in camp", (int)0, (int)camp.getGoodsCount(horsesType));
    }

    public void testEquipIndianNotEnoughReqGoods() {
        ServerGame game = ServerTestHelper.startServerGame(InGameControllerTest.getTestMap());
        InGameController igc = ServerTestHelper.getInGameController();
        FreeColTestCase.IndianSettlementBuilder builder = new FreeColTestCase.IndianSettlementBuilder(game);
        IndianSettlement camp = builder.build();
        List<AbstractGoods> required = mountedBraveRole.getRequiredGoodsList();
        int horsesReq = AbstractGoods.getCount(horsesType, required);
        int musketsReq = AbstractGoods.getCount(musketsType, required);
        camp.addGoods(horsesType, horsesReq / 2);
        camp.addGoods(musketsType, musketsReq / 2);
        InGameControllerTest.assertEquals((String)"Initial number of horses in camp not as expected", (int)(horsesReq / 2), (int)camp.getGoodsCount(horsesType));
        InGameControllerTest.assertEquals((String)"Initial number of muskets in camp not as expected", (int)(musketsReq / 2), (int)camp.getGoodsCount(musketsType));
        Unit brave = camp.getUnitList().get(0);
        InGameControllerTest.assertTrue((String)"Initial brave has default role", (boolean)brave.hasDefaultRole());
        InGameControllerTest.assertFalse((String)"Initial brave should not be mounted", (boolean)brave.isMounted());
        InGameControllerTest.assertFalse((String)"Initial brave should not be armed", (boolean)brave.isArmed());
        camp.equipForRole(brave, nativeDragoonRole, 1);
        InGameControllerTest.assertTrue((String)"Final brave has default role", (boolean)brave.hasDefaultRole());
        InGameControllerTest.assertFalse((String)"Final brave should not be armed", (boolean)brave.isArmed());
        InGameControllerTest.assertEquals((String)"The muskets should not have been touched", (int)(musketsReq / 2), (int)camp.getGoodsCount(musketsType));
        InGameControllerTest.assertFalse((String)"Final brave should not be mounted", (boolean)brave.isMounted());
        InGameControllerTest.assertEquals((String)"The horses should not have been touched", (int)(horsesReq / 2), (int)camp.getGoodsCount(horsesType));
    }

    public void testAddFatherUnits() {
        ServerGame game = ServerTestHelper.startServerGame(InGameControllerTest.getTestMap());
        InGameController igc = ServerTestHelper.getInGameController();
        ServerPlayer dutch = this.getServerPlayer(game, "model.nation.dutch");
        InGameControllerTest.assertEquals((int)0, (int)dutch.getUnitCount());
        ArrayList<AbstractUnit> units = new ArrayList<AbstractUnit>();
        units.add(new AbstractUnit(colonistType, "model.role.default", 1));
        units.add(new AbstractUnit(statesmanType, "model.role.default", 1));
        FoundingFather father = new FoundingFather("father", InGameControllerTest.spec());
        father.setType(FoundingFather.FoundingFatherType.TRADE);
        father.setUnits(units);
        InGameControllerTest.spec().addTestFather(father);
        igc.addFoundingFather(dutch, father);
        InGameControllerTest.assertEquals((int)2, (int)dutch.getUnitCount());
        List<UnitType> types = CollectionUtils.toList(CollectionUtils.transform(dutch.getUnits(), CollectionUtils.alwaysTrue(), Unit::getType));
        InGameControllerTest.assertTrue((colonistType == types.get(0) && statesmanType == types.get(1) || colonistType == types.get(1) && statesmanType == types.get(0) ? 1 : 0) != 0);
    }

    public void testAddFatherBuildingEvent() {
        ServerGame game = ServerTestHelper.startServerGame(InGameControllerTest.getTestMap());
        InGameController igc = ServerTestHelper.getInGameController();
        BuildingType press = InGameControllerTest.spec().getBuildingType("model.building.printingPress");
        Colony colony = this.getStandardColony(4);
        InGameControllerTest.assertEquals(null, (Object)colony.getBuilding(press));
        FoundingFather father = new FoundingFather("father", InGameControllerTest.spec());
        father.setType(FoundingFather.FoundingFatherType.TRADE);
        ArrayList<Event> events = new ArrayList<Event>();
        Event event = new Event("model.event.freeBuilding", InGameControllerTest.spec());
        event.setValue("model.building.printingPress");
        events.add(event);
        father.setEvents(events);
        igc.addFoundingFather(colony.getOwner(), father);
        InGameControllerTest.assertTrue((colony.getBuilding(press) != null ? 1 : 0) != 0);
    }

    public void testPocahontas() {
        ServerGame game = ServerTestHelper.startServerGame(InGameControllerTest.getTestMap());
        Map map = game.getMap();
        InGameController igc = ServerTestHelper.getInGameController();
        Colony colony = this.getStandardColony(4);
        ServerPlayer player = (ServerPlayer)colony.getOwner();
        FreeColTestCase.IndianSettlementBuilder builder = new FreeColTestCase.IndianSettlementBuilder(game).settlementTile(map.getTile(8, 8));
        ServerIndianSettlement camp = (ServerIndianSettlement)builder.build();
        ServerPlayer indian = (ServerPlayer)camp.getOwner();
        Player.makeContact(indian, player);
        camp.setContacted(player);
        InGameControllerTest.assertEquals((String)"Initially, camp should be happy", (Object)((Object)camp.getAlarm(player).getLevel()), (Object)((Object)Tension.Level.HAPPY));
        igc.changeStance(indian, Stance.WAR, player, true);
        InGameControllerTest.assertEquals((String)"Camp should be hateful if war occurs", (Object)((Object)camp.getAlarm(player).getLevel()), (Object)((Object)Tension.Level.HATEFUL));
        FoundingFather father = InGameControllerTest.spec().getFoundingFather("model.foundingFather.pocahontas");
        igc.addFoundingFather(player, father);
        InGameControllerTest.assertEquals((String)"Pocahontas should make all happy again", (Object)((Object)camp.getAlarm(player).getLevel()), (Object)((Object)Tension.Level.HAPPY));
    }

    public void testLaSalle() {
        ServerGame game = ServerTestHelper.startServerGame(InGameControllerTest.getTestMap());
        InGameController igc = ServerTestHelper.getInGameController();
        Colony colony = this.getStandardColony(2);
        ServerPlayer player = (ServerPlayer)colony.getOwner();
        InGameControllerTest.assertEquals((int)2, (int)colony.getUnitCount());
        InGameControllerTest.assertNull((String)"Colony should have no stockade", (Object)colony.getBuilding(stockadeType));
        InGameControllerTest.assertEquals((String)"Population of 3 to required to build stockade", (int)3, (int)stockadeType.getRequiredPopulation());
        FoundingFather father = InGameControllerTest.spec().getFoundingFather("model.foundingFather.laSalle");
        InGameControllerTest.assertEquals((String)"model.building.stockade", (String)father.getEvents().get(0).getValue());
        igc.addFoundingFather(player, father);
        ServerTestHelper.newTurn();
        InGameControllerTest.assertNull((String)"Colony still should have no stockade", (Object)colony.getBuilding(stockadeType));
        ServerUnit unit = new ServerUnit(InGameControllerTest.getGame(), colony.getTile(), player, colonistType);
        unit.changeWorkType(bellsType);
        unit.setLocation(colony.getWorkLocationFor(unit, bellsType));
        ServerTestHelper.newTurn();
        InGameControllerTest.assertNotNull((String)"Colony should now have a stockade", (Object)colony.getBuilding(stockadeType));
    }

    public void testBuildingBonus() {
        ServerGame game = ServerTestHelper.startServerGame(InGameControllerTest.getTestMap(true));
        InGameController igc = ServerTestHelper.getInGameController();
        ServerPlayer dutch = this.getServerPlayer(game, "model.nation.dutch");
        FoundingFather father = new FoundingFather("father", InGameControllerTest.spec());
        father.setType(FoundingFather.FoundingFatherType.TRADE);
        Modifier priceBonus = new Modifier("model.modifier.buildingPriceBonus", -100.0f, Modifier.ModifierType.PERCENTAGE);
        Scope pressScope = new Scope();
        pressScope.setType("model.building.printingPress");
        ArrayList<Scope> scopeList = new ArrayList<Scope>();
        scopeList.add(pressScope);
        priceBonus.copyScopes(scopeList);
        father.addModifier(priceBonus);
        igc.addFoundingFather(dutch, father);
        Colony colony = this.getStandardColony(4);
        ServerTestHelper.newTurn();
        InGameControllerTest.assertTrue((colony.getBuilding(press) != null ? 1 : 0) != 0);
    }

    public void testUnitLosesExperienceWithWorkChange() {
        ServerGame game = ServerTestHelper.startServerGame(InGameControllerTest.getTestMap());
        Map map = game.getMap();
        InGameController igc = ServerTestHelper.getInGameController();
        ServerPlayer dutch = this.getServerPlayer(game, "model.nation.dutch");
        Colony colony = this.getStandardColony(1);
        ServerUnit colonist = new ServerUnit(game, map.getTile(6, 8), dutch, colonistType);
        colonist.changeWorkType(grainType);
        WorkLocation wl = colony.getWorkLocationFor(colonist, grainType);
        InGameControllerTest.assertNotNull((Object)wl);
        colonist.setLocation(wl);
        colonist.modifyExperience(10);
        InGameControllerTest.assertTrue((String)"Colonist should some initial experience", (colonist.getExperience() > 0 ? 1 : 0) != 0);
        igc.changeWorkType(dutch, colonist, cottonType);
        InGameControllerTest.assertTrue((String)"Colonist should have lost all experience", (colonist.getExperience() == 0 ? 1 : 0) != 0);
    }

    private int workLeftFor(UnitType unitType, TileType tileType, TileImprovementType whichWork) {
        Game game = InGameControllerTest.getStandardGame();
        game = ServerTestHelper.startServerGame(InGameControllerTest.getTestMap(tileType));
        InGameController igc = ServerTestHelper.getInGameController();
        ServerPlayer dutch = this.getServerPlayer(game, "model.nation.dutch");
        Tile tile = game.getMap().getTile(3, 3);
        InGameControllerTest.assertEquals((Object)tile.getType(), (Object)tileType);
        ServerUnit unit = new ServerUnit(game, tile, dutch, unitType, pioneerRole);
        tile.setOwner(dutch);
        tile.setExplored(dutch, true);
        igc.changeWorkImprovementType(dutch, unit, whichWork);
        return unit.getWorkTurnsLeft();
    }

    public void testDoAssignedWorkAmateurAndHardyPioneer() {
        InGameControllerTest.assertEquals((int)8, (int)this.workLeftFor(colonistType, savannahForest, clear));
        InGameControllerTest.assertEquals((int)6, (int)this.workLeftFor(colonistType, savannahForest, road));
        InGameControllerTest.assertEquals((int)5, (int)this.workLeftFor(colonistType, savannah, plow));
        InGameControllerTest.assertEquals((int)3, (int)this.workLeftFor(colonistType, savannah, road));
        InGameControllerTest.assertEquals((int)4, (int)this.workLeftFor(hardyPioneerType, savannahForest, clear));
        InGameControllerTest.assertEquals((int)3, (int)this.workLeftFor(hardyPioneerType, savannahForest, road));
        InGameControllerTest.assertEquals((int)3, (int)this.workLeftFor(hardyPioneerType, savannah, plow));
        InGameControllerTest.assertEquals((int)2, (int)this.workLeftFor(hardyPioneerType, savannah, road));
        InGameControllerTest.assertEquals((int)6, (int)this.workLeftFor(colonistType, tundraForest, clear));
        InGameControllerTest.assertEquals((int)4, (int)this.workLeftFor(colonistType, tundraForest, road));
        InGameControllerTest.assertEquals((int)6, (int)this.workLeftFor(colonistType, tundra, plow));
        InGameControllerTest.assertEquals((int)4, (int)this.workLeftFor(colonistType, tundra, road));
        InGameControllerTest.assertEquals((int)3, (int)this.workLeftFor(hardyPioneerType, tundraForest, clear));
        InGameControllerTest.assertEquals((int)2, (int)this.workLeftFor(hardyPioneerType, tundraForest, road));
        InGameControllerTest.assertEquals((int)3, (int)this.workLeftFor(hardyPioneerType, tundra, plow));
        InGameControllerTest.assertEquals((int)2, (int)this.workLeftFor(hardyPioneerType, tundra, road));
        InGameControllerTest.assertEquals((int)6, (int)this.workLeftFor(colonistType, plainsForest, clear));
        InGameControllerTest.assertEquals((int)4, (int)this.workLeftFor(colonistType, plainsForest, road));
        InGameControllerTest.assertEquals((int)5, (int)this.workLeftFor(colonistType, plains, plow));
        InGameControllerTest.assertEquals((int)3, (int)this.workLeftFor(colonistType, plains, road));
        InGameControllerTest.assertEquals((int)3, (int)this.workLeftFor(hardyPioneerType, plainsForest, clear));
        InGameControllerTest.assertEquals((int)2, (int)this.workLeftFor(hardyPioneerType, plainsForest, road));
        InGameControllerTest.assertEquals((int)3, (int)this.workLeftFor(hardyPioneerType, plains, plow));
        InGameControllerTest.assertEquals((int)2, (int)this.workLeftFor(hardyPioneerType, plains, road));
        InGameControllerTest.assertEquals((int)4, (int)this.workLeftFor(colonistType, hills, road));
        InGameControllerTest.assertEquals((int)2, (int)this.workLeftFor(hardyPioneerType, hills, road));
        InGameControllerTest.assertEquals((int)7, (int)this.workLeftFor(colonistType, mountains, road));
        InGameControllerTest.assertEquals((int)4, (int)this.workLeftFor(hardyPioneerType, mountains, road));
        InGameControllerTest.assertEquals((int)8, (int)this.workLeftFor(colonistType, marshForest, clear));
        InGameControllerTest.assertEquals((int)6, (int)this.workLeftFor(colonistType, marshForest, road));
        InGameControllerTest.assertEquals((int)7, (int)this.workLeftFor(colonistType, marsh, plow));
        InGameControllerTest.assertEquals((int)5, (int)this.workLeftFor(colonistType, marsh, road));
        InGameControllerTest.assertEquals((int)4, (int)this.workLeftFor(hardyPioneerType, marshForest, clear));
        InGameControllerTest.assertEquals((int)3, (int)this.workLeftFor(hardyPioneerType, marshForest, road));
        InGameControllerTest.assertEquals((int)4, (int)this.workLeftFor(hardyPioneerType, marsh, plow));
        InGameControllerTest.assertEquals((int)3, (int)this.workLeftFor(hardyPioneerType, marsh, road));
        InGameControllerTest.assertEquals((int)6, (int)this.workLeftFor(colonistType, desertForest, clear));
        InGameControllerTest.assertEquals((int)4, (int)this.workLeftFor(colonistType, desertForest, road));
        InGameControllerTest.assertEquals((int)5, (int)this.workLeftFor(colonistType, desert, plow));
        InGameControllerTest.assertEquals((int)3, (int)this.workLeftFor(colonistType, desert, road));
        InGameControllerTest.assertEquals((int)3, (int)this.workLeftFor(hardyPioneerType, desertForest, clear));
        InGameControllerTest.assertEquals((int)2, (int)this.workLeftFor(hardyPioneerType, desertForest, road));
        InGameControllerTest.assertEquals((int)3, (int)this.workLeftFor(hardyPioneerType, desert, plow));
        InGameControllerTest.assertEquals((int)2, (int)this.workLeftFor(hardyPioneerType, desert, road));
        InGameControllerTest.assertEquals((int)9, (int)this.workLeftFor(colonistType, swampForest, clear));
        InGameControllerTest.assertEquals((int)7, (int)this.workLeftFor(colonistType, swampForest, road));
        InGameControllerTest.assertEquals((int)9, (int)this.workLeftFor(colonistType, swamp, plow));
        InGameControllerTest.assertEquals((int)7, (int)this.workLeftFor(colonistType, swamp, road));
        InGameControllerTest.assertEquals((int)5, (int)this.workLeftFor(hardyPioneerType, swampForest, clear));
        InGameControllerTest.assertEquals((int)4, (int)this.workLeftFor(hardyPioneerType, swampForest, road));
        InGameControllerTest.assertEquals((int)5, (int)this.workLeftFor(hardyPioneerType, swamp, plow));
        InGameControllerTest.assertEquals((int)4, (int)this.workLeftFor(hardyPioneerType, swamp, road));
    }

    public void testUnitTypeChangeOnEnterColony() {
        ServerGame game = ServerTestHelper.startServerGame(InGameControllerTest.getTestMap(true));
        InGameController igc = ServerTestHelper.getInGameController();
        ServerPlayer dutch = this.getServerPlayer(game, "model.nation.dutch");
        Colony colony = this.getStandardColony();
        UnitType gardenerType = new UnitType("gardener", InGameControllerTest.spec());
        gardenerType.setSkill(0);
        gardenerType.addAbility(new Ability("model.ability.person"));
        this.addUnitTypeChange("model.unitChange.enterColony", gardenerType, farmerType, 100, -1);
        InGameControllerTest.assertEquals((Object)farmerType, (Object)InGameControllerTest.spec().getUnitChange((String)"model.unitChange.enterColony", (UnitType)gardenerType).to);
        ServerUnit gardener = new ServerUnit(game, null, dutch, gardenerType);
        InGameControllerTest.assertEquals((Object)gardenerType, (Object)gardener.getType());
        WorkLocation loc = colony.getWorkLocationFor(gardener);
        InGameControllerTest.assertNotNull((Object)loc);
        gardener.setLocation(colony.getTile());
        igc.work(dutch, gardener, loc);
        InGameControllerTest.assertEquals((Object)farmerType, (Object)gardener.getType());
    }

    public void testCarpenterHouseNationalAdvantage() {
        ServerGame game = ServerTestHelper.startServerGame(InGameControllerTest.getTestMap(true));
        InGameController igc = ServerTestHelper.getInGameController();
        ServerColony colony = (ServerColony)this.getStandardColony(2);
        colony.addGoods(lumberType, 100);
        Unit unit = colony.getUnitList().get(0);
        Building building = colony.getBuilding(carpenterHouse);
        InGameControllerTest.assertEquals((String)"Production()", (int)0, (int)building.getTotalProductionOf(hammersType));
        unit.setLocation(building);
        colony.invalidateCache();
        InGameControllerTest.assertEquals((String)"Production(unit)", (int)3, (int)building.getTotalProductionOf(hammersType));
        ServerPlayer swedish = null;
        for (Nation n : game.getSpecification().getNations()) {
            if (!n.getId().equals("model.nation.swedish")) continue;
            swedish = new ServerPlayer(game, false, n);
            swedish.setAI(true);
            game.addPlayer(swedish);
            break;
        }
        InGameControllerTest.assertNotNull((String)"Swedes exist", swedish);
        igc.debugChangeOwner(colony, swedish);
        colony.invalidateCache();
        InGameControllerTest.assertEquals((String)"Production(unit/building-advantage)", (int)5, (int)building.getTotalProductionOf(hammersType));
    }

    public void testAttrition() {
        ServerGame game = ServerTestHelper.startServerGame(InGameControllerTest.getTestMap());
        InGameController igc = ServerTestHelper.getInGameController();
        Colony colony = this.getStandardColony();
        ServerPlayer player = (ServerPlayer)colony.getOwner();
        ServerUnit unit = new ServerUnit(game, colony.getTile(), player, indianConvertType);
        InGameControllerTest.assertEquals((int)0, (int)unit.getAttrition());
        ServerTestHelper.newTurn();
        InGameControllerTest.assertEquals((int)0, (int)unit.getAttrition());
        for (Tile t : colony.getTile().getSurroundingTiles(1, 1)) {
            if (!t.isLand()) continue;
            unit.setLocation(t);
            break;
        }
        ServerTestHelper.newTurn();
        InGameControllerTest.assertEquals((int)1, (int)unit.getAttrition());
        ServerUnit colonist = new ServerUnit(game, unit.getTile(), player, colonistType);
        InGameControllerTest.assertEquals((int)0, (int)colonist.getAttrition());
        ServerTestHelper.newTurn();
        InGameControllerTest.assertEquals((int)0, (int)colonist.getAttrition());
        while (unit.getAttrition() < unit.getType().getMaximumAttrition()) {
            ServerTestHelper.newTurn();
        }
        InGameControllerTest.assertFalse((boolean)unit.isDisposed());
        ServerTestHelper.newTurn();
        InGameControllerTest.assertTrue((boolean)unit.isDisposed());
    }
}

