/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.document;

import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;

public abstract class AbstractField
implements Fieldable {
    protected String name = "body";
    protected boolean storeTermVector = false;
    protected boolean storeOffsetWithTermVector = false;
    protected boolean storePositionWithTermVector = false;
    protected boolean omitNorms = false;
    protected boolean isStored = false;
    protected boolean isIndexed = true;
    protected boolean isTokenized = true;
    protected boolean isBinary = false;
    protected boolean isCompressed = false;
    protected boolean lazy = false;
    protected boolean omitTf = false;
    protected float boost = 1.0f;
    protected Object fieldsData = null;
    protected int binaryLength;
    protected int binaryOffset;

    protected AbstractField() {
    }

    protected AbstractField(String name, Field.Store store, Field.Index index, Field.TermVector termVector) {
        if (name == null) {
            throw new NullPointerException("name cannot be null");
        }
        this.name = name.intern();
        if (store == Field.Store.YES) {
            this.isStored = true;
            this.isCompressed = false;
        } else if (store == Field.Store.COMPRESS) {
            this.isStored = true;
            this.isCompressed = true;
        } else if (store == Field.Store.NO) {
            this.isStored = false;
            this.isCompressed = false;
        } else {
            throw new IllegalArgumentException("unknown store parameter " + store);
        }
        if (index == Field.Index.NO) {
            this.isIndexed = false;
            this.isTokenized = false;
        } else if (index == Field.Index.ANALYZED) {
            this.isIndexed = true;
            this.isTokenized = true;
        } else if (index == Field.Index.NOT_ANALYZED) {
            this.isIndexed = true;
            this.isTokenized = false;
        } else if (index == Field.Index.NOT_ANALYZED_NO_NORMS) {
            this.isIndexed = true;
            this.isTokenized = false;
            this.omitNorms = true;
        } else if (index == Field.Index.ANALYZED_NO_NORMS) {
            this.isIndexed = true;
            this.isTokenized = true;
            this.omitNorms = true;
        } else {
            throw new IllegalArgumentException("unknown index parameter " + index);
        }
        this.isBinary = false;
        this.setStoreTermVector(termVector);
    }

    public void setBoost(float boost) {
        this.boost = boost;
    }

    public float getBoost() {
        return this.boost;
    }

    public String name() {
        return this.name;
    }

    protected void setStoreTermVector(Field.TermVector termVector) {
        if (termVector == Field.TermVector.NO) {
            this.storeTermVector = false;
            this.storePositionWithTermVector = false;
            this.storeOffsetWithTermVector = false;
        } else if (termVector == Field.TermVector.YES) {
            this.storeTermVector = true;
            this.storePositionWithTermVector = false;
            this.storeOffsetWithTermVector = false;
        } else if (termVector == Field.TermVector.WITH_POSITIONS) {
            this.storeTermVector = true;
            this.storePositionWithTermVector = true;
            this.storeOffsetWithTermVector = false;
        } else if (termVector == Field.TermVector.WITH_OFFSETS) {
            this.storeTermVector = true;
            this.storePositionWithTermVector = false;
            this.storeOffsetWithTermVector = true;
        } else if (termVector == Field.TermVector.WITH_POSITIONS_OFFSETS) {
            this.storeTermVector = true;
            this.storePositionWithTermVector = true;
            this.storeOffsetWithTermVector = true;
        } else {
            throw new IllegalArgumentException("unknown termVector parameter " + termVector);
        }
    }

    public final boolean isStored() {
        return this.isStored;
    }

    public final boolean isIndexed() {
        return this.isIndexed;
    }

    public final boolean isTokenized() {
        return this.isTokenized;
    }

    public final boolean isCompressed() {
        return this.isCompressed;
    }

    public final boolean isTermVectorStored() {
        return this.storeTermVector;
    }

    public boolean isStoreOffsetWithTermVector() {
        return this.storeOffsetWithTermVector;
    }

    public boolean isStorePositionWithTermVector() {
        return this.storePositionWithTermVector;
    }

    public final boolean isBinary() {
        return this.isBinary;
    }

    public byte[] getBinaryValue() {
        return this.getBinaryValue(null);
    }

    public byte[] getBinaryValue(byte[] result) {
        if (this.isBinary || this.fieldsData instanceof byte[]) {
            return (byte[])this.fieldsData;
        }
        return null;
    }

    public int getBinaryLength() {
        if (this.isBinary) {
            if (!this.isCompressed) {
                return this.binaryLength;
            }
            return ((byte[])this.fieldsData).length;
        }
        if (this.fieldsData instanceof byte[]) {
            return ((byte[])this.fieldsData).length;
        }
        return 0;
    }

    public int getBinaryOffset() {
        return this.binaryOffset;
    }

    public boolean getOmitNorms() {
        return this.omitNorms;
    }

    public boolean getOmitTf() {
        return this.omitTf;
    }

    public void setOmitNorms(boolean omitNorms) {
        this.omitNorms = omitNorms;
    }

    public void setOmitTf(boolean omitTf) {
        this.omitTf = omitTf;
    }

    public boolean isLazy() {
        return this.lazy;
    }

    public final String toString() {
        StringBuffer result = new StringBuffer();
        if (this.isStored) {
            result.append("stored");
            if (this.isCompressed) {
                result.append("/compressed");
            } else {
                result.append("/uncompressed");
            }
        }
        if (this.isIndexed) {
            if (result.length() > 0) {
                result.append(",");
            }
            result.append("indexed");
        }
        if (this.isTokenized) {
            if (result.length() > 0) {
                result.append(",");
            }
            result.append("tokenized");
        }
        if (this.storeTermVector) {
            if (result.length() > 0) {
                result.append(",");
            }
            result.append("termVector");
        }
        if (this.storeOffsetWithTermVector) {
            if (result.length() > 0) {
                result.append(",");
            }
            result.append("termVectorOffsets");
        }
        if (this.storePositionWithTermVector) {
            if (result.length() > 0) {
                result.append(",");
            }
            result.append("termVectorPosition");
        }
        if (this.isBinary) {
            if (result.length() > 0) {
                result.append(",");
            }
            result.append("binary");
        }
        if (this.omitNorms) {
            result.append(",omitNorms");
        }
        if (this.omitTf) {
            result.append(",omitTf");
        }
        if (this.lazy) {
            result.append(",lazy");
        }
        result.append('<');
        result.append(this.name);
        result.append(':');
        if (this.fieldsData != null && !this.lazy) {
            result.append(this.fieldsData);
        }
        result.append('>');
        return result.toString();
    }
}

