/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options;

import com.intellij.application.options.ImportLayoutPanel;
import com.intellij.application.options.PackagePanelUIKt;
import com.intellij.psi.codeStyle.PackageEntry;
import com.intellij.psi.codeStyle.PackageEntryTable;
import com.intellij.ui.TableUtil;
import com.intellij.ui.table.JBTable;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;

public final class PackagePanel {
    static void addPackageToPackages(JBTable table, PackageEntryTable list) {
        int selected = table.getSelectedRow() + 1;
        if (selected < 0) {
            selected = list.getEntryCount();
        }
        PackageEntry entry = new PackageEntry(false, "", true);
        list.insertEntryAt(entry, selected);
        ImportLayoutPanel.refreshTableModel(selected, table);
    }

    static void removeEntryFromPackages(JBTable table, PackageEntryTable list) {
        int selected = table.getSelectedRow();
        if (selected < 0) {
            return;
        }
        TableUtil.stopEditing((JTable)table);
        list.removeEntryAt(selected);
        AbstractTableModel model = (AbstractTableModel)table.getModel();
        model.fireTableRowsDeleted(selected, selected);
        if (selected >= list.getEntryCount()) {
            --selected;
        }
        if (selected >= 0) {
            table.setRowSelectionInterval(selected, selected);
        }
    }

    public static JPanel createPackagesPanel(JBTable packageTable, PackageEntryTable packageList) {
        return PackagePanelUIKt.doCreatePackagesPanel(packageTable, packageList);
    }
}

