/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.longs;

import it.unimi.dsi.fastutil.Size64;
import it.unimi.dsi.fastutil.longs.AbstractLong2LongFunction;
import it.unimi.dsi.fastutil.longs.AbstractLongCollection;
import it.unimi.dsi.fastutil.longs.AbstractLongSet;
import it.unimi.dsi.fastutil.longs.Long2LongMap;
import it.unimi.dsi.fastutil.longs.Long2LongMaps;
import it.unimi.dsi.fastutil.longs.LongBinaryOperator;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.longs.LongSpliterator;
import it.unimi.dsi.fastutil.longs.LongSpliterators;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.function.LongConsumer;

public abstract class AbstractLong2LongMap
extends AbstractLong2LongFunction
implements Long2LongMap,
Serializable {
    private static final long serialVersionUID = -4940583368468432370L;

    protected AbstractLong2LongMap() {
    }

    @Override
    public boolean containsKey(long k) {
        Iterator i = this.long2LongEntrySet().iterator();
        while (i.hasNext()) {
            if (((Long2LongMap.Entry)i.next()).getLongKey() != k) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsValue(long v) {
        Iterator i = this.long2LongEntrySet().iterator();
        while (i.hasNext()) {
            if (((Long2LongMap.Entry)i.next()).getLongValue() != v) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    public final long mergeLong(long key, long value, LongBinaryOperator remappingFunction) {
        return this.mergeLong(key, value, (java.util.function.LongBinaryOperator)remappingFunction);
    }

    @Override
    public LongSet keySet() {
        return new AbstractLongSet(){

            @Override
            public boolean contains(long k) {
                return AbstractLong2LongMap.this.containsKey(k);
            }

            @Override
            public int size() {
                return AbstractLong2LongMap.this.size();
            }

            @Override
            public void clear() {
                AbstractLong2LongMap.this.clear();
            }

            @Override
            public LongIterator iterator() {
                return new LongIterator(){
                    private final ObjectIterator<Long2LongMap.Entry> i;
                    {
                        this.i = Long2LongMaps.fastIterator(AbstractLong2LongMap.this);
                    }

                    @Override
                    public long nextLong() {
                        return ((Long2LongMap.Entry)this.i.next()).getLongKey();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i.hasNext();
                    }

                    @Override
                    public void remove() {
                        this.i.remove();
                    }

                    @Override
                    public void forEachRemaining(LongConsumer action) {
                        this.i.forEachRemaining((? super E entry) -> action.accept(entry.getLongKey()));
                    }
                };
            }

            @Override
            public LongSpliterator spliterator() {
                return LongSpliterators.asSpliterator(this.iterator(), Size64.sizeOf(AbstractLong2LongMap.this), 321);
            }
        };
    }

    @Override
    public LongCollection values() {
        return new AbstractLongCollection(){

            @Override
            public boolean contains(long k) {
                return AbstractLong2LongMap.this.containsValue(k);
            }

            @Override
            public int size() {
                return AbstractLong2LongMap.this.size();
            }

            @Override
            public void clear() {
                AbstractLong2LongMap.this.clear();
            }

            @Override
            public LongIterator iterator() {
                return new LongIterator(){
                    private final ObjectIterator<Long2LongMap.Entry> i;
                    {
                        this.i = Long2LongMaps.fastIterator(AbstractLong2LongMap.this);
                    }

                    @Override
                    public long nextLong() {
                        return ((Long2LongMap.Entry)this.i.next()).getLongValue();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i.hasNext();
                    }

                    @Override
                    public void remove() {
                        this.i.remove();
                    }

                    @Override
                    public void forEachRemaining(LongConsumer action) {
                        this.i.forEachRemaining((? super E entry) -> action.accept(entry.getLongValue()));
                    }
                };
            }

            @Override
            public LongSpliterator spliterator() {
                return LongSpliterators.asSpliterator(this.iterator(), Size64.sizeOf(AbstractLong2LongMap.this), 320);
            }
        };
    }

    @Override
    public void putAll(Map<? extends Long, ? extends Long> m) {
        if (m instanceof Long2LongMap) {
            ObjectIterator<Long2LongMap.Entry> i = Long2LongMaps.fastIterator((Long2LongMap)m);
            while (i.hasNext()) {
                Long2LongMap.Entry e = (Long2LongMap.Entry)i.next();
                this.put(e.getLongKey(), e.getLongValue());
            }
        } else {
            int n = m.size();
            Iterator<Map.Entry<? extends Long, ? extends Long>> i = m.entrySet().iterator();
            while (n-- != 0) {
                Map.Entry<? extends Long, ? extends Long> e = i.next();
                this.put(e.getKey(), e.getValue());
            }
        }
    }

    @Override
    public int hashCode() {
        int h = 0;
        int n = this.size();
        ObjectIterator<Long2LongMap.Entry> i = Long2LongMaps.fastIterator(this);
        while (n-- != 0) {
            h += ((Long2LongMap.Entry)i.next()).hashCode();
        }
        return h;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map m = (Map)o;
        if (m.size() != this.size()) {
            return false;
        }
        return this.long2LongEntrySet().containsAll(m.entrySet());
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        ObjectIterator<Long2LongMap.Entry> i = Long2LongMaps.fastIterator(this);
        int n = this.size();
        boolean first2 = true;
        s.append("{");
        while (n-- != 0) {
            if (first2) {
                first2 = false;
            } else {
                s.append(", ");
            }
            Long2LongMap.Entry e = (Long2LongMap.Entry)i.next();
            s.append(String.valueOf(e.getLongKey()));
            s.append("=>");
            s.append(String.valueOf(e.getLongValue()));
        }
        s.append("}");
        return s.toString();
    }
}

