/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.fus;

import com.intellij.internal.statistic.eventLog.EventLogConfiguration;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.system.OS;
import com.sun.jna.platform.mac.IOKit;
import com.sun.jna.platform.mac.IOKitUtil;
import com.sun.jna.platform.win32.Advapi32Util;
import com.sun.jna.platform.win32.COM.WbemcliUtil;
import com.sun.jna.platform.win32.Ole32;
import com.sun.jna.platform.win32.WinReg;
import java.nio.file.Path;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u000fB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0007H\u0007J\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\u0007J\n\u0010\f\u001a\u0004\u0018\u00010\u0007H\u0002J\n\u0010\r\u001a\u0004\u0018\u00010\u0007H\u0002J\n\u0010\u000e\u001a\u0004\u0018\u00010\u0007H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/internal/statistic/eventLog/fus/MachineIdManager;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getAnonymizedMachineId", "", "purpose", "salt", "machineId", "Lkotlin/Lazy;", "getWindowsMachineId", "getMacOsMachineId", "getLinuxMachineId", "ComputerSystemProductProperty", "intellij.platform.statistics"})
@SourceDebugExtension(value={"SMAP\nMachineIdManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MachineIdManager.kt\ncom/intellij/internal/statistic/eventLog/fus/MachineIdManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,81:1\n1#2:82\n14#3:83\n*S KotlinDebug\n*F\n+ 1 MachineIdManager.kt\ncom/intellij/internal/statistic/eventLog/fus/MachineIdManager\n*L\n16#1:83\n*E\n"})
public final class MachineIdManager {
    @NotNull
    public static final MachineIdManager INSTANCE = new MachineIdManager();
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final Lazy<String> machineId;

    private MachineIdManager() {
    }

    @Deprecated(message="Use `getAnonymizedMachineId(String)`", level=DeprecationLevel.ERROR)
    @Nullable
    public final String getAnonymizedMachineId(@NotNull String purpose, @NotNull String salt) {
        Intrinsics.checkNotNullParameter((Object)purpose, (String)"purpose");
        Intrinsics.checkNotNullParameter((Object)salt, (String)"salt");
        return this.getAnonymizedMachineId(purpose + salt);
    }

    @Nullable
    public final String getAnonymizedMachineId(@NotNull String purpose) {
        String string;
        Intrinsics.checkNotNullParameter((Object)purpose, (String)"purpose");
        if (!(((CharSequence)purpose).length() > 0)) {
            boolean bl = false;
            String string2 = "`purpose` should not be empty";
            throw new IllegalArgumentException(string2.toString());
        }
        String string3 = (String)machineId.getValue();
        if (string3 != null) {
            String machineId = string3;
            boolean bl = false;
            byte[] byArray = (System.getProperty("user.name") + purpose).getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            string = EventLogConfiguration.Companion.hashSha256(byArray, machineId);
        } else {
            string = null;
        }
        return string;
    }

    private final String getWindowsMachineId() {
        Object object;
        Object object2;
        Object object3 = this;
        try {
            MachineIdManager $this$getWindowsMachineId_u24lambda_u245 = object3;
            boolean bl = false;
            object2 = Result.constructor-impl((Object)Advapi32Util.registryGetStringValue((WinReg.HKEY)WinReg.HKEY_LOCAL_MACHINE, (String)"SOFTWARE\\Microsoft\\Cryptography", (String)"MachineGuid"));
        }
        catch (Throwable bl) {
            object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object3 = object2;
        object2 = Result.exceptionOrNull-impl((Object)object3);
        if (object2 == null) {
            object = object3;
        } else {
            Object it = object2;
            boolean bl = false;
            LOG.debug((Throwable)it);
            Ole32.INSTANCE.CoInitializeEx(null, 2);
            WbemcliUtil.WmiResult result = new WbemcliUtil.WmiQuery("Win32_ComputerSystemProduct", ComputerSystemProductProperty.class).execute(2000);
            boolean bl2 = false;
            object = Result.constructor-impl(result.getResultCount() > 0 ? result.getValue((Enum)ComputerSystemProductProperty.UUID, 0).toString() : null);
        }
        object3 = object;
        ResultKt.throwOnFailure((Object)object3);
        return (String)object3;
    }

    /*
     * WARNING - void declaration
     */
    private final String getMacOsMachineId() {
        String string;
        IOKit.IOService iOService = IOKitUtil.getMatchingService((String)"IOPlatformExpertDevice");
        if (iOService != null) {
            void var3_3;
            IOKit.IOService device = iOService;
            boolean bl = false;
            String property = device.getStringProperty("IOPlatformUUID");
            device.release();
            string = var3_3;
        } else {
            string = null;
        }
        return string;
    }

    private final String getLinuxMachineId() {
        Object[] objectArray = new String[]{"/etc/machine-id", "/var/lib/dbus/machine-id", "/sys/devices/virtual/dmi/id/product_uuid"};
        return (String)SequencesKt.firstOrNull((Sequence)SequencesKt.map((Sequence)SequencesKt.sequenceOf((Object[])objectArray), MachineIdManager::getLinuxMachineId$lambda$11));
    }

    private static final String machineId$lambda$4() {
        Object object;
        block7: {
            Object object2;
            object = INSTANCE;
            try {
                String string;
                MachineIdManager $this$machineId_u24lambda_u244_u24lambda_u242 = object;
                boolean bl = false;
                OS oS = OS.CURRENT;
                switch (oS == null ? -1 : WhenMappings.$EnumSwitchMapping$0[oS.ordinal()]) {
                    case 1: {
                        string = $this$machineId_u24lambda_u244_u24lambda_u242.getWindowsMachineId();
                        break;
                    }
                    case 2: {
                        string = $this$machineId_u24lambda_u244_u24lambda_u242.getMacOsMachineId();
                        break;
                    }
                    case 3: {
                        string = $this$machineId_u24lambda_u244_u24lambda_u242.getLinuxMachineId();
                        break;
                    }
                    default: {
                        string = null;
                    }
                }
                object2 = Result.constructor-impl((Object)string);
            }
            catch (Throwable bl) {
                object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object = object2;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object);
            if (throwable == null) break block7;
            Object it = object2 = throwable;
            boolean bl = false;
            LOG.debug((Throwable)it);
        }
        return (String)(Result.isFailure-impl((Object)object) ? null : object);
    }

    private static final String getLinuxMachineId$lambda$11(String it) {
        Object object;
        block2: {
            Object object2;
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            object = INSTANCE;
            try {
                String string;
                MachineIdManager $this$getLinuxMachineId_u24lambda_u2411_u24lambda_u249 = object;
                boolean bl = false;
                Path path = Path.of(it, new String[0]);
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"of(...)");
                String p0 = string = ((Object)StringsKt.trim((CharSequence)PathsKt.readText$default((Path)path, null, (int)1, null))).toString();
                boolean bl2 = false;
                object2 = Result.constructor-impl((Object)(((CharSequence)p0).length() > 0 ? string : null));
            }
            catch (Throwable bl) {
                object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object = object2;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object);
            if (throwable == null) break block2;
            Object it2 = object2 = throwable;
            boolean bl = false;
            LOG.debug((Throwable)it2);
        }
        return (String)(Result.isFailure-impl((Object)object) ? null : object);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(MachineIdManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        machineId = LazyKt.lazy(MachineIdManager::machineId$lambda$4);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lcom/intellij/internal/statistic/eventLog/fus/MachineIdManager$ComputerSystemProductProperty;", "", "<init>", "(Ljava/lang/String;I)V", "UUID", "intellij.platform.statistics"})
    public static final class ComputerSystemProductProperty
    extends Enum<ComputerSystemProductProperty> {
        public static final /* enum */ ComputerSystemProductProperty UUID = new ComputerSystemProductProperty();
        private static final /* synthetic */ ComputerSystemProductProperty[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static ComputerSystemProductProperty[] values() {
            return (ComputerSystemProductProperty[])$VALUES.clone();
        }

        public static ComputerSystemProductProperty valueOf(String value) {
            return Enum.valueOf(ComputerSystemProductProperty.class, value);
        }

        @NotNull
        public static EnumEntries<ComputerSystemProductProperty> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = computerSystemProductPropertyArray = new ComputerSystemProductProperty[]{ComputerSystemProductProperty.UUID};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[OS.values().length];
            try {
                nArray[OS.Windows.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OS.macOS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OS.Linux.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

