/*
 * Decompiled with CFR 0.152.
 */
package zmq.io;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import zmq.Msg;
import zmq.ZMQ;
import zmq.util.Wire;

public class Metadata {
    public static final String IDENTITY = "Identity";
    public static final String SOCKET_TYPE = "Socket-Type";
    public static final String USER_ID = "User-Id";
    public static final String PEER_ADDRESS = "Peer-Address";
    private final Map<String, String> dictionary = new ConcurrentHashMap<String, String>();

    public Metadata() {
    }

    public Metadata(Properties dictionary) {
        dictionary.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> this.dictionary.put(key.toString(), value.toString())));
    }

    public Metadata(Map<String, String> dictionary) {
        dictionary.forEach((key, value) -> this.dictionary.put((String)key, Optional.ofNullable(value).orElse("")));
    }

    public Set<String> keySet() {
        return this.dictionary.keySet();
    }

    public Set<Map.Entry<String, String>> entrySet() {
        return this.dictionary.entrySet();
    }

    public Collection<String> values() {
        return this.dictionary.values();
    }

    public void remove(String key) {
        this.dictionary.remove(key);
    }

    public String get(String property) {
        return this.dictionary.get(property);
    }

    @Deprecated
    public void set(String property, String value) {
        this.put(property, value);
    }

    public void put(String property, String value) {
        if (value != null) {
            this.dictionary.put(property, value);
        } else {
            this.dictionary.put(property, "");
        }
    }

    public int hashCode() {
        return this.dictionary.hashCode();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!(other instanceof Metadata)) {
            return false;
        }
        Metadata that = (Metadata)other;
        return this.dictionary.equals(that.dictionary);
    }

    public void set(Metadata zapProperties) {
        this.dictionary.putAll(zapProperties.dictionary);
    }

    public boolean isEmpty() {
        return this.dictionary.isEmpty();
    }

    public boolean containsKey(String property) {
        return this.dictionary.containsKey(property);
    }

    public void clear() {
        this.dictionary.clear();
    }

    public int size() {
        return this.dictionary.size();
    }

    public String toString() {
        return "Metadata=" + this.dictionary;
    }

    public byte[] bytes() {
        byte[] byArray;
        ByteArrayOutputStream stream = new ByteArrayOutputStream(this.bytesSize());
        try {
            this.write(stream);
            byArray = stream.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    stream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new IllegalStateException("Unable to write content as bytes", e);
            }
        }
        stream.close();
        return byArray;
    }

    private int bytesSize() {
        int size = 0;
        for (Map.Entry<String, String> entry : this.dictionary.entrySet()) {
            ++size;
            size += entry.getKey().length();
            size += 4;
            size += entry.getValue().length();
        }
        return size;
    }

    public void write(OutputStream stream) throws IOException {
        for (Map.Entry<String, String> entry : this.dictionary.entrySet()) {
            byte[] keyBytes = entry.getKey().getBytes(ZMQ.CHARSET);
            if (keyBytes.length > 255) {
                throw new IllegalStateException("Trying to serialize an oversize attribute name");
            }
            stream.write(keyBytes.length);
            stream.write(keyBytes);
            byte[] valueBytes = entry.getValue().getBytes(ZMQ.CHARSET);
            stream.write(Wire.putUInt32(valueBytes.length));
            stream.write(valueBytes);
        }
    }

    public int read(Msg msg, int offset, ParseListener listener) {
        return this.read(msg.buf(), offset, listener);
    }

    public int read(ByteBuffer msg, int offset, ParseListener listener) {
        int nameLength;
        int bytesLeft;
        int valueLength;
        ByteBuffer data = msg.duplicate();
        data.position(offset);
        int index = offset;
        for (bytesLeft = data.remaining(); bytesLeft > 1 && (nameLength = Byte.toUnsignedInt(data.get(index))) != 0; bytesLeft -= valueLength) {
            int rc;
            ++index;
            if (--bytesLeft < nameLength) break;
            String name = new String(this.bytes(data, index, nameLength), ZMQ.CHARSET);
            index += nameLength;
            if ((bytesLeft -= nameLength) < 4) break;
            valueLength = Wire.getUInt32(data, index);
            index += 4;
            if ((bytesLeft -= 4) < valueLength || valueLength < 0) break;
            byte[] value = this.bytes(data, index, valueLength);
            String valueAsString = new String(value, ZMQ.CHARSET);
            index += valueLength;
            if (listener != null && (rc = listener.parsed(name, value, valueAsString)) != 0) {
                return rc;
            }
            this.set(name, valueAsString);
        }
        if (bytesLeft > 0) {
            return 156384820;
        }
        return 0;
    }

    private byte[] bytes(ByteBuffer buf, int position, int length) {
        byte[] bytes = new byte[length];
        int current = buf.position();
        buf.position(position);
        buf.get(bytes, 0, length);
        buf.position(current);
        return bytes;
    }

    public static interface ParseListener {
        public int parsed(String var1, byte[] var2, String var3);
    }
}

