/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kotlin.jupyter.core.editor.find;

import com.intellij.find.findUsages.FindUsagesHandler;
import com.intellij.find.findUsages.FindUsagesHandlerFactory;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.kotlin.jupyter.core.editor.find.FindUsagesHandlerKt;
import com.intellij.kotlin.jupyter.core.editor.find.KotlinNotebookElementFindUsagesHandler;
import com.intellij.kotlin.jupyter.core.util.IsKotlinNotebookKt;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtReferenceExpression;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0005H\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/kotlin/jupyter/core/editor/find/NotebookFindUsagesHandlerFactory;", "Lcom/intellij/find/findUsages/FindUsagesHandlerFactory;", "<init>", "()V", "canFindUsages", "", "element", "Lcom/intellij/psi/PsiElement;", "createFindUsagesHandler", "Lcom/intellij/find/findUsages/FindUsagesHandler;", "forHighlightUsages", "intellij.kotlin.jupyter.core"})
public final class NotebookFindUsagesHandlerFactory
extends FindUsagesHandlerFactory {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean canFindUsages(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        FileEditor openEditor = FileEditorManager.getInstance((Project)element.getProject()).getSelectedEditor();
        PsiFile psiFile = element.getContainingFile();
        VirtualFile virtualFile = psiFile != null ? psiFile.getVirtualFile() : null;
        VirtualFileWindow virtualFileWindow = virtualFile instanceof VirtualFileWindow ? (VirtualFileWindow)virtualFile : null;
        if (virtualFileWindow == null) {
            if (FindUsagesHandlerKt.isCompiledCellClassDeclaration(element)) return true;
            FileEditor fileEditor = openEditor;
            if (!IsKotlinNotebookKt.isKotlinNotebook((VirtualFile)(fileEditor != null ? fileEditor.getFile() : null))) return false;
            if (!FindUsagesHandlerKt.isFromJVMDeclaration(element)) return false;
            return true;
        }
        VirtualFileWindow fileWindow = virtualFileWindow;
        VirtualFile virtualFile2 = fileWindow.getDelegate();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"getDelegate(...)");
        VirtualFile notebookFile = virtualFile2;
        if (!BackedNotebookVirtualFile.Companion.isBacked(notebookFile)) return false;
        if (!IsKotlinNotebookKt.isKotlinNotebook(notebookFile)) return false;
        boolean bl = true;
        boolean isProperNotebook = bl;
        if (!isProperNotebook) return false;
        if (PsiTreeUtil.getParentOfType((PsiElement)element, KtReferenceExpression.class) != null) return false;
        return true;
    }

    @NotNull
    public FindUsagesHandler createFindUsagesHandler(@NotNull PsiElement element, boolean forHighlightUsages) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return new KotlinNotebookElementFindUsagesHandler(element, FindUsagesHandlerKt.isCompiledCellClassDeclaration(element), FindUsagesHandlerKt.isFromJVMDeclaration(element));
    }
}

