/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.builtins;

import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.Name;
import org.jetbrains.annotations.NotNull;

public final class UnsignedType
extends Enum<UnsignedType> {
    @NotNull
    private final ClassId classId;
    @NotNull
    private final Name typeName;
    @NotNull
    private final ClassId arrayClassId;
    public static final /* enum */ UnsignedType UBYTE;
    public static final /* enum */ UnsignedType USHORT;
    public static final /* enum */ UnsignedType UINT;
    public static final /* enum */ UnsignedType ULONG;
    private static final /* synthetic */ UnsignedType[] $VALUES;
    private static final /* synthetic */ EnumEntries $ENTRIES;

    private UnsignedType(ClassId classId) {
        this.classId = classId;
        Name name = this.classId.getShortClassName();
        Intrinsics.checkNotNullExpressionValue(name, "classId.shortClassName");
        this.typeName = name;
        this.arrayClassId = new ClassId(this.classId.getPackageFqName(), Name.identifier(this.typeName.asString() + "Array"));
    }

    @NotNull
    public final ClassId getClassId() {
        return this.classId;
    }

    @NotNull
    public final Name getTypeName() {
        return this.typeName;
    }

    @NotNull
    public final ClassId getArrayClassId() {
        return this.arrayClassId;
    }

    public static UnsignedType[] values() {
        return (UnsignedType[])$VALUES.clone();
    }

    public static UnsignedType valueOf(String value2) {
        return Enum.valueOf(UnsignedType.class, value2);
    }

    static {
        ClassId classId = ClassId.fromString("kotlin/UByte");
        Intrinsics.checkNotNullExpressionValue(classId, "fromString(\"kotlin/UByte\")");
        UBYTE = new UnsignedType(classId);
        ClassId classId2 = ClassId.fromString("kotlin/UShort");
        Intrinsics.checkNotNullExpressionValue(classId2, "fromString(\"kotlin/UShort\")");
        USHORT = new UnsignedType(classId2);
        ClassId classId3 = ClassId.fromString("kotlin/UInt");
        Intrinsics.checkNotNullExpressionValue(classId3, "fromString(\"kotlin/UInt\")");
        UINT = new UnsignedType(classId3);
        ClassId classId4 = ClassId.fromString("kotlin/ULong");
        Intrinsics.checkNotNullExpressionValue(classId4, "fromString(\"kotlin/ULong\")");
        ULONG = new UnsignedType(classId4);
        $VALUES = unsignedTypeArray = new UnsignedType[]{UnsignedType.UBYTE, UnsignedType.USHORT, UnsignedType.UINT, UnsignedType.ULONG};
        $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
    }
}

