/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.authenticators.browser;

import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import java.util.Optional;
import org.keycloak.authentication.AuthenticationFlowContext;
import org.keycloak.authentication.AuthenticationFlowError;
import org.keycloak.authentication.Authenticator;
import org.keycloak.authentication.authenticators.util.AuthenticatorUtils;
import org.keycloak.common.util.ObjectUtil;
import org.keycloak.credential.CredentialInput;
import org.keycloak.credential.CredentialModel;
import org.keycloak.forms.login.LoginFormsProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.credential.RecoveryAuthnCodesCredentialModel;
import org.keycloak.models.utils.FormMessage;
import org.keycloak.models.utils.RecoveryAuthnCodesUtils;
import org.keycloak.sessions.AuthenticationSessionModel;
import org.keycloak.storage.ReadOnlyException;

public class RecoveryAuthnCodesFormAuthenticator
implements Authenticator {
    public static final String GENERATED_RECOVERY_AUTHN_CODES_NOTE = "RecoveryAuthnCodes.generatedRecoveryAuthnCodes";
    public static final String GENERATED_AT_NOTE = "RecoveryAuthnCodes.generatedAt";

    public RecoveryAuthnCodesFormAuthenticator(KeycloakSession keycloakSession) {
    }

    public void authenticate(AuthenticationFlowContext context) {
        context.challenge(this.createLoginForm(context, false, null, null));
    }

    public void action(AuthenticationFlowContext context) {
        context.getEvent().detail("credential_type", "recovery-authn-codes").user(context.getUser());
        if (this.isRecoveryAuthnCodeInputValid(context)) {
            context.success("recovery-authn-codes");
        }
    }

    private boolean isRecoveryAuthnCodeInputValid(AuthenticationFlowContext authnFlowContext) {
        boolean result = false;
        MultivaluedMap formParamsMap = authnFlowContext.getHttpRequest().getDecodedFormParameters();
        String recoveryAuthnCodeUserInput = (String)formParamsMap.getFirst((Object)"recoveryCodeInput");
        UserModel authenticatedUser = authnFlowContext.getUser();
        boolean disabledByBruteForce = this.isDisabledByBruteForce(authnFlowContext, authenticatedUser);
        if (ObjectUtil.isBlank((CharSequence)recoveryAuthnCodeUserInput) || "true".equals(authnFlowContext.getAuthenticationSession().getAuthNote("SESSION_INVALID"))) {
            if (!disabledByBruteForce) {
                authnFlowContext.getAuthenticationSession().removeAuthNote("SESSION_INVALID");
            } else {
                authnFlowContext.forceChallenge(this.createLoginForm(authnFlowContext, true, "recovery-codes-error-invalid", "recoveryCodeInput"));
                return result;
            }
        }
        if (!disabledByBruteForce) {
            boolean isValid = authenticatedUser.credentialManager().isValid(new CredentialInput[]{UserCredentialModel.buildFromBackupAuthnCode((String)recoveryAuthnCodeUserInput.replace("-", ""))});
            if (!isValid) {
                Response responseChallenge = this.createLoginForm(authnFlowContext, true, "recovery-codes-error-invalid", "recoveryCodeInput");
                authnFlowContext.failureChallenge(AuthenticationFlowError.INVALID_CREDENTIALS, responseChallenge);
            } else {
                result = true;
                Optional optUserCredentialFound = RecoveryAuthnCodesUtils.getCredential((UserModel)authenticatedUser);
                RecoveryAuthnCodesCredentialModel recoveryCodeCredentialModel = null;
                if (optUserCredentialFound.isPresent() && (recoveryCodeCredentialModel = RecoveryAuthnCodesCredentialModel.createFromCredentialModel((CredentialModel)((CredentialModel)optUserCredentialFound.get()))).allCodesUsed()) {
                    authenticatedUser.credentialManager().removeStoredCredentialById(recoveryCodeCredentialModel.getId());
                }
                if (recoveryCodeCredentialModel == null || recoveryCodeCredentialModel.allCodesUsed()) {
                    this.addRequiredAction(authnFlowContext);
                }
            }
        } else {
            authnFlowContext.getAuthenticationSession().setAuthNote("SESSION_INVALID", "true");
        }
        return result;
    }

    protected void addRequiredAction(AuthenticationFlowContext authnFlowContext) {
        try {
            authnFlowContext.getUser().addRequiredAction(UserModel.RequiredAction.CONFIGURE_RECOVERY_AUTHN_CODES);
        }
        catch (ReadOnlyException e) {
            authnFlowContext.getAuthenticationSession().addRequiredAction(UserModel.RequiredAction.CONFIGURE_RECOVERY_AUTHN_CODES);
        }
    }

    protected boolean isDisabledByBruteForce(AuthenticationFlowContext authnFlowContext, UserModel authenticatedUser) {
        String bruteForceError = this.getDisabledByBruteForceEventError(authnFlowContext, authenticatedUser);
        if (bruteForceError == null) {
            return false;
        }
        authnFlowContext.getEvent().user(authenticatedUser);
        authnFlowContext.getEvent().error(bruteForceError);
        Response challengeResponse = this.createLoginForm(authnFlowContext, false, "invalidUserMessage", "username");
        authnFlowContext.forceChallenge(challengeResponse);
        return true;
    }

    protected String getDisabledByBruteForceEventError(AuthenticationFlowContext authnFlowContext, UserModel authenticatedUser) {
        return AuthenticatorUtils.getDisabledByBruteForceEventError(authnFlowContext, authenticatedUser);
    }

    private Response createLoginForm(AuthenticationFlowContext authnFlowContext, boolean withInvalidUserCredentialsError, String errorToRaise, String fieldError) {
        LoginFormsProvider loginFormsProvider;
        if (withInvalidUserCredentialsError) {
            loginFormsProvider = authnFlowContext.form();
            authnFlowContext.getEvent().user(authnFlowContext.getUser());
            authnFlowContext.getEvent().error("invalid_user_credentials");
            loginFormsProvider.addError(new FormMessage(fieldError, errorToRaise));
        } else {
            loginFormsProvider = authnFlowContext.form().setExecution(authnFlowContext.getExecution().getId());
            if (errorToRaise != null) {
                if (fieldError != null) {
                    loginFormsProvider.addError(new FormMessage(fieldError, errorToRaise));
                } else {
                    loginFormsProvider.setError(errorToRaise, new Object[0]);
                }
            }
        }
        Response challengeResponse = loginFormsProvider.createLoginRecoveryAuthnCode();
        return challengeResponse;
    }

    public boolean requiresUser() {
        return true;
    }

    public boolean configuredFor(KeycloakSession session, RealmModel realm, UserModel user) {
        return user.credentialManager().isConfiguredFor("recovery-authn-codes");
    }

    public void setRequiredActions(KeycloakSession session, RealmModel realm, UserModel user) {
        AuthenticationSessionModel authenticationSession = session.getContext().getAuthenticationSession();
        if (!authenticationSession.getRequiredActions().contains(UserModel.RequiredAction.CONFIGURE_RECOVERY_AUTHN_CODES.name())) {
            authenticationSession.addRequiredAction(UserModel.RequiredAction.CONFIGURE_RECOVERY_AUTHN_CODES.name());
        }
    }

    public void close() {
    }
}

