/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.util;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Window;
import java.awt.geom.Rectangle2D;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;

public class ComponentDrawable {
    private static final Logger logger = Logger.getLogger(ComponentDrawable.class.getName());
    private boolean preserveAspectRatio;
    private Component component;
    private JFrame peerSupply;
    private JPanel contentPane;
    private PainterRunnable runnable;
    private PreferredSizeRunnable preferredSizeRunnable;
    private DefinedSizeRunnable sizeRunnable;
    private boolean paintSynchronized;
    private boolean allowOwnPeer;

    public ComponentDrawable() {
        this(new JFrame());
    }

    public ComponentDrawable(JFrame jFrame) {
        if (jFrame == null) {
            throw new NullPointerException();
        }
        this.peerSupply = jFrame;
        this.contentPane = new JPanel();
        this.contentPane.setLayout(null);
        jFrame.setContentPane(this.contentPane);
        this.runnable = new PainterRunnable();
        this.preferredSizeRunnable = new PreferredSizeRunnable();
        this.sizeRunnable = new DefinedSizeRunnable();
    }

    public boolean isAllowOwnPeer() {
        return this.allowOwnPeer;
    }

    public void setAllowOwnPeer(boolean bl) {
        this.allowOwnPeer = bl;
    }

    public boolean isPaintSynchronized() {
        return this.paintSynchronized;
    }

    public void setPaintSynchronized(boolean bl) {
        this.paintSynchronized = bl;
    }

    protected final void cleanUp() {
        if (this.component instanceof JComponent && !this.isOwnPeerConnected()) {
            JComponent jComponent = (JComponent)this.component;
            RepaintManager.currentManager(jComponent).removeInvalidComponent(jComponent);
            RepaintManager.currentManager(jComponent).markCompletelyClean(jComponent);
        }
        this.contentPane.removeAll();
        RepaintManager.currentManager(this.contentPane).removeInvalidComponent(this.contentPane);
        RepaintManager.currentManager(this.contentPane).markCompletelyClean(this.contentPane);
        this.peerSupply.dispose();
    }

    public Component getComponent() {
        return this.component;
    }

    public void setComponent(Component component) {
        this.component = component;
        this.prepareComponent(component);
    }

    public Dimension getPreferredSize() {
        if (this.component == null) {
            return new Dimension(0, 0);
        }
        if (SwingUtilities.isEventDispatchThread() || !this.paintSynchronized) {
            this.preferredSizeRunnable.run();
            return this.preferredSizeRunnable.getRetval();
        }
        try {
            SwingUtilities.invokeAndWait(this.preferredSizeRunnable);
            return this.preferredSizeRunnable.getRetval();
        }
        catch (Exception exception) {
            logger.warning("Failed to compute the preferred size.");
            return new Dimension(0, 0);
        }
    }

    public Dimension getSize() {
        if (this.component == null) {
            return new Dimension(0, 0);
        }
        if (SwingUtilities.isEventDispatchThread() || !this.paintSynchronized) {
            this.sizeRunnable.run();
            return this.sizeRunnable.getRetval();
        }
        try {
            SwingUtilities.invokeAndWait(this.sizeRunnable);
            return this.sizeRunnable.getRetval();
        }
        catch (Exception exception) {
            logger.warning("Failed to compute the defined size.");
            return new Dimension(0, 0);
        }
    }

    protected final boolean isOwnPeerConnected() {
        if (!this.allowOwnPeer) {
            return false;
        }
        Window window = ComponentDrawable.getWindowAncestor(this.component);
        return window != null && window != this.peerSupply;
    }

    protected static Window getWindowAncestor(Component component) {
        for (Container container = component.getParent(); container != null; container = container.getParent()) {
            if (!(container instanceof Window)) continue;
            return (Window)container;
        }
        return null;
    }

    public void setPreserveAspectRatio(boolean bl) {
        this.preserveAspectRatio = bl;
    }

    public boolean isPreserveAspectRatio() {
        return this.preserveAspectRatio;
    }

    public void draw(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        if (this.component == null) {
            return;
        }
        this.runnable.setArea(rectangle2D);
        this.runnable.setGraphics(graphics2D);
        if (SwingUtilities.isEventDispatchThread() || !this.paintSynchronized) {
            this.runnable.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(this.runnable);
            }
            catch (Exception exception) {
                logger.warning("Failed to redraw the component.");
            }
        }
    }

    private void prepareComponent(Component component) {
        if (component instanceof JComponent) {
            JComponent jComponent = (JComponent)component;
            jComponent.setDoubleBuffered(false);
            Component[] componentArray = jComponent.getComponents();
            for (int i = 0; i < componentArray.length; ++i) {
                Component component2 = componentArray[i];
                this.prepareComponent(component2);
            }
        }
    }

    private class PainterRunnable
    implements Runnable {
        private Rectangle2D area;
        private Graphics2D graphics;

        protected PainterRunnable() {
        }

        public Graphics2D getGraphics() {
            return this.graphics;
        }

        public void setGraphics(Graphics2D graphics2D) {
            this.graphics = graphics2D;
        }

        public Rectangle2D getArea() {
            return this.area;
        }

        public void setArea(Rectangle2D rectangle2D) {
            this.area = rectangle2D;
        }

        @Override
        public void run() {
            try {
                Component component = ComponentDrawable.this.getComponent();
                if (component instanceof Window) {
                    Window window = (Window)component;
                    window.validate();
                } else if (ComponentDrawable.this.isOwnPeerConnected()) {
                    Window window = ComponentDrawable.getWindowAncestor(component);
                    if (window != null) {
                        window.validate();
                    }
                } else {
                    ComponentDrawable.this.peerSupply.pack();
                    ComponentDrawable.this.contentPane.add(component);
                }
                component.setBounds((int)this.area.getX(), (int)this.area.getY(), (int)this.area.getWidth(), (int)this.area.getHeight());
                component.validate();
                component.paint(this.graphics);
            }
            finally {
                ComponentDrawable.this.cleanUp();
            }
        }
    }

    private class PreferredSizeRunnable
    implements Runnable {
        private Dimension retval;

        protected PreferredSizeRunnable() {
        }

        public Dimension getRetval() {
            return this.retval;
        }

        @Override
        public void run() {
            this.retval = null;
            try {
                Component component = ComponentDrawable.this.getComponent();
                if (!(component instanceof Window) && !ComponentDrawable.this.isOwnPeerConnected()) {
                    ComponentDrawable.this.peerSupply.pack();
                    ComponentDrawable.this.contentPane.add(component);
                    ComponentDrawable.this.contentPane.validate();
                    component.validate();
                } else {
                    if (ComponentDrawable.this.isOwnPeerConnected()) {
                        this.retval = component.getSize();
                        return;
                    }
                    component.validate();
                }
                this.retval = component.getPreferredSize();
            }
            finally {
                ComponentDrawable.this.cleanUp();
            }
        }
    }

    private class DefinedSizeRunnable
    implements Runnable {
        private Dimension retval;

        protected DefinedSizeRunnable() {
        }

        public Dimension getRetval() {
            return this.retval;
        }

        @Override
        public void run() {
            this.retval = null;
            try {
                Component component = ComponentDrawable.this.getComponent();
                if (!(component instanceof Window) && !ComponentDrawable.this.isOwnPeerConnected()) {
                    ComponentDrawable.this.peerSupply.pack();
                    ComponentDrawable.this.contentPane.add(component);
                }
                this.retval = component.getSize();
            }
            finally {
                ComponentDrawable.this.cleanUp();
            }
        }
    }
}

