/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.renderer.process;

import org.jfree.layouting.renderer.border.Border;
import org.jfree.layouting.renderer.border.RenderLength;
import org.jfree.layouting.renderer.model.BlockRenderBox;
import org.jfree.layouting.renderer.model.BoxDefinition;
import org.jfree.layouting.renderer.model.EmptyBoxDefinition;
import org.jfree.layouting.renderer.model.RenderBox;
import org.jfree.layouting.renderer.model.RenderNode;
import org.jfree.layouting.renderer.model.page.LogicalPageBox;
import org.jfree.layouting.renderer.model.table.TableCellRenderBox;
import org.jfree.layouting.renderer.model.table.TableColumnGroupNode;
import org.jfree.layouting.renderer.model.table.TableColumnNode;
import org.jfree.layouting.renderer.model.table.TableRenderBox;
import org.jfree.layouting.renderer.model.table.TableRowInfoStructure;
import org.jfree.layouting.renderer.model.table.TableRowRenderBox;
import org.jfree.layouting.renderer.model.table.TableSectionRenderBox;
import org.jfree.layouting.renderer.model.table.cells.ConflictingCell;
import org.jfree.layouting.renderer.model.table.cells.DataCell;
import org.jfree.layouting.renderer.model.table.cells.PlaceHolderCell;
import org.jfree.layouting.renderer.model.table.cells.TableCell;
import org.jfree.layouting.renderer.model.table.cols.TableColumn;
import org.jfree.layouting.renderer.model.table.cols.TableColumnGroup;
import org.jfree.layouting.renderer.model.table.cols.TableColumnModel;
import org.jfree.layouting.renderer.model.table.rows.TableRow;
import org.jfree.layouting.renderer.model.table.rows.TableRowModel;
import org.jfree.layouting.renderer.process.IterateStructuralProcessStep;
import org.pentaho.reporting.libraries.base.util.FastStack;

public class TableValidationStep
extends IterateStructuralProcessStep {
    private FastStack tableStack = new FastStack();
    private TableInfoStructure currentTable;

    public void validate(LogicalPageBox logicalPageBox) {
        this.tableStack.clear();
        this.currentTable = null;
        this.startProcessing(logicalPageBox);
        if (!this.tableStack.isEmpty()) {
            throw new IllegalStateException();
        }
    }

    @Override
    protected boolean startBlockBox(BlockRenderBox blockRenderBox) {
        if (!(blockRenderBox instanceof TableRenderBox)) {
            return true;
        }
        TableRenderBox tableRenderBox = (TableRenderBox)blockRenderBox;
        this.currentTable = new TableInfoStructure(tableRenderBox);
        this.tableStack.push((Object)this.currentTable);
        if (!tableRenderBox.isOpen()) {
            if (!tableRenderBox.isStructureValidated()) {
                this.validateTable();
                return true;
            }
            return false;
        }
        this.validateTable();
        return true;
    }

    @Override
    protected void finishBlockBox(BlockRenderBox blockRenderBox) {
        if (blockRenderBox instanceof TableRenderBox) {
            this.currentTable = (TableInfoStructure)this.tableStack.pop();
        }
    }

    private void validateTable() {
        this.validatePredefinedColumns();
        this.validateRowStructure();
        TableRenderBox tableRenderBox = this.currentTable.getTable();
        if (!tableRenderBox.isOpen()) {
            tableRenderBox.setStructureValidated(true);
        }
    }

    private void validateFinalRows(TableSectionRenderBox tableSectionRenderBox) {
        RenderBox renderBox = null;
        for (RenderNode renderNode = tableSectionRenderBox.getLastChild(); renderNode != null; renderNode = renderNode.getVisiblePrev()) {
            if (!(renderNode instanceof TableRowRenderBox)) continue;
            renderBox = (TableRowRenderBox)renderNode;
            break;
        }
        TableRowModel tableRowModel = tableSectionRenderBox.getRowModel();
        while (renderBox != null) {
            RenderBox renderBox2 = null;
            TableRowInfoStructure tableRowInfoStructure = null;
            TableRowInfoStructure tableRowInfoStructure2 = renderBox.getRowInfoStructure();
            for (int i = 0; i < tableRowInfoStructure2.getCellCount(); ++i) {
                Object object;
                Object object2;
                TableCell tableCell = tableRowInfoStructure2.getCellAt(i);
                if (tableCell.getRowSpan() > 1) {
                    if (renderBox2 == null) {
                        renderBox2 = new TableRowRenderBox(EmptyBoxDefinition.getInstance(), true);
                        tableRowModel.addRow(new TableRow());
                        tableRowInfoStructure = ((TableRowRenderBox)renderBox2).getRowInfoStructure();
                        for (int j = 0; j < i; ++j) {
                            object2 = new TableCellRenderBox(EmptyBoxDefinition.getInstance(), true);
                            ((RenderBox)object2).close();
                            ((TableCellRenderBox)object2).setColumnIndex(j);
                            DataCell dataCell = new DataCell(1, 1, ((RenderNode)object2).getInstanceId());
                            tableRowInfoStructure.addCell(dataCell);
                            renderBox2.addChild((RenderNode)object2);
                        }
                    }
                    if (tableCell instanceof DataCell) {
                        object = new PlaceHolderCell((DataCell)tableCell, tableCell.getRowSpan() - 1, tableCell.getColSpan());
                    } else if (tableCell instanceof PlaceHolderCell) {
                        object2 = (PlaceHolderCell)tableCell;
                        object = new PlaceHolderCell(((PlaceHolderCell)object2).getSourceCell(), tableCell.getRowSpan() - 1, tableCell.getColSpan());
                    } else {
                        throw new IllegalStateException("Unexpected cell type.");
                    }
                    tableRowInfoStructure.addCell((TableCell)object);
                    continue;
                }
                if (renderBox2 == null) continue;
                object = new TableCellRenderBox(EmptyBoxDefinition.getInstance(), true);
                ((RenderBox)object).close();
                ((TableCellRenderBox)object).setColumnIndex(i);
                object2 = new DataCell(1, 1, ((RenderNode)object).getInstanceId());
                tableRowInfoStructure.addCell((TableCell)object2);
                renderBox2.addChild((RenderNode)object);
            }
            if (renderBox2 != null) {
                renderBox2.close();
                tableRowInfoStructure.setValidationDone(true);
                tableSectionRenderBox.addGeneratedChild(renderBox2);
            }
            renderBox = renderBox2;
        }
    }

    private void validateRowStructure() {
        TableRenderBox tableRenderBox = this.currentTable.getTable();
        if (!tableRenderBox.isPredefinedColumnsValidated()) {
            return;
        }
        TableColumnModel tableColumnModel = this.currentTable.getColumnModel();
        RenderNode renderNode = tableRenderBox.getFirstChild();
        while (renderNode != null) {
            if (!(renderNode instanceof TableSectionRenderBox)) {
                renderNode = renderNode.getNext();
                continue;
            }
            TableSectionRenderBox tableSectionRenderBox = (TableSectionRenderBox)renderNode;
            if (!tableSectionRenderBox.isStructureValidated()) {
                TableRowInfoStructure tableRowInfoStructure = new TableRowInfoStructure();
                RenderNode renderNode2 = tableSectionRenderBox.getFirstChild();
                while (renderNode2 != null) {
                    if (renderNode2.isOpen()) {
                        throw new IllegalStateException("An open row cannot be part of a layoutable model.");
                    }
                    if (!(renderNode2 instanceof TableRowRenderBox)) {
                        renderNode2 = renderNode2.getNext();
                        continue;
                    }
                    TableRowInfoStructure tableRowInfoStructure2 = this.validateRow(tableSectionRenderBox, renderNode2, tableRowInfoStructure);
                    int n = tableRowInfoStructure2.getCellCount();
                    if (this.currentTable.getColumns() < n) {
                        this.currentTable.setColumns(n);
                    }
                    while (n > tableColumnModel.getColumnCount()) {
                        tableColumnModel.addAutoColumn();
                    }
                    renderNode2 = renderNode2.getNext();
                    tableRowInfoStructure = tableRowInfoStructure2;
                }
                if (!tableSectionRenderBox.isOpen()) {
                    this.validateFinalRows(tableSectionRenderBox);
                    tableSectionRenderBox.setStructureValidated(true);
                }
            }
            renderNode = renderNode.getNext();
        }
    }

    private TableRowInfoStructure validateRow(TableSectionRenderBox tableSectionRenderBox, RenderNode renderNode, TableRowInfoStructure tableRowInfoStructure) {
        Object object;
        TableRowRenderBox tableRowRenderBox = (TableRowRenderBox)renderNode;
        TableRowInfoStructure tableRowInfoStructure2 = tableRowRenderBox.getRowInfoStructure();
        if (tableRowInfoStructure2.isValidationDone()) {
            return tableRowInfoStructure2;
        }
        RenderNode renderNode2 = tableRowRenderBox.getFirstChild();
        int n = 0;
        while (renderNode2 != null) {
            if (!(renderNode2 instanceof TableCellRenderBox)) {
                renderNode2 = renderNode2.getNext();
                continue;
            }
            object = (TableCellRenderBox)renderNode2;
            if (n >= tableRowInfoStructure.getCellCount()) {
                ((TableCellRenderBox)object).setColumnIndex(n);
                n = this.validateSafeCellPos((TableCellRenderBox)object, tableRowInfoStructure2, n);
            } else {
                n = this.findCellPosition(n, tableRowInfoStructure, tableRowInfoStructure2);
                int n2 = ((TableCellRenderBox)object).getColSpan();
                int n3 = ((TableCellRenderBox)object).getRowSpan();
                DataCell dataCell = new DataCell(n3, n2, ((RenderNode)object).getInstanceId());
                tableRowInfoStructure2.addCell(dataCell);
                ((TableCellRenderBox)object).setColumnIndex(n);
                ++n;
                for (int i = 1; i < n2; ++i) {
                    TableCell tableCell;
                    if (n < tableRowInfoStructure.getCellCount()) {
                        PlaceHolderCell placeHolderCell;
                        tableCell = tableRowInfoStructure.getCellAt(n);
                        if (tableCell.getRowSpan() > 1) {
                            PlaceHolderCell placeHolderCell2;
                            placeHolderCell = new ConflictingCell(dataCell, n3, n2 - i);
                            if (tableCell instanceof ConflictingCell) {
                                placeHolderCell2 = (ConflictingCell)tableCell;
                                int n4 = ((ConflictingCell)placeHolderCell2).getConflictingCellCount();
                                for (int j = 0; j < n4; ++j) {
                                    PlaceHolderCell placeHolderCell3 = ((ConflictingCell)placeHolderCell2).getConflictingCell(j);
                                    if (placeHolderCell3.getRowSpan() <= 1) continue;
                                    PlaceHolderCell placeHolderCell4 = new PlaceHolderCell(placeHolderCell3.getSourceCell(), placeHolderCell3.getRowSpan() - 1, placeHolderCell3.getColSpan());
                                    ((ConflictingCell)placeHolderCell).addConflictingCell(placeHolderCell4);
                                }
                            } else if (tableCell instanceof PlaceHolderCell) {
                                placeHolderCell2 = (PlaceHolderCell)tableCell;
                                PlaceHolderCell placeHolderCell5 = new PlaceHolderCell(placeHolderCell2.getSourceCell(), tableCell.getRowSpan() - 1, tableCell.getColSpan());
                                ((ConflictingCell)placeHolderCell).addConflictingCell(placeHolderCell5);
                            } else if (tableCell instanceof DataCell) {
                                placeHolderCell2 = new PlaceHolderCell((DataCell)tableCell, tableCell.getRowSpan() - 1, tableCell.getColSpan());
                                ((ConflictingCell)placeHolderCell).addConflictingCell(placeHolderCell2);
                            } else {
                                throw new IllegalStateException("Unexpected cell type.");
                            }
                            tableRowInfoStructure2.addCell(placeHolderCell);
                        } else {
                            placeHolderCell = new PlaceHolderCell(dataCell, n3, n2 - i);
                            tableRowInfoStructure2.addCell(placeHolderCell);
                        }
                    } else {
                        tableCell = new PlaceHolderCell(dataCell, n3, n2 - i);
                        tableRowInfoStructure2.addCell(tableCell);
                    }
                    ++n;
                }
            }
            renderNode2 = renderNode2.getNext();
        }
        object = new TableRow(tableRowRenderBox.getBorder());
        tableSectionRenderBox.getRowModel().addRow((TableRow)object);
        tableRowInfoStructure2.setValidationDone(true);
        return tableRowInfoStructure2;
    }

    private int findCellPosition(int n, TableRowInfoStructure tableRowInfoStructure, TableRowInfoStructure tableRowInfoStructure2) {
        TableCell tableCell;
        while (n < tableRowInfoStructure.getCellCount() && (tableCell = tableRowInfoStructure.getCellAt(n)).getRowSpan() > 1) {
            DataCell dataCell;
            if (tableCell instanceof DataCell) {
                dataCell = (DataCell)tableCell;
            } else if (tableCell instanceof PlaceHolderCell) {
                PlaceHolderCell placeHolderCell = (PlaceHolderCell)tableCell;
                dataCell = placeHolderCell.getSourceCell();
            } else {
                throw new IllegalStateException("Unexpected cell type.");
            }
            int n2 = tableCell.getColSpan();
            int n3 = tableCell.getRowSpan() - 1;
            for (int i = 0; i < n2; ++i) {
                PlaceHolderCell placeHolderCell = new PlaceHolderCell(dataCell, n3, n2 - i);
                tableRowInfoStructure2.addCell(placeHolderCell);
            }
            n += tableCell.getColSpan();
        }
        return n;
    }

    private int validateSafeCellPos(TableCellRenderBox tableCellRenderBox, TableRowInfoStructure tableRowInfoStructure, int n) {
        int n2 = tableCellRenderBox.getColSpan();
        int n3 = tableCellRenderBox.getRowSpan();
        DataCell dataCell = new DataCell(n3, n2, tableCellRenderBox.getInstanceId());
        tableRowInfoStructure.addCell(dataCell);
        ++n;
        for (int i = 1; i < n2; ++i) {
            PlaceHolderCell placeHolderCell = new PlaceHolderCell(dataCell, n3, n2 - i);
            tableRowInfoStructure.addCell(placeHolderCell);
            ++n;
        }
        return n;
    }

    private void validatePredefinedColumns() {
        TableRenderBox tableRenderBox = this.currentTable.getTable();
        if (tableRenderBox.isPredefinedColumnsValidated()) {
            return;
        }
        TableColumnModel tableColumnModel = tableRenderBox.getColumnModel();
        int n = 0;
        for (RenderNode renderNode = tableRenderBox.getFirstChild(); renderNode != null; renderNode = renderNode.getNext()) {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            RenderNode renderNode2;
            if (renderNode instanceof TableColumnNode) {
                renderNode2 = (TableColumnNode)renderNode;
                if (n < tableColumnModel.getColumnCount()) continue;
                BoxDefinition boxDefinition = ((TableColumnNode)renderNode2).getBoxDefinition();
                object4 = boxDefinition.getBorder();
                object3 = boxDefinition.getPreferredWidth();
                object2 = new TableColumn((Border)object4, (RenderLength)object3, false);
                object = new TableColumnGroup();
                ((TableColumnGroup)object).addColumn((TableColumn)object2);
                tableColumnModel.addColumnGroup((TableColumnGroup)object);
                ++n;
                continue;
            }
            if (renderNode instanceof TableColumnGroupNode) {
                boolean bl;
                renderNode2 = (TableColumnGroupNode)renderNode;
                if (n >= tableColumnModel.getColumnCount()) {
                    object4 = new TableColumnGroup(((RenderBox)renderNode2).getBorder());
                    bl = true;
                } else {
                    object4 = tableColumnModel.getGroupForIndex(n);
                    bl = false;
                }
                for (object3 = ((RenderBox)renderNode2).getFirstChild(); object3 != null; object3 = ((RenderNode)object3).getNext()) {
                    if (!(object3 instanceof TableColumnNode)) continue;
                    object2 = (TableColumnNode)object3;
                    if (n >= tableColumnModel.getColumnCount()) {
                        object = ((TableColumnNode)object2).getBoxDefinition();
                        Border border = object.getBorder();
                        RenderLength renderLength = object.getPreferredWidth();
                        TableColumn tableColumn = new TableColumn(border, renderLength, false);
                        ((TableColumnGroup)object4).addColumn(tableColumn);
                        continue;
                    }
                    ++n;
                }
                if (!bl) continue;
                tableColumnModel.addColumnGroup((TableColumnGroup)object4);
                n += ((TableColumnGroup)object4).getColumnCount();
                continue;
            }
            if (!(renderNode instanceof TableSectionRenderBox)) continue;
            tableRenderBox.setPredefinedColumnsValidated(true);
        }
    }

    public static class TableInfoStructure {
        private TableRenderBox table;
        private TableColumnModel columnModel;
        private int columns;

        public TableInfoStructure(TableRenderBox tableRenderBox) {
            this.table = tableRenderBox;
            this.columnModel = tableRenderBox.getColumnModel();
            this.columns = this.columnModel.getColumnCount();
        }

        public TableRenderBox getTable() {
            return this.table;
        }

        public TableColumnModel getColumnModel() {
            return this.columnModel;
        }

        public int getColumns() {
            return this.columns;
        }

        public void setColumns(int n) {
            this.columns = n;
        }
    }
}

