/*
 * Decompiled with CFR 0.152.
 */
package liquibase.changelog.filter;

import java.util.List;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.RanChangeSet;
import liquibase.changelog.filter.ChangeSetFilter;

public abstract class RanChangeSetFilter
implements ChangeSetFilter {
    public List<RanChangeSet> ranChangeSets;
    private final boolean ignoreClasspathPrefix;

    public RanChangeSetFilter(List<RanChangeSet> ranChangeSets, boolean ignoreClasspathPrefix) {
        this.ignoreClasspathPrefix = ignoreClasspathPrefix;
        this.ranChangeSets = ranChangeSets;
    }

    public RanChangeSet getRanChangeSet(ChangeSet changeSet) {
        for (RanChangeSet ranChangeSet : this.ranChangeSets) {
            if (!ranChangeSet.getId().equalsIgnoreCase(changeSet.getId()) || !ranChangeSet.getAuthor().equalsIgnoreCase(changeSet.getAuthor()) || !this.normalizePath(ranChangeSet.getChangeLog()).equalsIgnoreCase(this.normalizePath(changeSet.getFilePath()))) continue;
            return ranChangeSet;
        }
        return null;
    }

    protected String normalizePath(String filePath) {
        if (this.ignoreClasspathPrefix) {
            return filePath.replaceFirst("^classpath:", "");
        }
        return filePath;
    }
}

