/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkBufferCopy2
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int SRCOFFSET;
    public static final int DSTOFFSET;
    public static final int SIZE;

    public VkBufferCopy2(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkBufferCopy2.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkBufferCopy2.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkBufferCopy2.npNext(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long srcOffset() {
        return VkBufferCopy2.nsrcOffset(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long dstOffset() {
        return VkBufferCopy2.ndstOffset(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long size() {
        return VkBufferCopy2.nsize(this.address());
    }

    public VkBufferCopy2 sType(@NativeType(value="VkStructureType") int value) {
        VkBufferCopy2.nsType(this.address(), value);
        return this;
    }

    public VkBufferCopy2 sType$Default() {
        return this.sType(1000337006);
    }

    public VkBufferCopy2 pNext(@NativeType(value="void const *") long value) {
        VkBufferCopy2.npNext(this.address(), value);
        return this;
    }

    public VkBufferCopy2 srcOffset(@NativeType(value="VkDeviceSize") long value) {
        VkBufferCopy2.nsrcOffset(this.address(), value);
        return this;
    }

    public VkBufferCopy2 dstOffset(@NativeType(value="VkDeviceSize") long value) {
        VkBufferCopy2.ndstOffset(this.address(), value);
        return this;
    }

    public VkBufferCopy2 size(@NativeType(value="VkDeviceSize") long value) {
        VkBufferCopy2.nsize(this.address(), value);
        return this;
    }

    public VkBufferCopy2 set(int sType, long pNext, long srcOffset, long dstOffset, long size) {
        this.sType(sType);
        this.pNext(pNext);
        this.srcOffset(srcOffset);
        this.dstOffset(dstOffset);
        this.size(size);
        return this;
    }

    public VkBufferCopy2 set(VkBufferCopy2 src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkBufferCopy2 malloc() {
        return (VkBufferCopy2)VkBufferCopy2.wrap(VkBufferCopy2.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VkBufferCopy2 calloc() {
        return (VkBufferCopy2)VkBufferCopy2.wrap(VkBufferCopy2.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VkBufferCopy2 create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VkBufferCopy2)VkBufferCopy2.wrap(VkBufferCopy2.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VkBufferCopy2 create(long address) {
        return (VkBufferCopy2)VkBufferCopy2.wrap(VkBufferCopy2.class, (long)address);
    }

    @Nullable
    public static VkBufferCopy2 createSafe(long address) {
        return address == 0L ? null : (VkBufferCopy2)VkBufferCopy2.wrap(VkBufferCopy2.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VkBufferCopy2.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VkBufferCopy2.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VkBufferCopy2.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkBufferCopy2.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VkBufferCopy2.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VkBufferCopy2.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VkBufferCopy2.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static VkBufferCopy2 malloc(MemoryStack stack) {
        return (VkBufferCopy2)VkBufferCopy2.wrap(VkBufferCopy2.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkBufferCopy2 calloc(MemoryStack stack) {
        return (VkBufferCopy2)VkBufferCopy2.wrap(VkBufferCopy2.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)VkBufferCopy2.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)VkBufferCopy2.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static long nsrcOffset(long struct) {
        return UNSAFE.getLong(null, struct + (long)SRCOFFSET);
    }

    public static long ndstOffset(long struct) {
        return UNSAFE.getLong(null, struct + (long)DSTOFFSET);
    }

    public static long nsize(long struct) {
        return UNSAFE.getLong(null, struct + (long)SIZE);
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    public static void nsrcOffset(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)SRCOFFSET, value);
    }

    public static void ndstOffset(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)DSTOFFSET, value);
    }

    public static void nsize(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)SIZE, value);
    }

    static {
        Struct.Layout layout = VkBufferCopy2.__struct((Struct.Member[])new Struct.Member[]{VkBufferCopy2.__member((int)4), VkBufferCopy2.__member((int)POINTER_SIZE), VkBufferCopy2.__member((int)8), VkBufferCopy2.__member((int)8), VkBufferCopy2.__member((int)8)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        SRCOFFSET = layout.offsetof(2);
        DSTOFFSET = layout.offsetof(3);
        SIZE = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<VkBufferCopy2, Buffer>
    implements NativeResource {
        private static final VkBufferCopy2 ELEMENT_FACTORY = VkBufferCopy2.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkBufferCopy2 getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkBufferCopy2.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkBufferCopy2.npNext(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long srcOffset() {
            return VkBufferCopy2.nsrcOffset(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long dstOffset() {
            return VkBufferCopy2.ndstOffset(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long size() {
            return VkBufferCopy2.nsize(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkBufferCopy2.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000337006);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkBufferCopy2.npNext(this.address(), value);
            return this;
        }

        public Buffer srcOffset(@NativeType(value="VkDeviceSize") long value) {
            VkBufferCopy2.nsrcOffset(this.address(), value);
            return this;
        }

        public Buffer dstOffset(@NativeType(value="VkDeviceSize") long value) {
            VkBufferCopy2.ndstOffset(this.address(), value);
            return this;
        }

        public Buffer size(@NativeType(value="VkDeviceSize") long value) {
            VkBufferCopy2.nsize(this.address(), value);
            return this;
        }
    }
}

