/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util;

import org.springframework.util.ObjectUtils;

public abstract class PatternMatchUtils {
    public static boolean simpleMatch(String pattern, String str) {
        if (ObjectUtils.nullSafeEquals(pattern, str) || "*".equals(pattern)) {
            return true;
        }
        if (pattern == null || str == null) {
            return false;
        }
        if (pattern.startsWith("*") && pattern.endsWith("*") && str.indexOf(pattern.substring(1, pattern.length() - 1)) != -1) {
            return true;
        }
        if (pattern.startsWith("*") && str.endsWith(pattern.substring(1, pattern.length()))) {
            return true;
        }
        return pattern.endsWith("*") && str.startsWith(pattern.substring(0, pattern.length() - 1));
    }

    public static boolean simpleMatch(String[] patterns, String str) {
        if (patterns != null) {
            for (int i = 0; i < patterns.length; ++i) {
                if (!PatternMatchUtils.simpleMatch(patterns[i], str)) continue;
                return true;
            }
        }
        return false;
    }
}

