/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui;

import ca.sqlpower.architect.swingui.ASUtils;
import ca.sqlpower.architect.swingui.ArchitectSwingSession;
import ca.sqlpower.architect.swingui.FormLayout;
import ca.sqlpower.architect.swingui.Messages;
import ca.sqlpower.architect.swingui.PlayPen;
import ca.sqlpower.architect.swingui.PrintSettings;
import ca.sqlpower.swingui.DataEntryPanel;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.Iterator;
import javax.print.PrintService;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MouseInputAdapter;
import org.apache.log4j.Logger;

public class PrintPanel
extends JPanel
implements DataEntryPanel,
Pageable,
Printable,
ChangeListener {
    private static final Logger logger = Logger.getLogger(PrintPanel.class);
    private PlayPen pp;
    private JComboBox printerBox;
    private PrinterJob job;
    private PrintRequestAttributeSet jobAttributes;
    private PageFormat pageFormat;
    private JLabel pageFormatLabel;
    private JButton pageFormatButton;
    private final JLabel zoomLabel;
    private final JSlider zoomSlider;
    private JLabel pageCountLabel;
    private final JCheckBox printPageNumbersBox;
    private final JSpinner numOfCopies;
    private PrintPreviewPanel previewPanel;
    private int pagesAcross;
    private int pagesDown;
    private double zoom;
    private final ArchitectSwingSession session;

    public PrintPanel(ArchitectSwingSession session) {
        this.setOpaque(true);
        this.setLayout(new BoxLayout(this, 0));
        this.session = session;
        this.pp = new PlayPen(session, session.getPlayPen());
        this.pp.destroy();
        this.previewPanel = new PrintPreviewPanel();
        this.add(this.previewPanel);
        this.job = PrinterJob.getPrinterJob();
        this.jobAttributes = new HashPrintRequestAttributeSet();
        this.pageFormat = new PageFormat();
        Paper paper = new Paper();
        PrintSettings printSettings = session.getPrintSettings();
        paper.setSize(printSettings.getPaperWidth(), printSettings.getPaperHeight());
        paper.setImageableArea(printSettings.getLeftBorder(), printSettings.getRightBorder(), paper.getWidth() - printSettings.getLeftBorder() - printSettings.getRightBorder(), paper.getHeight() - printSettings.getTopBorder() - printSettings.getBottomBorder());
        this.pageFormat.setPaper(paper);
        this.pageFormat.setOrientation(printSettings.getOrientation());
        logger.debug((Object)("Page format has paper size " + this.pageFormat.getPaper().getWidth() + "x" + this.pageFormat.getPaper().getHeight()));
        logger.debug((Object)("Page size saved as " + printSettings.getPaperWidth() + "x" + printSettings.getPaperHeight()));
        JPanel formPanel = new JPanel(new FormLayout());
        formPanel.add(new JLabel(Messages.getString("PrintPanel.printerLabel")));
        this.printerBox = new JComboBox<PrintService>(PrinterJob.lookupPrintServices());
        formPanel.add(this.printerBox);
        this.printerBox.setSelectedItem(this.getPreferredPrinter(session));
        formPanel.add(new JLabel(Messages.getString("PrintPanel.pageFormateLabel")));
        String pf = PrintPanel.paperToPrintable(this.pageFormat);
        this.pageFormatLabel = new JLabel(pf.toString());
        formPanel.add(this.pageFormatLabel);
        formPanel.add(new JLabel(Messages.getString("PrintPanel.numCopiesLabel")));
        this.numOfCopies = new JSpinner(new SpinnerNumberModel((Number)printSettings.getNumCopies(), Integer.valueOf(1), null, (Number)1));
        formPanel.add(this.numOfCopies);
        formPanel.add(new JLabel(Messages.getString("PrintPanel.changePageFormatLabel")));
        this.pageFormatButton = new JButton(Messages.getString("PrintPanel.changePageFormatLabel"));
        formPanel.add(this.pageFormatButton);
        this.pageFormatButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PrintPanel.this.setPageFormat(PrintPanel.this.job.pageDialog(PrintPanel.this.pageFormat));
            }
        });
        this.zoomLabel = new JLabel(Messages.getString("PrintPanel.scalingLabel"));
        this.setZoom(printSettings.getZoom());
        formPanel.add(this.zoomLabel);
        this.zoomSlider = new JSlider(0, 1, 300, (int)(this.zoom * 100.0));
        formPanel.add(this.zoomSlider);
        formPanel.add(new JLabel(""));
        this.printPageNumbersBox = new JCheckBox(Messages.getString("PrintPanel.printPageNumbersOption"));
        formPanel.add(this.printPageNumbersBox);
        this.printPageNumbersBox.setSelected(printSettings.isPageNumbersPrinted());
        this.zoomSlider.addChangeListener(this);
        this.pageCountLabel = new JLabel(Messages.getString("PrintPanel.pageCountLabel", String.valueOf(this.getNumberOfPages())));
        formPanel.add(this.pageCountLabel);
        this.add(formPanel);
    }

    public static String paperToPrintable(PageFormat pageFormat) {
        StringBuffer pf = new StringBuffer();
        Paper paper = pageFormat.getPaper();
        pf.append(String.format("%.1f", paper.getWidth() / 72.0));
        pf.append('x');
        pf.append(String.format("%.1f", paper.getHeight() / 72.0));
        pf.append('-');
        switch (pageFormat.getOrientation()) {
            case 1: {
                pf.append("(portrait)");
                break;
            }
            case 0: {
                pf.append("(landscape)");
                break;
            }
            case 2: {
                pf.append("(rev. landscape)");
                break;
            }
            default: {
                pf.append("(?)");
            }
        }
        return pf.toString();
    }

    PrintService getPreferredPrinter(ArchitectSwingSession session) {
        String lastUsedPrinter = session.getPrintSettings().getPrinterName();
        if (lastUsedPrinter != null) {
            for (PrintService ps : Arrays.asList(PrinterJob.lookupPrintServices())) {
                if (!ps.getName().equals(lastUsedPrinter)) continue;
                return ps;
            }
        }
        String defaultPrinterName = session.getUserSettings().getPrintUserSettings().getDefaultPrinterName();
        PrintService psRetVal = null;
        Iterator<PrintService> it = Arrays.asList(PrinterJob.lookupPrintServices()).iterator();
        while (it.hasNext() && psRetVal == null) {
            PrintService ps = it.next();
            if (!ps.getName().equals(defaultPrinterName)) continue;
            psRetVal = ps;
        }
        if (psRetVal == null) {
            psRetVal = PrinterJob.getPrinterJob().getPrintService();
        }
        return psRetVal;
    }

    public void setPageFormat(PageFormat pf) {
        PageFormat oldPF = this.pageFormat;
        if (pf != null) {
            this.pageFormat = pf;
            if (pf != oldPF) {
                this.validateLayout();
                this.pageFormatLabel.setText(PrintPanel.paperToPrintable(this.pageFormat));
                this.firePropertyChange("pageFormat", oldPF, this.pageFormat);
            }
        }
    }

    public void validateLayout() {
        this.pp.setZoom(1.0);
        Dimension ppSize = this.pp.getPreferredSize();
        double ppWidth = ppSize.width;
        double ppHeight = ppSize.height;
        double paperWidth = this.pageFormat.getImageableWidth();
        double paperHeight = this.pageFormat.getImageableHeight();
        logger.debug((Object)("Validating layout: zoom is " + this.zoom + ", play pen width " + ppWidth + ", paper width " + paperWidth));
        this.pagesAcross = (int)Math.ceil(this.zoom * ppWidth / paperWidth);
        this.pagesDown = (int)Math.ceil(this.zoom * ppHeight / paperHeight);
        logger.debug((Object)("Validating layout: pages across " + this.pagesAcross + ", pages down " + this.pagesDown));
        this.pageCountLabel.setText(Messages.getString("PrintPanel.pageCountLabel", String.valueOf(this.getNumberOfPages())));
    }

    public void setZoom(double newZoom) {
        double oldZoom = this.zoom;
        this.zoom = newZoom;
        this.zoomLabel.setText(Messages.getString("PrintPanel.zoomLabel", String.valueOf((int)(newZoom * 100.0))));
        this.firePropertyChange("zoom", oldZoom, this.zoom);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (e.getSource() == this.zoomSlider) {
            this.setZoom((double)this.zoomSlider.getValue() / 100.0);
        }
    }

    @Override
    public int getNumberOfPages() {
        return this.pagesAcross * this.pagesDown;
    }

    @Override
    public PageFormat getPageFormat(int pageIndex) throws IndexOutOfBoundsException {
        return this.pageFormat;
    }

    @Override
    public Printable getPrintable(int pageIndex) throws IndexOutOfBoundsException {
        return this;
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
        Graphics2D g2 = (Graphics2D)graphics;
        if (pageIndex < this.pagesAcross * this.pagesDown) {
            double leftMargin = pageFormat.getImageableX();
            double topMargin = pageFormat.getImageableY();
            double width = pageFormat.getImageableWidth();
            double height = pageFormat.getImageableHeight();
            int col = pageIndex % this.pagesAcross;
            int row = pageIndex / this.pagesAcross;
            logger.debug((Object)("Printing page " + (pageIndex + 1) + " of " + this.pagesAcross * this.pagesDown + " at [" + col + "," + row + "]"));
            AffineTransform backupXform = g2.getTransform();
            g2.translate(leftMargin - (double)col * width, topMargin - (double)row * height);
            g2.scale(this.zoom, this.zoom);
            this.pp.print(g2);
            g2.setTransform(backupXform);
            if (this.printPageNumbersBox.isSelected()) {
                g2.drawString(Messages.getString("PrintPanel.pageNumber", String.valueOf(pageIndex + 1), String.valueOf(this.pagesAcross * this.pagesDown)), (float)(leftMargin + 10.0), (float)(topMargin + 10.0));
            }
            return 0;
        }
        return 1;
    }

    public boolean applyChanges() {
        PrintSettings printSettings = this.session.getPrintSettings();
        printSettings.setZoom(this.zoom);
        printSettings.setNumCopies((Integer)this.numOfCopies.getValue());
        printSettings.setPageNumbersPrinted(this.printPageNumbersBox.isSelected());
        printSettings.setPrinterName(((PrintService)this.printerBox.getSelectedItem()).getName());
        printSettings.setOrientation(this.pageFormat.getOrientation());
        Paper paper = this.pageFormat.getPaper();
        printSettings.setPaperWidth(paper.getWidth());
        printSettings.setPaperHeight(paper.getHeight());
        printSettings.setLeftBorder(paper.getImageableX());
        printSettings.setRightBorder(paper.getWidth() - paper.getImageableWidth() - paper.getImageableX());
        printSettings.setTopBorder(paper.getImageableY());
        printSettings.setBottomBorder(paper.getHeight() - paper.getImageableHeight() - paper.getImageableY());
        try {
            if (this.printerBox.getItemCount() > 0 && this.printerBox.getSelectedItem() instanceof PrintService) {
                this.session.getUserSettings().getPrintUserSettings().setDefaultPrinterName(((PrintService)this.printerBox.getSelectedItem()).getName());
            }
            this.validateLayout();
            this.job.setPrintService((PrintService)this.printerBox.getSelectedItem());
            this.job.setPageable(this);
            this.job.setCopies((Integer)this.numOfCopies.getValue());
            this.job.print(this.jobAttributes);
        }
        catch (PrinterException ex) {
            logger.error((Object)"Printing failure", (Throwable)ex);
            ASUtils.showExceptionDialogNoReport(this, Messages.getString("PrintPanel.printFailed"), ex);
            return false;
        }
        return true;
    }

    public void discardChanges() {
    }

    public JPanel getPanel() {
        return this;
    }

    public boolean hasUnsavedChanges() {
        return true;
    }

    public class PrintPreviewPanel
    extends JPanel
    implements PropertyChangeListener {
        private Dimension playPenPreferredSize;
        private Graphics fontContextGraphic;

        public PrintPreviewPanel() {
            this.setDoubleBuffered(false);
            PrintPanel.this.addPropertyChangeListener(this);
            PreviewZoomAdjuster adjuster = new PreviewZoomAdjuster();
            this.addMouseMotionListener(adjuster);
            this.addMouseListener(adjuster);
            this.playPenPreferredSize = PrintPanel.this.pp.getPreferredSize();
            this.fontContextGraphic = PrintPanel.this.session.getPlayPen().getGraphics().create();
        }

        @Override
        public Dimension getPreferredSize() {
            PrintPanel.this.validateLayout();
            double iW = PrintPanel.this.pageFormat.getImageableWidth();
            double iH = PrintPanel.this.pageFormat.getImageableHeight();
            double printoutWidth = (double)PrintPanel.this.pagesAcross * iW;
            double printoutHeight = (double)PrintPanel.this.pagesDown * iH;
            double preferredScale = 500.0 / printoutWidth;
            return new Dimension((int)(printoutWidth * preferredScale), (int)(printoutHeight * preferredScale));
        }

        private double calculateZoom() {
            Dimension ppSize = this.playPenPreferredSize;
            double previewZoomX = (double)this.getWidth() / (double)ppSize.width;
            double previewZoomY = (double)this.getHeight() / (double)ppSize.height;
            return Math.min(previewZoomX, previewZoomY);
        }

        @Override
        public void paintComponent(Graphics g) {
            int i;
            PrintPanel.this.validateLayout();
            Graphics2D g2 = (Graphics2D)g;
            double zoom = this.calculateZoom();
            Graphics2D fcg = (Graphics2D)this.fontContextGraphic;
            AffineTransform backupContextTransform = fcg.getTransform();
            FontRenderContext frc = null;
            if (fcg != null) {
                fcg.scale(zoom, zoom);
                frc = fcg.getFontRenderContext();
                fcg.setTransform(backupContextTransform);
            }
            PrintPanel.this.pp.setFontRenderContext(frc);
            PrintPanel.this.pp.setZoom(zoom);
            PrintPanel.this.pp.paintComponent(g);
            PrintPanel.this.pp.setZoom(1.0);
            int scaledWidth = (int)((double)this.getWidth() / zoom);
            int scaledHeight = (int)((double)this.getHeight() / zoom);
            double iW = PrintPanel.this.pageFormat.getImageableWidth();
            double iH = PrintPanel.this.pageFormat.getImageableHeight();
            logger.debug((Object)("Painting print preview: play pen zoom " + zoom + ", print panel zoom " + PrintPanel.this.zoom + ", page width " + iW));
            g2.scale(1.0 / PrintPanel.this.zoom, 1.0 / PrintPanel.this.zoom);
            g2.setColor(PrintPanel.this.pp.getForeground());
            for (i = 0; i <= PrintPanel.this.pagesAcross; ++i) {
                g2.drawLine((int)((double)i * iW * zoom), 0, (int)((double)i * iW * zoom), (int)((double)scaledHeight * PrintPanel.this.zoom * zoom));
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("Drew page separator at x=" + (double)i * iW));
            }
            for (i = 0; i <= PrintPanel.this.pagesDown; ++i) {
                g2.drawLine(0, (int)((double)i * iH * zoom), (int)((double)scaledWidth * PrintPanel.this.zoom * zoom), (int)((double)i * iH * zoom));
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("Drew page separator at y=" + (double)i * iH));
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName() == null) {
                return;
            }
            if (e.getPropertyName().equals("zoom") || e.getPropertyName().equals("pageFormat")) {
                this.repaint();
            }
        }

        public class PreviewZoomAdjuster
        extends MouseInputAdapter {
            @Override
            public void mouseDragged(MouseEvent e) {
                PrintPreviewPanel.this.setCursor(Cursor.getPredefinedCursor(11));
                Point p = new Point(e.getPoint());
                double zoom = PrintPreviewPanel.this.calculateZoom();
                p.x = (int)((double)p.x / zoom);
                p.y = (int)((double)p.y / zoom);
                PrintPanel.this.zoomSlider.setValue((int)(PrintPanel.this.pageFormat.getImageableWidth() / (double)p.x * 100.0));
            }

            @Override
            public void mousePressed(MouseEvent e) {
                this.mouseDragged(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                PrintPreviewPanel.this.setCursor(null);
            }
        }
    }
}

