/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.query;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;

public class InputStreamMarker {
    private final InputStream stream;

    public InputStreamMarker(InputStream stream) {
        this.stream = stream;
    }

    public static InputStream ensureMarkSupported(InputStream stream) {
        if (InputStreamMarker.isMarkSupported(stream)) {
            return stream;
        }
        return new BufferedInputStream(stream);
    }

    private static boolean isMarkSupported(InputStream stream) {
        return stream.markSupported();
    }

    public boolean isMarkSupported() {
        return this.stream.markSupported();
    }

    public void mark(int readLimit) {
        this.stream.mark(readLimit);
    }

    public void reset() throws IOException {
        this.stream.reset();
    }
}

