/*
 * Decompiled with CFR 0.152.
 */
package com.ca.commons.naming;

import com.ca.commons.cbutil.CBParse;
import javax.naming.InvalidNameException;

public class NameUtility {
    public static int next(String searchMe, int startpos, char c) {
        if (c == '\\') {
            return -1;
        }
        if (startpos < 0 || startpos > searchMe.length()) {
            return -1;
        }
        int escape = -1;
        int quotes = -1;
        int nextC = -1;
        while (true) {
            if (escape < startpos) {
                escape = searchMe.indexOf(92, startpos);
            }
            if (quotes < startpos) {
                quotes = searchMe.indexOf(34, startpos);
            }
            if (nextC < startpos) {
                nextC = searchMe.indexOf(c, startpos);
            }
            if (escape == -1 && quotes == -1) {
                return nextC;
            }
            if (!(escape != -1 && nextC >= escape || quotes != -1 && nextC > quotes)) {
                return nextC;
            }
            if (quotes == -1 || escape != -1 && escape < quotes) {
                startpos = escape + 2;
                continue;
            }
            boolean escaped = true;
            while (escaped) {
                if ((quotes = searchMe.indexOf(34, quotes + 1)) == -1) {
                    return -1;
                }
                int backcheck = quotes - 1;
                while (searchMe.charAt(backcheck--) == '\\') {
                    escaped = !escaped;
                }
                escaped = !escaped;
            }
            startpos = quotes + 1;
        }
    }

    public static String unescape(String string) throws InvalidNameException {
        return NameUtility.unescape(string, false);
    }

    public static String removeEscapedUTF(String utfString) throws InvalidNameException {
        try {
            boolean foundUTF = false;
            int safeLen = utfString.length() - 1;
            int pos = utfString.indexOf(92);
            while (pos > -1 && pos < safeLen) {
                char c = utfString.charAt(pos + 1);
                if ("01234567890ABCDEFabcdef".indexOf(c) > 0) {
                    foundUTF = true;
                    char c2 = utfString.charAt(pos + 2);
                    if ("01234567890ABCDEFabcdef".indexOf(c2) == -1) {
                        throw new InvalidNameException("second char of escaped hex couplet wasn't hex; was '" + c2 + "'");
                    }
                    char utf8 = (char)Integer.parseInt("" + c + c2, 16);
                    utfString = utfString.substring(0, pos) + utf8 + utfString.substring(pos + 3);
                    pos = utfString.indexOf(92, pos + 1);
                    continue;
                }
                pos = utfString.indexOf(92, pos + 1);
            }
            if (foundUTF) {
                utfString = new String(utfString.getBytes("ISO-8859-1"), "UTF8");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new InvalidNameException("unable to parse rdn val: '" + utfString + "' - raw error was: " + e.toString());
        }
        return utfString;
    }

    public static String unescape(String string, boolean jndiHack) throws InvalidNameException {
        int len = string.length();
        if (len == 0) {
            return string;
        }
        if (string.charAt(0) == '\"') {
            if (string.charAt(string.length() - 1) != '\"') {
                throw new InvalidNameException("RDN.unescape(): invalid rdn fragment '" + (string == null ? "<null>" : string) + "'");
            }
            string = string.substring(1, string.length() - 1);
        } else {
            string = NameUtility.handleEscapedCharacters(string);
        }
        return string;
    }

    private static String handleEscapedCharacters(String string) throws InvalidNameException {
        if (string.indexOf(92) == -1) {
            return string;
        }
        boolean hasUTF8 = false;
        StringBuffer buffy = new StringBuffer(string);
        try {
            int pos = string.indexOf("\\");
            while (pos > -1) {
                if (pos == buffy.length() - 1) {
                    buffy.setCharAt(pos, ' ');
                } else {
                    char c = buffy.charAt(pos + 1);
                    if ("\",=+<>#;\\ ".indexOf(c) >= 0) {
                        buffy.deleteCharAt(pos);
                    } else if ("0123456789abcdefABCDEF".indexOf(c) >= 0) {
                        hasUTF8 = true;
                        pos += 2;
                    } else {
                        throw new InvalidNameException("illegal escaped character '" + c + "' in name: '" + string + "' (NameUtility:handleEscapedCharacters() ).");
                    }
                }
                pos = buffy.toString().indexOf("\\", pos + 1);
            }
        }
        catch (StringIndexOutOfBoundsException e) {
            throw new InvalidNameException("unparsable string '" + string + "' in NameUtility");
        }
        if (hasUTF8) {
            return NameUtility.removeEscapedUTF(buffy.toString());
        }
        return buffy.toString();
    }

    public static String trimQuotes(String string) {
        int pos = string.indexOf(34);
        int pos2 = string.lastIndexOf(34);
        if (pos == -1 || pos == pos2) {
            System.out.println("RDN.trimQuotes(): rare error parsing rdn fragment:   " + string);
        } else {
            string = string.substring(0, pos) + string.substring(pos + 1, pos2) + string.substring(pos2 + 1);
        }
        return string;
    }

    protected static String cleanupSlashes(String string) {
        int pos = 0;
        while (pos > -1) {
            int next4group = string.indexOf("\\\\\\\\", pos);
            int next3group = string.indexOf("\\\\\\", pos);
            if (next3group == -1) {
                pos = -1;
                continue;
            }
            if (next4group == -1 || next3group < next4group) {
                string = string.substring(0, next3group) + string.substring(next3group + 1);
                pos = next3group + 2;
                continue;
            }
            string = string.substring(0, next4group) + string.substring(next4group + 2);
            pos = next4group + 2;
        }
        return string;
    }

    public static String escape(String string) {
        if (string == null || string.length() == 0) {
            return string;
        }
        StringBuffer buffy = new StringBuffer(string);
        buffy = CBParse.replaceAllBufferChar(buffy, '\\', "\\\\");
        buffy = CBParse.replaceAllBufferChar(buffy, ',', "\\,");
        buffy = CBParse.replaceAllBufferChar(buffy, '=', "\\=");
        buffy = CBParse.replaceAllBufferChar(buffy, '+', "\\+");
        buffy = CBParse.replaceAllBufferChar(buffy, '<', "\\<");
        buffy = CBParse.replaceAllBufferChar(buffy, '>', "\\>");
        buffy = CBParse.replaceAllBufferChar(buffy, '#', "\\#");
        buffy = CBParse.replaceAllBufferChar(buffy, ';', "\\;");
        if ((buffy = CBParse.replaceAllBufferChar(buffy, '\"', "\\\"")).charAt(buffy.length() - 1) == ' ') {
            buffy.setCharAt(buffy.length() - 1, '\\');
            buffy.append(' ');
        }
        string = buffy.toString();
        return buffy.toString();
    }

    public static String checkEndSpaces(String ldapDNString) {
        int finalPos;
        int pos = finalPos = ldapDNString.length() - 1;
        while (ldapDNString.charAt(pos) == '\\') {
            --pos;
        }
        int numSlashes = finalPos - pos;
        if (numSlashes % 4 == 2) {
            return ldapDNString + " ";
        }
        return ldapDNString;
    }
}

