/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.x500;

import java.util.Collection;
import java.util.Collections;
import org.wildfly.common.Assert;
import org.wildfly.security.asn1.ASN1Encodable;
import org.wildfly.security.asn1.ASN1Encoder;

public final class X500DirectoryAttribute
implements ASN1Encodable {
    private final String attributeType;
    private final Collection<ASN1Encodable> values;

    private X500DirectoryAttribute(String attributeType, Collection<ASN1Encodable> values) {
        this.attributeType = attributeType;
        this.values = values;
    }

    public static X500DirectoryAttribute create(String attributeType, Collection<ASN1Encodable> values) {
        Assert.checkNotNullParam((String)"attributeType", (Object)attributeType);
        Assert.checkNotNullParam((String)"values", values);
        return new X500DirectoryAttribute(attributeType, values);
    }

    public static X500DirectoryAttribute create(String attributeType) {
        return X500DirectoryAttribute.create(attributeType, Collections.emptyList());
    }

    public static X500DirectoryAttribute create(String attributeType, ASN1Encodable value) {
        Assert.checkNotNullParam((String)"value", (Object)value);
        return X500DirectoryAttribute.create(attributeType, Collections.singletonList(value));
    }

    public static X500DirectoryAttribute createUtf8(String attributeType, String stringValue) {
        Assert.checkNotNullParam((String)"stringValue", (Object)stringValue);
        return X500DirectoryAttribute.create(attributeType, ASN1Encodable.ofUtf8String((String)stringValue));
    }

    public static X500DirectoryAttribute createObjectId(String attributeType, String oid) {
        return X500DirectoryAttribute.create(attributeType, ASN1Encodable.ofOid((String)oid));
    }

    public void encodeTo(ASN1Encoder encoder) {
        encoder.startSequence();
        encoder.encodeObjectIdentifier(this.attributeType);
        encoder.startSet();
        for (ASN1Encodable value : this.values) {
            value.encodeTo(encoder);
        }
        encoder.endSet();
        encoder.endSequence();
    }
}

