/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.io.rest.ui.internal;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.security.InvalidParameterException;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.common.registry.Identifiable;
import org.openhab.core.common.registry.RegistryChangeListener;
import org.openhab.core.io.rest.RESTConstants;
import org.openhab.core.io.rest.RESTResource;
import org.openhab.core.io.rest.Stream2JSONInputStream;
import org.openhab.core.io.rest.ui.TileDTO;
import org.openhab.core.ui.components.RootUIComponent;
import org.openhab.core.ui.components.UIComponentRegistry;
import org.openhab.core.ui.components.UIComponentRegistryFactory;
import org.openhab.core.ui.tiles.Tile;
import org.openhab.core.ui.tiles.TileProvider;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JSONRequired;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JaxrsApplicationSelect;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JaxrsName;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JaxrsResource;

@Path(value="ui")
@Tag(name="ui")
@Component(service={RESTResource.class, UIResource.class})
@JaxrsResource
@JaxrsName(value="ui")
@JaxrsApplicationSelect(value="(osgi.jaxrs.name=openhab)")
@JSONRequired
@NonNullByDefault
public class UIResource
implements RESTResource {
    public static final String PATH_UI = "ui";
    private final UIComponentRegistryFactory componentRegistryFactory;
    private final TileProvider tileProvider;
    private Map<String, Date> lastModifiedDates = new HashMap<String, Date>();
    private Map<String, RegistryChangeListener<RootUIComponent>> registryChangeListeners = new HashMap<String, RegistryChangeListener<RootUIComponent>>();

    @Activate
    public UIResource(@Reference UIComponentRegistryFactory componentRegistryFactory, @Reference TileProvider tileProvider) {
        this.componentRegistryFactory = componentRegistryFactory;
        this.tileProvider = tileProvider;
    }

    @Deactivate
    public void deactivate() {
        this.registryChangeListeners.forEach((n, l) -> {
            UIComponentRegistry registry = this.componentRegistryFactory.getRegistry(n);
            registry.removeRegistryChangeListener(l);
        });
    }

    @GET
    @Path(value="/tiles")
    @Produces(value={"application/json"})
    @Operation(operationId="getUITiles", summary="Get all registered UI tiles.", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(array=@ArraySchema(schema=@Schema(implementation=TileDTO.class)))})})
    public Response getAll() {
        Stream<TileDTO> tiles = this.tileProvider.getTiles().map(this::toTileDTO);
        return Response.ok((Object)new Stream2JSONInputStream(tiles)).build();
    }

    @GET
    @Path(value="/components/{namespace}")
    @Produces(value={"application/json"})
    @Operation(operationId="getRegisteredUIComponentsInNamespace", summary="Get all registered UI components in the specified namespace.", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(array=@ArraySchema(schema=@Schema(implementation=RootUIComponent.class)))})})
    public Response getAllComponents(@Context Request request, @PathParam(value="namespace") String namespace, @QueryParam(value="summary") @Parameter(description="summary fields only") @Nullable Boolean summary) {
        UIComponentRegistry registry = this.componentRegistryFactory.getRegistry(namespace);
        Stream<Object> components = registry.getAll().stream();
        if (summary != null && summary.booleanValue()) {
            components = components.map(c -> {
                Date timestamp;
                RootUIComponent component = new RootUIComponent(c.getUID(), c.getType());
                @Nullable Set tags = c.getTags();
                if (tags != null) {
                    component.addTags((Collection)c.getTags());
                }
                if ((timestamp = c.getTimestamp()) != null) {
                    component.setTimestamp(timestamp);
                }
                return component;
            });
            return Response.ok((Object)new Stream2JSONInputStream(components)).build();
        }
        if (!this.registryChangeListeners.containsKey(namespace)) {
            ResetLastModifiedChangeListener changeListener = new ResetLastModifiedChangeListener(namespace);
            this.registryChangeListeners.put(namespace, changeListener);
            registry.addRegistryChangeListener((RegistryChangeListener)changeListener);
        }
        Date lastModifiedDate = Date.from(Instant.now());
        if (this.lastModifiedDates.containsKey(namespace)) {
            lastModifiedDate = this.lastModifiedDates.get(namespace);
            Response.ResponseBuilder responseBuilder = request.evaluatePreconditions(lastModifiedDate);
            if (responseBuilder != null) {
                return responseBuilder.build();
            }
        } else {
            lastModifiedDate = Date.from(Instant.now().truncatedTo(ChronoUnit.SECONDS));
            this.lastModifiedDates.put(namespace, lastModifiedDate);
        }
        return Response.ok((Object)new Stream2JSONInputStream(components)).lastModified(lastModifiedDate).cacheControl(RESTConstants.CACHE_CONTROL).build();
    }

    @GET
    @Path(value="/components/{namespace}/{componentUID}")
    @Produces(value={"application/json"})
    @Operation(operationId="getUIComponentInNamespace", summary="Get a specific UI component in the specified namespace.", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=RootUIComponent.class))}), @ApiResponse(responseCode="404", description="Component not found")})
    public Response getComponentByUID(@PathParam(value="namespace") String namespace, @PathParam(value="componentUID") String componentUID) {
        UIComponentRegistry registry = this.componentRegistryFactory.getRegistry(namespace);
        RootUIComponent component = (RootUIComponent)registry.get((Object)componentUID);
        if (component == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return Response.ok((Object)component).build();
    }

    @POST
    @RolesAllowed(value={"administrator"})
    @Path(value="/components/{namespace}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(operationId="addUIComponentToNamespace", summary="Add a UI component in the specified namespace.", security={@SecurityRequirement(name="oauth2", scopes={"admin"})}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=RootUIComponent.class))})})
    public Response addComponent(@PathParam(value="namespace") String namespace, RootUIComponent component) {
        UIComponentRegistry registry = this.componentRegistryFactory.getRegistry(namespace);
        component.updateTimestamp();
        RootUIComponent createdComponent = (RootUIComponent)registry.add((Identifiable)component);
        return Response.ok((Object)createdComponent).build();
    }

    @PUT
    @RolesAllowed(value={"administrator"})
    @Path(value="/components/{namespace}/{componentUID}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(operationId="updateUIComponentInNamespace", summary="Update a specific UI component in the specified namespace.", security={@SecurityRequirement(name="oauth2", scopes={"admin"})}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=RootUIComponent.class))}), @ApiResponse(responseCode="404", description="Component not found")})
    public Response updateComponent(@PathParam(value="namespace") String namespace, @PathParam(value="componentUID") String componentUID, RootUIComponent component) {
        UIComponentRegistry registry = this.componentRegistryFactory.getRegistry(namespace);
        RootUIComponent existingComponent = (RootUIComponent)registry.get((Object)componentUID);
        if (existingComponent == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        if (!componentUID.equals(component.getUID())) {
            throw new InvalidParameterException("The component UID in the body of the request should match the UID in the URL");
        }
        component.updateTimestamp();
        registry.update((Identifiable)component);
        return Response.ok((Object)component).build();
    }

    @DELETE
    @RolesAllowed(value={"administrator"})
    @Path(value="/components/{namespace}/{componentUID}")
    @Produces(value={"application/json"})
    @Operation(operationId="removeUIComponentFromNamespace", summary="Remove a specific UI component in the specified namespace.", security={@SecurityRequirement(name="oauth2", scopes={"admin"})}, responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="Component not found")})
    public Response deleteComponent(@PathParam(value="namespace") String namespace, @PathParam(value="componentUID") String componentUID) {
        UIComponentRegistry registry = this.componentRegistryFactory.getRegistry(namespace);
        RootUIComponent component = (RootUIComponent)registry.get((Object)componentUID);
        if (component == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        registry.remove((Object)componentUID);
        return Response.ok().build();
    }

    private TileDTO toTileDTO(Tile tile) {
        return new TileDTO(tile.getName(), tile.getUrl(), tile.getOverlay(), tile.getImageUrl());
    }

    private void resetLastModifiedDate(String namespace) {
        this.lastModifiedDates.remove(namespace);
    }

    private class ResetLastModifiedChangeListener
    implements RegistryChangeListener<RootUIComponent> {
        private String namespace;

        ResetLastModifiedChangeListener(String namespace) {
            this.namespace = namespace;
        }

        public void added(RootUIComponent element) {
            UIResource.this.resetLastModifiedDate(this.namespace);
        }

        public void removed(RootUIComponent element) {
            UIResource.this.resetLastModifiedDate(this.namespace);
        }

        public void updated(RootUIComponent oldElement, RootUIComponent element) {
            UIResource.this.resetLastModifiedDate(this.namespace);
        }
    }
}

