/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.message.computations;

import de.rub.nds.modifiablevariable.ModifiableVariableFactory;
import de.rub.nds.modifiablevariable.ModifiableVariableProperty;
import de.rub.nds.modifiablevariable.biginteger.ModifiableBigInteger;
import de.rub.nds.modifiablevariable.bytearray.ModifiableByteArray;
import de.rub.nds.modifiablevariable.string.ModifiableString;
import de.rub.nds.tlsattacker.core.config.Config;
import de.rub.nds.tlsattacker.core.crypto.ec.Point;
import de.rub.nds.tlsattacker.core.protocol.message.computations.KeyExchangeComputations;
import java.math.BigInteger;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;

public class GOSTClientComputations
extends KeyExchangeComputations {
    @ModifiableVariableProperty(type=ModifiableVariableProperty.Type.KEY_MATERIAL)
    private ModifiableByteArray ukm;
    @ModifiableVariableProperty(type=ModifiableVariableProperty.Type.KEY_MATERIAL)
    private ModifiableByteArray encryptedKey;
    @ModifiableVariableProperty(type=ModifiableVariableProperty.Type.KEY_MATERIAL)
    private ModifiableByteArray macKey;
    @ModifiableVariableProperty(type=ModifiableVariableProperty.Type.KEY_MATERIAL)
    private ModifiableByteArray keyEncryptionKey;
    @ModifiableVariableProperty(type=ModifiableVariableProperty.Type.KEY_MATERIAL)
    private ModifiableByteArray maskKey;
    private ModifiableByteArray proxyKeyBlobs;
    private ModifiableString encryptionParamSet;
    private ModifiableBigInteger clientPublicKeyX;
    private ModifiableBigInteger clientPublicKeyY;

    @Override
    public void setSecretsInConfig(Config config) {
    }

    public void setClientPublicKey(Point point) {
        this.clientPublicKeyX = ModifiableVariableFactory.safelySetValue((ModifiableBigInteger)this.clientPublicKeyX, (BigInteger)point.getX().getData());
        this.clientPublicKeyY = ModifiableVariableFactory.safelySetValue((ModifiableBigInteger)this.clientPublicKeyY, (BigInteger)point.getY().getData());
    }

    public ModifiableBigInteger getClientPublicKeyX() {
        return this.clientPublicKeyX;
    }

    public void setClientPublicKeyX(ModifiableBigInteger clientPublicKeyX) {
        this.clientPublicKeyX = clientPublicKeyX;
    }

    public ModifiableBigInteger getClientPublicKeyY() {
        return this.clientPublicKeyY;
    }

    public void setClientPublicKeyY(ModifiableBigInteger clientPublicKeyY) {
        this.clientPublicKeyY = clientPublicKeyY;
    }

    public ModifiableByteArray getEncryptedKey() {
        return this.encryptedKey;
    }

    public void setEncryptedKey(byte[] encryptedKey) {
        this.encryptedKey = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.encryptedKey, (byte[])encryptedKey);
    }

    public ModifiableString getEncryptionParamSet() {
        return this.encryptionParamSet;
    }

    public void setEncryptionParamSet(ASN1ObjectIdentifier oid) {
        this.encryptionParamSet = ModifiableVariableFactory.safelySetValue((ModifiableString)this.encryptionParamSet, (String)oid.getId());
    }

    public ModifiableByteArray getKeyEncryptionKey() {
        return this.keyEncryptionKey;
    }

    public void setKeyEncryptionKey(byte[] keyEncryptionKey) {
        this.keyEncryptionKey = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.keyEncryptionKey, (byte[])keyEncryptionKey);
    }

    public ModifiableByteArray getMacKey() {
        return this.macKey;
    }

    public void setMacKey(byte[] macKey) {
        this.macKey = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.macKey, (byte[])macKey);
    }

    public ModifiableByteArray getMaskKey() {
        return this.maskKey;
    }

    public void setMaskKey(ModifiableByteArray maskKey) {
        this.maskKey = maskKey;
    }

    public ModifiableByteArray getProxyKeyBlobs() {
        return this.proxyKeyBlobs;
    }

    public void setProxyKeyBlobs(ModifiableByteArray proxyKeyBlobs) {
        this.proxyKeyBlobs = proxyKeyBlobs;
    }

    public ModifiableByteArray getUkm() {
        return this.ukm;
    }

    public void setUkm(ModifiableByteArray ukm) {
        this.ukm = ukm;
    }

    public void setCekEnc(ModifiableByteArray cekEnc) {
        this.encryptedKey = cekEnc;
    }

    public void setCekMac(ModifiableByteArray cekMac) {
        this.macKey = cekMac;
    }

    public void setEncryptionAlgOid(ModifiableString encryptionAlgOid) {
        this.encryptionParamSet = encryptionAlgOid;
    }

    public void setKek(ModifiableByteArray kek) {
        this.keyEncryptionKey = kek;
    }

    public void setUkm(byte[] ukm) {
        this.ukm = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.ukm, (byte[])ukm);
    }
}

