/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.preparator;

import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.constants.ECPointFormat;
import de.rub.nds.tlsattacker.core.constants.NamedGroup;
import de.rub.nds.tlsattacker.core.crypto.ec.CurveFactory;
import de.rub.nds.tlsattacker.core.crypto.ec.EllipticCurve;
import de.rub.nds.tlsattacker.core.crypto.ec.Point;
import de.rub.nds.tlsattacker.core.crypto.ec.PointFormatter;
import de.rub.nds.tlsattacker.core.crypto.ec.RFC7748Curve;
import de.rub.nds.tlsattacker.core.protocol.message.ClientKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.message.ECDHClientKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.preparator.ClientKeyExchangePreparator;
import de.rub.nds.tlsattacker.core.workflow.chooser.Chooser;
import java.math.BigInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ECDHClientKeyExchangePreparator<T extends ECDHClientKeyExchangeMessage>
extends ClientKeyExchangePreparator<T> {
    private static final Logger LOGGER = LogManager.getLogger();
    protected byte[] premasterSecret;
    protected byte[] random;
    protected final T msg;

    public ECDHClientKeyExchangePreparator(Chooser chooser, T message) {
        super(chooser, (ClientKeyExchangeMessage)message);
        this.msg = message;
    }

    @Override
    public void prepareHandshakeMessageContents() {
        LOGGER.debug("Preparing ECDHClientExchangeMessage");
        ((ECDHClientKeyExchangeMessage)this.msg).prepareComputations();
        this.setSerializedPublicKey();
        this.prepareSerializedPublicKeyLength(this.msg);
        this.prepareAfterParse(true);
    }

    protected byte[] computePremasterSecret(EllipticCurve curve, Point publicKey, BigInteger privateKey) {
        Point sharedPoint = curve.mult(privateKey, publicKey);
        int elementLenght = ArrayConverter.bigIntegerToByteArray((BigInteger)sharedPoint.getX().getModulus()).length;
        return ArrayConverter.bigIntegerToNullPaddedByteArray((BigInteger)sharedPoint.getX().getData(), (int)elementLenght);
    }

    protected void prepareSerializedPublicKeyLength(T msg) {
        ((ClientKeyExchangeMessage)msg).setPublicKeyLength(((byte[])((ClientKeyExchangeMessage)msg).getPublicKey().getValue()).length);
        LOGGER.debug("SerializedPublicKeyLength: " + ((ClientKeyExchangeMessage)msg).getPublicKeyLength().getValue());
    }

    protected void preparePremasterSecret(T msg) {
        ((ECDHClientKeyExchangeMessage)msg).getComputations().setPremasterSecret(this.premasterSecret);
        LOGGER.debug("PremasterSecret: " + ArrayConverter.bytesToHexString((byte[])((byte[])((ECDHClientKeyExchangeMessage)msg).getComputations().getPremasterSecret().getValue())));
    }

    protected void prepareClientServerRandom(T msg) {
        this.random = ArrayConverter.concatenate((byte[][])new byte[][]{this.chooser.getClientRandom(), this.chooser.getServerRandom()});
        ((ECDHClientKeyExchangeMessage)msg).getComputations().setClientServerRandom(this.random);
        LOGGER.debug("ClientServerRandom: " + ArrayConverter.bytesToHexString((byte[])((byte[])((ECDHClientKeyExchangeMessage)msg).getComputations().getClientServerRandom().getValue())));
    }

    @Override
    public void prepareAfterParse(boolean clientMode) {
        ((ECDHClientKeyExchangeMessage)this.msg).prepareComputations();
        this.prepareClientServerRandom(this.msg);
        NamedGroup usedGroup = this.chooser.getSelectedNamedGroup();
        LOGGER.debug("PMS used Group: " + usedGroup.name());
        if (((ECDHClientKeyExchangeMessage)this.msg).getComputations().getPrivateKey() == null) {
            this.setComputationPrivateKey(this.msg, clientMode);
        }
        EllipticCurve curve = CurveFactory.getCurve(usedGroup);
        if (usedGroup == NamedGroup.ECDH_X25519 || usedGroup == NamedGroup.ECDH_X448) {
            RFC7748Curve rfcCurve = (RFC7748Curve)curve;
            this.premasterSecret = clientMode ? rfcCurve.computeSharedSecret((BigInteger)((ECDHClientKeyExchangeMessage)this.msg).getComputations().getPrivateKey().getValue(), this.chooser.getServerEcPublicKey()) : rfcCurve.computeSharedSecret((BigInteger)((ECDHClientKeyExchangeMessage)this.msg).getComputations().getPrivateKey().getValue(), (byte[])((ClientKeyExchangeMessage)this.msg).getPublicKey().getValue());
        } else {
            Point publicKey = clientMode ? this.chooser.getServerEcPublicKey() : PointFormatter.formatFromByteArray(usedGroup, (byte[])((ClientKeyExchangeMessage)this.msg).getPublicKey().getValue());
            this.premasterSecret = this.computePremasterSecret(curve, publicKey, (BigInteger)((ECDHClientKeyExchangeMessage)this.msg).getComputations().getPrivateKey().getValue());
        }
        this.preparePremasterSecret(this.msg);
    }

    private void setSerializedPublicKey() {
        byte[] publicKeyBytes;
        NamedGroup usedGroup = this.chooser.getSelectedNamedGroup();
        LOGGER.debug("PublicKey used Group: " + usedGroup.name());
        ECPointFormat pointFormat = this.chooser.getConfig().getDefaultSelectedPointFormat();
        LOGGER.debug("EC Point format: " + pointFormat.name());
        this.setComputationPrivateKey(this.msg, true);
        BigInteger privateKey = (BigInteger)((ECDHClientKeyExchangeMessage)this.msg).getComputations().getPrivateKey().getValue();
        EllipticCurve curve = CurveFactory.getCurve(usedGroup);
        if (usedGroup == NamedGroup.ECDH_X25519 || usedGroup == NamedGroup.ECDH_X448) {
            RFC7748Curve rfcCurve = (RFC7748Curve)curve;
            publicKeyBytes = rfcCurve.computePublicKey(privateKey);
        } else {
            Point publicKey = curve.mult(privateKey, curve.getBasePoint());
            ((ECDHClientKeyExchangeMessage)this.msg).getComputations().setPublicKeyX(publicKey.getX().getData());
            ((ECDHClientKeyExchangeMessage)this.msg).getComputations().setPublicKeyY(publicKey.getY().getData());
            publicKey = curve.getPoint((BigInteger)((ECDHClientKeyExchangeMessage)this.msg).getComputations().getPublicKeyX().getValue(), (BigInteger)((ECDHClientKeyExchangeMessage)this.msg).getComputations().getPublicKeyY().getValue());
            publicKeyBytes = PointFormatter.formatToByteArray(usedGroup, publicKey, pointFormat);
        }
        ((ClientKeyExchangeMessage)this.msg).setPublicKey(publicKeyBytes);
    }

    protected void setComputationPrivateKey(T msg, boolean clientMode) {
        if (clientMode) {
            LOGGER.debug("Using Client PrivateKey");
            ((ECDHClientKeyExchangeMessage)msg).getComputations().setPrivateKey(this.chooser.getClientEcPrivateKey());
        } else {
            LOGGER.debug("Using Server PrivateKey");
            ((ECDHClientKeyExchangeMessage)msg).getComputations().setPrivateKey(this.chooser.getServerEcPrivateKey());
        }
        LOGGER.debug("Computation PrivateKey: " + ((BigInteger)((ECDHClientKeyExchangeMessage)msg).getComputations().getPrivateKey().getValue()).toString());
    }
}

