/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javaee.resources.api.model;

import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.modules.javaee.resources.api.model.JndiResourcesModel;
import org.netbeans.modules.javaee.resources.api.model.JndiResourcesModelFactory;
import org.netbeans.modules.javaee.resources.api.model.JndiResourcesModelUnit;
import org.netbeans.spi.java.classpath.ClassPathProvider;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.filesystems.FileObject;

public final class JndiResourcesModelSupport {
    private static final Logger LOGGER = Logger.getLogger(JndiResourcesModelSupport.class.getName());
    public static final Map<Project, WeakReference<MetadataModel<JndiResourcesModel>>> MODELS = new WeakHashMap<Project, WeakReference<MetadataModel<JndiResourcesModel>>>();

    private JndiResourcesModelSupport() {
    }

    public static MetadataModel<JndiResourcesModel> getModel(Project project) {
        WeakReference<MetadataModel<JndiResourcesModel>> reference = MODELS.get(project);
        MetadataModel<JndiResourcesModel> metadataModel = null;
        if (reference != null) {
            metadataModel = (MetadataModel<JndiResourcesModel>)reference.get();
        }
        if (metadataModel == null) {
            JndiResourcesModelUnit modelUnit = JndiResourcesModelSupport.getModelUnit(project);
            LOGGER.log(Level.FINE, "Metadata model not found in cache for model unit: {0}, reference: {1}", new Object[]{modelUnit, reference});
            if (modelUnit == null) {
                return null;
            }
            metadataModel = JndiResourcesModelFactory.createMetaModel(modelUnit);
            reference = new WeakReference<MetadataModel<JndiResourcesModel>>(metadataModel);
            MODELS.put(project, reference);
        }
        return metadataModel;
    }

    private static JndiResourcesModelUnit getModelUnit(Project project) {
        if (project == null) {
            return null;
        }
        ClassPath boot = JndiResourcesModelSupport.getClassPath(project, "classpath/boot");
        ClassPath compile = JndiResourcesModelSupport.getClassPath(project, "classpath/compile");
        ClassPath src = JndiResourcesModelSupport.getClassPath(project, "classpath/source");
        return JndiResourcesModelUnit.create(boot, compile, src);
    }

    private static ClassPath getClassPath(Project project, String type) {
        ClassPathProvider provider = (ClassPathProvider)project.getLookup().lookup(ClassPathProvider.class);
        if (provider == null) {
            return null;
        }
        Sources sources = ProjectUtils.getSources((Project)project);
        if (sources == null) {
            return null;
        }
        SourceGroup[] sourceGroups = sources.getSourceGroups("java");
        ClassPath[] paths = new ClassPath[sourceGroups.length];
        int i = 0;
        for (SourceGroup sourceGroup : sourceGroups) {
            FileObject rootFolder = sourceGroup.getRootFolder();
            paths[i] = provider.findClassPath(rootFolder, type);
            ++i;
        }
        return ClassPathSupport.createProxyClassPath((ClassPath[])paths);
    }
}

