/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jshell.support;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.modules.java.source.usages.ClasspathInfoAccessor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

final class SwitchingJavaFileManger
implements StandardJavaFileManager,
ChangeListener {
    private volatile JavaFileManager delegate;
    private final StandardJavaFileManager.PathFactory pathFactory = Paths::get;
    private final ClasspathInfo cpInfo;
    private volatile ThreadLocal<JavaFileManager> localDelegate = new ThreadLocal();
    private final Deque<JavaFileManager> locals = new ArrayDeque<JavaFileManager>();

    public SwitchingJavaFileManger(ClasspathInfo cpInfo) {
        this.cpInfo = cpInfo;
    }

    private synchronized void resetFileManager() {
        this.delegate = null;
        this.locals.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> T withLocalManager(Callable<T> r) throws Exception {
        JavaFileManager local;
        SwitchingJavaFileManger switchingJavaFileManger = this;
        synchronized (switchingJavaFileManger) {
            local = this.locals.poll();
        }
        if (local == null) {
            local = ClasspathInfoAccessor.getINSTANCE().createFileManager(this.cpInfo, null);
        }
        JavaFileManager old = this.localDelegate.get();
        this.localDelegate.set(local);
        try {
            T t = r.call();
            return t;
        }
        finally {
            this.localDelegate.set(old);
            SwitchingJavaFileManger switchingJavaFileManger2 = this;
            synchronized (switchingJavaFileManger2) {
                this.locals.push(local);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JavaFileManager delegate() {
        JavaFileManager d = this.localDelegate.get();
        if (d != null) {
            return d;
        }
        d = this.delegate;
        if (d != null) {
            return d;
        }
        SwitchingJavaFileManger switchingJavaFileManger = this;
        synchronized (switchingJavaFileManger) {
            if (this.delegate == null) {
                this.delegate = ClasspathInfoAccessor.getINSTANCE().createFileManager(this.cpInfo, "9");
            }
            return this.delegate;
        }
    }

    @Override
    public ClassLoader getClassLoader(JavaFileManager.Location location) {
        return this.delegate().getClassLoader(location);
    }

    @Override
    public Iterable<JavaFileObject> list(JavaFileManager.Location location, String packageName, Set<JavaFileObject.Kind> kinds, boolean recurse) throws IOException {
        return this.delegate().list(location, packageName, kinds, recurse);
    }

    @Override
    public String inferBinaryName(JavaFileManager.Location location, JavaFileObject file) {
        return this.delegate().inferBinaryName(location, file);
    }

    @Override
    public boolean isSameFile(javax.tools.FileObject a, javax.tools.FileObject b) {
        return this.delegate().isSameFile(a, b);
    }

    @Override
    public boolean handleOption(String current, Iterator<String> remaining) {
        return this.delegate().handleOption(current, remaining);
    }

    @Override
    public boolean hasLocation(JavaFileManager.Location location) {
        return this.delegate().hasLocation(location);
    }

    @Override
    public JavaFileObject getJavaFileForInput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind) throws IOException {
        return this.delegate().getJavaFileForInput(location, className, kind);
    }

    @Override
    public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind, javax.tools.FileObject sibling) throws IOException {
        return this.delegate().getJavaFileForOutput(location, className, kind, sibling);
    }

    @Override
    public javax.tools.FileObject getFileForInput(JavaFileManager.Location location, String packageName, String relativeName) throws IOException {
        return this.delegate().getFileForInput(location, packageName, relativeName);
    }

    @Override
    public javax.tools.FileObject getFileForOutput(JavaFileManager.Location location, String packageName, String relativeName, javax.tools.FileObject sibling) throws IOException {
        return this.delegate().getFileForOutput(location, packageName, relativeName, sibling);
    }

    @Override
    public void flush() throws IOException {
        this.delegate().flush();
    }

    @Override
    public void close() throws IOException {
        this.delegate().close();
    }

    @Override
    public JavaFileManager.Location getLocationForModule(JavaFileManager.Location location, String moduleName) throws IOException {
        return this.delegate().getLocationForModule(location, moduleName);
    }

    @Override
    public JavaFileManager.Location getLocationForModule(JavaFileManager.Location location, JavaFileObject fo) throws IOException {
        if ("string".equals(fo.toUri().getScheme())) {
            return null;
        }
        return this.delegate().getLocationForModule(location, fo);
    }

    @Override
    public <S> ServiceLoader<S> getServiceLoader(JavaFileManager.Location location, Class<S> service) throws IOException {
        return this.delegate().getServiceLoader(location, service);
    }

    @Override
    public String inferModuleName(JavaFileManager.Location location) throws IOException {
        return this.delegate().inferModuleName(location);
    }

    @Override
    public Iterable<Set<JavaFileManager.Location>> listLocationsForModules(JavaFileManager.Location location) throws IOException {
        return this.delegate().listLocationsForModules(location);
    }

    @Override
    public int isSupportedOption(String option) {
        return this.delegate().isSupportedOption(option);
    }

    @Override
    public Iterable<? extends JavaFileObject> getJavaFileObjectsFromFiles(Iterable<? extends File> files) {
        throw new UnsupportedOperationException("Unsupported");
    }

    @Override
    public Iterable<? extends JavaFileObject> getJavaFileObjects(File ... files) {
        return this.getJavaFileObjectsFromFiles(Arrays.asList(files));
    }

    private Path getPath(String first, String ... more) {
        return this.pathFactory.getPath(first, more);
    }

    @Override
    public Iterable<? extends JavaFileObject> getJavaFileObjectsFromStrings(Iterable<String> names) {
        ArrayList<Path> paths = new ArrayList<Path>();
        for (String name : names) {
            paths.add(this.getPath(name, new String[0]));
        }
        return this.getJavaFileObjectsFromPaths((Collection<? extends Path>)paths);
    }

    @Override
    public Iterable<? extends JavaFileObject> getJavaFileObjects(String ... names) {
        return this.getJavaFileObjectsFromStrings(Arrays.asList(names));
    }

    @Override
    public void setLocation(JavaFileManager.Location location, Iterable<? extends File> files) throws IOException {
        throw new UnsupportedOperationException("Unsupported");
    }

    @Override
    public Iterable<? extends File> getLocation(JavaFileManager.Location location) {
        ClassPath cp = null;
        if (location == StandardLocation.SOURCE_PATH) {
            cp = this.cpInfo.getClassPath(ClasspathInfo.PathKind.SOURCE);
        } else if (location == StandardLocation.CLASS_PATH) {
            cp = this.cpInfo.getClassPath(ClasspathInfo.PathKind.COMPILE);
        } else if (location == StandardLocation.PLATFORM_CLASS_PATH) {
            cp = this.cpInfo.getClassPath(ClasspathInfo.PathKind.BOOT);
        }
        if (cp == null) {
            return null;
        }
        FileObject[] roots = cp.getRoots();
        if (roots == null || roots.length == 0) {
            return null;
        }
        ArrayList<File> res = new ArrayList<File>(roots.length);
        for (FileObject f : roots) {
            File x = FileUtil.toFile((FileObject)f);
            if (x == null) continue;
            res.add(x);
        }
        return res;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (e.getSource() == this.cpInfo) {
            this.resetFileManager();
        }
    }
}

