/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visual.action;

import java.awt.Container;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.netbeans.api.visual.action.WidgetAction;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;

public final class PanAction
extends WidgetAction.LockedAdapter {
    private Scene scene;
    private JScrollPane scrollPane;
    private Point lastLocation;

    @Override
    protected boolean isLocked() {
        return this.scrollPane != null;
    }

    @Override
    public WidgetAction.State mousePressed(Widget widget, WidgetAction.WidgetMouseEvent event) {
        if (this.isLocked()) {
            return WidgetAction.State.createLocked(widget, this);
        }
        this.scene = widget.getScene();
        if (event.getButton() == this.scene.getInputBindings().getPanActionButton()) {
            this.scrollPane = this.findScrollPane(this.scene.getView());
            if (this.scrollPane != null) {
                this.lastLocation = this.scene.convertSceneToView(widget.convertLocalToScene(event.getPoint()));
                SwingUtilities.convertPointToScreen(this.lastLocation, this.scene.getView());
                return WidgetAction.State.createLocked(widget, this);
            }
        }
        return WidgetAction.State.REJECTED;
    }

    private JScrollPane findScrollPane(JComponent component) {
        while (component != null) {
            if (component instanceof JScrollPane) {
                return (JScrollPane)component;
            }
            Container parent = component.getParent();
            if (!(parent instanceof JComponent)) {
                return null;
            }
            component = (JComponent)parent;
        }
        return null;
    }

    @Override
    public WidgetAction.State mouseReleased(Widget widget, WidgetAction.WidgetMouseEvent event) {
        boolean state = this.pan(widget, event.getPoint());
        if (state) {
            this.scrollPane = null;
        }
        return state ? WidgetAction.State.createLocked(widget, this) : WidgetAction.State.REJECTED;
    }

    @Override
    public WidgetAction.State mouseDragged(Widget widget, WidgetAction.WidgetMouseEvent event) {
        return this.pan(widget, event.getPoint()) ? WidgetAction.State.createLocked(widget, this) : WidgetAction.State.REJECTED;
    }

    private boolean pan(Widget widget, Point newLocation) {
        if (this.scrollPane == null || this.scene != widget.getScene()) {
            return false;
        }
        newLocation = this.scene.convertSceneToView(widget.convertLocalToScene(newLocation));
        SwingUtilities.convertPointToScreen(newLocation, this.scene.getView());
        JComponent view = this.scene.getView();
        Rectangle rectangle = view.getVisibleRect();
        rectangle.x += this.lastLocation.x - newLocation.x;
        rectangle.y += this.lastLocation.y - newLocation.y;
        view.scrollRectToVisible(rectangle);
        this.lastLocation = newLocation;
        return true;
    }
}

