/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.model.mindmap;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.primefaces.model.mindmap.MindmapNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultMindmapNode
implements MindmapNode,
Serializable {
    private MindmapNode parent;
    private List<MindmapNode> children;
    private String label;
    private Object data;
    private String fill;
    private boolean selectable;

    public DefaultMindmapNode() {
    }

    public DefaultMindmapNode(String label) {
        this.label = label;
        this.children = new ArrayList<MindmapNode>();
        this.selectable = true;
    }

    public DefaultMindmapNode(String label, Object data) {
        this(label);
        this.data = data;
    }

    public DefaultMindmapNode(String label, Object data, String fill) {
        this(label, data);
        this.fill = fill;
    }

    public DefaultMindmapNode(String label, Object data, String fill, boolean selectable) {
        this(label, data, fill);
        this.selectable = selectable;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    @Override
    public MindmapNode getParent() {
        return this.parent;
    }

    @Override
    public Object getData() {
        return this.data;
    }

    public void setData(Object data) {
        this.data = data;
    }

    @Override
    public void setParent(MindmapNode parent) {
        if (this.parent != null) {
            this.parent.getChildren().remove(this);
        }
        this.parent = parent;
        if (this.parent != null) {
            this.parent.getChildren().add(this);
        }
    }

    @Override
    public String getFill() {
        return this.fill;
    }

    public void setFill(String fill) {
        this.fill = fill;
    }

    @Override
    public void addNode(MindmapNode node) {
        node.setParent(this);
    }

    @Override
    public boolean isSelectable() {
        return this.selectable;
    }

    @Override
    public void setSelectable(boolean selectable) {
        this.selectable = selectable;
    }

    @Override
    public List<MindmapNode> getChildren() {
        return this.children;
    }

    public void setChildren(List<MindmapNode> children) {
        this.children = children;
    }
}

