/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OptionalDataException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.project.ui.Bundle;
import org.netbeans.modules.project.ui.LazyProject;
import org.netbeans.modules.project.ui.NodeSelectionProjectPanel;
import org.netbeans.modules.project.ui.OpenProjectList;
import org.netbeans.modules.project.ui.ProjectsRootNode;
import org.netbeans.modules.project.ui.SyncEditorWithViewsAction;
import org.netbeans.modules.project.ui.groups.Group;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.awt.Actions;
import org.openide.awt.StatusDisplayer;
import org.openide.awt.UndoRedo;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerUtils;
import org.openide.explorer.view.BeanTreeView;
import org.openide.explorer.view.Visualizer;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.NodeNotFoundException;
import org.openide.nodes.NodeOp;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.NbCollections;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.openide.util.actions.BooleanStateAction;
import org.openide.util.lookup.Lookups;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class ProjectTab
extends TopComponent
implements ExplorerManager.Provider,
PropertyChangeListener,
UndoRedo.Provider {
    public static final String ID_LOGICAL = "projectTabLogical_tc";
    public static final String ID_PHYSICAL = "projectTab_tc";
    private static final String PROJECT_TAB = "org/netbeans/modules/project/ui/resources/projectTab.png";
    private static final String FILES_TAB = "org/netbeans/modules/project/ui/resources/filesTab.png";
    private static final Image ICON_LOGICAL = ImageUtilities.loadImage((String)"org/netbeans/modules/project/ui/resources/projectTab.png");
    private static final Image ICON_PHYSICAL = ImageUtilities.loadImage((String)"org/netbeans/modules/project/ui/resources/filesTab.png");
    private static final Logger LOG = Logger.getLogger(ProjectTab.class.getName());
    private static Map<String, ProjectTab> tabs = new HashMap<String, ProjectTab>();
    private final transient ExplorerManager manager;
    private transient Node rootNode;
    private String id;
    private final transient ProjectTreeView btv;
    private final JLabel noProjectsLabel = new JLabel(NbBundle.getMessage(ProjectTab.class, (String)"NO_PROJECT_OPEN"));
    private boolean synchronizeViews = false;
    private FileObject objectToSelect;
    private boolean prompt;
    private RequestProcessor.Task selectionTask;
    private static final int NODE_SELECTION_DELAY = 200;
    private final NodeSelectionProjectPanel nodeSelectionProjectPanel;
    private static final long serialVersionUID = 9374872358L;
    private static final Lookup context = Utilities.actionsGlobalContext();
    private static final Lookup.Result<FileObject> foSelection = context.lookup(new Lookup.Template(FileObject.class));
    private static final Lookup.Result<DataObject> doSelection = context.lookup(new Lookup.Template(DataObject.class));
    private final LookupListener baseListener = new LookupListener(){

        public void resultChanged(LookupEvent ev) {
            if (TopComponent.getRegistry().getActivated() == ProjectTab.this) {
                return;
            }
            if (ProjectTab.this.synchronizeViews) {
                Collection fos = foSelection.allInstances();
                if (fos.size() == 1) {
                    ProjectTab.this.selectNodeAsyncNoSelect((FileObject)fos.iterator().next(), false);
                } else {
                    Collection dos = doSelection.allInstances();
                    if (dos.size() == 1) {
                        ProjectTab.this.selectNodeAsyncNoSelect(((DataObject)dos.iterator().next()).getPrimaryFile(), false);
                    }
                }
            }
        }
    };
    private final LookupListener weakListener = (LookupListener)WeakListeners.create(LookupListener.class, (EventListener)this.baseListener, null);
    public static final RequestProcessor RP = new RequestProcessor(ProjectTab.class);

    public ProjectTab(String id) {
        this();
        this.id = id;
        this.initValues();
    }

    public ProjectTab() {
        this.manager = new ExplorerManager();
        ActionMap map = this.getActionMap();
        map.put("copy-to-clipboard", ExplorerUtils.actionCopy((ExplorerManager)this.manager));
        map.put("cut-to-clipboard", ExplorerUtils.actionCut((ExplorerManager)this.manager));
        map.put("paste-from-clipboard", ExplorerUtils.actionPaste((ExplorerManager)this.manager));
        map.put("delete", ExplorerUtils.actionDelete((ExplorerManager)this.manager, (boolean)true));
        this.initComponents();
        this.btv = new ProjectTreeView();
        this.btv.setDragSource(true);
        this.btv.setRootVisible(false);
        this.add((Component)((Object)this.btv), "Center");
        OpenProjects.getDefault().addPropertyChangeListener((PropertyChangeListener)this);
        this.noProjectsLabel.addMouseListener(new LabelPopupDisplayer(this.noProjectsLabel));
        this.noProjectsLabel.setHorizontalAlignment(0);
        this.noProjectsLabel.setEnabled(false);
        Color usualWindowBkg = UIManager.getColor("window");
        if (null != usualWindowBkg) {
            this.noProjectsLabel.setBackground(usualWindowBkg);
            this.noProjectsLabel.setOpaque(true);
        } else {
            this.noProjectsLabel.setOpaque(false);
        }
        this.associateLookup(ExplorerUtils.createLookup((ExplorerManager)this.manager, (ActionMap)map));
        this.selectionTask = this.createSelectionTask();
        Preferences nbPrefs = NbPreferences.forModule(SyncEditorWithViewsAction.class);
        this.synchronizeViews = nbPrefs.getBoolean("synchronizeEditorWithViews", false);
        nbPrefs.addPreferenceChangeListener(new NbPrefsListener());
        this.nodeSelectionProjectPanel = new NodeSelectionProjectPanel();
        ActualSelectionProject actualSelectionProject = new ActualSelectionProject(this.nodeSelectionProjectPanel);
        this.manager.addPropertyChangeListener((PropertyChangeListener)actualSelectionProject);
        this.btv.getViewport().addChangeListener(actualSelectionProject);
        this.add(this.nodeSelectionProjectPanel, "South");
    }

    public void setGroup(Group g) {
        if (this.id.equals(ID_LOGICAL)) {
            if (g != null) {
                this.setName(NbBundle.getMessage(ProjectTab.class, (String)"LBL_projectTabLogical_tc_with_group", (Object)g.getName()));
                this.setToolTipText(NbBundle.getMessage(ProjectTab.class, (String)"TT_projectTabLogical_tc_with_group", (Object)g.getName(), (Object)this.getKeyStrokeString()));
            } else {
                this.setName(NbBundle.getMessage(ProjectTab.class, (String)"LBL_projectTabLogical_tc"));
                this.setToolTipText(NbBundle.getMessage(ProjectTab.class, (String)"TT_projectTabLogical_tc", (Object)this.getKeyStrokeString()));
            }
        } else {
            this.setName(NbBundle.getMessage(ProjectTab.class, (String)"LBL_projectTab_tc"));
            if (g != null) {
                this.setToolTipText(NbBundle.getMessage(ProjectTab.class, (String)"TT_projectTab_tc_with_group", (Object)g.getName(), (Object)this.getKeyStrokeString()));
            } else {
                this.setToolTipText(NbBundle.getMessage(ProjectTab.class, (String)"TT_projectTab_tc", (Object)this.getKeyStrokeString()));
            }
        }
    }

    private String getKeyStrokeString() {
        String string;
        Object object;
        Action action;
        Action action2 = action = this.id.equals(ID_LOGICAL) ? Actions.forID((String)"Window/SelectDocumentNode", (String)"org.netbeans.modules.project.ui.SelectInProjects") : Actions.forID((String)"Window/SelectDocumentNode", (String)"org.netbeans.modules.project.ui.SelectInFiles");
        if (action != null && (object = action.getValue("AcceleratorKey")) instanceof KeyStroke) {
            KeyStroke ks = (KeyStroke)object;
            string = Actions.keyStrokeToString((KeyStroke)ks);
        } else {
            string = "";
        }
        return string;
    }

    private void initValues() {
        this.setGroup(Group.getActiveGroup());
        if (this.id.equals(ID_LOGICAL)) {
            this.setIcon(ICON_LOGICAL);
        } else {
            this.setIcon(ICON_PHYSICAL);
        }
        if (this.rootNode == null) {
            this.rootNode = new ProjectsRootNode(this.id.equals(ID_LOGICAL) ? 1 : 0);
        }
        this.manager.setRootContext(this.rootNode);
    }

    public ExplorerManager getExplorerManager() {
        return this.manager;
    }

    public UndoRedo getUndoRedo() {
        UndoRedo undoRedo = (UndoRedo)Lookups.forPath((String)"org/netbeans/modules/refactoring").lookup(UndoRedo.class);
        return undoRedo == null ? UndoRedo.NONE : undoRedo;
    }

    public static synchronized ProjectTab findDefault(String tcID) {
        ProjectTab tab = tabs.get(tcID);
        if (tab == null) {
            TopComponent tc = WindowManager.getDefault().findTopComponent(tcID);
            if (tc != null) {
                if (!(tc instanceof ProjectTab)) {
                    IllegalStateException exc = new IllegalStateException("Incorrect settings file. Unexpected class returned. Expected:" + ProjectTab.class.getName() + " Returned:" + tc.getClass().getName());
                    ErrorManager.getDefault().notify(1, (Throwable)exc);
                    tab = ProjectTab.getDefault(tcID);
                } else {
                    tab = (ProjectTab)tc;
                }
            } else {
                tab = ProjectTab.getDefault(tcID);
            }
        }
        return tab;
    }

    public static synchronized ProjectTab getDefault(String tcID) {
        ProjectTab tab = tabs.get(tcID);
        if (tab == null) {
            tab = new ProjectTab(tcID);
            tabs.put(tcID, tab);
        }
        return tab;
    }

    public static TopComponent getLogical() {
        return ProjectTab.getDefault(ID_LOGICAL);
    }

    public static TopComponent getPhysical() {
        return ProjectTab.getDefault(ID_PHYSICAL);
    }

    protected String preferredID() {
        return this.id;
    }

    public HelpCtx getHelpCtx() {
        return ExplorerUtils.getHelpCtx((Node[])this.manager.getSelectedNodes(), (HelpCtx)(ID_LOGICAL.equals(this.id) ? new HelpCtx("ProjectTab_Projects") : new HelpCtx("ProjectTab_Files")));
    }

    public int getPersistenceType() {
        return 0;
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }

    public boolean requestFocusInWindow() {
        super.requestFocusInWindow();
        return this.btv.requestFocusInWindow();
    }

    public void requestFocus() {
        super.requestFocus();
        this.btv.requestFocus();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.id);
        out.writeObject(this.rootNode.getHandle());
        out.writeObject(this.btv.getExpandedPaths());
        out.writeObject(this.getSelectedPaths());
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.id = (String)in.readObject();
        this.rootNode = ((Node.Handle)in.readObject()).getNode();
        List exPaths = NbCollections.checkedListByCopy((List)((List)in.readObject()), String[].class, (boolean)true);
        ArrayList<String[]> selPaths = new ArrayList<String[]>();
        try {
            selPaths.addAll(NbCollections.checkedListByCopy((List)((List)in.readObject()), String[].class, (boolean)true));
        }
        catch (OptionalDataException optionalDataException) {
            // empty catch block
        }
        this.initValues();
        if (!"false".equals(System.getProperty("netbeans.keep.expansion"))) {
            KeepExpansion ke = new KeepExpansion(exPaths, selPaths);
            ke.task.schedule(0);
        }
    }

    protected void componentActivated() {
        ExplorerUtils.activateActions((ExplorerManager)this.manager, (boolean)true);
    }

    protected void componentDeactivated() {
        ExplorerUtils.activateActions((ExplorerManager)this.manager, (boolean)false);
    }

    private void startListening() {
        foSelection.addLookupListener(this.weakListener);
        doSelection.addLookupListener(this.weakListener);
        this.baseListener.resultChanged(null);
    }

    private void stopListening() {
        foSelection.removeLookupListener(this.weakListener);
        doSelection.removeLookupListener(this.weakListener);
    }

    protected void componentShowing() {
        super.componentShowing();
        this.startListening();
    }

    protected void componentHidden() {
        super.componentHidden();
        this.stopListening();
    }

    public void selectNodeAsync(FileObject object) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.open();
        this.requestActive();
        this.selectNodeAsyncNoSelect(object, true);
    }

    private RequestProcessor.Task createSelectionTask() {
        RequestProcessor.Task task = RP.create(new Runnable(){

            @Override
            public void run() {
                if (ProjectTab.this.objectToSelect == null) {
                    return;
                }
                ProjectsRootNode root = (ProjectsRootNode)ProjectTab.this.manager.getRootContext();
                Node tempNode = root.findNode(ProjectTab.this.objectToSelect);
                if (tempNode == null) {
                    Project project = FileOwnerQuery.getOwner((FileObject)ProjectTab.this.objectToSelect);
                    Project found = null;
                    while (true) {
                        if (project != null) {
                            for (Project p : OpenProjectList.getDefault().getOpenProjects()) {
                                if (!p.getProjectDirectory().equals(project.getProjectDirectory())) continue;
                                found = p;
                                break;
                            }
                        }
                        if (!(found instanceof LazyProject)) break;
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    }
                    tempNode = root.findNode(ProjectTab.this.objectToSelect);
                    if (ProjectTab.this.prompt && project != null && found == null) {
                        String message = NbBundle.getMessage(ProjectTab.class, (String)"MSG_openProject_confirm", (Object)ProjectUtils.getInformation((Project)project).getDisplayName());
                        String title = NbBundle.getMessage(ProjectTab.class, (String)"MSG_openProject_confirm_title");
                        NotifyDescriptor.Confirmation confirm = new NotifyDescriptor.Confirmation((Object)message, title, 2);
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)confirm);
                        if (confirm.getValue() == NotifyDescriptor.OK_OPTION) {
                            if (!OpenProjectList.getDefault().isOpen(project)) {
                                OpenProjects.getDefault().open(new Project[]{project}, false);
                                ProjectsRootNode.ProjectChildren.RP.post(new Runnable(){

                                    @Override
                                    public void run() {
                                    }
                                }).waitFinished();
                            }
                            tempNode = root.findNode(ProjectTab.this.objectToSelect);
                        }
                    }
                }
                final Node selectedNode = tempNode;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (selectedNode != null) {
                            try {
                                ProjectTab.this.manager.setSelectedNodes(new Node[]{selectedNode});
                                ProjectTab.this.btv.scrollToNode(selectedNode);
                                StatusDisplayer.getDefault().setStatusText("");
                            }
                            catch (PropertyVetoException propertyVetoException) {}
                        } else if (ProjectTab.this.prompt) {
                            try {
                                ProjectTab.this.manager.setSelectedNodes(new Node[0]);
                                StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(ProjectTab.class, (String)(ProjectTab.ID_LOGICAL.equals(ProjectTab.this.id) ? "MSG_NodeNotFound_ProjectsTab" : "MSG_NodeNotFound_FilesTab")));
                            }
                            catch (PropertyVetoException ex) {
                                Exceptions.printStackTrace((Throwable)ex);
                            }
                        }
                        ProjectTab.this.setCursor(null);
                    }
                });
            }
        });
        return task;
    }

    private void selectNodeAsyncNoSelect(FileObject object, boolean prompt) {
        this.objectToSelect = object;
        this.prompt = prompt;
        this.selectionTask.schedule(200);
    }

    Node findNode(FileObject object) {
        return ((ProjectsRootNode)this.manager.getRootContext()).findNode(object);
    }

    void selectNode(final Node node) {
        Mutex.EVENT.writeAccess(new Runnable(){

            @Override
            public void run() {
                try {
                    ProjectTab.this.manager.setSelectedNodes(new Node[]{node});
                    ProjectTab.this.btv.scrollToNode(node);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
        });
    }

    void expandNode(Node node) {
        this.btv.expandNode(node);
    }

    private List<String[]> getSelectedPaths() {
        ArrayList<String[]> result = new ArrayList<String[]>();
        Node root = this.manager.getRootContext();
        for (Node n : this.manager.getSelectedNodes()) {
            String[] path = NodeOp.createPath((Node)n, (Node)root);
            LOG.log(Level.FINE, "path from {0} to {1}: {2}", new Object[]{root, n, Arrays.asList(path)});
            if (path == null) continue;
            result.add(path);
        }
        return result;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("openProjects".equals(evt.getPropertyName())) {
            final boolean someProjectsOpen = OpenProjects.getDefault().getOpenProjects().length > 0;
            Mutex.EVENT.readAccess(new Runnable(){

                @Override
                public void run() {
                    if (someProjectsOpen) {
                        ProjectTab.this.restoreTreeView();
                    } else {
                        ProjectTab.this.showNoProjectsLabel();
                    }
                }
            });
        }
    }

    private void showNoProjectsLabel() {
        if (this.noProjectsLabel.isShowing()) {
            return;
        }
        this.remove((Component)((Object)this.btv));
        this.add(this.noProjectsLabel, "Center");
        this.revalidate();
        this.repaint();
    }

    private void restoreTreeView() {
        if (this.btv.isShowing()) {
            return;
        }
        this.remove(this.noProjectsLabel);
        this.add((Component)((Object)this.btv), "Center");
        this.revalidate();
        this.repaint();
    }

    private class ProjectTreeView
    extends BeanTreeView {
        private ProjectTreeView() {
        }

        public void scrollToNode(final Node n) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TreeNode tn = Visualizer.findVisualizer((Node)n);
                    if (tn == null) {
                        return;
                    }
                    TreeModel model = ProjectTreeView.this.tree.getModel();
                    if (!(model instanceof DefaultTreeModel)) {
                        return;
                    }
                    TreePath path = new TreePath(((DefaultTreeModel)model).getPathToRoot(tn));
                    Rectangle r = ProjectTreeView.this.tree.getPathBounds(path);
                    if (r != null) {
                        ProjectTreeView.this.tree.scrollRectToVisible(r);
                    }
                }
            });
        }

        public List<String[]> getExpandedPaths() {
            ArrayList<String[]> result = new ArrayList<String[]>();
            TreeNode rtn = Visualizer.findVisualizer((Node)ProjectTab.this.rootNode);
            TreePath tp = new TreePath(rtn);
            Enumeration<TreePath> exPaths = this.tree.getExpandedDescendants(tp);
            while (exPaths != null && exPaths.hasMoreElements()) {
                TreePath ep = exPaths.nextElement();
                Node en = Visualizer.findNode((Object)ep.getLastPathComponent());
                String[] path = NodeOp.createPath((Node)en, (Node)ProjectTab.this.rootNode);
                result.add(path);
            }
            return result;
        }

        public void expandNodes(List<String[]> exPaths) {
            for (Object[] objectArray : exPaths) {
                Node n;
                LOG.log(Level.FINE, "{0}: expanding {1}", new Object[]{ProjectTab.this.id, Arrays.asList(objectArray)});
                try {
                    n = NodeOp.findPath((Node)ProjectTab.this.rootNode, (String[])objectArray);
                }
                catch (NodeNotFoundException e) {
                    LOG.log(Level.FINE, "got {0}", e.toString());
                    n = e.getClosestNode();
                }
                if (n == null) {
                    LOG.log(Level.FINE, "nothing from {0} via {1}", new Object[]{ProjectTab.this.rootNode, Arrays.toString(objectArray)});
                    continue;
                }
                Node leafNode = n;
                EventQueue.invokeLater(new Runnable(){
                    final /* synthetic */ String[] val$sp;
                    final /* synthetic */ Node val$leafNode;
                    {
                        this.val$sp = stringArray;
                        this.val$leafNode = node;
                    }

                    @Override
                    public void run() {
                        Object[] tns = new TreeNode[this.val$sp.length + 1];
                        Node n = this.val$leafNode;
                        for (int i = this.val$sp.length; i >= 0; --i) {
                            if (n == null) {
                                LOG.log(Level.FINE, "lost parent node at #{0} from {1}", new Object[]{i, this.val$leafNode});
                                return;
                            }
                            tns[i] = Visualizer.findVisualizer((Node)n);
                            n = n.getParentNode();
                        }
                        ProjectTreeView.this.showPath(new TreePath(tns));
                    }
                });
            }
        }

        public void showOrHideNodeSelectionProjectPanel(final Node n, final Node sn) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TreeNode tn = Visualizer.findVisualizer((Node)n);
                    TreeNode tsn = Visualizer.findVisualizer((Node)sn);
                    if (tn == null || tsn == null) {
                        return;
                    }
                    TreeModel model = ProjectTreeView.this.tree.getModel();
                    if (!(model instanceof DefaultTreeModel)) {
                        return;
                    }
                    TreePath path = new TreePath(((DefaultTreeModel)model).getPathToRoot(tn));
                    TreePath snPath = new TreePath(((DefaultTreeModel)model).getPathToRoot(tsn));
                    Rectangle projectNodeCoordinates = ProjectTreeView.this.tree.getPathBounds(path);
                    Rectangle selectedNodeCoordinates = ProjectTreeView.this.tree.getPathBounds(snPath);
                    Rectangle prjTabScrollCoordinates = ProjectTreeView.this.tree.getVisibleRect();
                    Integer projectTabTopPos = prjTabScrollCoordinates.y;
                    Integer projectTabBottomPos = prjTabScrollCoordinates.y + prjTabScrollCoordinates.height + (ProjectTab.this.nodeSelectionProjectPanel.isMinimized() ? 0 : 22);
                    if (projectNodeCoordinates != null && selectedNodeCoordinates != null) {
                        Double projectNodePos = (double)projectNodeCoordinates.y + (double)projectNodeCoordinates.height * 0.5;
                        Double selectedNodePos = (double)selectedNodeCoordinates.y + (double)selectedNodeCoordinates.height * 0.5;
                        if ((double)projectTabTopPos.intValue() < projectNodePos && (double)projectTabBottomPos.intValue() > projectNodePos || (double)projectTabTopPos.intValue() > selectedNodePos || (double)projectTabBottomPos.intValue() < selectedNodePos || (double)(projectTabBottomPos + 1) < selectedNodePos || (double)(projectTabBottomPos - 1) < selectedNodePos) {
                            ProjectTab.this.nodeSelectionProjectPanel.minimize();
                        } else {
                            ProjectTab.this.nodeSelectionProjectPanel.maximize();
                        }
                    } else {
                        ProjectTab.this.nodeSelectionProjectPanel.minimize();
                    }
                }
            });
        }
    }

    private class LabelPopupDisplayer
    extends MouseAdapter {
        private final Component component;

        public LabelPopupDisplayer(Component comp) {
            this.component = comp;
        }

        private void showPopup(int x, int y) {
            Action[] actions = ProjectTab.this.rootNode.getActions(false);
            JPopupMenu popup = Utilities.actionsToPopup((Action[])actions, (Component)this.component);
            popup.show(this.component, x, y);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger() && ProjectTab.this.id.equals(ProjectTab.ID_LOGICAL)) {
                this.showPopup(e.getX(), e.getY());
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger() && ProjectTab.this.id.equals(ProjectTab.ID_LOGICAL)) {
                this.showPopup(e.getX(), e.getY());
            }
        }
    }

    private class NbPrefsListener
    implements PreferenceChangeListener {
        private NbPrefsListener() {
        }

        @Override
        public void preferenceChange(PreferenceChangeEvent evt) {
            if ("synchronizeEditorWithViews".equals(evt.getKey())) {
                ProjectTab.this.synchronizeViews = Boolean.parseBoolean(evt.getNewValue());
            }
        }
    }

    private class ActualSelectionProject
    implements PropertyChangeListener,
    ChangeListener {
        private final JPanel selectionsProjectPanel;
        private JLabel actualProjectLabel;
        private Node[] lastSelectedNodes;

        public ActualSelectionProject(JPanel selectionsProjectPanel) {
            this.selectionsProjectPanel = selectionsProjectPanel;
            this.actualProjectLabel = new JLabel(Bundle.MSG_none_node_selected());
            this.setSelectionLabelProperties(null);
            this.selectionsProjectPanel.add(this.actualProjectLabel);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("selectedNodes") && NodeSelectionProjectPanel.prefs.getBoolean("enable.actualselectionproject", false)) {
                this.lastSelectedNodes = (Node[])evt.getNewValue();
                this.performChange(this.lastSelectedNodes);
            }
        }

        private void performChange(Node[] selectedNodes) {
            String text = "";
            Node projectNode = null;
            if (selectedNodes != null && selectedNodes.length > 0) {
                Node selectedNode = selectedNodes[0];
                Node originallySelectedNode = selectedNodes[0];
                Node rootNode = ProjectTab.this.manager.getRootContext();
                while (selectedNode.getParentNode() != null && !selectedNode.getParentNode().equals((Object)rootNode)) {
                    selectedNode = selectedNode.getParentNode();
                }
                projectNode = selectedNode;
                if (selectedNodes.length > 1) {
                    for (int i = 1; i < selectedNodes.length; ++i) {
                        selectedNode = selectedNodes[i];
                        while (!selectedNode.getParentNode().equals((Object)rootNode)) {
                            selectedNode = selectedNode.getParentNode();
                        }
                        if (projectNode.equals((Object)selectedNode)) continue;
                        projectNode = null;
                        text = Bundle.MSG_nodes_from_more_projects();
                        break;
                    }
                }
                if (projectNode != null) {
                    ProjectTab.this.btv.showOrHideNodeSelectionProjectPanel(projectNode, originallySelectedNode);
                    text = projectNode.getDisplayName();
                }
            } else {
                text = Bundle.MSG_none_node_selected();
            }
            if (this.actualProjectLabel != null) {
                this.actualProjectLabel.setText(text);
                this.setSelectionLabelProperties(projectNode);
            } else {
                this.actualProjectLabel = new JLabel(text);
                this.setSelectionLabelProperties(projectNode);
                this.selectionsProjectPanel.add(this.actualProjectLabel);
            }
        }

        private void setSelectionLabelProperties(Node projectNode) {
            if (projectNode != null) {
                this.actualProjectLabel.setIcon(ImageUtilities.image2Icon((Image)projectNode.getIcon(1)));
            } else {
                this.actualProjectLabel.setIcon(null);
            }
            this.actualProjectLabel.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 0));
        }

        @Override
        public void stateChanged(ChangeEvent evt) {
            if (NodeSelectionProjectPanel.prefs.getBoolean("enable.actualselectionproject", false)) {
                this.performChange(this.lastSelectedNodes);
            }
        }
    }

    private class KeepExpansion
    implements Runnable {
        final RequestProcessor.Task task;
        final List<String[]> exPaths;
        final List<String[]> selPaths;

        KeepExpansion(List<String[]> exPaths, List<String[]> selPaths) {
            this.exPaths = exPaths;
            this.selPaths = selPaths;
            this.task = RP.create((Runnable)this);
        }

        @Override
        public void run() {
            try {
                LOG.log(Level.FINE, "{0}: waiting for projects being open", ProjectTab.this.id);
                OpenProjects.getDefault().openProjects().get(10L, TimeUnit.SECONDS);
            }
            catch (TimeoutException ex) {
                LOG.log(Level.FINE, "{0}: Timeout. Will retry in a second", ProjectTab.this.id);
                this.task.schedule(1000);
                return;
            }
            catch (ExecutionException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (InterruptedException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            LOG.log(Level.FINE, "{0}: Checking node state", ProjectTab.this.id);
            for (Node n : ProjectTab.this.rootNode.getChildren().getNodes()) {
                if (!ProjectTab.this.btv.isExpanded(n)) continue;
                LOG.log(Level.FINE, "{0}: Node {1} has been expanded. Giving up.", new Object[]{ProjectTab.this.id, n});
                return;
            }
            LOG.log(Level.FINE, "{0}: expanding paths", ProjectTab.this.id);
            ProjectTab.this.btv.expandNodes(this.exPaths);
            LOG.log(Level.FINE, "{0}: selecting paths", ProjectTab.this.id);
            final ArrayList<Node> selectedNodes = new ArrayList<Node>();
            Node root = ProjectTab.this.manager.getRootContext();
            for (String[] sp : this.selPaths) {
                LOG.log(Level.FINE, "{0}: selecting {1}", new Object[]{ProjectTab.this.id, Arrays.asList(sp)});
                try {
                    Node n = NodeOp.findPath((Node)root, (String[])sp);
                    if (n == null) continue;
                    selectedNodes.add(n);
                }
                catch (NodeNotFoundException x) {
                    LOG.log(Level.FINE, null, x);
                }
            }
            if (!selectedNodes.isEmpty()) {
                LOG.log(Level.FINE, "{0}: Switching to AWT", ProjectTab.this.id);
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            ProjectTab.this.manager.setSelectedNodes((Node[])selectedNodes.toArray(Node[]::new));
                        }
                        catch (PropertyVetoException x) {
                            LOG.log(Level.FINE, null, x);
                        }
                        LOG.log(Level.FINE, "{0}: done.", ProjectTab.this.id);
                    }
                });
            }
        }
    }

    public static class NodeSelectionProjectAction
    extends BooleanStateAction {
        public String getName() {
            return NbBundle.getMessage(NodeSelectionProjectAction.class, (String)"CTL_MenuItem_NodeSelectionProjectAction");
        }

        public boolean isEnabled() {
            return true;
        }

        public boolean getBooleanState() {
            return NodeSelectionProjectPanel.prefs.getBoolean("enable.actualselectionproject", false);
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx(NodeSelectionProjectAction.class);
        }

        public void actionPerformed(ActionEvent e) {
            boolean show = NodeSelectionProjectPanel.prefs.getBoolean("enable.actualselectionproject", false);
            NodeSelectionProjectPanel.prefs.putBoolean("enable.actualselectionproject", !show);
        }
    }

    public static class CollapseAll
    implements ActionListener {
        private final String type;

        public CollapseAll(String type) {
            this.type = type;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            RP.post(new Runnable(){

                @Override
                public void run() {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            final ProjectTab tab = ProjectTab.findDefault(type);
                            final Children children = tab.manager.getRootContext().getChildren();
                            for (Node root : children.getNodes()) {
                                if (!tab.btv.isExpanded(root)) continue;
                                this.collapseNodes(root, tab);
                                tab.btv.collapseNode(root);
                            }
                            Mutex.EVENT.writeAccess(new Runnable(){

                                @Override
                                public void run() {
                                    Project projectOwner;
                                    FileObject activeFile = null;
                                    for (TopComponent componentIter : TopComponent.getRegistry().getOpened()) {
                                        if (!componentIter.isVisible() || componentIter.getLookup().lookup(FileObject.class) == null) continue;
                                        activeFile = (FileObject)componentIter.getLookup().lookup(FileObject.class);
                                        break;
                                    }
                                    if (activeFile != null && (projectOwner = FileOwnerQuery.getOwner(activeFile)) != null) {
                                        Node projectNode = null;
                                        for (Node node : children.getNodes(true)) {
                                            if (!projectOwner.equals(node.getLookup().lookup(Project.class))) continue;
                                            projectNode = node;
                                            break;
                                        }
                                        if (projectNode != null) {
                                            try {
                                                tab.manager.setSelectedNodes(new Node[]{projectNode});
                                                tab.btv.scrollToNode(projectNode);
                                            }
                                            catch (PropertyVetoException pve) {
                                                Logger.getLogger(ProjectTab.class.getName()).log(Level.WARNING, null, pve);
                                            }
                                        }
                                    }
                                }
                            });
                        }
                    });
                }
            });
        }

        private void collapseNodes(Node node, ProjectTab tab) {
            if (node.getChildren().getNodesCount() != 0) {
                for (Node nodeIter : node.getChildren().getNodes()) {
                    if (!tab.btv.isExpanded(nodeIter)) continue;
                    this.collapseNodes(nodeIter, tab);
                    tab.btv.collapseNode(nodeIter);
                }
            }
        }
    }
}

