/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.symfony2.ui.actions;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.csl.api.UiUtils;
import org.netbeans.modules.php.api.editor.EditorSupport;
import org.netbeans.modules.php.api.editor.PhpClass;
import org.netbeans.modules.php.api.editor.PhpType;
import org.netbeans.modules.php.api.phpmodule.PhpModule;
import org.netbeans.modules.php.spi.framework.actions.GoToActionAction;
import org.netbeans.modules.php.symfony2.util.SymfonyUtils;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;

final class SymfonyGoToActionAction
extends GoToActionAction {
    private static final Logger LOGGER = Logger.getLogger(SymfonyGoToActionAction.class.getName());
    private final PhpModule phpModule;
    private final FileObject view;

    SymfonyGoToActionAction(PhpModule phpModule, FileObject view) {
        assert (phpModule != null);
        assert (view != null);
        this.phpModule = phpModule;
        this.view = view;
    }

    public boolean goToAction() {
        FileObject sources = this.phpModule.getSourceDirectory();
        if (sources == null) {
            LOGGER.log(Level.INFO, "No Source Files for project {0}", this.phpModule.getDisplayName());
            return false;
        }
        FileObject controller = SymfonyUtils.getController(sources, this.view);
        if (controller != null) {
            UiUtils.open((FileObject)controller, (int)this.getActionMethodOffset(controller));
            return true;
        }
        return false;
    }

    private int getActionMethodOffset(FileObject controller) {
        String actionMethodName = SymfonyUtils.getActionMethodName(this.view.getName());
        EditorSupport editorSupport = (EditorSupport)Lookup.getDefault().lookup(EditorSupport.class);
        int firstClassOffset = -1;
        for (PhpClass phpClass : editorSupport.getClasses(controller)) {
            if (phpClass.getName().equals(controller.getName())) {
                for (PhpType.Method method : phpClass.getMethods()) {
                    if (!actionMethodName.equals(method.getName())) continue;
                    return method.getOffset();
                }
                return phpClass.getOffset();
            }
            if (firstClassOffset != -1) continue;
            firstClassOffset = phpClass.getOffset();
        }
        if (firstClassOffset != -1) {
            return firstClassOffset;
        }
        return 0;
    }
}

