/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.vue.editor.lexer;

import org.antlr.v4.runtime.Lexer;
import org.netbeans.api.lexer.Token;
import org.netbeans.modules.javascript2.vue.editor.lexer.VueTokenId;
import org.netbeans.modules.javascript2.vue.grammar.antlr4.coloring.VueAntlrColoringLexer;
import org.netbeans.spi.lexer.LexerRestartInfo;
import org.netbeans.spi.lexer.antlr4.AbstractAntlrLexerBridge;

public class VueLexer
extends AbstractAntlrLexerBridge<VueAntlrColoringLexer, VueTokenId> {
    public static final String PUG_LANG = "pug";
    public static final String JADE_LANG = "jade";
    public static final String SCSS_LANG = "scss";
    public static final String LESS_LANG = "less";

    public VueLexer(LexerRestartInfo<VueTokenId> info) {
        super(info, VueAntlrColoringLexer::new);
    }

    public Object state() {
        return new State((VueAntlrColoringLexer)this.lexer);
    }

    protected Token<VueTokenId> mapToken(org.antlr.v4.runtime.Token antlrToken) {
        return switch (antlrToken.getType()) {
            case 7 -> this.groupToken(VueTokenId.HTML, 7);
            case 2 -> this.token(VueTokenId.VUE_DIRECTIVE);
            case 3 -> this.token(VueTokenId.QUOTE_ATTR);
            case 10 -> this.token(VueTokenId.VAR_TAG);
            case 5 -> this.groupToken(VueTokenId.JAVASCRIPT_ATTR, 5);
            case 6 -> this.groupToken(VueTokenId.JAVASCRIPT_INTERP, 6);
            case 4 -> this.assignScriptLexerToken(VueTokenId.JAVASCRIPT, 4);
            case 8 -> this.assignStyleLexerToken(VueTokenId.CSS, 8);
            default -> this.groupToken(VueTokenId.HTML, 7);
        };
    }

    private Token<VueTokenId> assignScriptLexerToken(VueTokenId id, int antlrTokenType) {
        State currentState = (State)((Object)this.state());
        String scriptLang = currentState.getScriptLanguageState();
        if (scriptLang == null) {
            return this.groupToken(id, antlrTokenType);
        }
        return switch (scriptLang) {
            case JADE_LANG, PUG_LANG -> this.groupToken(VueTokenId.JAVASCRIPT_PUG, antlrTokenType);
            default -> this.groupToken(id, antlrTokenType);
        };
    }

    private Token<VueTokenId> assignStyleLexerToken(VueTokenId id, int antlrTokenType) {
        State currentState = (State)((Object)this.state());
        String styleLang = currentState.getStyleLanguageState();
        if (styleLang == null) {
            return this.groupToken(id, antlrTokenType);
        }
        return switch (styleLang) {
            case SCSS_LANG -> this.groupToken(VueTokenId.STYLE_SCSS, antlrTokenType);
            case LESS_LANG -> this.groupToken(VueTokenId.STYLE_LESS, antlrTokenType);
            default -> this.groupToken(id, antlrTokenType);
        };
    }

    private static class State
    extends AbstractAntlrLexerBridge.LexerState<VueAntlrColoringLexer> {
        final boolean attrQuoteOpened;
        final boolean varInterpolationOpened;
        final String scriptLanguage;
        final String styleLanguage;

        public State(VueAntlrColoringLexer lexer) {
            super((Lexer)lexer);
            this.attrQuoteOpened = lexer.getAttrQuoteState();
            this.varInterpolationOpened = lexer.isVarInterpolationOpened();
            this.scriptLanguage = lexer.getScriptLanguage();
            this.styleLanguage = lexer.getStyleLanguage();
        }

        public void restore(VueAntlrColoringLexer lexer) {
            super.restore((Lexer)lexer);
            lexer.setAttrQuoteState(this.attrQuoteOpened);
            lexer.setVarInterpolationOpened(this.varInterpolationOpened);
            lexer.setScriptLanguage(this.scriptLanguage);
            lexer.setStyleLanguage(this.styleLanguage);
        }

        public String getScriptLanguageState() {
            return this.scriptLanguage;
        }

        public String getStyleLanguageState() {
            return this.styleLanguage;
        }
    }
}

