/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class DbSystemUpgradeHistoryEntry
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="action")
    private final Action action;
    @JsonProperty(value="newGiVersion")
    private final String newGiVersion;
    @JsonProperty(value="oldGiVersion")
    private final String oldGiVersion;
    @JsonProperty(value="snapshotRetentionPeriodInDays")
    private final Integer snapshotRetentionPeriodInDays;
    @JsonProperty(value="lifecycleState")
    private final LifecycleState lifecycleState;
    @JsonProperty(value="lifecycleDetails")
    private final String lifecycleDetails;
    @JsonProperty(value="timeStarted")
    private final Date timeStarted;
    @JsonProperty(value="timeEnded")
    private final Date timeEnded;

    @Deprecated
    @ConstructorProperties(value={"id", "action", "newGiVersion", "oldGiVersion", "snapshotRetentionPeriodInDays", "lifecycleState", "lifecycleDetails", "timeStarted", "timeEnded"})
    public DbSystemUpgradeHistoryEntry(String id, Action action, String newGiVersion, String oldGiVersion, Integer snapshotRetentionPeriodInDays, LifecycleState lifecycleState, String lifecycleDetails, Date timeStarted, Date timeEnded) {
        this.id = id;
        this.action = action;
        this.newGiVersion = newGiVersion;
        this.oldGiVersion = oldGiVersion;
        this.snapshotRetentionPeriodInDays = snapshotRetentionPeriodInDays;
        this.lifecycleState = lifecycleState;
        this.lifecycleDetails = lifecycleDetails;
        this.timeStarted = timeStarted;
        this.timeEnded = timeEnded;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public Action getAction() {
        return this.action;
    }

    public String getNewGiVersion() {
        return this.newGiVersion;
    }

    public String getOldGiVersion() {
        return this.oldGiVersion;
    }

    public Integer getSnapshotRetentionPeriodInDays() {
        return this.snapshotRetentionPeriodInDays;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String getLifecycleDetails() {
        return this.lifecycleDetails;
    }

    public Date getTimeStarted() {
        return this.timeStarted;
    }

    public Date getTimeEnded() {
        return this.timeEnded;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("DbSystemUpgradeHistoryEntry(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", action=").append(String.valueOf((Object)this.action));
        sb.append(", newGiVersion=").append(String.valueOf(this.newGiVersion));
        sb.append(", oldGiVersion=").append(String.valueOf(this.oldGiVersion));
        sb.append(", snapshotRetentionPeriodInDays=").append(String.valueOf(this.snapshotRetentionPeriodInDays));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", lifecycleDetails=").append(String.valueOf(this.lifecycleDetails));
        sb.append(", timeStarted=").append(String.valueOf(this.timeStarted));
        sb.append(", timeEnded=").append(String.valueOf(this.timeEnded));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DbSystemUpgradeHistoryEntry)) {
            return false;
        }
        DbSystemUpgradeHistoryEntry other = (DbSystemUpgradeHistoryEntry)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals((Object)this.action, (Object)other.action) && Objects.equals(this.newGiVersion, other.newGiVersion) && Objects.equals(this.oldGiVersion, other.oldGiVersion) && Objects.equals(this.snapshotRetentionPeriodInDays, other.snapshotRetentionPeriodInDays) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.lifecycleDetails, other.lifecycleDetails) && Objects.equals(this.timeStarted, other.timeStarted) && Objects.equals(this.timeEnded, other.timeEnded) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.action == null ? 43 : this.action.hashCode());
        result = result * 59 + (this.newGiVersion == null ? 43 : this.newGiVersion.hashCode());
        result = result * 59 + (this.oldGiVersion == null ? 43 : this.oldGiVersion.hashCode());
        result = result * 59 + (this.snapshotRetentionPeriodInDays == null ? 43 : this.snapshotRetentionPeriodInDays.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.lifecycleDetails == null ? 43 : this.lifecycleDetails.hashCode());
        result = result * 59 + (this.timeStarted == null ? 43 : this.timeStarted.hashCode());
        result = result * 59 + (this.timeEnded == null ? 43 : this.timeEnded.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum LifecycleState implements BmcEnum
    {
        InProgress("IN_PROGRESS"),
        Succeeded("SUCCEEDED"),
        Failed("FAILED"),
        NeedsAttention("NEEDS_ATTENTION"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, LifecycleState> map;

        private LifecycleState(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LifecycleState create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'LifecycleState', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(LifecycleState.class);
            map = new HashMap<String, LifecycleState>();
            for (LifecycleState v : LifecycleState.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum Action implements BmcEnum
    {
        Precheck("PRECHECK"),
        Rollback("ROLLBACK"),
        UpdateSnapshotRetentionDays("UPDATE_SNAPSHOT_RETENTION_DAYS"),
        Upgrade("UPGRADE"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Action> map;

        private Action(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Action create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Action', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Action.class);
            map = new HashMap<String, Action>();
            for (Action v : Action.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="action")
        private Action action;
        @JsonProperty(value="newGiVersion")
        private String newGiVersion;
        @JsonProperty(value="oldGiVersion")
        private String oldGiVersion;
        @JsonProperty(value="snapshotRetentionPeriodInDays")
        private Integer snapshotRetentionPeriodInDays;
        @JsonProperty(value="lifecycleState")
        private LifecycleState lifecycleState;
        @JsonProperty(value="lifecycleDetails")
        private String lifecycleDetails;
        @JsonProperty(value="timeStarted")
        private Date timeStarted;
        @JsonProperty(value="timeEnded")
        private Date timeEnded;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder action(Action action) {
            this.action = action;
            this.__explicitlySet__.add("action");
            return this;
        }

        public Builder newGiVersion(String newGiVersion) {
            this.newGiVersion = newGiVersion;
            this.__explicitlySet__.add("newGiVersion");
            return this;
        }

        public Builder oldGiVersion(String oldGiVersion) {
            this.oldGiVersion = oldGiVersion;
            this.__explicitlySet__.add("oldGiVersion");
            return this;
        }

        public Builder snapshotRetentionPeriodInDays(Integer snapshotRetentionPeriodInDays) {
            this.snapshotRetentionPeriodInDays = snapshotRetentionPeriodInDays;
            this.__explicitlySet__.add("snapshotRetentionPeriodInDays");
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder lifecycleDetails(String lifecycleDetails) {
            this.lifecycleDetails = lifecycleDetails;
            this.__explicitlySet__.add("lifecycleDetails");
            return this;
        }

        public Builder timeStarted(Date timeStarted) {
            this.timeStarted = timeStarted;
            this.__explicitlySet__.add("timeStarted");
            return this;
        }

        public Builder timeEnded(Date timeEnded) {
            this.timeEnded = timeEnded;
            this.__explicitlySet__.add("timeEnded");
            return this;
        }

        public DbSystemUpgradeHistoryEntry build() {
            DbSystemUpgradeHistoryEntry model = new DbSystemUpgradeHistoryEntry(this.id, this.action, this.newGiVersion, this.oldGiVersion, this.snapshotRetentionPeriodInDays, this.lifecycleState, this.lifecycleDetails, this.timeStarted, this.timeEnded);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(DbSystemUpgradeHistoryEntry model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("action")) {
                this.action(model.getAction());
            }
            if (model.wasPropertyExplicitlySet("newGiVersion")) {
                this.newGiVersion(model.getNewGiVersion());
            }
            if (model.wasPropertyExplicitlySet("oldGiVersion")) {
                this.oldGiVersion(model.getOldGiVersion());
            }
            if (model.wasPropertyExplicitlySet("snapshotRetentionPeriodInDays")) {
                this.snapshotRetentionPeriodInDays(model.getSnapshotRetentionPeriodInDays());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("lifecycleDetails")) {
                this.lifecycleDetails(model.getLifecycleDetails());
            }
            if (model.wasPropertyExplicitlySet("timeStarted")) {
                this.timeStarted(model.getTimeStarted());
            }
            if (model.wasPropertyExplicitlySet("timeEnded")) {
                this.timeEnded(model.getTimeEnded());
            }
            return this;
        }
    }
}

