/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class InfrastructureTargetVersionSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="targetDbVersionHistoryEntry")
    private final List<String> targetDbVersionHistoryEntry;
    @JsonProperty(value="targetStorageVersionHistoryEntry")
    private final List<String> targetStorageVersionHistoryEntry;
    @JsonProperty(value="targetResourceType")
    private final TargetResourceType targetResourceType;
    @JsonProperty(value="targetResourceId")
    private final String targetResourceId;

    @Deprecated
    @ConstructorProperties(value={"targetDbVersionHistoryEntry", "targetStorageVersionHistoryEntry", "targetResourceType", "targetResourceId"})
    public InfrastructureTargetVersionSummary(List<String> targetDbVersionHistoryEntry, List<String> targetStorageVersionHistoryEntry, TargetResourceType targetResourceType, String targetResourceId) {
        this.targetDbVersionHistoryEntry = targetDbVersionHistoryEntry;
        this.targetStorageVersionHistoryEntry = targetStorageVersionHistoryEntry;
        this.targetResourceType = targetResourceType;
        this.targetResourceId = targetResourceId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public List<String> getTargetDbVersionHistoryEntry() {
        return this.targetDbVersionHistoryEntry;
    }

    public List<String> getTargetStorageVersionHistoryEntry() {
        return this.targetStorageVersionHistoryEntry;
    }

    public TargetResourceType getTargetResourceType() {
        return this.targetResourceType;
    }

    public String getTargetResourceId() {
        return this.targetResourceId;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("InfrastructureTargetVersionSummary(");
        sb.append("super=").append(super.toString());
        sb.append("targetDbVersionHistoryEntry=").append(String.valueOf(this.targetDbVersionHistoryEntry));
        sb.append(", targetStorageVersionHistoryEntry=").append(String.valueOf(this.targetStorageVersionHistoryEntry));
        sb.append(", targetResourceType=").append(String.valueOf((Object)this.targetResourceType));
        sb.append(", targetResourceId=").append(String.valueOf(this.targetResourceId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InfrastructureTargetVersionSummary)) {
            return false;
        }
        InfrastructureTargetVersionSummary other = (InfrastructureTargetVersionSummary)((Object)o);
        return Objects.equals(this.targetDbVersionHistoryEntry, other.targetDbVersionHistoryEntry) && Objects.equals(this.targetStorageVersionHistoryEntry, other.targetStorageVersionHistoryEntry) && Objects.equals((Object)this.targetResourceType, (Object)other.targetResourceType) && Objects.equals(this.targetResourceId, other.targetResourceId) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.targetDbVersionHistoryEntry == null ? 43 : this.targetDbVersionHistoryEntry.hashCode());
        result = result * 59 + (this.targetStorageVersionHistoryEntry == null ? 43 : this.targetStorageVersionHistoryEntry.hashCode());
        result = result * 59 + (this.targetResourceType == null ? 43 : this.targetResourceType.hashCode());
        result = result * 59 + (this.targetResourceId == null ? 43 : this.targetResourceId.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum TargetResourceType implements BmcEnum
    {
        ExadataDbSystem("EXADATA_DB_SYSTEM"),
        CloudExadataInfrastructure("CLOUD_EXADATA_INFRASTRUCTURE"),
        ExaccInfrastructure("EXACC_INFRASTRUCTURE");

        private final String value;
        private static Map<String, TargetResourceType> map;

        private TargetResourceType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static TargetResourceType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid TargetResourceType: " + key);
        }

        static {
            map = new HashMap<String, TargetResourceType>();
            for (TargetResourceType v : TargetResourceType.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="targetDbVersionHistoryEntry")
        private List<String> targetDbVersionHistoryEntry;
        @JsonProperty(value="targetStorageVersionHistoryEntry")
        private List<String> targetStorageVersionHistoryEntry;
        @JsonProperty(value="targetResourceType")
        private TargetResourceType targetResourceType;
        @JsonProperty(value="targetResourceId")
        private String targetResourceId;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder targetDbVersionHistoryEntry(List<String> targetDbVersionHistoryEntry) {
            this.targetDbVersionHistoryEntry = targetDbVersionHistoryEntry;
            this.__explicitlySet__.add("targetDbVersionHistoryEntry");
            return this;
        }

        public Builder targetStorageVersionHistoryEntry(List<String> targetStorageVersionHistoryEntry) {
            this.targetStorageVersionHistoryEntry = targetStorageVersionHistoryEntry;
            this.__explicitlySet__.add("targetStorageVersionHistoryEntry");
            return this;
        }

        public Builder targetResourceType(TargetResourceType targetResourceType) {
            this.targetResourceType = targetResourceType;
            this.__explicitlySet__.add("targetResourceType");
            return this;
        }

        public Builder targetResourceId(String targetResourceId) {
            this.targetResourceId = targetResourceId;
            this.__explicitlySet__.add("targetResourceId");
            return this;
        }

        public InfrastructureTargetVersionSummary build() {
            InfrastructureTargetVersionSummary model = new InfrastructureTargetVersionSummary(this.targetDbVersionHistoryEntry, this.targetStorageVersionHistoryEntry, this.targetResourceType, this.targetResourceId);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(InfrastructureTargetVersionSummary model) {
            if (model.wasPropertyExplicitlySet("targetDbVersionHistoryEntry")) {
                this.targetDbVersionHistoryEntry(model.getTargetDbVersionHistoryEntry());
            }
            if (model.wasPropertyExplicitlySet("targetStorageVersionHistoryEntry")) {
                this.targetStorageVersionHistoryEntry(model.getTargetStorageVersionHistoryEntry());
            }
            if (model.wasPropertyExplicitlySet("targetResourceType")) {
                this.targetResourceType(model.getTargetResourceType());
            }
            if (model.wasPropertyExplicitlySet("targetResourceId")) {
                this.targetResourceId(model.getTargetResourceId());
            }
            return this;
        }
    }
}

