/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.core.model.ImageSourceDetails;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="sourceType")
@JsonFilter(value="explicitlySetFilter")
public final class ImageSourceViaObjectStorageTupleDetails
extends ImageSourceDetails {
    @JsonProperty(value="bucketName")
    private final String bucketName;
    @JsonProperty(value="namespaceName")
    private final String namespaceName;
    @JsonProperty(value="objectName")
    private final String objectName;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public ImageSourceViaObjectStorageTupleDetails(String operatingSystem, String operatingSystemVersion, ImageSourceDetails.SourceImageType sourceImageType, String bucketName, String namespaceName, String objectName) {
        super(operatingSystem, operatingSystemVersion, sourceImageType);
        this.bucketName = bucketName;
        this.namespaceName = namespaceName;
        this.objectName = objectName;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getObjectName() {
        return this.objectName;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ImageSourceViaObjectStorageTupleDetails(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", bucketName=").append(String.valueOf(this.bucketName));
        sb.append(", namespaceName=").append(String.valueOf(this.namespaceName));
        sb.append(", objectName=").append(String.valueOf(this.objectName));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ImageSourceViaObjectStorageTupleDetails)) {
            return false;
        }
        ImageSourceViaObjectStorageTupleDetails other = (ImageSourceViaObjectStorageTupleDetails)((Object)o);
        return Objects.equals(this.bucketName, other.bucketName) && Objects.equals(this.namespaceName, other.namespaceName) && Objects.equals(this.objectName, other.objectName) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.bucketName == null ? 43 : this.bucketName.hashCode());
        result = result * 59 + (this.namespaceName == null ? 43 : this.namespaceName.hashCode());
        result = result * 59 + (this.objectName == null ? 43 : this.objectName.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="operatingSystem")
        private String operatingSystem;
        @JsonProperty(value="operatingSystemVersion")
        private String operatingSystemVersion;
        @JsonProperty(value="sourceImageType")
        private ImageSourceDetails.SourceImageType sourceImageType;
        @JsonProperty(value="bucketName")
        private String bucketName;
        @JsonProperty(value="namespaceName")
        private String namespaceName;
        @JsonProperty(value="objectName")
        private String objectName;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder operatingSystem(String operatingSystem) {
            this.operatingSystem = operatingSystem;
            this.__explicitlySet__.add("operatingSystem");
            return this;
        }

        public Builder operatingSystemVersion(String operatingSystemVersion) {
            this.operatingSystemVersion = operatingSystemVersion;
            this.__explicitlySet__.add("operatingSystemVersion");
            return this;
        }

        public Builder sourceImageType(ImageSourceDetails.SourceImageType sourceImageType) {
            this.sourceImageType = sourceImageType;
            this.__explicitlySet__.add("sourceImageType");
            return this;
        }

        public Builder bucketName(String bucketName) {
            this.bucketName = bucketName;
            this.__explicitlySet__.add("bucketName");
            return this;
        }

        public Builder namespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            this.__explicitlySet__.add("namespaceName");
            return this;
        }

        public Builder objectName(String objectName) {
            this.objectName = objectName;
            this.__explicitlySet__.add("objectName");
            return this;
        }

        public ImageSourceViaObjectStorageTupleDetails build() {
            ImageSourceViaObjectStorageTupleDetails model = new ImageSourceViaObjectStorageTupleDetails(this.operatingSystem, this.operatingSystemVersion, this.sourceImageType, this.bucketName, this.namespaceName, this.objectName);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ImageSourceViaObjectStorageTupleDetails model) {
            if (model.wasPropertyExplicitlySet("operatingSystem")) {
                this.operatingSystem(model.getOperatingSystem());
            }
            if (model.wasPropertyExplicitlySet("operatingSystemVersion")) {
                this.operatingSystemVersion(model.getOperatingSystemVersion());
            }
            if (model.wasPropertyExplicitlySet("sourceImageType")) {
                this.sourceImageType(model.getSourceImageType());
            }
            if (model.wasPropertyExplicitlySet("bucketName")) {
                this.bucketName(model.getBucketName());
            }
            if (model.wasPropertyExplicitlySet("namespaceName")) {
                this.namespaceName(model.getNamespaceName());
            }
            if (model.wasPropertyExplicitlySet("objectName")) {
                this.objectName(model.getObjectName());
            }
            return this;
        }
    }
}

