/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class UpdateInstanceShapeConfigDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="ocpus")
    private final Float ocpus;
    @JsonProperty(value="vcpus")
    private final Integer vcpus;
    @JsonProperty(value="memoryInGBs")
    private final Float memoryInGBs;
    @JsonProperty(value="baselineOcpuUtilization")
    private final BaselineOcpuUtilization baselineOcpuUtilization;
    @JsonProperty(value="nvmes")
    private final Integer nvmes;

    @Deprecated
    @ConstructorProperties(value={"ocpus", "vcpus", "memoryInGBs", "baselineOcpuUtilization", "nvmes"})
    public UpdateInstanceShapeConfigDetails(Float ocpus, Integer vcpus, Float memoryInGBs, BaselineOcpuUtilization baselineOcpuUtilization, Integer nvmes) {
        this.ocpus = ocpus;
        this.vcpus = vcpus;
        this.memoryInGBs = memoryInGBs;
        this.baselineOcpuUtilization = baselineOcpuUtilization;
        this.nvmes = nvmes;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Float getOcpus() {
        return this.ocpus;
    }

    public Integer getVcpus() {
        return this.vcpus;
    }

    public Float getMemoryInGBs() {
        return this.memoryInGBs;
    }

    public BaselineOcpuUtilization getBaselineOcpuUtilization() {
        return this.baselineOcpuUtilization;
    }

    public Integer getNvmes() {
        return this.nvmes;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("UpdateInstanceShapeConfigDetails(");
        sb.append("super=").append(super.toString());
        sb.append("ocpus=").append(String.valueOf(this.ocpus));
        sb.append(", vcpus=").append(String.valueOf(this.vcpus));
        sb.append(", memoryInGBs=").append(String.valueOf(this.memoryInGBs));
        sb.append(", baselineOcpuUtilization=").append(String.valueOf((Object)this.baselineOcpuUtilization));
        sb.append(", nvmes=").append(String.valueOf(this.nvmes));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateInstanceShapeConfigDetails)) {
            return false;
        }
        UpdateInstanceShapeConfigDetails other = (UpdateInstanceShapeConfigDetails)((Object)o);
        return Objects.equals(this.ocpus, other.ocpus) && Objects.equals(this.vcpus, other.vcpus) && Objects.equals(this.memoryInGBs, other.memoryInGBs) && Objects.equals((Object)this.baselineOcpuUtilization, (Object)other.baselineOcpuUtilization) && Objects.equals(this.nvmes, other.nvmes) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.ocpus == null ? 43 : this.ocpus.hashCode());
        result = result * 59 + (this.vcpus == null ? 43 : this.vcpus.hashCode());
        result = result * 59 + (this.memoryInGBs == null ? 43 : this.memoryInGBs.hashCode());
        result = result * 59 + (this.baselineOcpuUtilization == null ? 43 : this.baselineOcpuUtilization.hashCode());
        result = result * 59 + (this.nvmes == null ? 43 : this.nvmes.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum BaselineOcpuUtilization implements BmcEnum
    {
        Baseline18("BASELINE_1_8"),
        Baseline12("BASELINE_1_2"),
        Baseline11("BASELINE_1_1");

        private final String value;
        private static Map<String, BaselineOcpuUtilization> map;

        private BaselineOcpuUtilization(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static BaselineOcpuUtilization create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid BaselineOcpuUtilization: " + key);
        }

        static {
            map = new HashMap<String, BaselineOcpuUtilization>();
            for (BaselineOcpuUtilization v : BaselineOcpuUtilization.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="ocpus")
        private Float ocpus;
        @JsonProperty(value="vcpus")
        private Integer vcpus;
        @JsonProperty(value="memoryInGBs")
        private Float memoryInGBs;
        @JsonProperty(value="baselineOcpuUtilization")
        private BaselineOcpuUtilization baselineOcpuUtilization;
        @JsonProperty(value="nvmes")
        private Integer nvmes;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder ocpus(Float ocpus) {
            this.ocpus = ocpus;
            this.__explicitlySet__.add("ocpus");
            return this;
        }

        public Builder vcpus(Integer vcpus) {
            this.vcpus = vcpus;
            this.__explicitlySet__.add("vcpus");
            return this;
        }

        public Builder memoryInGBs(Float memoryInGBs) {
            this.memoryInGBs = memoryInGBs;
            this.__explicitlySet__.add("memoryInGBs");
            return this;
        }

        public Builder baselineOcpuUtilization(BaselineOcpuUtilization baselineOcpuUtilization) {
            this.baselineOcpuUtilization = baselineOcpuUtilization;
            this.__explicitlySet__.add("baselineOcpuUtilization");
            return this;
        }

        public Builder nvmes(Integer nvmes) {
            this.nvmes = nvmes;
            this.__explicitlySet__.add("nvmes");
            return this;
        }

        public UpdateInstanceShapeConfigDetails build() {
            UpdateInstanceShapeConfigDetails model = new UpdateInstanceShapeConfigDetails(this.ocpus, this.vcpus, this.memoryInGBs, this.baselineOcpuUtilization, this.nvmes);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(UpdateInstanceShapeConfigDetails model) {
            if (model.wasPropertyExplicitlySet("ocpus")) {
                this.ocpus(model.getOcpus());
            }
            if (model.wasPropertyExplicitlySet("vcpus")) {
                this.vcpus(model.getVcpus());
            }
            if (model.wasPropertyExplicitlySet("memoryInGBs")) {
                this.memoryInGBs(model.getMemoryInGBs());
            }
            if (model.wasPropertyExplicitlySet("baselineOcpuUtilization")) {
                this.baselineOcpuUtilization(model.getBaselineOcpuUtilization());
            }
            if (model.wasPropertyExplicitlySet("nvmes")) {
                this.nvmes(model.getNvmes());
            }
            return this;
        }
    }
}

