/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven;

import com.sun.source.tree.DirectiveTree;
import com.sun.source.tree.ModuleTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.lang.model.element.ModuleElement;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.project.MavenProject;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.modules.maven.DependencyType;
import org.netbeans.modules.maven.NbMavenProjectImpl;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.util.RequestProcessor;

public class ModuleInfoSupport {
    private static final Logger LOG = Logger.getLogger(ModuleInfoSupport.class.getName());
    private static final RequestProcessor RP = new RequestProcessor(ModuleInfoSupport.class.getName());
    private final DependencyType type;
    private final NbMavenProjectImpl project;
    private FileObject moduleInfo;
    private final Set<String> declaredModules = new HashSet<String>();
    private final FileChangeAdapter moduleInfoListener = new FileChangeAdapter(){

        public void fileDataCreated(FileEvent fe) {
            if ("module-info.java".equals(fe.getFile().getNameExt())) {
                ModuleInfoSupport.this.moduleInfoChange();
            }
        }

        public void fileChanged(FileEvent fe) {
            if ("module-info.java".equals(fe.getFile().getNameExt())) {
                ModuleInfoSupport.this.moduleInfoChange();
            }
        }

        public void fileDeleted(FileEvent fe) {
            if ("module-info.java".equals(fe.getFile().getNameExt())) {
                ModuleInfoSupport.this.moduleInfoChange();
            }
        }

        public void fileRenamed(FileRenameEvent fe) {
            if ("module-info.java".equals(fe.getFile().getNameExt()) || "module-info.java".equals(fe.getName() + "." + fe.getExt())) {
                ModuleInfoSupport.this.moduleInfoChange();
            }
        }
    };

    public ModuleInfoSupport(NbMavenProjectImpl project, DependencyType type) {
        this.project = project;
        this.type = type;
        Collection<String> roots = ModuleInfoSupport.getRoots(project.getOriginalMavenProject(), type);
        for (String root : roots) {
            FileUtil.addFileChangeListener((FileChangeListener)this.moduleInfoListener, (File)new File(root));
        }
        this.moduleInfo = ModuleInfoSupport.getModuleInfo(roots);
        if (this.moduleInfo != null) {
            this.populateDeclaredModules(this.moduleInfo);
        }
    }

    private static Collection<String> getRoots(MavenProject mp, DependencyType type) {
        List roots = type == DependencyType.TEST ? mp.getTestCompileSourceRoots() : mp.getCompileSourceRoots();
        return roots;
    }

    private synchronized void moduleInfoChange() {
        this.moduleInfo = this.getModuleInfo();
        this.populateDeclaredModules(this.moduleInfo);
    }

    private synchronized void populateDeclaredModules(FileObject moduleInfo) {
        Set<String> dm;
        this.declaredModules.clear();
        if (moduleInfo != null && (dm = ModuleInfoSupport.getDeclaredModules(moduleInfo)) != null) {
            this.declaredModules.addAll(dm);
        }
    }

    public synchronized boolean canAddToModuleInfo(String name) {
        if (this.moduleInfo == null || !this.moduleInfo.isValid()) {
            return false;
        }
        return this.declaredModules != null ? !this.declaredModules.contains(name) : true;
    }

    private FileObject getModuleInfo() {
        MavenProject mp = this.project.getOriginalMavenProject();
        List roots = this.type == DependencyType.TEST ? mp.getTestCompileSourceRoots() : mp.getCompileSourceRoots();
        return ModuleInfoSupport.getModuleInfo(roots);
    }

    static FileObject getModuleInfo(Collection<String> sourceRoots) {
        String sourceRoot;
        File file;
        FileObject moduleInfo = null;
        Iterator<String> iterator = sourceRoots.iterator();
        while (iterator.hasNext() && (moduleInfo = FileUtil.toFileObject((File)(file = new File(sourceRoot = iterator.next(), "module-info.java")))) == null) {
        }
        return moduleInfo;
    }

    static Set<String> getDeclaredModules(NbMavenProjectImpl project) {
        FileObject moduleInfo = ModuleInfoSupport.getModuleInfo(project.getOriginalMavenProject().getCompileSourceRoots());
        return moduleInfo != null ? ModuleInfoSupport.getDeclaredModules(moduleInfo) : null;
    }

    static Set<String> getDeclaredModules(FileObject moduleInfo) {
        JavaSource src;
        JavaSource javaSource = src = moduleInfo != null ? JavaSource.forFileObject((FileObject)moduleInfo) : null;
        if (src == null) {
            return null;
        }
        return ModuleInfoSupport.getDeclaredModules(src);
    }

    static Set<String> getDeclaredModules(JavaSource src) {
        HashSet<String> declaredModuleNames = new HashSet<String>();
        try {
            src.runUserActionTask(cc -> {
                ModuleElement me;
                cc.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                ModuleTree moduleTree = cc.getCompilationUnit().getModule();
                ModuleElement moduleElement = me = moduleTree != null ? (ModuleElement)cc.getTrees().getElement(TreePath.getPath(cc.getCompilationUnit(), (Tree)moduleTree)) : null;
                if (me != null) {
                    for (ModuleElement.Directive directive : me.getDirectives()) {
                        if (directive.getKind() != ModuleElement.DirectiveKind.REQUIRES) continue;
                        ModuleElement.RequiresDirective reqD = (ModuleElement.RequiresDirective)directive;
                        String name = reqD.getDependency().getQualifiedName().toString();
                        declaredModuleNames.add(name);
                    }
                }
            }, true);
        }
        catch (IOException ex) {
            LOG.log(Level.WARNING, null, ex);
        }
        ModuleInfoSupport.log("Declared modules:", declaredModuleNames);
        return declaredModuleNames;
    }

    public static void addRequires(MavenProject mp, Collection<? extends Artifact> artifacts) {
        artifacts.stream().collect(Collectors.groupingBy(DependencyType::forArtifact)).entrySet().forEach(e -> ModuleInfoSupport.addRequires(ModuleInfoSupport.getModuleInfo(ModuleInfoSupport.getRoots(mp, (DependencyType)((Object)((Object)e.getKey())))), (Collection<? extends Artifact>)((Collection)e.getValue())));
    }

    private static void addRequires(FileObject moduleInfo, Collection<? extends Artifact> artifacts) {
        RP.post(() -> {
            if (moduleInfo != null) {
                Set<String> declaredModules = ModuleInfoSupport.getDeclaredModules(moduleInfo);
                LinkedList<String> newModules = new LinkedList<String>();
                for (Artifact a : artifacts) {
                    URL url = FileUtil.urlForArchiveOrDir((File)a.getFile());
                    String name = url != null ? SourceUtils.getModuleName((URL)url) : null;
                    LOG.log(Level.FINE, "Artifact {0} has modules name ''{1}''", new Object[]{url, name});
                    if (name != null) {
                        if (declaredModules.contains(name)) continue;
                        newModules.add(name);
                        continue;
                    }
                    LOG.log(Level.WARNING, "Could not determine module name for artifact {0}", new Object[]{url});
                }
                if (!newModules.isEmpty()) {
                    ModuleInfoSupport.addRequires(moduleInfo, newModules);
                }
            }
        });
    }

    static void addRequires(FileObject moduleInfo, List<String> newModules) {
        JavaSource src = JavaSource.forFileObject((FileObject)moduleInfo);
        if (src == null) {
            return;
        }
        Set<String> declaredModuleNames = ModuleInfoSupport.getDeclaredModules(src);
        LinkedHashSet<String> requiredModuleNames = new LinkedHashSet<String>();
        for (String name : newModules) {
            if (name == null || declaredModuleNames.contains(name)) continue;
            requiredModuleNames.add(name);
        }
        ModuleInfoSupport.log("To be addded modules:", requiredModuleNames);
        if (!requiredModuleNames.isEmpty()) {
            LinkedHashSet<String> mNames = requiredModuleNames;
            try {
                src.runModificationTask(copy -> {
                    ModuleTree modle;
                    copy.toPhase(JavaSource.Phase.RESOLVED);
                    TreeMaker tm = copy.getTreeMaker();
                    ModuleTree newModle = modle = copy.getCompilationUnit().getModule();
                    for (String mName : mNames) {
                        newModle = tm.addModuleDirective(newModle, (DirectiveTree)tm.Requires(false, false, tm.QualIdent(mName)));
                    }
                    copy.rewrite((Tree)modle, (Tree)newModle);
                }).commit();
            }
            catch (IOException ex) {
                LOG.log(Level.WARNING, null, ex);
            }
        }
    }

    static void log(String prefix, Collection cls) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, prefix);
            if (cls.isEmpty()) {
                LOG.log(Level.FINE, " EMPTY");
            } else {
                for (Object o : cls) {
                    LOG.log(Level.FINE, " {0}", o.toString());
                }
            }
        }
    }
}

