/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.backward_codecs.lucene50;

import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.backward_codecs.store.EndiannessReverserUtil;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.CompoundDirectory;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.CollectionUtil;
import org.apache.lucene.util.IOUtils;

final class Lucene50CompoundReader
extends CompoundDirectory {
    private final Directory directory;
    private final String segmentName;
    private final Map<String, FileEntry> entries;
    private final IndexInput handle;
    private int version;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Lucene50CompoundReader(Directory directory, SegmentInfo si, IOContext context) throws IOException {
        this.directory = directory;
        this.segmentName = si.name;
        String dataFileName = IndexFileNames.segmentFileName((String)this.segmentName, (String)"", (String)"cfs");
        String entriesFileName = IndexFileNames.segmentFileName((String)this.segmentName, (String)"", (String)"cfe");
        this.entries = this.readEntries(si.getId(), directory, entriesFileName);
        boolean success = false;
        long expectedLength = CodecUtil.indexHeaderLength((String)"Lucene50CompoundData", (String)"");
        for (Map.Entry<String, FileEntry> ent : this.entries.entrySet()) {
            expectedLength += ent.getValue().length;
        }
        expectedLength += (long)CodecUtil.footerLength();
        this.handle = directory.openInput(dataFileName, context);
        try {
            CodecUtil.checkIndexHeader((DataInput)this.handle, (String)"Lucene50CompoundData", (int)this.version, (int)this.version, (byte[])si.getId(), (String)"");
            CodecUtil.retrieveChecksum((IndexInput)this.handle);
            if (this.handle.length() != expectedLength) {
                throw new CorruptIndexException("length should be " + expectedLength + " bytes, but is " + this.handle.length() + " instead", (DataInput)this.handle);
            }
            success = true;
            if (success) return;
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this.handle});
            throw throwable;
        }
        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this.handle});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, FileEntry> readEntries(byte[] segmentID, Directory dir, String entriesFileName) throws IOException {
        Map<String, FileEntry> mapping;
        block11: {
            mapping = null;
            try (ChecksumIndexInput entriesStream = EndiannessReverserUtil.openChecksumInput(dir, entriesFileName, IOContext.READONCE);){
                Throwable priorE = null;
                try {
                    this.version = CodecUtil.checkIndexHeader((DataInput)entriesStream, (String)"Lucene50CompoundEntries", (int)0, (int)0, (byte[])segmentID, (String)"");
                    mapping = this.readMapping((IndexInput)entriesStream);
                }
                catch (Throwable exception) {
                    try {
                        priorE = exception;
                        break block11;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        CodecUtil.checkFooter((ChecksumIndexInput)entriesStream, (Throwable)priorE);
                    }
                }
                CodecUtil.checkFooter((ChecksumIndexInput)entriesStream, (Throwable)priorE);
            }
        }
        return Collections.unmodifiableMap(mapping);
    }

    private Map<String, FileEntry> readMapping(IndexInput entriesStream) throws IOException {
        int numEntries = entriesStream.readVInt();
        HashMap mapping = CollectionUtil.newHashMap((int)numEntries);
        for (int i = 0; i < numEntries; ++i) {
            FileEntry fileEntry = new FileEntry();
            String id = entriesStream.readString();
            FileEntry previous = mapping.put(id, fileEntry);
            if (previous != null) {
                throw new CorruptIndexException("Duplicate cfs entry id=" + id + " in CFS ", (DataInput)entriesStream);
            }
            fileEntry.offset = entriesStream.readLong();
            fileEntry.length = entriesStream.readLong();
        }
        return mapping;
    }

    public void close() throws IOException {
        IOUtils.close((Closeable[])new Closeable[]{this.handle});
    }

    public IndexInput openInput(String name, IOContext context) throws IOException {
        this.ensureOpen();
        String id = IndexFileNames.stripSegmentName((String)name);
        FileEntry entry = this.entries.get(id);
        if (entry == null) {
            String datFileName = IndexFileNames.segmentFileName((String)this.segmentName, (String)"", (String)"cfs");
            throw new FileNotFoundException("No sub-file with id " + id + " found in compound file \"" + datFileName + "\" (fileName=" + name + " files: " + this.entries.keySet() + ")");
        }
        return this.handle.slice(name, entry.offset, entry.length);
    }

    public String[] listAll() {
        this.ensureOpen();
        String[] res = this.entries.keySet().toArray(new String[this.entries.size()]);
        for (int i = 0; i < res.length; ++i) {
            res[i] = this.segmentName + res[i];
        }
        return res;
    }

    public long fileLength(String name) throws IOException {
        this.ensureOpen();
        FileEntry e = this.entries.get(IndexFileNames.stripSegmentName((String)name));
        if (e == null) {
            throw new FileNotFoundException(name);
        }
        return e.length;
    }

    public String toString() {
        return "CompoundFileDirectory(segment=\"" + this.segmentName + "\" in dir=" + this.directory + ")";
    }

    public Set<String> getPendingDeletions() {
        return Collections.emptySet();
    }

    public void checkIntegrity() throws IOException {
        CodecUtil.checksumEntireFile((IndexInput)this.handle);
    }

    public static final class FileEntry {
        long offset;
        long length;
    }
}

