/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.java.classpath;

import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.classpath.GlobalPathRegistry;
import org.netbeans.api.project.Project;
import org.netbeans.modules.gradle.java.api.ProjectSourcesClassPathProvider;
import org.netbeans.modules.gradle.java.classpath.BootClassPathImpl;
import org.netbeans.modules.gradle.java.classpath.GradleGlobalClassPathImpl;
import org.netbeans.spi.java.classpath.ClassPathFactory;
import org.netbeans.spi.java.classpath.ClassPathImplementation;
import org.netbeans.spi.project.ui.ProjectOpenedHook;

public class GlobalClassPathProviderImpl
extends ProjectOpenedHook
implements ProjectSourcesClassPathProvider {
    private static final Logger LOG = Logger.getLogger(GlobalClassPathProviderImpl.class.getName());
    final Project project;
    private static final int BOOT = 0;
    private static final int SOURCE = 2;
    private static final int COMPILE = 4;
    private static final int RUNTIME = 6;
    final ClassPath[] cache = new ClassPath[8];

    public GlobalClassPathProviderImpl(Project project) {
        this.project = project;
    }

    @Override
    public ClassPath getProjectSourcesClassPath(String type) {
        return this.getClassPath(type, true);
    }

    @Override
    public ClassPath[] getProjectClassPath(String type) {
        ClassPath[] classPathArray;
        ClassPath instance = this.getClassPath(type, false);
        if (instance != null) {
            ClassPath[] classPathArray2 = new ClassPath[1];
            classPathArray = classPathArray2;
            classPathArray2[0] = instance;
        } else {
            classPathArray = new ClassPath[]{};
        }
        return classPathArray;
    }

    private ClassPath getClassPath(String type, boolean excludeTests) {
        int index = GlobalClassPathProviderImpl.type2Index(type, excludeTests);
        if (index < 0) {
            return null;
        }
        ClassPath cp = this.cache[index];
        if (cp == null) {
            this.cache[index] = cp = (switch (type) {
                case "classpath/boot" -> ClassPathFactory.createClassPath((ClassPathImplementation)new BootClassPathImpl(this.project, null));
                case "classpath/source" -> ClassPathFactory.createClassPath((ClassPathImplementation)new GradleGlobalClassPathImpl.ProjectSourceClassPathImpl(this.project, excludeTests));
                case "classpath/compile" -> ClassPathFactory.createClassPath((ClassPathImplementation)new GradleGlobalClassPathImpl.ProjectCompileClassPathImpl(this.project, excludeTests));
                case "classpath/execute" -> ClassPathFactory.createClassPath((ClassPathImplementation)new GradleGlobalClassPathImpl.ProjectRuntimeClassPathImpl(this.project, excludeTests));
                default -> null;
            });
        }
        return cp;
    }

    private static int type2Index(String type, boolean excludeTests) {
        int index = switch (type) {
            case "classpath/boot" -> 0;
            case "classpath/source" -> 2;
            case "classpath/compile" -> 4;
            case "classpath/execute" -> 6;
            default -> -1;
        };
        return index >= 0 && excludeTests ? index + 1 : index;
    }

    protected void projectOpened() {
        GlobalPathRegistry.getDefault().register("classpath/boot", this.getProjectClassPath("classpath/boot"));
        GlobalPathRegistry.getDefault().register("classpath/source", this.getProjectClassPath("classpath/source"));
        GlobalPathRegistry.getDefault().register("classpath/compile", this.getProjectClassPath("classpath/compile"));
        GlobalPathRegistry.getDefault().register("classpath/execute", this.getProjectClassPath("classpath/execute"));
    }

    protected void projectClosed() {
        this.safeUnregister("classpath/boot", this.getProjectClassPath("classpath/boot"));
        this.safeUnregister("classpath/source", this.getProjectClassPath("classpath/source"));
        this.safeUnregister("classpath/compile", this.getProjectClassPath("classpath/compile"));
        this.safeUnregister("classpath/execute", this.getProjectClassPath("classpath/execute"));
        Arrays.fill(this.cache, null);
    }

    private void safeUnregister(String id, ClassPath[] paths) {
        try {
            GlobalPathRegistry.getDefault().unregister(id, paths);
        }
        catch (IllegalArgumentException ex) {
            LOG.log(Level.INFO, "Could not unregister {0} from {1}", new Object[]{paths, id});
        }
    }
}

