/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.api.common;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.modules.java.api.common.SourceRoots;
import org.netbeans.modules.java.api.common.impl.RootsAccessor;
import org.openide.util.Parameters;

public abstract class Roots {
    private final PropertyChangeSupport support;
    private final boolean isSourceRoot;
    private final boolean supportIncludes;
    private final String type;
    private final String hint;

    Roots(boolean isSourceRoot, boolean supportIncludes, @NullAllowed String type, @NullAllowed String hint) {
        this.isSourceRoot = isSourceRoot;
        this.supportIncludes = supportIncludes;
        this.type = type;
        this.hint = hint;
        this.support = new PropertyChangeSupport(this);
    }

    @NonNull
    public abstract String[] getRootDisplayNames();

    @NonNull
    public abstract String[] getRootProperties();

    public final void addPropertyChangeListener(@NonNull PropertyChangeListener listener) {
        Parameters.notNull((CharSequence)"listener", (Object)listener);
        this.support.addPropertyChangeListener(listener);
    }

    public final void removePropertyChangeListener(@NonNull PropertyChangeListener listener) {
        Parameters.notNull((CharSequence)"listener", (Object)listener);
        this.support.removePropertyChangeListener(listener);
    }

    final void firePropertyChange(@NonNull String propName, @NullAllowed Object oldValue, @NonNull Object newValue) {
        Parameters.notNull((CharSequence)"propName", (Object)propName);
        this.support.firePropertyChange(propName, oldValue, newValue);
    }

    public static Roots nonSourceRoots(String ... rootPropNames) {
        Parameters.notNull((CharSequence)"rootPropNames", (Object)rootPropNames);
        return new NonSourceRoots(rootPropNames);
    }

    public static Roots propertyBased(@NonNull String[] properties, @NonNull String[] displayNames, boolean supportIncludes, @NullAllowed String type, @NullAllowed String hint) {
        Parameters.notNull((CharSequence)"properties", (Object)properties);
        Parameters.notNull((CharSequence)"displayNames", (Object)displayNames);
        if (properties.length != displayNames.length) {
            throw new IllegalArgumentException();
        }
        return new PropSourceRoots(properties, displayNames, supportIncludes, type, hint);
    }

    static {
        RootsAccessor.setInstance(new MyAccessor());
    }

    private static class NonSourceRoots
    extends Roots {
        private final Set<String> rootPropNames;

        private NonSourceRoots(String ... rootPropNames) {
            super(false, false, null, null);
            this.rootPropNames = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(rootPropNames)));
        }

        @Override
        public String[] getRootDisplayNames() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String[] getRootProperties() {
            return this.rootPropNames.toArray(new String[0]);
        }
    }

    private static class PropSourceRoots
    extends Roots {
        private final String[] props;
        private final String[] names;

        private PropSourceRoots(String[] props, String[] names, boolean supportIncludes, String type, String hint) {
            super(true, supportIncludes, type, hint);
            this.props = Arrays.copyOf(props, props.length);
            this.names = Arrays.copyOf(names, names.length);
        }

        @Override
        public String[] getRootDisplayNames() {
            return Arrays.copyOf(this.names, this.names.length);
        }

        @Override
        public String[] getRootProperties() {
            return Arrays.copyOf(this.props, this.props.length);
        }
    }

    private static class MyAccessor
    extends RootsAccessor {
        private MyAccessor() {
        }

        @Override
        public boolean isSourceRoot(@NonNull Roots roots) {
            return roots.isSourceRoot;
        }

        @Override
        public boolean supportIncludes(@NonNull Roots roots) {
            return roots.supportIncludes;
        }

        @Override
        public String getHint(@NonNull Roots roots) {
            return roots.hint;
        }

        @Override
        public String getType(@NonNull Roots roots) {
            return roots.type;
        }

        @Override
        public String[] getRootPathProperties(@NonNull Roots roots) {
            return roots instanceof SourceRoots ? ((SourceRoots)roots).getRootPathProperties() : new String[roots.getRootProperties().length];
        }
    }
}

