/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.debug.ui.annotation;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.modules.javascript2.debug.breakpoints.JSBreakpointsInfoManager;
import org.netbeans.modules.javascript2.debug.breakpoints.JSLineBreakpoint;
import org.netbeans.modules.javascript2.debug.ui.JSUtils;
import org.netbeans.modules.javascript2.debug.ui.annotation.LineBreakpointAnnotation;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.text.Annotatable;
import org.openide.text.Annotation;
import org.openide.text.Line;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;

class BreakpointAnnotationManager
implements PropertyChangeListener {
    private static Reference<BreakpointAnnotationManager> INSTANCE_REF = new WeakReference<Object>(null);
    private static final Logger logger = Logger.getLogger(BreakpointAnnotationManager.class.getName());
    private final Map<JSLineBreakpoint, Annotation> breakpointAnnotations = new HashMap<JSLineBreakpoint, Annotation>();
    private final Set<FileObject> annotatedFiles = Collections.newSetFromMap(new WeakHashMap());
    private Set<PropertyChangeListener> dataObjectListeners;
    private final RequestProcessor annotationProcessor = new RequestProcessor("Annotation Refresh", 1);
    private volatile Boolean active = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static BreakpointAnnotationManager getInstance() {
        JSBreakpointsInfoManager jsBIM = JSBreakpointsInfoManager.getDefault();
        Class<BreakpointAnnotationManager> clazz = BreakpointAnnotationManager.class;
        synchronized (BreakpointAnnotationManager.class) {
            BreakpointAnnotationManager instance = INSTANCE_REF.get();
            if (instance == null) {
                instance = new BreakpointAnnotationManager(jsBIM);
                INSTANCE_REF = new WeakReference<BreakpointAnnotationManager>(instance);
            }
            // ** MonitorExit[var2_1] (shouldn't be in output)
            return instance;
        }
    }

    private BreakpointAnnotationManager(JSBreakpointsInfoManager jsBIM) {
        jsBIM.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)jsBIM));
    }

    private static boolean isAnnotateable(Breakpoint breakpoint) {
        return breakpoint instanceof JSLineBreakpoint;
    }

    private static boolean isAnnotateable(FileObject fo) {
        return JSBreakpointsInfoManager.getDefault().isAnnotatable(fo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void annotate(Line.Set set, Lookup context) {
        FileObject fo = (FileObject)context.lookup(FileObject.class);
        if (fo == null || !BreakpointAnnotationManager.isAnnotateable(fo)) {
            return;
        }
        DataObject dobj = (DataObject)context.lookup(DataObject.class);
        logger.log(Level.FINE, "annotate({0}, {1}), fo = {2}, foID = {3}, dobj = {4}", new Object[]{set, context, fo, System.identityHashCode(fo), dobj});
        if (dobj != null) {
            PropertyChangeListener pchl = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if ("primaryFile".equals(evt.getPropertyName())) {
                        DataObject dobj = (DataObject)evt.getSource();
                        final FileObject newFO = dobj.getPrimaryFile();
                        BreakpointAnnotationManager.this.annotationProcessor.post(new Runnable(){

                            @Override
                            public void run() {
                                BreakpointAnnotationManager.this.annotate(newFO);
                            }
                        });
                    }
                }
            };
            dobj.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)pchl, (Object)dobj));
            BreakpointAnnotationManager breakpointAnnotationManager = this;
            synchronized (breakpointAnnotationManager) {
                if (this.dataObjectListeners == null) {
                    this.dataObjectListeners = new HashSet<PropertyChangeListener>();
                }
                this.dataObjectListeners.add(pchl);
            }
        }
        this.annotate(fo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void annotate(FileObject fo) {
        Map<JSLineBreakpoint, Annotation> map = this.breakpointAnnotations;
        synchronized (map) {
            for (Breakpoint breakpoint : DebuggerManager.getDebuggerManager().getBreakpoints()) {
                JSLineBreakpoint b;
                if (!BreakpointAnnotationManager.isAnnotateable(breakpoint) || this.breakpointAnnotations.containsKey(breakpoint) || !fo.equals((b = (JSLineBreakpoint)breakpoint).getFileObject())) continue;
                logger.log(Level.FINE, "annotate({0} (ID={1})): b = {2}", new Object[]{fo, System.identityHashCode(fo), b});
                b.addPropertyChangeListener((PropertyChangeListener)this);
                this.annotationProcessor.post((Runnable)new AnnotationRefresh(b, false, true));
            }
            this.annotatedFiles.add(fo);
            logger.log(Level.FINE, "Annotated files = {0}", this.annotatedFiles);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void breakpointAdded(Breakpoint breakpoint) {
        if (!BreakpointAnnotationManager.isAnnotateable(breakpoint)) {
            return;
        }
        JSLineBreakpoint lb = (JSLineBreakpoint)breakpoint;
        FileObject fo = lb.getFileObject();
        Map<JSLineBreakpoint, Annotation> map = this.breakpointAnnotations;
        synchronized (map) {
            boolean isFileAnnotated = this.annotatedFiles.contains(fo);
            logger.log(Level.FINE, "breakpointAdded({0}), fo = {1}, foID = {2}, annotated = {3}", new Object[]{breakpoint, fo, System.identityHashCode(fo), isFileAnnotated});
            lb.addPropertyChangeListener((PropertyChangeListener)this);
            this.annotationProcessor.post((Runnable)new AnnotationRefresh(lb, false, true));
        }
    }

    void breakpointRemoved(Breakpoint breakpoint) {
        if (!BreakpointAnnotationManager.isAnnotateable(breakpoint)) {
            return;
        }
        JSLineBreakpoint lb = (JSLineBreakpoint)breakpoint;
        logger.log(Level.FINE, "breakpointRemoved({0})", breakpoint);
        lb.removePropertyChangeListener((PropertyChangeListener)this);
        this.annotationProcessor.post((Runnable)new AnnotationRefresh(lb, true, false));
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String propertyName = evt.getPropertyName();
        if ("enabled".equals(propertyName) || "lineNumber".equals(propertyName) || "validity".equals(propertyName) || "condition".equals(propertyName)) {
            JSLineBreakpoint lb = (JSLineBreakpoint)evt.getSource();
            this.annotationProcessor.post((Runnable)new AnnotationRefresh(lb, true, true));
        } else if ("breakpointsActive".equals(propertyName)) {
            boolean a = JSBreakpointsInfoManager.getDefault().areBreakpointsActivated();
            if (this.active != null && a != this.active) {
                this.active = a;
                this.annotationProcessor.post((Runnable)new AnnotationRefresh(null, true, true));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addAnnotation(JSLineBreakpoint breakpoint) {
        Line line = JSUtils.getLine(breakpoint);
        if (this.active == null) {
            this.active = JSBreakpointsInfoManager.getDefault().areBreakpointsActivated();
        }
        LineBreakpointAnnotation annotation = new LineBreakpointAnnotation((Annotatable)line, breakpoint, this.active);
        logger.log(Level.FINE, "Added annotation of {0} : {1}", new Object[]{breakpoint, annotation});
        Map<JSLineBreakpoint, Annotation> map = this.breakpointAnnotations;
        synchronized (map) {
            this.breakpointAnnotations.put(breakpoint, (Annotation)annotation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeAnnotation(Breakpoint breakpoint) {
        Annotation annotation;
        Map<JSLineBreakpoint, Annotation> map = this.breakpointAnnotations;
        synchronized (map) {
            annotation = this.breakpointAnnotations.remove(breakpoint);
        }
        if (annotation != null) {
            logger.log(Level.FINE, "Removed annotation of {0} : {1}", new Object[]{breakpoint, annotation});
            annotation.detach();
            return true;
        }
        return false;
    }

    private final class AnnotationRefresh
    implements Runnable {
        private final JSLineBreakpoint b;
        private final boolean remove;
        private final boolean add;

        public AnnotationRefresh(JSLineBreakpoint b, boolean remove, boolean add) {
            this.b = b;
            this.remove = remove;
            this.add = add;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (this.b != null) {
                this.refreshAnnotation(this.b);
            } else {
                ArrayList bpts;
                Map map = BreakpointAnnotationManager.this.breakpointAnnotations;
                synchronized (map) {
                    bpts = new ArrayList(BreakpointAnnotationManager.this.breakpointAnnotations.keySet());
                }
                for (JSLineBreakpoint bp : bpts) {
                    this.refreshAnnotation(bp);
                }
            }
        }

        private void refreshAnnotation(JSLineBreakpoint b) {
            boolean removed = BreakpointAnnotationManager.this.removeAnnotation((Breakpoint)b);
            if (this.add && (!this.remove || this.remove && removed)) {
                BreakpointAnnotationManager.this.addAnnotation(b);
            }
        }
    }
}

