/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.favorites;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.Function;
import java.util.prefs.Preferences;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.netbeans.modules.favorites.Tab;
import org.netbeans.modules.favorites.api.Favorites;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbPreferences;
import org.openide.windows.Mode;
import org.openide.windows.WindowManager;

public final class Module {
    private static final String INITIAL_OPEN_DONE_KEY = "initial-open-done";

    private Module() {
    }

    public static final class EDTInit
    implements Runnable {
        @Override
        public void run() {
            this.registerFavAppenderFunction();
            this.attachFirstEditorOpenListener();
        }

        private void registerFavAppenderFunction() {
            Function<File[], File[]> favAppender = files -> {
                if (!UIManager.getBoolean("FileChooser.favorites.enabled")) {
                    return files;
                }
                ArrayList<File> shortcuts = new ArrayList<File>(Arrays.asList(files));
                for (FileObject favorite : Favorites.getDefault().getFavoriteRoots()) {
                    File file = FileUtil.toFile((FileObject)favorite);
                    if (!file.isDirectory()) continue;
                    shortcuts.add(file);
                }
                return (File[])shortcuts.toArray(File[]::new);
            };
            UIManager.put("FileChooser.shortcuts.filesFunction", favAppender);
        }

        private void attachFirstEditorOpenListener() {
            final Preferences prefs = NbPreferences.forModule(Module.class);
            if (prefs.getBoolean(Module.INITIAL_OPEN_DONE_KEY, false)) {
                return;
            }
            final WindowManager wm = WindowManager.getDefault();
            wm.addPropertyChangeListener(new PropertyChangeListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    Mode mode;
                    Object object;
                    if ("activeMode".equals(evt.getPropertyName()) && (object = evt.getNewValue()) instanceof Mode && wm.isEditorMode(mode = (Mode)object)) {
                        try {
                            Tab favTab = Tab.findDefault();
                            if (favTab != null && !favTab.wasOpened() && !favTab.isOpened()) {
                                favTab.open();
                            }
                        }
                        finally {
                            prefs.putBoolean(Module.INITIAL_OPEN_DONE_KEY, true);
                            1 thisListener = this;
                            SwingUtilities.invokeLater(() -> wm.removePropertyChangeListener(thisListener));
                        }
                    }
                }
            });
        }
    }
}

